/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.sba;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import uk.ac.ed.inf.pepa.analysis.IProblem;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Compiler;
import uk.ac.ed.inf.pepa.model.Model;
import uk.ac.ed.inf.pepa.parsing.ASTSupport;
import uk.ac.ed.inf.pepa.parsing.ASTVisitor;
import uk.ac.ed.inf.pepa.parsing.ActionTypeNode;
import uk.ac.ed.inf.pepa.parsing.Actions;
import uk.ac.ed.inf.pepa.parsing.ActivityNode;
import uk.ac.ed.inf.pepa.parsing.AggregationNode;
import uk.ac.ed.inf.pepa.parsing.BinaryOperatorProcessNode;
import uk.ac.ed.inf.pepa.parsing.BinaryOperatorRateNode;
import uk.ac.ed.inf.pepa.parsing.ChoiceNode;
import uk.ac.ed.inf.pepa.parsing.ConstantProcessNode;
import uk.ac.ed.inf.pepa.parsing.CooperationNode;
import uk.ac.ed.inf.pepa.parsing.ExpressionVisitor;
import uk.ac.ed.inf.pepa.parsing.HidingNode;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.parsing.MoveOnVisitor;
import uk.ac.ed.inf.pepa.parsing.PassiveRateNode;
import uk.ac.ed.inf.pepa.parsing.PrefixNode;
import uk.ac.ed.inf.pepa.parsing.ProcessDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.ProcessNode;
import uk.ac.ed.inf.pepa.parsing.RateDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.RateDoubleNode;
import uk.ac.ed.inf.pepa.parsing.RateNode;
import uk.ac.ed.inf.pepa.parsing.UnknownActionTypeNode;
import uk.ac.ed.inf.pepa.parsing.VariableRateNode;
import uk.ac.ed.inf.pepa.parsing.WildcardCooperationNode;
import uk.ac.ed.inf.pepa.sba.CompiledRate;
import uk.ac.ed.inf.pepa.sba.Mapping;
import uk.ac.ed.inf.pepa.sba.ReactionBuilder;
import uk.ac.ed.inf.pepa.sba.ReactionBuilderAction;
import uk.ac.ed.inf.pepa.sba.ReactionsSet;
import uk.ac.ed.inf.pepa.sba.SBAComponent;
import uk.ac.ed.inf.pepa.sba.SBAInterface;
import uk.ac.ed.inf.pepa.sba.SBAParseException;
import uk.ac.ed.inf.pepa.sba.SBAReaction;
import uk.ac.ed.inf.pepa.sba.SBASupport;
import uk.ac.ed.inf.pepa.sba.SBAVisitorException;

public class PEPAtoSBA
implements SBAInterface {
    Mapping map = null;
    private MappingVisitor mappingVisitor;
    LinkedList<HashMap<String, String>> nameMap = null;
    Map<String, String> originalDef = null;
    ModelNode originalModel = null;
    ModelNode model = null;
    Map<String, ReactionBuilder> reactions = null;
    Map<String, Number> sbaPopulations = null;
    Map<String, RateNode> sbaRates = null;
    Set<SBAReaction> sbaReactions = null;
    Set<String> actions;

    public PEPAtoSBA(ModelNode model) {
        if (model == null) {
            throw new NullPointerException("Null ModelNode passed.");
        }
        this.originalModel = model;
    }

    private void ensureUniqueReactionNames() {
        HashSet<String> names = new HashSet<String>();
        HashSet<String> copies = new HashSet<String>();
        block0: while (true) {
            boolean string;
            names.clear();
            names.addAll(this.sbaRates.keySet());
            names.addAll(this.sbaPopulations.keySet());
            copies.clear();
            for (SBAReaction reaction : this.sbaReactions) {
                if (names.contains(reaction.name)) {
                    copies.add(reaction.name);
                    continue;
                }
                names.add(reaction.name);
            }
            if (copies.size() == 0) break;
            String duplicatedName = (String)copies.iterator().next();
            if (duplicatedName.endsWith("\"")) {
                string = true;
                duplicatedName = duplicatedName.substring(0, duplicatedName.length() - 1);
            } else {
                string = false;
            }
            boolean postfixFound = false;
            int underscores = -1;
            block2: while (!postfixFound) {
                postfixFound = true;
                Pattern p = Pattern.compile(String.valueOf(duplicatedName) + "_{" + ++underscores + "}\\d+" + (string ? "\\\"" : ""));
                for (String next : names) {
                    if (!p.matcher(next).matches()) continue;
                    postfixFound = false;
                    continue block2;
                }
            }
            String newName = duplicatedName;
            while (underscores-- > 0) {
                newName = String.valueOf(newName) + "_";
            }
            underscores = 1;
            Iterator<SBAReaction> iterator = this.sbaReactions.iterator();
            while (true) {
                SBAReaction reaction;
                if (!iterator.hasNext()) continue block0;
                reaction = iterator.next();
                if (!reaction.name.equals(String.valueOf(duplicatedName) + (string ? "\"" : ""))) continue;
                reaction.setName(String.valueOf(newName) + underscores++ + (string ? "\"" : ""));
            }
            break;
        }
    }

    public synchronized ModelNode getFlattenedModel() {
        return this.model;
    }

    @Override
    public synchronized Mapping getMapping() {
        HashSet<String> labelledComponents = new HashSet<String>();
        for (ProcessDefinitionNode pdn : this.originalModel.processDefinitions()) {
            labelledComponents.add(pdn.getName().getName());
        }
        this.map = null;
        this.mappingVisitor = new MappingVisitor(labelledComponents);
        this.matchTrees(this.originalModel.getSystemEquation(), this.model.getSystemEquation());
        while (this.map.previous != null) {
            this.map = this.map.previous;
        }
        return this.map;
    }

    public synchronized ModelNode getOriginalModel() {
        return this.originalModel;
    }

    @Override
    public synchronized Map<String, Number> getPopulations() {
        return this.sbaPopulations;
    }

    @Override
    public synchronized Map<String, RateNode> getRates() {
        return this.sbaRates;
    }

    @Override
    public synchronized Set<SBAReaction> getReactions() {
        HashSet<SBAReaction> copy = new HashSet<SBAReaction>();
        for (SBAReaction r : this.sbaReactions) {
            copy.add(r.clone());
        }
        return copy;
    }

    @Override
    public boolean isParseable() {
        if (this.originalModel == null) {
            return false;
        }
        IProblem[] iProblemArray = this.originalModel.getProblems();
        int n = iProblemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem = iProblemArray[n2];
            if (problem.isError()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void matchTrees(ProcessNode originalEquation, ProcessNode expandedEquation) {
        boolean mapBoolean = true;
        if (originalEquation.getClass().equals(expandedEquation.getClass())) {
            mapBoolean = false;
            if (originalEquation instanceof BinaryOperatorProcessNode) {
                this.matchTrees(((BinaryOperatorProcessNode)originalEquation).getLeft(), ((BinaryOperatorProcessNode)expandedEquation).getLeft());
                if (originalEquation instanceof CooperationNode) {
                    Actions actions2 = ((CooperationNode)originalEquation).getActionSet();
                    if (actions2.size() == 0) {
                        this.map.cooperation = "||";
                    } else {
                        StringBuilder sb = new StringBuilder("<");
                        for (ActionTypeNode atn : actions2) {
                            sb.append(atn.getType()).append(", ");
                        }
                        sb.delete(sb.length() - 2, sb.length());
                        sb.append(">");
                        this.map.cooperation = sb.toString();
                    }
                } else if (originalEquation instanceof WildcardCooperationNode) {
                    this.map.cooperation = "<*>";
                }
                this.matchTrees(((BinaryOperatorProcessNode)originalEquation).getRight(), ((BinaryOperatorProcessNode)expandedEquation).getRight());
            } else if (originalEquation instanceof AggregationNode) {
                this.matchTrees(((AggregationNode)originalEquation).getProcessNode(), ((AggregationNode)expandedEquation).getProcessNode());
            } else if (originalEquation instanceof HidingNode) {
                this.matchTrees(((HidingNode)originalEquation).getProcess(), ((HidingNode)expandedEquation).getProcess());
            } else if (originalEquation instanceof PrefixNode) {
                this.matchTrees(((PrefixNode)originalEquation).getTarget(), ((PrefixNode)expandedEquation).getTarget());
            } else if (originalEquation instanceof ConstantProcessNode) {
                mapBoolean = true;
            }
        }
        if (mapBoolean) {
            this.mappingVisitor.createNext();
            expandedEquation.accept(this.mappingVisitor);
            this.map.originalRepresentation = ASTSupport.toString(originalEquation);
        }
    }

    public synchronized void parseModel() throws SBAParseException {
        this.sbaRates = new HashMap<String, RateNode>();
        this.reactions = new HashMap<String, ReactionBuilder>();
        this.sbaReactions = new HashSet<SBAReaction>();
        this.sbaPopulations = new HashMap<String, Number>();
        this.model = (ModelNode)ASTSupport.copy(this.originalModel);
        this.nameMap = SBASupport.flattenNameSpace(this.model, true);
        HashMap<String, String> tHashMap = new HashMap<String, String>();
        for (HashMap hashMap : this.nameMap) {
            tHashMap.putAll(hashMap);
        }
        HashMap<String, HashMap<String, String>> hashMap = ASTSupport.generateNamedForm(this.model, tHashMap);
        this.originalDef = new HashMap<String, String>();
        for (HashMap hashMap2 : this.nameMap) {
            HashSet<String> h2 = new HashSet<String>();
            for (String string : hashMap2.keySet()) {
                h2.add(string);
            }
            for (Map.Entry<String, HashMap<String, String>> entry : hashMap.entrySet()) {
                if (!h2.contains(entry.getKey())) continue;
                String tString = (String)hashMap2.get(entry.getKey());
                for (String s : entry.getValue().keySet()) {
                    this.originalDef.put(s, tString);
                }
                hashMap2.putAll((Map)entry.getValue());
            }
        }
        PreParseVisitor preParseVisitor = new PreParseVisitor();
        this.model.accept(preParseVisitor);
        this.actions = preParseVisitor.actions;
        this.updateReactions();
        ParseVisitor parse = new ParseVisitor();
        try {
            this.model.accept(parse);
        }
        catch (SBAVisitorException e) {
            if (parse.error != null) {
                throw new SBAParseException(parse.error);
            }
            throw e;
        }
        HashSet<String> usedNames = new HashSet<String>();
        for (SBAReaction sBAReaction : this.sbaReactions) {
            for (SBAComponent c : sBAReaction.reactants) {
                usedNames.add(c.name);
            }
            for (SBAComponent c : sBAReaction.products) {
                usedNames.add(c.name);
            }
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (HashMap hashMap3 : this.nameMap) {
            hashSet.clear();
            for (String s : hashMap3.keySet()) {
                if (!usedNames.contains(s)) {
                    hashSet.add(s);
                    continue;
                }
                if (this.sbaPopulations.containsKey(s)) continue;
                this.sbaPopulations.put(s, 0);
            }
            for (String s : hashSet) {
                hashMap3.remove(s);
            }
        }
        hashSet.clear();
        for (String string : this.sbaPopulations.keySet()) {
            if (usedNames.contains(string)) continue;
            hashSet.add(string);
        }
        for (String string : hashSet) {
            this.sbaPopulations.remove(string);
        }
        this.ensureUniqueReactionNames();
    }

    private final void updateReactions() {
        boolean altered = true;
        LinkedList<ReactionBuilder> todo = new LinkedList<ReactionBuilder>();
        LinkedList<ReactionBuilderAction> toDel = new LinkedList<ReactionBuilderAction>();
        LinkedList<ReactionBuilderAction> toAdd = new LinkedList<ReactionBuilderAction>();
        while (altered) {
            altered = false;
            for (ReactionBuilder rb : this.reactions.values()) {
                todo.clear();
                toDel.clear();
                toAdd.clear();
                todo.add(rb);
                while (!todo.isEmpty()) {
                    ReactionBuilder reactionBuilder = (ReactionBuilder)todo.remove(0);
                    for (ReactionBuilderAction rba : reactionBuilder.moves) {
                        if (rba.next != null) {
                            todo.add(rba.next);
                            continue;
                        }
                        if (!rba.noPrefix) continue;
                        ReactionBuilder cloned = this.reactions.get(rba.product).clone();
                        toAdd.addAll(cloned.moves);
                        toDel.add(rba);
                        altered = true;
                    }
                    reactionBuilder.moves.removeAll(toDel);
                    reactionBuilder.moves.addAll(toAdd);
                }
            }
        }
    }

    @Override
    public synchronized void updateReactions(Set<SBAReaction> updatedReactions) {
        for (SBAReaction reaction : this.sbaReactions) {
            boolean found = false;
            for (SBAReaction r : updatedReactions) {
                if (!reaction.equals(r)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new IllegalArgumentException("Reaction sets do not match.");
        }
        if (this.sbaReactions.size() != updatedReactions.size()) {
            throw new IllegalArgumentException("Reaction sets do not match.");
        }
        HashSet<SBAReaction> tSet = new HashSet<SBAReaction>(this.sbaReactions);
        SBAReaction tReaction = null;
        for (SBAReaction newReaction : updatedReactions) {
            for (SBAReaction reaction : tSet) {
                if (!reaction.equals(newReaction)) continue;
                tReaction = reaction;
                break;
            }
            tSet.remove(tReaction);
            List<SBAComponent> components = tReaction.getReactants();
            block4: for (SBAComponent updatedComponent : newReaction.getReactants()) {
                for (SBAComponent component : components) {
                    if (!updatedComponent.equals(component)) continue;
                    component.setStoichiometry(updatedComponent.getStoichiometry());
                    continue block4;
                }
            }
            components = tReaction.getProducts();
            block6: for (SBAComponent updatedComponent : newReaction.getProducts()) {
                for (SBAComponent component : components) {
                    if (!updatedComponent.equals(component)) continue;
                    component.setStoichiometry(updatedComponent.getStoichiometry());
                    continue block6;
                }
            }
        }
    }

    private class MappingVisitor
    extends MoveOnVisitor {
        Iterator<HashMap<String, String>> iterator;
        HashSet<String> labelledComponents;

        MappingVisitor(HashSet<String> labelledComponents) {
            this.labelledComponents = labelledComponents;
            this.iterator = PEPAtoSBA.this.nameMap.iterator();
        }

        public void createNext() {
            Mapping newMapping = new Mapping();
            newMapping.previous = PEPAtoSBA.this.map;
            if (PEPAtoSBA.this.map != null) {
                PEPAtoSBA.this.map.next = newMapping;
            }
            PEPAtoSBA.this.map = newMapping;
        }

        @Override
        public void visitConstantProcessNode(ConstantProcessNode constantProcessNode) {
            for (Map.Entry<String, String> me : this.iterator.next().entrySet()) {
                if (this.labelledComponents.contains(me.getValue())) {
                    PEPAtoSBA.this.map.labelled.put(me.getKey(), me.getValue());
                    continue;
                }
                PEPAtoSBA.this.map.unlabelled.put(me.getKey(), me.getValue());
            }
        }
    }

    private class ParseVisitor
    implements ASTVisitor {
        Model compiledModel;
        ReactionBuilder currentReaction;
        Set<SBAReaction> currentReactions;
        Set<Link> done = new HashSet<Link>();
        Set<String> synchedActions = new HashSet<String>();
        String lastConstant;
        String error = null;
        Stack<Link> todo = new Stack();

        private ParseVisitor() {
        }

        @Override
        public void visitActionTypeNode(ActionTypeNode actionType) {
            throw new SBAVisitorException(Thread.currentThread().getStackTrace());
        }

        @Override
        public void visitActivityNode(ActivityNode activity) {
            throw new SBAVisitorException(Thread.currentThread().getStackTrace());
        }

        @Override
        public void visitAggregationNode(AggregationNode aggregation) {
            aggregation.getProcessNode().accept(this);
            ExpressionVisitor v = new ExpressionVisitor(this.compiledModel);
            aggregation.getCopies().accept(v);
            PEPAtoSBA.this.sbaPopulations.put(this.lastConstant, new Integer(v.eval()));
        }

        @Override
        public void visitBinaryOperatorRateNode(BinaryOperatorRateNode rate) {
            throw new SBAVisitorException(Thread.currentThread().getStackTrace());
        }

        @Override
        public void visitChoiceNode(ChoiceNode choice) {
            throw new SBAVisitorException(Thread.currentThread().getStackTrace());
        }

        @Override
        public void visitConstantProcessNode(ConstantProcessNode constant) {
            this.lastConstant = constant.getName();
            PEPAtoSBA.this.sbaPopulations.put(this.lastConstant, new Integer(1));
            this.genReac();
        }

        @Override
        public void visitCooperationNode(CooperationNode cooperation) {
            boolean topSynch;
            SBAReaction sbar2;
            HashSet<String> coopSet = new HashSet<String>();
            HashSet<String> synchedHere = new HashSet<String>();
            for (ActionTypeNode atn : cooperation.getActionSet()) {
                coopSet.add(atn.getType());
            }
            for (String s : coopSet) {
                if (!this.synchedActions.add(s)) continue;
                synchedHere.add(s);
            }
            cooperation.getLeft().accept(this);
            Set<SBAReaction> left = this.currentReactions;
            System.out.println("----- Left -----");
            for (SBAReaction sbar2 : left) {
                System.out.println(sbar2);
            }
            cooperation.getRight().accept(this);
            Set<SBAReaction> right = this.currentReactions;
            System.out.println("----- Right -----");
            for (SBAReaction sbar2 : right) {
                System.out.println(sbar2);
            }
            this.currentReactions = new HashSet<SBAReaction>();
            sbar2 = null;
            HashMap<String, CompiledRate> rates = new HashMap<String, CompiledRate>();
            for (SBAReaction l : left) {
                boolean leftUsed = false;
                String name = l.getName();
                boolean synchedOn = coopSet.contains(name);
                topSynch = synchedHere.contains(name);
                for (SBAReaction r : right) {
                    if (!name.equals(r.getName())) continue;
                    leftUsed = true;
                    if (synchedOn) {
                        sbar2 = l.merge(r);
                        if (topSynch) {
                            if (sbar2.overall == null) {
                                sbar2.overall = new CompiledRate(1);
                            }
                            sbar2.overall = sbar2.overall.op(BinaryOperatorRateNode.Operator.MULT, sbar2.numerator);
                        }
                    } else if (l.passive == r.passive) {
                        sbar2 = l.clone();
                        sbar2.denominator = sbar2.denominator.op(BinaryOperatorRateNode.Operator.PLUS, r.denominator);
                        rates.put(name, sbar2.denominator.clone());
                        if (topSynch) {
                            if (sbar2.overall == null) {
                                sbar2.overall = new CompiledRate(1);
                            }
                            sbar2.overall = sbar2.overall.op(BinaryOperatorRateNode.Operator.MULT, sbar2.numerator.op(BinaryOperatorRateNode.Operator.DIV, sbar2.denominator));
                        }
                    } else {
                        throw new SBAVisitorException("");
                    }
                    this.currentReactions.add(sbar2);
                }
                if (leftUsed) continue;
                this.currentReactions.add(l);
            }
            for (SBAReaction r : right) {
                if (coopSet.contains(r.getName())) continue;
                CompiledRate c = (CompiledRate)rates.get(r.getName());
                topSynch = synchedHere.contains(r.getName());
                if (c != null) {
                    r.denominator = c;
                    if (topSynch) {
                        if (r.overall == null) {
                            r.overall = new CompiledRate(1);
                        }
                        r.overall = r.overall.op(BinaryOperatorRateNode.Operator.MULT, r.numerator.op(BinaryOperatorRateNode.Operator.DIV, r.denominator));
                    }
                }
                this.currentReactions.add(r);
            }
            for (String s : synchedHere) {
                this.synchedActions.remove(s);
            }
        }

        @Override
        public void visitHidingNode(HidingNode hiding) {
            hiding.getProcess().accept(this);
            HashSet<String> hideSet = new HashSet<String>();
            for (ActionTypeNode atn : hiding.getActionSet()) {
                hideSet.add(atn.getType());
            }
            for (SBAReaction sbar : this.currentReactions) {
                if (!hideSet.contains(sbar.name)) continue;
                sbar.hide();
            }
        }

        @Override
        public void visitModelNode(ModelNode model) {
            this.compiledModel = new Compiler(model).getModel();
            this.synchedActions.clear();
            model.getSystemEquation().accept(this);
            for (SBAReaction sbar : this.currentReactions) {
                if (sbar.reactants.size() != 1) continue;
                sbar.numerator = sbar.overall = CompiledRate.compileRate(sbar.reactants.getFirst().rate, PEPAtoSBA.this.sbaRates);
            }
            PEPAtoSBA.this.sbaReactions = this.currentReactions;
        }

        @Override
        public void visitPassiveRateNode(PassiveRateNode passive) {
            throw new SBAVisitorException(Thread.currentThread().getStackTrace());
        }

        @Override
        public void visitPrefixNode(PrefixNode prefix) {
            throw new SBAVisitorException(Thread.currentThread().getStackTrace());
        }

        @Override
        public void visitProcessDefinitionNode(ProcessDefinitionNode processDefinition) {
            throw new SBAVisitorException(Thread.currentThread().getStackTrace());
        }

        @Override
        public void visitRateDefinitionNode(RateDefinitionNode rateDefinition) {
            throw new SBAVisitorException(Thread.currentThread().getStackTrace());
        }

        @Override
        public void visitRateDoubleNode(RateDoubleNode doubleRate) {
            throw new SBAVisitorException(Thread.currentThread().getStackTrace());
        }

        @Override
        public void visitUnknownActionTypeNode(UnknownActionTypeNode unknownActionTypeNode) {
            throw new SBAVisitorException(Thread.currentThread().getStackTrace());
        }

        @Override
        public void visitVariableRateNode(VariableRateNode variableRate) {
            throw new SBAVisitorException(Thread.currentThread().getStackTrace());
        }

        @Override
        public void visitWildcardCooperationNode(WildcardCooperationNode cooperation) {
            HashSet<String> synchedHere = new HashSet<String>();
            for (String s : PEPAtoSBA.this.actions) {
                if (!this.synchedActions.add(s)) continue;
                synchedHere.add(s);
            }
            cooperation.getLeft().accept(this);
            Set<SBAReaction> left = this.currentReactions;
            cooperation.getRight().accept(this);
            Set<SBAReaction> right = this.currentReactions;
            this.currentReactions = new HashSet<SBAReaction>();
            HashSet<String> used = new HashSet<String>();
            for (SBAReaction l : left) {
                boolean unused = true;
                String name = l.getName();
                used.add(name);
                boolean topSynch = synchedHere.contains(name);
                for (SBAReaction r : right) {
                    if (!r.getName().equals(name)) continue;
                    SBAReaction sbar = l.merge(r);
                    if (topSynch) {
                        if (sbar.overall == null) {
                            sbar.overall = new CompiledRate(1);
                        }
                        sbar.overall = sbar.overall.op(BinaryOperatorRateNode.Operator.MULT, sbar.numerator);
                    }
                    this.currentReactions.add(sbar);
                    unused = false;
                }
                if (!unused) continue;
                if (topSynch) {
                    if (l.overall == null) {
                        l.overall = new CompiledRate(1);
                    }
                    l.overall = l.overall.op(BinaryOperatorRateNode.Operator.MULT, l.numerator);
                }
                this.currentReactions.add(l);
            }
            for (SBAReaction r : right) {
                if (used.contains(r.getName())) continue;
                if (synchedHere.contains(r.getName())) {
                    if (r.overall == null) {
                        r.overall = new CompiledRate(1);
                    }
                    r.overall = r.overall.op(BinaryOperatorRateNode.Operator.MULT, r.numerator);
                }
                this.currentReactions.add(r);
            }
            for (String s : synchedHere) {
                this.synchedActions.remove(s);
            }
        }

        private final void genReac() throws SBAVisitorException {
            this.todo.clear();
            this.done.clear();
            this.currentReactions = new HashSet<SBAReaction>();
            this.todo.push(new Link(this.lastConstant, null));
            while (!this.todo.isEmpty()) {
                Link currentConstant = this.todo.pop();
                if (!this.done.add(currentConstant)) continue;
                this.currentReaction = PEPAtoSBA.this.reactions.get(currentConstant.to == null ? currentConstant.from : currentConstant.to);
                ReactionsSet reactionsSet = this.currentReaction.generateReactions(currentConstant.from);
                this.currentReactions.addAll(reactionsSet.reactions);
                for (Map.Entry<String, String> me : reactionsSet.reactionsToIterate.entrySet()) {
                    this.todo.add(new Link(me.getKey(), me.getValue()));
                }
            }
            HashMap map = new HashMap();
            for (SBAReaction sbar : this.currentReactions) {
                if (!map.containsKey(sbar.name)) {
                    map.put(sbar.name, new LinkedList());
                }
                ((List)map.get(sbar.name)).add(sbar);
            }
            assert (!map.containsKey("tau"));
            map.remove("tau");
            CompiledRate c1 = null;
            boolean passive = false;
            for (Map.Entry me : map.entrySet()) {
                List list = (List)me.getValue();
                CompiledRate c2 = null;
                passive = CompiledRate.isPassive(((SBAReaction)list.get((int)0)).reactants.getFirst());
                String firstComponent = ((SBAReaction)list.get((int)0)).sourceDefinition;
                for (SBAReaction sbar : list) {
                    SBAComponent sbac = sbar.reactants.getFirst();
                    sbar.passive = passive;
                    if (passive) {
                        c1 = CompiledRate.passive(sbac);
                        if (c1 == null) {
                            this.error = firstComponent.equals(sbar.sourceDefinition) ? "Cannot parse model for time-series analysis. Action " + (String)me.getKey() + " is defined as both passive and active in " + firstComponent + ", a reachable component state from " + this.lastConstant + "." : "Cannot parse model for time-series analysis. Action " + (String)me.getKey() + " is defined as passive in " + firstComponent + " and active in " + sbar.sourceDefinition + ", both reachable component states from " + this.lastConstant + ".";
                            throw new SBAVisitorException(this.error);
                        }
                    } else {
                        if (CompiledRate.isPassive(sbac)) {
                            this.error = firstComponent.equals(sbar.sourceDefinition) ? "Cannot parse model for time-series analysis. Action " + (String)me.getKey() + " is defined as both passive and active in " + firstComponent + ", a reachable component state from " + this.lastConstant + "." : "Cannot parse model for time-series analysis. Action " + (String)me.getKey() + " is defined as passive in " + sbar.sourceDefinition + " and active in " + firstComponent + ", both reachable component states from " + this.lastConstant + ".";
                            throw new SBAVisitorException(this.error);
                        }
                        c1 = CompiledRate.compileRate(sbac.rate, PEPAtoSBA.this.sbaRates);
                        c1 = c1.op(BinaryOperatorRateNode.Operator.MULT, new CompiledRate(sbac));
                    }
                    c2 = c2 == null ? c1 : c1.op(BinaryOperatorRateNode.Operator.PLUS, c2);
                    sbar.numerator = c1;
                }
                for (SBAReaction sbar : list) {
                    sbar.denominator = c2;
                }
            }
        }

        private class Link {
            String from;
            String to;

            Link(String from, String to) {
                if (from == null) {
                    throw new NullPointerException("Key in Link cannot be null");
                }
                this.from = from;
                this.to = to;
            }

            public boolean equals(Object o) {
                if (o == null || !(o instanceof Link)) {
                    return false;
                }
                Link l = (Link)o;
                return this.from.equals(l.from) && (this.to == null ? l.to == null : this.to.equals(this.to));
            }

            public int hashCode() {
                return (this.to == null ? this.from : String.valueOf(this.from) + this.to).hashCode();
            }
        }
    }

    private class PreParseVisitor
    implements ASTVisitor {
        String constantLabel;
        String action;
        ReactionBuilder currentReactionBuilder;
        Map<String, RateNode> rates = new HashMap<String, RateNode>();
        Map<String, String> mapping = new HashMap<String, String>();
        Set<String> actions = new HashSet<String>();

        PreParseVisitor() {
        }

        @Override
        public void visitActionTypeNode(ActionTypeNode actionType) {
            this.action = actionType.getType();
            this.actions.add(this.action);
        }

        @Override
        public void visitActivityNode(ActivityNode activity) {
            activity.getRate().accept(this);
            activity.getAction().accept(this);
        }

        @Override
        public void visitAggregationNode(AggregationNode aggregation) {
            throw new SBAVisitorException(Thread.currentThread().getStackTrace());
        }

        @Override
        public void visitBinaryOperatorRateNode(BinaryOperatorRateNode rate) {
            rate.getLeft().accept(this);
            rate.getRight().accept(this);
        }

        @Override
        public void visitChoiceNode(ChoiceNode choice) {
            ProcessNode[] nodes = new ProcessNode[]{choice.getLeft(), choice.getRight()};
            ReactionBuilder merged = new ReactionBuilder();
            ProcessNode[] processNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                ProcessNode pn = processNodeArray[n2];
                pn.accept(this);
                if (this.constantLabel != null) {
                    merged.addReaction(this.constantLabel, null, null);
                    this.constantLabel = null;
                } else {
                    merged = merged.merge(this.currentReactionBuilder);
                }
                ++n2;
            }
            this.currentReactionBuilder = merged;
        }

        @Override
        public void visitConstantProcessNode(ConstantProcessNode constant) {
            this.constantLabel = constant.getName();
            this.currentReactionBuilder = null;
        }

        @Override
        public void visitCooperationNode(CooperationNode cooperation) {
            throw new SBAVisitorException(Thread.currentThread().getStackTrace());
        }

        @Override
        public void visitHidingNode(HidingNode hiding) {
            throw new SBAVisitorException(Thread.currentThread().getStackTrace());
        }

        @Override
        public void visitModelNode(ModelNode model) {
            this.mapping.clear();
            this.actions.clear();
            for (RateDefinitionNode rdn : model.rateDefinitions()) {
                this.rates.put(rdn.getName().getName(), rdn.getRate());
            }
            for (ProcessDefinitionNode pdn : model.processDefinitions()) {
                pdn.accept(this);
            }
            for (Map.Entry<String, String> me : this.mapping.entrySet()) {
                ReactionBuilder rb = PEPAtoSBA.this.reactions.get(me.getValue());
                rb = rb.clone();
                String originalComponent = PEPAtoSBA.this.originalDef.get(me.getKey());
                if (originalComponent == null) {
                    originalComponent = me.getKey();
                }
                rb.setSource(originalComponent);
                PEPAtoSBA.this.reactions.put(me.getKey(), rb);
            }
        }

        @Override
        public void visitPassiveRateNode(PassiveRateNode passive) {
        }

        @Override
        public void visitPrefixNode(PrefixNode prefix) {
            prefix.getTarget().accept(this);
            prefix.getActivity().accept(this);
            ReactionBuilder r = new ReactionBuilder();
            if (this.constantLabel != null) {
                r.addReaction(this.constantLabel, this.action, prefix.getActivity().getRate());
                this.constantLabel = null;
            } else {
                r.addReaction(this.currentReactionBuilder, this.action, prefix.getActivity().getRate());
                r.link(this.currentReactionBuilder);
            }
            this.currentReactionBuilder = r;
        }

        @Override
        public void visitProcessDefinitionNode(ProcessDefinitionNode processDefinition) {
            processDefinition.getNode().accept(this);
            if (this.currentReactionBuilder != null) {
                String originalComponent = PEPAtoSBA.this.originalDef.get(processDefinition.getName().getName());
                if (originalComponent == null) {
                    originalComponent = processDefinition.getName().getName();
                }
                this.currentReactionBuilder.setSource(originalComponent);
                PEPAtoSBA.this.reactions.put(processDefinition.getName().getName(), this.currentReactionBuilder);
            } else {
                this.mapping.put(processDefinition.getName().getName(), this.constantLabel);
            }
        }

        @Override
        public void visitRateDefinitionNode(RateDefinitionNode rateDefinition) {
            throw new SBAVisitorException(Thread.currentThread().getStackTrace());
        }

        @Override
        public void visitRateDoubleNode(RateDoubleNode doubleRate) {
        }

        @Override
        public void visitUnknownActionTypeNode(UnknownActionTypeNode unknownActionTypeNode) {
            this.action = "tau";
        }

        @Override
        public void visitVariableRateNode(VariableRateNode variableRate) {
            String s = variableRate.getName();
            if (this.rates.containsKey(s)) {
                PEPAtoSBA.this.sbaRates.put(s, this.rates.get(s));
                this.rates.get(s).accept(this);
            }
        }

        @Override
        public void visitWildcardCooperationNode(WildcardCooperationNode cooperation) {
            throw new SBAVisitorException(Thread.currentThread().getStackTrace());
        }
    }
}

