/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.sba;

import org.systemsbiology.chem.SimulationResults;

public class Results {
    private SimulationResults simulationResults;

    Results(SimulationResults results) {
        this.simulationResults = results;
    }

    public synchronized double[] getReactionCounts() {
        return this.simulationResults.getReactionCounts();
    }

    public synchronized String[] getReactionOrdering() {
        return this.simulationResults.getReactionNames();
    }

    public synchronized double[] getReactionTimes() {
        return this.simulationResults.getReactionTimes();
    }

    public synchronized double[][] getSimpleTimeSeries() {
        double[] times = this.simulationResults.getResultsTimeValues();
        Object[] values = this.simulationResults.getResultsSymbolValues();
        double[][] results = new double[times.length][this.simulationResults.getResultsSymbolNames().length + 1];
        int i = 0;
        while (i < times.length) {
            results[i][0] = times[i];
            ++i;
        }
        i = 0;
        while (i < values.length) {
            double[] value = (double[])values[i];
            int i2 = 0;
            while (i2 < value.length) {
                results[i][i2 + 1] = value[i2];
                ++i2;
            }
            ++i;
        }
        return results;
    }

    public synchronized String[] getSpeciesOrdering() {
        return this.simulationResults.getResultsSymbolNames();
    }

    public String returnSimpleResults() {
        StringBuilder results = new StringBuilder();
        String[] names = this.simulationResults.getResultsSymbolNames();
        results.append("# time");
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            results.append(", ").append(name);
            ++n2;
        }
        results.append("\n");
        double[] times = this.simulationResults.getResultsTimeValues();
        Object[] values = this.simulationResults.getResultsSymbolValues();
        int i = 0;
        while (i < values.length) {
            double[] value;
            results.append(times[i]);
            double[] dArray = value = (double[])values[i];
            int n3 = value.length;
            int n4 = 0;
            while (n4 < n3) {
                double d = dArray[n4];
                results.append(", ").append(d);
                ++n4;
            }
            results.append("\n");
            ++i;
        }
        return results.toString();
    }
}

