/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.sba;

import uk.ac.ed.inf.pepa.parsing.ASTSupport;
import uk.ac.ed.inf.pepa.parsing.RateNode;

public class SBAComponent
implements Comparable<SBAComponent> {
    boolean catalyst;
    boolean inhibitor;
    final String name;
    RateNode rate;
    int stoichiometry;

    SBAComponent(String name, RateNode rate) {
        if (name == null) {
            throw new NullPointerException("Component must have a defined name. Cannot pass null argument.");
        }
        this.name = name;
        this.catalyst = false;
        this.inhibitor = false;
        this.stoichiometry = 1;
        this.setRate(rate);
    }

    public SBAComponent clone() {
        SBAComponent c = new SBAComponent(this.name, (RateNode)ASTSupport.copy(this.rate));
        c.stoichiometry = this.stoichiometry;
        c.catalyst = this.catalyst;
        c.inhibitor = this.inhibitor;
        return c;
    }

    @Override
    public int compareTo(SBAComponent c) {
        return this.name.compareTo(c.name);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SBAComponent)) {
            return false;
        }
        return this.name.equals(((SBAComponent)o).name);
    }

    public String getName() {
        return this.name;
    }

    public int getStoichiometry() {
        return this.stoichiometry;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean isCatalyst() {
        return this.catalyst;
    }

    public boolean isInhibitor() {
        return this.inhibitor;
    }

    void makeCatalyst() {
        this.catalyst = true;
        this.inhibitor = false;
    }

    void makeInhibitor() {
        this.inhibitor = true;
        this.catalyst = false;
    }

    void makeReactant() {
        this.inhibitor = false;
        this.catalyst = false;
    }

    void setRate(RateNode rate) {
        if (rate == null) {
            throw new NullPointerException("Invalid rate for component " + this.name + ". Rates must be defined.");
        }
        this.rate = rate;
    }

    public void setStoichiometry(int stoichiometry) {
        if ((this.catalyst || this.inhibitor) && stoichiometry != 1) {
            throw new IllegalArgumentException("Illegal Argument for Component " + this.name + ". Stoichiometric rate for catalysts or inhibitors is not legal.");
        }
        if (stoichiometry < 1) {
            throw new IllegalArgumentException("Illegal Argument for Component " + this.name + ". Stoichiometric values must greater than or equal to 1.");
        }
        this.stoichiometry = stoichiometry;
    }

    String toCMDL() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.stoichiometry) {
            if (this.catalyst || this.inhibitor) {
                sb.append("$");
            }
            sb.append(this.name).append(" + ");
            ++i;
        }
        sb.delete(sb.length() - 3, sb.length());
        return sb.toString();
    }

    public String toString() {
        if (this.stoichiometry > 1) {
            return String.valueOf(this.stoichiometry) + "." + this.name;
        }
        return this.name;
    }
}

