/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.sba;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import uk.ac.ed.inf.pepa.parsing.BinaryOperatorRateNode;
import uk.ac.ed.inf.pepa.sba.CompiledRate;
import uk.ac.ed.inf.pepa.sba.SBAComponent;

public class SBAReaction {
    String name = null;
    String sourceDefinition;
    boolean passive;
    CompiledRate numerator = null;
    CompiledRate denominator = null;
    CompiledRate overall = null;
    LinkedList<SBAComponent> reactants = new LinkedList();
    LinkedList<SBAComponent> products = new LinkedList();

    SBAReaction() {
    }

    SBAReaction(String name) {
        this();
        this.name = name;
    }

    void hide() {
        this.name = "tau";
    }

    boolean addProduct(SBAComponent c) {
        if (c == null) {
            throw new NullPointerException("All components must be defined in the reaction " + (this.name == null ? "." : String.valueOf(this.name) + "."));
        }
        if (c.catalyst || c.inhibitor) {
            throw new IllegalArgumentException("Products in " + (this.name == null ? "a reaction" : "reaction " + this.name) + " cannot act as catalysts or inhibitors.");
        }
        if (this.products.contains(c)) {
            return false;
        }
        return this.products.add(c);
    }

    boolean addReactant(SBAComponent c) {
        if (c == null) {
            throw new NullPointerException("All components must be defined in the reaction " + (this.name == null ? "." : String.valueOf(this.name) + "."));
        }
        if (this.reactants.contains(c)) {
            return false;
        }
        return this.reactants.add(c);
    }

    public SBAReaction clone() {
        SBAReaction clone = new SBAReaction(this.name);
        for (SBAComponent c : this.reactants) {
            clone.reactants.add(c.clone());
        }
        for (SBAComponent c : this.products) {
            clone.products.add(c.clone());
        }
        clone.passive = this.passive;
        if (this.numerator != null) {
            clone.numerator = this.numerator.clone();
        }
        if (this.denominator != null) {
            clone.denominator = this.denominator.clone();
        }
        if (this.overall != null) {
            clone.overall = this.overall.clone();
        }
        return clone;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SBAReaction)) {
            return false;
        }
        SBAReaction r = (SBAReaction)o;
        return (this.name == null ? r.name == null : this.name.equals(r.name)) && this.reactants.containsAll(r.reactants) && r.reactants.containsAll(this.reactants) && this.products.containsAll(r.products) && r.products.containsAll(this.products);
    }

    public int hashCode() {
        return (this.name == null ? 0 : this.name.hashCode()) ^ this.reactants.hashCode() ^ this.products.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public List<SBAComponent> getProducts() {
        return (LinkedList)this.products.clone();
    }

    public List<SBAComponent> getReactants() {
        return (LinkedList)this.reactants.clone();
    }

    SBAReaction merge(SBAReaction r) {
        if (!this.name.equals(r.name)) {
            throw new IllegalArgumentException("Reaction names must agree to allow merge. " + this.name + " != " + r.name);
        }
        SBAReaction merged = new SBAReaction();
        merged.name = this.name;
        for (SBAComponent c : this.reactants) {
            merged.reactants.add(c.clone());
        }
        for (SBAComponent c : this.products) {
            merged.products.add(c.clone());
        }
        for (SBAComponent c : r.reactants) {
            if (merged.addReactant(c.clone())) continue;
            throw new IllegalArgumentException("Error. Component " + c.name + " exists in both reaction " + this.name + " and " + r.name + ".");
        }
        for (SBAComponent c : r.products) {
            if (merged.addProduct(c.clone())) continue;
            throw new IllegalArgumentException("Error. Component " + c.name + " exists in both reaction " + this.name + " and " + r.name + ".");
        }
        if (this.numerator == null && this.denominator == null && this.overall == null && r.numerator == null && r.denominator == null && r.overall == null) {
            return merged;
        }
        merged.passive = this.passive && r.passive;
        merged.overall = new CompiledRate(1);
        if (this.passive) {
            merged.overall = CompiledRate.theta(this.numerator);
            if (!this.numerator.equals(this.denominator)) {
                merged.overall = merged.overall.op(BinaryOperatorRateNode.Operator.MULT, this.numerator.stabilisedRatio(this.denominator));
            }
        } else if (!this.numerator.equals(this.denominator)) {
            merged.overall = this.numerator.stabilisedRatio(this.denominator);
        }
        if (r.passive) {
            merged.overall = merged.overall.op(BinaryOperatorRateNode.Operator.MULT, CompiledRate.theta(r.numerator));
            if (!r.numerator.equals(r.denominator)) {
                merged.overall = merged.overall.op(BinaryOperatorRateNode.Operator.MULT, r.numerator.stabilisedRatio(r.denominator));
            }
        } else if (!r.numerator.equals(r.denominator)) {
            merged.overall = merged.overall.op(BinaryOperatorRateNode.Operator.MULT, r.numerator.stabilisedRatio(r.denominator));
        }
        if (this.overall != null) {
            merged.overall = merged.overall.op(BinaryOperatorRateNode.Operator.MULT, this.overall);
        }
        if (r.overall != null) {
            merged.overall = merged.overall.op(BinaryOperatorRateNode.Operator.MULT, r.overall);
        }
        if (this.passive == r.passive) {
            merged.numerator = merged.denominator = CompiledRate.min(this.denominator, r.denominator);
        } else {
            merged.denominator = this.passive ? r.denominator : this.denominator;
            merged.numerator = merged.denominator;
        }
        return merged;
    }

    boolean removeProduct(SBAComponent c) {
        return this.products.remove(c);
    }

    boolean removeProduct(String s) {
        Iterator i = this.products.iterator();
        while (i.hasNext()) {
            if (!((SBAComponent)i.next()).name.equals(s)) continue;
            i.remove();
            return true;
        }
        return false;
    }

    boolean removeReactant(SBAComponent c) {
        return this.reactants.remove(c);
    }

    boolean removeReactant(String s) {
        Iterator i = this.reactants.iterator();
        while (i.hasNext()) {
            if (!((SBAComponent)i.next()).name.equals(s)) continue;
            i.remove();
            return true;
        }
        return false;
    }

    void setName(String name) {
        this.name = name;
    }

    String toCMDL() {
        StringBuilder s = new StringBuilder();
        if (this.name != null) {
            s.append(this.name).append(", ");
        }
        for (SBAComponent r : this.reactants) {
            s.append(r.toCMDL()).append(" + ");
        }
        if (this.reactants.size() > 0) {
            s.delete(s.length() - 3, s.length());
        }
        s.append(" -> ");
        for (SBAComponent p : this.products) {
            s.append(p.toCMDL()).append(" + ");
        }
        if (this.products.size() > 0) {
            s.delete(s.length() - 3, s.length());
        }
        return s.toString();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (SBAComponent r : this.reactants) {
            s.append(r.toString()).append(" + ");
        }
        if (this.reactants.size() > 0) {
            s.delete(s.length() - 3, s.length());
        }
        s.append(" -> ");
        for (SBAComponent p : this.products) {
            s.append(p.toString()).append(" + ");
        }
        if (this.products.size() > 0) {
            s.delete(s.length() - 3, s.length());
        }
        return s.toString();
    }
}

