/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.sba;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;
import uk.ac.ed.inf.pepa.analysis.IAlphabetProvider;
import uk.ac.ed.inf.pepa.analysis.internal.AlphabetProvider;
import uk.ac.ed.inf.pepa.parsing.ASTSupport;
import uk.ac.ed.inf.pepa.parsing.ASTVisitor;
import uk.ac.ed.inf.pepa.parsing.ActionTypeNode;
import uk.ac.ed.inf.pepa.parsing.ActivityNode;
import uk.ac.ed.inf.pepa.parsing.AggregationNode;
import uk.ac.ed.inf.pepa.parsing.BinaryOperatorProcessNode;
import uk.ac.ed.inf.pepa.parsing.BinaryOperatorRateNode;
import uk.ac.ed.inf.pepa.parsing.ChoiceNode;
import uk.ac.ed.inf.pepa.parsing.ConstantProcessNode;
import uk.ac.ed.inf.pepa.parsing.CooperationNode;
import uk.ac.ed.inf.pepa.parsing.HidingNode;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.parsing.MoveOnVisitor;
import uk.ac.ed.inf.pepa.parsing.PassiveRateNode;
import uk.ac.ed.inf.pepa.parsing.PrefixNode;
import uk.ac.ed.inf.pepa.parsing.ProcessDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.ProcessDefinitions;
import uk.ac.ed.inf.pepa.parsing.ProcessNode;
import uk.ac.ed.inf.pepa.parsing.RateDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.RateDoubleNode;
import uk.ac.ed.inf.pepa.parsing.UnknownActionTypeNode;
import uk.ac.ed.inf.pepa.parsing.VariableRateNode;
import uk.ac.ed.inf.pepa.parsing.WildcardCooperationNode;
import uk.ac.ed.inf.pepa.sba.SBAVisitorException;

public class SBASupport {
    private static IAlphabetProvider alphabetProvider;
    private static ConstantCountVisitor ccv;
    private static ConstantRenamerVisitor crv;
    private static ExpandEquationVisitor eev;

    static {
        ccv = new ConstantCountVisitor();
        crv = new ConstantRenamerVisitor();
        eev = new ExpandEquationVisitor();
    }

    public static synchronized ProcessNode expandSystemEquation(ModelNode model) {
        model.accept(eev);
        return SBASupport.eev.expandedSystemEquation;
    }

    public static synchronized LinkedList<HashMap<String, String>> flattenNameSpace(ModelNode model, boolean aggregateWherePossible) {
        model.setSystemEquation(SBASupport.expandSystemEquation(model));
        if (aggregateWherePossible) {
            model.setSystemEquation(ASTSupport.enforceAggregation(model.getSystemEquation(), model));
        }
        alphabetProvider = new AlphabetProvider(model);
        SBASupport.ccv.alphabet = alphabetProvider.getProcessAlphabets();
        SBASupport.crv.alphabet = SBASupport.ccv.alphabet;
        model.accept(ccv);
        SBASupport.crv.multipleConstants = SBASupport.ccv.multipleConstants;
        model.accept(crv);
        return SBASupport.crv.nameMapping;
    }

    private static class ConstantCountVisitor
    extends MoveOnVisitor {
        HashMap<String, HashSet<String>> alphabet;
        private HashMap<String, Integer> constantCount;
        HashSet<String> multipleConstants;

        private ConstantCountVisitor() {
        }

        @Override
        public void visitConstantProcessNode(ConstantProcessNode constant) {
            HashSet<String> hashSet = new HashSet<String>((Collection)this.alphabet.get(constant.getName()));
            hashSet.add(constant.getName());
            for (String name : hashSet) {
                int i = this.constantCount.get(name);
                this.constantCount.put(name, i + 1);
            }
        }

        @Override
        public void visitModelNode(ModelNode model) {
            this.constantCount = new HashMap();
            for (String string : this.alphabet.keySet()) {
                this.constantCount.put(string, 0);
            }
            model.getSystemEquation().accept(this);
            this.multipleConstants = new HashSet();
            for (Map.Entry entry : this.constantCount.entrySet()) {
                if ((Integer)entry.getValue() <= 1) continue;
                this.multipleConstants.add((String)entry.getKey());
            }
            this.constantCount = null;
            this.alphabet = null;
        }
    }

    private static class ConstantRenamerVisitor
    extends MoveOnVisitor {
        HashMap<String, HashSet<String>> alphabet;
        private HashMap<String, Integer> constantCount;
        HashSet<String> multipleConstants;
        LinkedList<HashMap<String, String>> nameMapping;
        private ProcessDefinitions newDefinitions;
        private String postfix;
        private HashMap<String, ProcessDefinitionNode> processMap;
        private boolean renaming;

        private ConstantRenamerVisitor() {
        }

        @Override
        public void visitConstantProcessNode(ConstantProcessNode constant) {
            String constantsName = constant.getName();
            if (!this.renaming) {
                this.nameMapping.add(new HashMap());
                HashSet<String> tHashSet = this.alphabet.get(constantsName);
                tHashSet.add(constantsName);
                for (String name : tHashSet) {
                    int i = this.constantCount.get(name);
                    this.constantCount.put(name, i + 1);
                }
                this.renaming = true;
                for (String name : tHashSet) {
                    ProcessDefinitionNode pdn = (ProcessDefinitionNode)ASTSupport.copy(this.processMap.get(name));
                    this.newDefinitions.add(pdn);
                    pdn.accept(this);
                }
                this.renaming = false;
            }
            if (this.multipleConstants.contains(constantsName)) {
                String newName = constantsName.startsWith("\"") ? String.valueOf(constantsName.substring(0, constantsName.length() - 1)) + this.postfix + this.constantCount.get(constantsName).toString() + "\"" : String.valueOf(constantsName) + this.postfix + this.constantCount.get(constantsName).toString();
                constant.setName(newName);
                this.nameMapping.getLast().put(newName, constantsName);
            } else {
                this.nameMapping.getLast().put(constantsName, constantsName);
            }
        }

        @Override
        public void visitModelNode(ModelNode model) {
            this.constantCount = new HashMap();
            this.processMap = new HashMap();
            this.newDefinitions = new ProcessDefinitions();
            for (ProcessDefinitionNode pdn : model.processDefinitions()) {
                this.processMap.put(pdn.getName().getName(), pdn);
            }
            for (String constant : this.processMap.keySet()) {
                this.constantCount.put(constant, 0);
            }
            boolean postfixFound = false;
            int underscores = 0;
            block2: while (!postfixFound) {
                ++underscores;
                postfixFound = true;
                LinkedList<String> definedNames = new LinkedList<String>(this.constantCount.keySet());
                while (!definedNames.isEmpty()) {
                    String currentDefinedName = definedNames.remove();
                    Pattern p = currentDefinedName.startsWith("\"") ? Pattern.compile(String.valueOf(currentDefinedName.substring(0, currentDefinedName.length() - 1)) + "_{" + underscores + "}\\d+\"") : Pattern.compile(String.valueOf(currentDefinedName) + "_{" + underscores + "}\\d+");
                    for (String next : definedNames) {
                        if (!p.matcher(next).matches()) continue;
                        postfixFound = false;
                        continue block2;
                    }
                }
            }
            this.postfix = "";
            while (underscores-- > 0) {
                this.postfix = String.valueOf(this.postfix) + "_";
            }
            this.renaming = false;
            this.nameMapping = new LinkedList();
            model.getSystemEquation().accept(this);
            model.processDefinitions().clear();
            model.processDefinitions().addAll(this.newDefinitions);
            this.alphabet = null;
            this.processMap = null;
            this.newDefinitions = null;
            this.constantCount = null;
            this.multipleConstants = null;
        }

        @Override
        public void visitProcessDefinitionNode(ProcessDefinitionNode processDefinition) {
            processDefinition.getName().accept(this);
            processDefinition.getNode().accept(this);
        }
    }

    private static class ExpandEquationVisitor
    implements ASTVisitor {
        String currentConstant;
        ProcessNode currentNode;
        ProcessNode expandedSystemEquation;
        boolean expanding;
        boolean compositional;
        boolean toReplace;
        boolean processDefinitionNode;
        HashMap<String, ProcessNode> replaceableNodes;

        private ExpandEquationVisitor() {
        }

        @Override
        public void visitActionTypeNode(ActionTypeNode actionType) {
            throw new SBAVisitorException(Thread.currentThread().getStackTrace());
        }

        @Override
        public void visitActivityNode(ActivityNode activity) {
            throw new SBAVisitorException(Thread.currentThread().getStackTrace());
        }

        @Override
        public void visitAggregationNode(AggregationNode aggregation) {
            if (!this.expanding) {
                this.compositional = true;
            }
        }

        private void visitBinaryOperatorProcessNode(BinaryOperatorProcessNode binary) {
            if (!this.expanding) {
                this.compositional = true;
            } else {
                binary.getLeft().accept(this);
                if (this.toReplace) {
                    binary.setLeft(this.currentNode);
                    this.toReplace = false;
                    this.currentNode.accept(this);
                }
                binary.getRight().accept(this);
                if (this.toReplace) {
                    binary.setRight(this.currentNode);
                    this.toReplace = false;
                    this.currentNode.accept(this);
                }
            }
        }

        @Override
        public void visitBinaryOperatorRateNode(BinaryOperatorRateNode rate) {
            throw new SBAVisitorException(Thread.currentThread().getStackTrace());
        }

        @Override
        public void visitChoiceNode(ChoiceNode choice) {
            choice.getLeft().accept(this);
            if (this.expanding && this.toReplace) {
                choice.setLeft(this.currentNode);
                this.toReplace = false;
                this.currentNode.accept(this);
            }
            choice.getRight().accept(this);
            if (this.expanding && this.toReplace) {
                choice.setRight(this.currentNode);
                this.toReplace = false;
                this.currentNode.accept(this);
            }
        }

        @Override
        public void visitConstantProcessNode(ConstantProcessNode constant) {
            if (!this.expanding) {
                if (this.processDefinitionNode) {
                    this.currentConstant = constant.getName();
                }
            } else if (this.replaceableNodes.containsKey(constant.getName())) {
                this.toReplace = true;
                this.currentNode = (ProcessNode)ASTSupport.copy(this.replaceableNodes.get(constant.getName()));
            }
        }

        @Override
        public void visitCooperationNode(CooperationNode cooperation) {
            this.visitBinaryOperatorProcessNode(cooperation);
        }

        @Override
        public void visitHidingNode(HidingNode hiding) {
            if (!this.expanding) {
                this.compositional = true;
            }
        }

        @Override
        public void visitModelNode(ModelNode model) {
            this.expanding = false;
            this.replaceableNodes = new HashMap();
            for (ProcessDefinitionNode pdn : model.processDefinitions()) {
                pdn.accept(this);
            }
            this.expanding = true;
            this.expandedSystemEquation = (ProcessNode)ASTSupport.copy(model.getSystemEquation());
            this.expandedSystemEquation.accept(this);
        }

        @Override
        public void visitPassiveRateNode(PassiveRateNode passive) {
            throw new SBAVisitorException(Thread.currentThread().getStackTrace());
        }

        @Override
        public void visitPrefixNode(PrefixNode prefix) {
            prefix.getTarget().accept(this);
            if (this.expanding && this.toReplace) {
                prefix.setTarget(this.currentNode);
                this.toReplace = false;
                this.currentNode.accept(this);
            }
        }

        @Override
        public void visitProcessDefinitionNode(ProcessDefinitionNode processDefinition) {
            this.processDefinitionNode = true;
            processDefinition.getName().accept(this);
            this.currentNode = processDefinition.getNode();
            this.processDefinitionNode = false;
            this.compositional = false;
            this.currentNode.accept(this);
            if (this.compositional) {
                this.replaceableNodes.put(this.currentConstant, this.currentNode);
            }
        }

        @Override
        public void visitRateDefinitionNode(RateDefinitionNode rateDefinition) {
            throw new SBAVisitorException(Thread.currentThread().getStackTrace());
        }

        @Override
        public void visitRateDoubleNode(RateDoubleNode doubleRate) {
            throw new SBAVisitorException(Thread.currentThread().getStackTrace());
        }

        @Override
        public void visitUnknownActionTypeNode(UnknownActionTypeNode unknownActionTypeNode) {
            throw new SBAVisitorException(Thread.currentThread().getStackTrace());
        }

        @Override
        public void visitVariableRateNode(VariableRateNode variableRate) {
            throw new SBAVisitorException(Thread.currentThread().getStackTrace());
        }

        @Override
        public void visitWildcardCooperationNode(WildcardCooperationNode cooperation) {
            this.visitBinaryOperatorProcessNode(cooperation);
        }
    }
}

