/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.tests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import uk.ac.ed.inf.pepa.OptionsMap;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Compiler;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.model.Aggregation;
import uk.ac.ed.inf.pepa.model.Choice;
import uk.ac.ed.inf.pepa.model.Constant;
import uk.ac.ed.inf.pepa.model.Cooperation;
import uk.ac.ed.inf.pepa.model.Hiding;
import uk.ac.ed.inf.pepa.model.Model;
import uk.ac.ed.inf.pepa.model.Prefix;
import uk.ac.ed.inf.pepa.model.Process;
import uk.ac.ed.inf.pepa.model.Visitor;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.sba.PEPAtoSBA;
import uk.ac.ed.inf.pepa.sba.Results;
import uk.ac.ed.inf.pepa.sba.SBASimulatorException;
import uk.ac.ed.inf.pepa.sba.SBAtoISBJava;
import uk.ac.ed.inf.pepa.tests.TestFilter;
import uk.ac.ed.inf.pepa.tools.PepaTools;

public class AggregationExpressionTest {
    public static void main(String[] args) throws IOException, DerivationException, SBASimulatorException {
        String modelName = args[0];
        String modelText = TestFilter.readText(modelName);
        ModelNode modelNode = (ModelNode)PepaTools.parse(modelText);
        Compiler compiler = new Compiler(modelNode);
        Model model = compiler.getModel();
        model.getSystemEquation().accept(new CompilerVisitor());
        OptionMap map = new OptionMap();
        map.put("ctmc.derivation.aggregate_arrays", false);
        IStateSpace ss = PepaTools.derive(map, modelNode, null, null);
        System.out.println("Size: " + ss.size());
        PEPAtoSBA p2s = new PEPAtoSBA(modelNode);
        try {
            p2s.parseModel();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> rules = new ArrayList<String>();
        for (String c : p2s.getPopulations().keySet()) {
            System.out.println(c);
            rules.add(c);
        }
        OptionsMap omap = new OptionsMap();
        omap.setValue(OptionsMap.Parameter.Solver, (Object)OptionsMap.Solver.DOPR);
        omap.setValue(OptionsMap.Parameter.Stop_Time, 10.0);
        omap.setValue(OptionsMap.Parameter.Components, rules.toArray(new String[rules.size()]));
        SBAtoISBJava modelSBA = new SBAtoISBJava(p2s);
        modelSBA.generateISBJavaModel("name", true);
        modelSBA.initialiseSimulator(omap);
        Results r = null;
        r = modelSBA.runModel();
        int i = 0;
        while (i < r.getSpeciesOrdering().length) {
            System.out.print(String.valueOf(r.getSpeciesOrdering()[i]) + (i == r.getSpeciesOrdering().length - 1 ? "\n" : ","));
            ++i;
        }
        int dataPoints = r.getSimpleTimeSeries().length;
        int i2 = 0;
        while (i2 < dataPoints) {
            int j = 0;
            while (j < r.getSpeciesOrdering().length + 1) {
                System.out.print(String.valueOf(r.getSimpleTimeSeries()[i2][j]) + (j == r.getSpeciesOrdering().length ? "\n" : ","));
                ++j;
            }
            ++i2;
        }
    }

    static class CompilerVisitor
    implements Visitor {
        CompilerVisitor() {
        }

        @Override
        public void visitAggregation(Aggregation aggregation) {
            for (Map.Entry<Process, Integer> entry : aggregation.getSubProcesses().entrySet()) {
                entry.getKey().accept(this);
                System.out.println("Value:" + entry.getValue().doubleValue());
            }
        }

        @Override
        public void visitChoice(Choice choice) {
        }

        @Override
        public void visitConstant(Constant constant) {
            System.out.println(constant.getName());
        }

        @Override
        public void visitCooperation(Cooperation cooperation) {
            cooperation.getLeftHandSide().accept(this);
            cooperation.getRightHandSide().accept(this);
        }

        @Override
        public void visitHiding(Hiding hiding) {
        }

        @Override
        public void visitPrefix(Prefix prefix) {
        }
    }
}

