/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.tests;

import java.io.IOException;
import uk.ac.ed.inf.pepa.ctmc.ThroughputResult;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpaceBuilder;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.StateSpaceBuilderFactory;
import uk.ac.ed.inf.pepa.ctmc.solution.ISolver;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.ctmc.solution.SolverException;
import uk.ac.ed.inf.pepa.ctmc.solution.SolverFactory;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.tests.TestFilter;
import uk.ac.ed.inf.pepa.tools.PepaTools;

public class ArrayTest {
    public static void main(String[] args) throws IOException, DerivationException, SolverException {
        int N = 5;
        long elapsed = 0L;
        int solverId = 7;
        String path = "/Users/Mirco/Workspaces/workspace/uk.ac.ed.inf.pepa/tests/state-space-exploration/";
        String modelFile = String.valueOf(path) + "kdc.pepa";
        OptionMap map = new OptionMap();
        map.put("ctmc.derivation.storage", 1);
        map.put("ctmc.steadystate.solver", solverId);
        int i = 0;
        while (i < N) {
            ModelNode model = (ModelNode)PepaTools.parse(TestFilter.readText(modelFile));
            IStateSpaceBuilder b = StateSpaceBuilderFactory.createStateSpaceBuilder(model, map, null);
            long tic = System.currentTimeMillis();
            IStateSpace ss = b.derive(false, null);
            elapsed += System.currentTimeMillis() - tic;
            if (i == 0) {
                System.out.println("Size: " + ss.size());
                ISolver solver = SolverFactory.createSolver(ss, map);
                double[] solution = solver.solve(null);
                ss.setSolution(solution);
                ThroughputResult[] throughputResultArray = ss.getThroughput();
                int n = throughputResultArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ThroughputResult r = throughputResultArray[n2];
                    System.out.println(String.valueOf(r.getActionType()) + " -> " + r.getThroughput());
                    ++n2;
                }
            }
            ++i;
        }
        System.out.println("Average: " + (double)elapsed / 5.0);
    }
}

