/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.tests;

import java.io.IOException;
import uk.ac.ed.inf.pepa.IResourceManager;
import uk.ac.ed.inf.pepa.ctmc.PopulationLevelResult;
import uk.ac.ed.inf.pepa.ctmc.ThroughputResult;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpaceBuilder;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.StateSpaceBuilderFactory;
import uk.ac.ed.inf.pepa.ctmc.solution.ISolver;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.ctmc.solution.SolverException;
import uk.ac.ed.inf.pepa.ctmc.solution.SolverFactory;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.tests.TestFilter;
import uk.ac.ed.inf.pepa.tools.PepaTools;

public class SolverFramework {
    public static void main(String[] args) throws IOException, DerivationException, SolverException {
        String[] EXAMPLES = new String[]{"C:/Europa-Workspace/uk.ac.ed.inf.pepa/tests/pasm/acs-cpu.pepa"};
        int n = 1;
        OptionMap map = new OptionMap();
        map.put("ctmc.steadystate.solver", 11);
        map.put("ctmc.solver.simple.w", 0.1);
        map.put("ctmc.derivation.storage", 1);
        map.put("cmtc.derivation.kind", 0);
        map.put("ctmc.derivation.parallel.num_workers", 2);
        IStateSpace ss = null;
        String[] stringArray = EXAMPLES;
        int n2 = EXAMPLES.length;
        int n3 = 0;
        while (n3 < n2) {
            String file = stringArray[n3];
            System.out.println("Reading " + file);
            int i = 0;
            while (i < n) {
                System.out.println("Run " + i);
                ModelNode model = (ModelNode)PepaTools.parse(TestFilter.readText(file));
                long deriveTic = System.currentTimeMillis();
                ss = SolverFramework.derive(model, map);
                long deriveToc = System.currentTimeMillis();
                System.out.println("Model derived: " + (deriveToc - deriveTic));
                ISolver solver = SolverFactory.createSolver(ss, map);
                long solverTic = System.currentTimeMillis();
                double[] solution = solver.solve(null);
                long solverToc = System.currentTimeMillis();
                System.out.println("Solved: " + (solverToc - solverTic));
                if (i == 0) {
                    Object r;
                    ss.setSolution(solution);
                    Object[] objectArray = ss.getPopulationLevels();
                    int n4 = objectArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        r = objectArray[n5];
                        System.out.println(String.valueOf(((PopulationLevelResult)r).getName()) + " -> " + ((PopulationLevelResult)r).getMean());
                        ++n5;
                    }
                    objectArray = ss.getThroughput();
                    n4 = objectArray.length;
                    n5 = 0;
                    while (n5 < n4) {
                        r = objectArray[n5];
                        System.out.println(String.valueOf(((ThroughputResult)r).getActionType()) + " -> " + ((ThroughputResult)r).getThroughput());
                        ++n5;
                    }
                }
                System.gc();
                ++i;
            }
            ++n3;
        }
    }

    private static IStateSpace derive(ModelNode model, OptionMap map) throws DerivationException {
        IStateSpaceBuilder builder = StateSpaceBuilderFactory.createStateSpaceBuilder(model, map, IResourceManager.TEMP);
        return builder.derive(false, null);
    }
}

