/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.tests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import uk.ac.ed.inf.pepa.OptionsMap;
import uk.ac.ed.inf.pepa.parsing.ASTFactory;
import uk.ac.ed.inf.pepa.parsing.AggregationNode;
import uk.ac.ed.inf.pepa.parsing.CooperationNode;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.parsing.ProcessNode;
import uk.ac.ed.inf.pepa.parsing.RateDoubleNode;
import uk.ac.ed.inf.pepa.sba.PEPAtoSBA;
import uk.ac.ed.inf.pepa.sba.Results;
import uk.ac.ed.inf.pepa.sba.SBAtoISBJava;
import uk.ac.ed.inf.pepa.tools.PepaTools;

public class TestODE {
    private static String[] rules = new String[]{"User1", "AC_DO_ADMIT1", "AC11", "AC3"};
    private static double start = 0.0;
    private static double stop = 10000.0;
    private static int datapoints = 100;

    public static void main(String[] args) throws IOException {
        System.out.println("ODE Analysis");
        System.out.println("Reading file: " + args[0]);
        TestODE.dothejob(args[0]);
    }

    private static String readText(String fileName) throws IOException {
        String result = null;
        if (fileName != null) {
            File file = new File(fileName);
            StringBuffer sb = new StringBuffer();
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(file));
                String line = null;
                String lineSearator = System.getProperty("line.separator");
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append(lineSearator);
                }
                result = sb.toString();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace(System.err);
                    }
                }
            }
        }
        return result;
    }

    private static void dothejob(String modelName) throws IOException {
        ModelNode model = (ModelNode)PepaTools.parse(TestODE.readText(modelName));
        int[] experiment = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 20, 30, 40, 50, 100, 200};
        ProcessNode coop = model.getSystemEquation();
        while (coop instanceof CooperationNode) {
            coop = ((CooperationNode)coop).getLeft();
        }
        AggregationNode user = (AggregationNode)coop;
        int RUNS = 1;
        long[] elapsed = new long[RUNS];
        int e = 0;
        while (e < experiment.length) {
            RateDoubleNode node = ASTFactory.createRate();
            node.setValue(experiment[e]);
            user.setCopies(node);
            System.out.println("******");
            System.out.println("Running experiment with " + experiment[e] + " copies");
            System.out.println("******");
            int run = 0;
            while (run < RUNS) {
                try {
                    OptionsMap map = new OptionsMap();
                    map.setValue(OptionsMap.Parameter.Components, rules);
                    map.setValue(OptionsMap.Parameter.Solver, (Object)OptionsMap.Solver.DOPR);
                    map.setValue(OptionsMap.Parameter.Absolute_Error, 1.0E-4);
                    map.setValue(OptionsMap.Parameter.Relative_Error, 1.0E-4);
                    map.setValue(OptionsMap.Parameter.Step_Size, 0.001);
                    map.setValue(OptionsMap.Parameter.Start_Time, start);
                    map.setValue(OptionsMap.Parameter.Stop_Time, stop);
                    map.setValue(OptionsMap.Parameter.Data_Points, datapoints);
                    PEPAtoSBA p2s = new PEPAtoSBA(model);
                    p2s.parseModel();
                    SBAtoISBJava modelSBA = new SBAtoISBJava(p2s);
                    modelSBA.generateISBJavaModel("name", true);
                    modelSBA.initialiseSimulator(map);
                    Results r = null;
                    long tic = System.currentTimeMillis();
                    r = modelSBA.runModel();
                    long toc = System.currentTimeMillis();
                    elapsed[run] = toc - tic;
                    System.out.println("Elapsed: " + elapsed[run]);
                    int lastTimePoint = r.getSimpleTimeSeries().length - 1;
                    int numberOfElements = r.getSimpleTimeSeries()[lastTimePoint].length;
                    int j = 1;
                    while (j < numberOfElements) {
                        System.out.print(String.valueOf(r.getSpeciesOrdering()[j - 1]) + " : ");
                        System.out.println(r.getSimpleTimeSeries()[lastTimePoint][j]);
                        ++j;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                System.gc();
                long average = 0L;
                long[] lArray = elapsed;
                int n = elapsed.length;
                int n2 = 0;
                while (n2 < n) {
                    long el = lArray[n2];
                    average += el;
                    ++n2;
                }
                System.out.println("Execution time: " + (double)average / (double)RUNS);
                ++run;
            }
            ++e;
        }
    }
}

