/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.tests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import uk.ac.ed.inf.pepa.OptionsMap;
import uk.ac.ed.inf.pepa.parsing.ASTFactory;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.parsing.RateDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.RateDoubleNode;
import uk.ac.ed.inf.pepa.sba.PEPAtoSBA;
import uk.ac.ed.inf.pepa.sba.Results;
import uk.ac.ed.inf.pepa.sba.SBAtoISBJava;
import uk.ac.ed.inf.pepa.tools.PepaTools;

public class TestSimu {
    private static String[] rules = new String[]{"User1", "AC_DO_ADMIT1", "AC11", "AC3"};
    private static HashSet<String> throughputs = new HashSet();
    private static int number_of_experiments = 10000;
    private static double start = 0.0;
    private static double stop = 10000.0;
    private static int datapoints = 100;

    public static void main(String[] args) throws IOException {
        System.out.println("Reading file: " + args[0]);
        TestSimu.dothejob(args[0]);
    }

    private static String readText(String fileName) throws IOException {
        String result = null;
        if (fileName != null) {
            File file = new File(fileName);
            StringBuffer sb = new StringBuffer();
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(file));
                String line = null;
                String lineSearator = System.getProperty("line.separator");
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append(lineSearator);
                }
                result = sb.toString();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace(System.err);
                    }
                }
            }
        }
        return result;
    }

    private static void dothejob(String modelName) throws IOException {
        throughputs.add("enterBuilding");
        throughputs.add("doWriteEvent");
        throughputs.add("doReadData");
        ModelNode model = (ModelNode)PepaTools.parse(TestSimu.readText(modelName));
        double[] experiment = new double[]{100.0, 200.0, 300.0, 400.0, 500.0, 600.0, 700.0, 800.0, 900.0, 1000.0};
        int RUNS = 1;
        long[] elapsed = new long[RUNS];
        ArrayList<RateDefinitionNode> rates = new ArrayList<RateDefinitionNode>();
        int e = 0;
        while (e < experiment.length) {
            if (e == 0) {
                for (RateDefinitionNode node : model.rateDefinitions()) {
                    if (!(node.getRate() instanceof RateDoubleNode) || ((RateDoubleNode)node.getRate()).getValue() != 2000.0) continue;
                    rates.add(node);
                    System.out.println("Node added:" + node.getName().getName());
                }
            }
            for (RateDefinitionNode node : rates) {
                RateDoubleNode newRate = ASTFactory.createRate();
                newRate.setValue(experiment[e]);
                node.setRate(newRate);
            }
            System.out.println("******");
            System.out.println("Running experiment with fast rate " + experiment[e]);
            System.out.println("******");
            int run = 0;
            while (run < RUNS) {
                try {
                    OptionsMap map = new OptionsMap();
                    map.setValue(OptionsMap.Parameter.Components, rules);
                    map.setValue(OptionsMap.Parameter.Solver, (Object)OptionsMap.Solver.Gibson_Bruck);
                    map.setValue(OptionsMap.Parameter.Start_Time, start);
                    map.setValue(OptionsMap.Parameter.Independent_Replications, number_of_experiments);
                    map.setValue(OptionsMap.Parameter.Stop_Time, stop);
                    map.setValue(OptionsMap.Parameter.Data_Points, datapoints);
                    PEPAtoSBA p2s = new PEPAtoSBA(model);
                    p2s.parseModel();
                    SBAtoISBJava modelSBA = new SBAtoISBJava(p2s);
                    modelSBA.generateISBJavaModel("name", true);
                    modelSBA.initialiseSimulator(map);
                    Results r = null;
                    long tic = System.currentTimeMillis();
                    r = modelSBA.runModel();
                    long toc = System.currentTimeMillis();
                    elapsed[run] = toc - tic;
                    System.out.println("Elapsed: " + elapsed[run]);
                    int lastTimePoint = r.getSimpleTimeSeries().length - 1;
                    int numberOfElements = r.getSimpleTimeSeries()[lastTimePoint].length;
                    double N = 0.0;
                    int j = 1;
                    while (j < numberOfElements) {
                        String species = r.getSpeciesOrdering()[j - 1];
                        double value = r.getSimpleTimeSeries()[lastTimePoint][j];
                        System.out.print(String.valueOf(species) + " : ");
                        System.out.println(value);
                        if (species.equals("User1")) {
                            N = value;
                        }
                        ++j;
                    }
                    System.out.println("Throughput");
                    int i = 0;
                    while (i < r.getReactionOrdering().length) {
                        String throughput = r.getReactionOrdering()[i];
                        double th = r.getReactionCounts()[i] / (stop - start);
                        if (throughputs.contains(throughput)) {
                            System.out.println(String.valueOf(r.getReactionOrdering()[i]) + " : " + th);
                            if (throughput.equals("enterBuilding")) {
                                System.out.println("Response time: " + N / th);
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                System.gc();
                long average = 0L;
                long[] lArray = elapsed;
                int n = elapsed.length;
                int n2 = 0;
                while (n2 < n) {
                    long el = lArray[n2];
                    average += el;
                    ++n2;
                }
                System.out.println("Execution time: " + (double)average / (double)RUNS);
                ++run;
            }
            ++e;
        }
    }
}

