/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.tools;

import com.mindprod.ledatastream.LEDataOutputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import uk.ac.ed.inf.pepa.DoNothingMonitor;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.ctmc.ThroughputResult;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.ctmc.solution.SolverException;
import uk.ac.ed.inf.pepa.ctmc.solution.SolverFactory;
import uk.ac.ed.inf.pepa.ctmc.solution.internal.hydra.SteadyStateAnalyser;
import uk.ac.ed.inf.pepa.parsing.ASTNode;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.tools.HydraImporter;
import uk.ac.ed.inf.pepa.tools.PepaTools;

public class HydraExporter {
    private IStateSpace stateSpace;
    private String fileName;
    private int maxChildren = -1;

    public HydraExporter(IStateSpace stateSpace, String fileName) {
        if (stateSpace == null) {
            throw new NullPointerException();
        }
        if (fileName == null) {
            throw new NullPointerException();
        }
        this.stateSpace = stateSpace;
        this.fileName = fileName;
    }

    public void export(IProgressMonitor monitor) throws IOException {
        LEDataOutputStream os = new LEDataOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(this.fileName)));
        if (monitor == null) {
            monitor = new DoNothingMonitor();
        }
        int[] indices = null;
        int reportingPeriod = this.stateSpace.size() / 100 + 1;
        monitor.beginTask(100);
        int i = 0;
        while (i < this.stateSpace.size()) {
            int j;
            if (i % reportingPeriod == 0) {
                monitor.worked(1);
            }
            indices = this.stateSpace.getOutgoingStateIndices(i);
            this.maxChildren = Math.max(indices.length, this.maxChildren);
            os.writeInt(indices.length);
            int[] nArray = indices;
            int n = indices.length;
            int n2 = 0;
            while (n2 < n) {
                j = nArray[n2];
                os.writeInt(j);
                ++n2;
            }
            nArray = indices;
            n = indices.length;
            n2 = 0;
            while (n2 < n) {
                j = nArray[n2];
                os.writeDouble(this.stateSpace.getRate(i, j));
                ++n2;
            }
            ++i;
        }
        os.close();
        monitor.done();
    }

    public int getStateSpaceSize() {
        return this.stateSpace.size();
    }

    public int getMaxChildren() {
        if (this.maxChildren == -1) {
            throw new IllegalStateException();
        }
        return this.maxChildren;
    }

    public static void main(String[] args) throws IOException, DerivationException, InterruptedException, SolverException {
        String SOLVER_PATH = "C:/GanymedeWorkspace/hydra/src/build/";
        String SOLVER_NAME = "hydra-steady-2.exe";
        String MATRIX_PATH = "C:/ipcoutput/out.matrix";
        String RESULT_PATH = String.valueOf(MATRIX_PATH) + ".RESULT";
        String modelName = args[0];
        ASTNode node = PepaTools.parse(HydraExporter.readText(modelName));
        OptionMap map = new OptionMap();
        map.put("ctmc.derivation.aggregate_arrays", true);
        IStateSpace ss = PepaTools.derive(map, (ModelNode)node, new IProgressMonitor(){
            int worked = 0;

            @Override
            public void beginTask(int amount) {
            }

            @Override
            public void done() {
            }

            @Override
            public boolean isCanceled() {
                return false;
            }

            @Override
            public void setCanceled(boolean state) {
            }

            @Override
            public void worked(int worked) {
                this.worked += worked;
                System.out.println("Worked:" + this.worked);
            }
        }, null);
        HydraExporter exporter = new HydraExporter(ss, MATRIX_PATH);
        exporter.export(null);
        System.out.printf("Solving model (%d states)\n", ss.size());
        Process p = Runtime.getRuntime().exec(new String[]{String.valueOf(SOLVER_PATH) + SOLVER_NAME, MATRIX_PATH, Integer.toString(ss.size()), Integer.toString(exporter.getMaxChildren())});
        InputStream stdout = p.getInputStream();
        InputStreamReader isr = new InputStreamReader(stdout);
        BufferedReader br = new BufferedReader(isr);
        String line = null;
        while ((line = br.readLine()) != null) {
            System.out.println(line);
        }
        int exitCode = p.waitFor();
        if (exitCode != 0) {
            InputStream stderr = p.getInputStream();
            InputStreamReader isre = new InputStreamReader(stderr);
            BufferedReader bre = new BufferedReader(isre);
            while ((line = bre.readLine()) != null) {
                System.err.println(line);
            }
            System.exit(1);
        }
        double[] solution = new HydraImporter(RESULT_PATH).importSolution();
        ss.setSolution(solution);
        ThroughputResult[] throughputResultArray = ss.getThroughput();
        int n = throughputResultArray.length;
        int n2 = 0;
        while (n2 < n) {
            ThroughputResult r = throughputResultArray[n2];
            System.out.printf("%s : %f\n", r.getActionType(), r.getThroughput());
            ++n2;
        }
        long tic = System.currentTimeMillis();
        map.put("ctmc.steadystate.solver", 12);
        SolverFactory.createSolver(ss, map);
        SteadyStateAnalyser analyser = new SteadyStateAnalyser(ss, map);
        double[] newSolution = analyser.solve(new IProgressMonitor(){

            @Override
            public void beginTask(int amount) {
                System.out.println("Solution:");
            }

            @Override
            public void done() {
                System.out.println();
            }

            @Override
            public boolean isCanceled() {
                return false;
            }

            @Override
            public void setCanceled(boolean state) {
            }

            @Override
            public void worked(int worked) {
                System.out.print(".");
            }
        });
        System.out.println("Solution took:" + (System.currentTimeMillis() - tic));
        ss.setSolution(newSolution);
        ThroughputResult[] throughputResultArray2 = ss.getThroughput();
        int n3 = throughputResultArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            ThroughputResult r = throughputResultArray2[n4];
            System.out.printf("%s : %f\n", r.getActionType(), r.getThroughput());
            ++n4;
        }
    }

    private static String readText(String fileName) throws IOException {
        String result = null;
        if (fileName != null) {
            File file = new File(fileName);
            StringBuffer sb = new StringBuffer();
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(file));
                String line = null;
                String lineSearator = System.getProperty("line.separator");
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append(lineSearator);
                }
                result = sb.toString();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace(System.err);
                    }
                }
            }
        }
        return result;
    }
}

