/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java_cup.runtime.Symbol;
import org.apache.log4j.Logger;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.IResourceManager;
import uk.ac.ed.inf.pepa.analysis.IProblem;
import uk.ac.ed.inf.pepa.analysis.StaticAnalyser;
import uk.ac.ed.inf.pepa.analysis.internal.ProblemFactory;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpaceBuilder;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.StateSpaceBuilderFactory;
import uk.ac.ed.inf.pepa.ctmc.solution.ISolver;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.ctmc.solution.SolverFactory;
import uk.ac.ed.inf.pepa.parsing.ASTFactory;
import uk.ac.ed.inf.pepa.parsing.ASTNode;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.parsing.internal.NewPepaSymbolFactory;
import uk.ac.ed.inf.pepa.parsing.internal.PepaLexer;
import uk.ac.ed.inf.pepa.parsing.internal.PepaParser;

public class PepaTools {
    static Logger logger = Logger.getLogger(PepaTools.class);

    public static synchronized ASTNode parse(String source) {
        if (source == null) {
            throw new NullPointerException("Source string is null");
        }
        NewPepaSymbolFactory symbolFactory = new NewPepaSymbolFactory();
        PepaParser parser = new PepaParser(new PepaLexer(new StringReader(source), symbolFactory), symbolFactory);
        ModelNode result = null;
        try {
            Symbol symbol = parser.parse();
            if (symbol != null) {
                result = (ModelNode)symbol.value;
            }
        }
        catch (Exception e) {
            logger.debug((Object)("When parsing, it should never return an exception of" + e.getClass().getName()));
        }
        if (result == null) {
            result = ASTFactory.createModel();
            IProblem generalProblem = ProblemFactory.createProblem(0x10000E, 0, 0, 0, 0, 0, 0, "Model does not have system equation");
            result.setProblems(new IProblem[]{generalProblem});
        }
        return result;
    }

    public static StaticAnalyser doStaticAnalysis(ModelNode astModel) {
        if (astModel == null) {
            throw new NullPointerException("No model to analyse");
        }
        StaticAnalyser analyser = new StaticAnalyser(astModel);
        return analyser;
    }

    public static IStateSpaceBuilder getBuilder(ModelNode model, OptionMap map, IResourceManager manager) {
        if (model == null) {
            throw new NullPointerException("Model is null.");
        }
        if (map == null) {
            map = new OptionMap();
        }
        return StateSpaceBuilderFactory.createStateSpaceBuilder(model, map, manager);
    }

    public static IStateSpace derive(OptionMap map, ModelNode model, IProgressMonitor monitor, IResourceManager manager) throws DerivationException {
        if (model == null) {
            throw new NullPointerException();
        }
        return PepaTools.getBuilder(model, map, manager).derive(false, monitor);
    }

    public static ISolver getSolver(OptionMap map, IStateSpace stateSpace) {
        if (stateSpace == null) {
            throw new NullPointerException();
        }
        if (map == null) {
            map = new OptionMap();
        }
        return SolverFactory.createSolver(stateSpace, map);
    }

    public static String readText(String fileName) throws IOException {
        String result = null;
        if (fileName != null) {
            File file = new File(fileName);
            StringBuffer sb = new StringBuffer();
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(file));
                String line = null;
                String lineSearator = System.getProperty("line.separator");
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append(lineSearator);
                }
                result = sb.toString();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace(System.err);
                    }
                }
            }
        }
        return result;
    }
}

