/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem;

import org.systemsbiology.math.Expression;
import org.systemsbiology.math.SymbolValue;
import org.systemsbiology.math.Value;

public final class Compartment
extends SymbolValue {
    private final String mName;
    public static final double DEFAULT_VOLUME = 1.0;

    public void setVolume(double pVolume) {
        this.setValue(new Value(pVolume));
    }

    public void setVolume(Expression pVolume) {
        this.setValue(new Value(pVolume));
    }

    public Compartment(String pName, double pVolume) {
        super(pName);
        this.mName = pName;
        this.setVolume(pVolume);
    }

    public Compartment(SymbolValue pSymbolValue) {
        super(pSymbolValue);
        this.mName = pSymbolValue.getSymbol().getName();
    }

    public Compartment(String pName) {
        this(pName, 1.0);
    }

    public String getName() {
        return this.mName;
    }

    public boolean equals(Compartment pCompartment) {
        return this.mName.equals(pCompartment.mName) && super.equals(pCompartment);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Compartment: ");
        sb.append(this.getName());
        sb.append(" [Value: ");
        sb.append(this.getValue().toString());
        sb.append("]");
        return sb.toString();
    }

    public Object clone() {
        Compartment compartment = new Compartment(this.mName);
        compartment.setValue((Value)this.getValue().clone());
        return compartment;
    }
}

