/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.systemsbiology.chem.Compartment;
import org.systemsbiology.chem.Parameter;
import org.systemsbiology.chem.Reaction;
import org.systemsbiology.chem.Species;
import org.systemsbiology.math.ReservedSymbolMapper;
import org.systemsbiology.math.SymbolEvaluationPostProcessor;
import org.systemsbiology.math.SymbolValue;
import org.systemsbiology.util.DataNotFoundException;
import org.systemsbiology.util.DebugUtils;

public final class Model {
    public static final String INTERNAL_SYMBOL_PREFIX = "___";
    private HashMap mReactionsMap = new HashMap();
    private String mName;
    private HashMap mDynamicSymbolsMap = new HashMap();
    private HashMap mSymbolsMap = new HashMap();
    private HashMap mParametersMap = new HashMap();
    public static final String NAMESPACE_IDENTIFIER = "::";
    private SymbolEvaluationPostProcessor mSymbolEvaluationPostProcessor = null;
    private ReservedSymbolMapper mReservedSymbolMapper = null;

    public Model() {
        this.setName(null);
    }

    public ReservedSymbolMapper getReservedSymbolMapper() {
        return this.mReservedSymbolMapper;
    }

    public void setReservedSymbolMapper(ReservedSymbolMapper pReservedSymbolMapper) {
        this.mReservedSymbolMapper = pReservedSymbolMapper;
    }

    public void setSymbolEvaluationPostProcessor(SymbolEvaluationPostProcessor pSymbolEvaluationPostProcessor) {
        this.mSymbolEvaluationPostProcessor = pSymbolEvaluationPostProcessor;
    }

    public SymbolEvaluationPostProcessor getSymbolEvaluationPostProcessor() {
        return this.mSymbolEvaluationPostProcessor;
    }

    public Model(String pName) {
        this();
        this.setName(pName);
    }

    public void setName(String pName) {
        this.mName = pName;
    }

    public String getName() {
        return this.mName;
    }

    HashMap getSymbolsMap() {
        return this.mSymbolsMap;
    }

    HashMap getDynamicSymbolsMap() {
        return this.mDynamicSymbolsMap;
    }

    ArrayList constructReactionsList() {
        Reaction[] sampleArray = new Reaction[]{};
        Reaction[] intArray = this.getReactionsMap().values().toArray(sampleArray);
        int numReactions = intArray.length;
        ArrayList<Reaction> reactionsList = new ArrayList<Reaction>();
        int reactionCtr = 0;
        while (reactionCtr < numReactions) {
            reactionsList.add((Reaction)intArray[reactionCtr].clone());
            ++reactionCtr;
        }
        return reactionsList;
    }

    Reaction[] constructReactionsArray() {
        Reaction[] sampleArray = new Reaction[]{};
        Reaction[] intArray = this.getReactionsMap().values().toArray(sampleArray);
        int numReactions = intArray.length;
        Reaction[] retArray = new Reaction[numReactions];
        int reactionCtr = 0;
        while (reactionCtr < numReactions) {
            retArray[reactionCtr] = (Reaction)intArray[reactionCtr].clone();
            ++reactionCtr;
        }
        return retArray;
    }

    ArrayList constructDynamicSymbolsList() {
        Species[] sampleArray = new Species[]{};
        Species[] intArray = this.getDynamicSymbolsMap().values().toArray(sampleArray);
        int numSpecies = intArray.length;
        ArrayList<Species> symbolsList = new ArrayList<Species>();
        int speciesCtr = 0;
        while (speciesCtr < numSpecies) {
            symbolsList.add((Species)intArray[speciesCtr].clone());
            ++speciesCtr;
        }
        return symbolsList;
    }

    Species[] constructDynamicSymbolsArray() {
        Species[] sampleArray = new Species[]{};
        Species[] intArray = this.getDynamicSymbolsMap().values().toArray(sampleArray);
        int numSpecies = intArray.length;
        Species[] retArray = new Species[numSpecies];
        int speciesCtr = 0;
        while (speciesCtr < numSpecies) {
            retArray[speciesCtr] = (Species)intArray[speciesCtr].clone();
            ++speciesCtr;
        }
        return retArray;
    }

    SymbolValue[] constructGlobalNonDynamicSymbolsArray() {
        HashMap symbolsMap = this.getSymbolsMap();
        HashMap dynamicSpeciesMap = this.getDynamicSymbolsMap();
        Iterator symbolsIter = symbolsMap.keySet().iterator();
        ArrayList<SymbolValue> retList = new ArrayList<SymbolValue>();
        while (symbolsIter.hasNext()) {
            String symbolName = (String)symbolsIter.next();
            if (dynamicSpeciesMap.get(symbolName) != null) continue;
            SymbolValue symbolValue = (SymbolValue)symbolsMap.get(symbolName);
            assert (symbolValue.getValue() != null) : "null value for symbol: " + symbolName;
            SymbolValue newSymbolValue = (SymbolValue)symbolValue.clone();
            retList.add(newSymbolValue);
        }
        SymbolValue[] sampleArray = new SymbolValue[]{};
        return retList.toArray(sampleArray);
    }

    SymbolValue getSymbolByName(String pSymbolName) {
        return (SymbolValue)this.getSymbolsMap().get(pSymbolName);
    }

    HashMap getReactionsMap() {
        return this.mReactionsMap;
    }

    public void addParameter(Parameter pParameter) {
        pParameter.addSymbolToMap(this.mSymbolsMap, pParameter.getSymbolName(), this.mReservedSymbolMapper);
        pParameter.addSymbolToMap(this.mParametersMap, pParameter.getSymbolName(), this.mReservedSymbolMapper);
    }

    public void addSpecies(Species pSpecies) {
        pSpecies.addSymbolsToGlobalSymbolMap(this.mSymbolsMap, this.mReservedSymbolMapper);
    }

    public Collection getDynamicSymbols() {
        return this.mDynamicSymbolsMap.values();
    }

    public Collection getReactions() {
        return this.mReactionsMap.values();
    }

    public Collection getSymbols() {
        return this.mSymbolsMap.values();
    }

    public void addReaction(Reaction pReaction) throws IllegalStateException {
        String reactionName = pReaction.getName();
        Reaction storedReaction = (Reaction)this.mReactionsMap.get(reactionName);
        if (storedReaction != null) {
            throw new IllegalStateException("reaction is already added to this model: " + reactionName);
        }
        this.mReactionsMap.put(reactionName, pReaction);
        pReaction.addDynamicSpeciesToGlobalSpeciesMap(this.getDynamicSymbolsMap(), this.mReservedSymbolMapper);
        pReaction.addSymbolsToGlobalSymbolMap(this.getSymbolsMap(), this.mReservedSymbolMapper);
    }

    public Species getSpeciesByName(String pSpeciesName) throws DataNotFoundException {
        SymbolValue symbolValue = (SymbolValue)this.mSymbolsMap.get(pSpeciesName);
        if (symbolValue == null) {
            throw new DataNotFoundException("could not find species: " + pSpeciesName);
        }
        if (!(symbolValue instanceof Species)) {
            throw new IllegalArgumentException("requested item is not a species: " + pSpeciesName);
        }
        return (Species)symbolValue;
    }

    public boolean containsDelayedOrMultistepReaction() {
        boolean containsDelayedOrMultistepReaction = false;
        for (Reaction reaction : this.mReactionsMap.values()) {
            if (!(reaction.getDelay() > 0.0) && reaction.getNumSteps() <= 1) continue;
            containsDelayedOrMultistepReaction = true;
        }
        return containsDelayedOrMultistepReaction;
    }

    public String[] getOrderedSpeciesNamesArray() {
        LinkedList<String> speciesNamesList = new LinkedList<String>();
        for (SymbolValue symbolValue : this.mSymbolsMap.values()) {
            if (!(symbolValue instanceof Species)) continue;
            speciesNamesList.add(symbolValue.getSymbol().getName());
        }
        Collections.sort(speciesNamesList);
        return speciesNamesList.toArray(new String[0]);
    }

    public String[] getOrderedResultsSymbolNamesArray() throws IllegalStateException {
        LinkedList<String> symbolNamesList = new LinkedList<String>();
        Iterator symbolValuesIter = this.mSymbolsMap.values().iterator();
        String symbolName = null;
        while (symbolValuesIter.hasNext()) {
            SymbolValue symbolValue = (SymbolValue)symbolValuesIter.next();
            if (symbolValue.getValue() == null) {
                throw new IllegalStateException("symbol has no value associated with it: " + symbolValue.getSymbol().getName());
            }
            if ((!symbolValue.getValue().isExpression() || symbolValue instanceof Reaction) && !(symbolValue instanceof Species)) continue;
            symbolName = symbolValue.getSymbol().getName();
            symbolNamesList.add(symbolName);
        }
        Collections.sort(symbolNamesList);
        return symbolNamesList.toArray(new String[0]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Model: ");
        sb.append(this.getName());
        sb.append("\n\n");
        sb.append("Parameters: \n");
        String separatorString = ",\n";
        DebugUtils.describeSortedObjectList(sb, this.mParametersMap, separatorString);
        sb.append("\n\n");
        sb.append("Compartments: \n");
        DebugUtils.describeSortedObjectList(sb, this.mSymbolsMap, Compartment.class, separatorString);
        sb.append("\n\n");
        sb.append("Species: \n");
        DebugUtils.describeSortedObjectList(sb, this.mSymbolsMap, Species.class, separatorString);
        sb.append("\n\n");
        sb.append("Reactions: \n");
        DebugUtils.describeSortedObjectList(sb, this.mReactionsMap, separatorString);
        return sb.toString();
    }
}

