/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.systemsbiology.chem.Compartment;
import org.systemsbiology.chem.IModelBuilder;
import org.systemsbiology.chem.Model;
import org.systemsbiology.chem.Parameter;
import org.systemsbiology.chem.Reaction;
import org.systemsbiology.chem.ReactionParticipant;
import org.systemsbiology.chem.ReservedSymbolMapperChemCommandLanguage;
import org.systemsbiology.chem.Species;
import org.systemsbiology.math.Expression;
import org.systemsbiology.math.MutableBoolean;
import org.systemsbiology.math.MutableInteger;
import org.systemsbiology.math.Symbol;
import org.systemsbiology.math.SymbolEvaluatorHashMap;
import org.systemsbiology.math.SymbolValue;
import org.systemsbiology.math.Value;
import org.systemsbiology.util.DataNotFoundException;
import org.systemsbiology.util.IAliasableClass;
import org.systemsbiology.util.IncludeHandler;
import org.systemsbiology.util.InvalidInputException;

public class ModelBuilderCommandLanguage
implements IModelBuilder,
IAliasableClass {
    private HashMap mDefaultModelSymbols;
    public static final String CLASS_ALIAS = "command-language";
    private static final String DEFAULT_MODEL_NAME = "model";
    private static final String TOKEN_MULTILINE_COMMENT_END = "*/";
    private static final String TOKEN_MULTILINE_COMMENT_BEGIN = "/*";
    private static final String TOKEN_SIMPLE_COMMENT = "//";
    private static final String REACTION_MODIFIER_STEPS = "steps:";
    private static final String REACTION_MODIFIER_DELAY = "delay:";
    private static final String STATEMENT_KEYWORD_INCLUDE = "include";
    private static final String STATEMENT_KEYWORD_MODEL = "model";
    private static final String STATEMENT_KEYWORD_REF = "ref";
    private static final String STATEMENT_KEYWORD_DEFINE = "define";
    private static final String KEYWORD_LOOP = "loop";
    private static final String VALID_SYMBOL_REGEX = "^[a-zA-Z]([_a-zA-Z0-9])*$";
    private static final Pattern VALID_SYMBOL_PATTERN = Pattern.compile("^[a-zA-Z]([_a-zA-Z0-9])*$");
    private static final String REQUIRED_CHAR_SET = "UTF-8";
    private static final String COMPARTMENT_NAME_DEFAULT = "univ";
    private String mNamespace;
    private static final Charset sCharset = Charset.forName("UTF-8");
    private Pattern mSearchPatternMath;

    private Pattern getSearchPatternMath() {
        return this.mSearchPatternMath;
    }

    private void setSearchPatternMath(Pattern pSearchPatternMath) {
        this.mSearchPatternMath = pSearchPatternMath;
    }

    private void initializeSearchPatternMath() {
        String searchRegex = "\\[([^\\[\\]]+)\\]";
        Pattern searchPattern = Pattern.compile(searchRegex);
        this.setSearchPatternMath(searchPattern);
    }

    private void initializeDefaultModelSymbols() {
        this.mDefaultModelSymbols = new HashMap();
        Compartment compartment = new Compartment(COMPARTMENT_NAME_DEFAULT);
        this.mDefaultModelSymbols.put(compartment.getName(), compartment);
    }

    public ModelBuilderCommandLanguage() {
        this.initializeSearchPatternMath();
        this.initializeDefaultModelSymbols();
        this.mNamespace = null;
    }

    private Token getNextToken(ListIterator pTokenIter) throws InvalidInputException {
        if (!pTokenIter.hasNext()) {
            throw new InvalidInputException("expected a token, but no token was found");
        }
        Token token = (Token)pTokenIter.next();
        assert (token != null) : "unexpected null token";
        return token;
    }

    private void defineParameters(HashMap pSymbolMap, Model pModel) {
        for (SymbolValue symbolValue : pSymbolMap.values()) {
            if (!symbolValue.getClass().getSuperclass().equals(Object.class)) continue;
            Parameter parameter = new Parameter(symbolValue);
            pModel.addParameter(parameter);
        }
    }

    private void tokenizeStatement(String pStatement, List pTokens, int pStartingLineNumber) {
        StringTokenizer st = new StringTokenizer(pStatement, "=\", \t[]{}()->+;@#$*/%^\n", true);
        String tokenString = null;
        boolean inQuote = false;
        StringBuffer symbolTokenBuffer = new StringBuffer();
        int lineCtr = pStartingLineNumber;
        while (st.hasMoreElements()) {
            String symbolTokenString;
            tokenString = st.nextToken();
            Token token = null;
            if (tokenString.equals("\n")) {
                ++lineCtr;
            } else if (tokenString.equals("\"")) {
                inQuote = !inQuote;
                token = new Token(Token.Code.QUOTE);
            } else if (!inQuote) {
                if (tokenString.equals("=")) {
                    token = new Token(Token.Code.EQUALS);
                } else if (tokenString.equals(",")) {
                    token = new Token(Token.Code.COMMA);
                } else if (tokenString.equals("=")) {
                    token = new Token(Token.Code.EQUALS);
                } else if (!tokenString.equals(" ") && !tokenString.equals("\t")) {
                    if (tokenString.equals("(")) {
                        token = new Token(Token.Code.PAREN_BEGIN);
                    } else if (tokenString.equals(")")) {
                        token = new Token(Token.Code.PAREN_END);
                    } else if (tokenString.equals("[")) {
                        token = new Token(Token.Code.BRACKET_BEGIN);
                    } else if (tokenString.equals("]")) {
                        token = new Token(Token.Code.BRACKET_END);
                    } else if (tokenString.equals("{")) {
                        token = new Token(Token.Code.BRACE_BEGIN);
                    } else if (tokenString.equals("}")) {
                        token = new Token(Token.Code.BRACE_END);
                    } else if (tokenString.equals("-")) {
                        token = new Token(Token.Code.HYPHEN);
                    } else if (tokenString.equals(">")) {
                        token = new Token(Token.Code.GREATER_THAN);
                    } else if (tokenString.equals("+")) {
                        token = new Token(Token.Code.PLUS);
                    } else if (tokenString.equals(";")) {
                        token = new Token(Token.Code.SEMICOLON);
                    } else if (tokenString.equals("@")) {
                        token = new Token(Token.Code.ATSIGN);
                    } else if (tokenString.equals("#")) {
                        token = new Token(Token.Code.POUNDSIGN);
                    } else if (tokenString.equals("$")) {
                        token = new Token(Token.Code.DOLLAR);
                    } else if (tokenString.equals("/")) {
                        token = new Token(Token.Code.RIGHT_SLASH);
                    } else if (tokenString.equals("*")) {
                        token = new Token(Token.Code.ASTERISK);
                    } else if (tokenString.equals("%")) {
                        token = new Token(Token.Code.PERCENT);
                    } else if (tokenString.equals("^")) {
                        token = new Token(Token.Code.CARET);
                    } else {
                        token = new Token(Token.Code.SYMBOL);
                        token.mSymbol = tokenString;
                    }
                }
            } else {
                symbolTokenBuffer.append(tokenString);
            }
            if (tokenString.equals("\"") && !inQuote && (symbolTokenString = symbolTokenBuffer.toString()).length() > 0) {
                Token symbolToken = new Token(Token.Code.SYMBOL);
                symbolToken.mSymbol = symbolTokenString;
                symbolTokenBuffer.delete(0, symbolTokenString.length());
                pTokens.add(symbolToken);
            }
            if (token == null) continue;
            token.mLine = lineCtr;
            pTokens.add(token);
            token = null;
        }
    }

    private void checkSymbolValidity(String pSymbolName) throws InvalidInputException {
        if (ReservedSymbolMapperChemCommandLanguage.isReservedSymbol(pSymbolName)) {
            throw new InvalidInputException("attempt to define a reserved symbol: " + pSymbolName);
        }
        if (this.mDefaultModelSymbols.get(pSymbolName) != null) {
            throw new InvalidInputException("symbol name is reserved as a default model element: " + pSymbolName);
        }
        if (!ModelBuilderCommandLanguage.isValidSymbol(pSymbolName)) {
            throw new InvalidInputException("invalid symbol definition: " + pSymbolName);
        }
    }

    private void processDefaultModelElements(HashMap pSymbolMap) {
        for (SymbolValue defaultModelSymbolValue : this.mDefaultModelSymbols.values()) {
            pSymbolMap.put(defaultModelSymbolValue.getSymbol().getName(), defaultModelSymbolValue);
        }
    }

    private static String addNamespaceToSymbol(String pSymbolName, String pNamespace) {
        String retName = pSymbolName;
        if (pNamespace != null) {
            retName = String.valueOf(pNamespace) + "::" + pSymbolName;
        }
        return retName;
    }

    private static Object performSymbolTokenMacroTranslationLookup(String pSymbol, HashMap pSymbolMap, String pNamespace) {
        Object retObj = pSymbol;
        if (pNamespace != null && !ReservedSymbolMapperChemCommandLanguage.isReservedSymbol(pSymbol)) {
            pSymbol = ModelBuilderCommandLanguage.addNamespaceToSymbol(pSymbol, pNamespace);
            retObj = pSymbol;
            SymbolValue symbolValue = (SymbolValue)pSymbolMap.get(pSymbol);
            if (symbolValue != null && symbolValue instanceof DummySymbol) {
                DummySymbol dummySymbol = (DummySymbol)symbolValue;
                Object dummySymbolInstance = dummySymbol.mInstanceSymbolObject;
                if (dummySymbolInstance instanceof String) {
                    retObj = dummySymbolInstance;
                } else if (dummySymbolInstance instanceof Value) {
                    retObj = dummySymbolInstance;
                } else assert (false) : "unknown dummy symbol instance class, for symbol: " + pSymbol;
            }
        }
        return retObj;
    }

    private String handleExpression(String pExpressionString, HashMap pSymbolMap) {
        String retVal = null;
        return retVal;
    }

    private String translateMathExpressionsInString(String pInputString, HashMap pSymbolMap) throws DataNotFoundException, IllegalArgumentException {
        Pattern searchPatternMath = this.getSearchPatternMath();
        Matcher matcher = searchPatternMath.matcher(pInputString);
        while (matcher.find()) {
            String matchedSubsequence = matcher.group(1);
            Expression exp = new Expression(matchedSubsequence);
            SymbolEvaluatorNamespaced evaluator = new SymbolEvaluatorNamespaced(pSymbolMap, this.mNamespace);
            double value = exp.computeValue(evaluator);
            String formattedExp = Long.toString((long)value);
            pInputString = matcher.replaceFirst(formattedExp);
            matcher = searchPatternMath.matcher(pInputString);
        }
        return pInputString;
    }

    private void grabTokensToNextCommaOrParen(ListIterator pTokenIter, LinkedList pTokens, HashMap pSymbolMap) throws InvalidInputException, DataNotFoundException {
        Token token = null;
        boolean inQuote = false;
        StringBuffer quotedString = new StringBuffer();
        int parenDepth = 0;
        while (pTokenIter.hasNext()) {
            token = this.getNextToken(pTokenIter);
            if (!inQuote) {
                if (token.mCode.equals(Token.Code.PAREN_END)) {
                    if (parenDepth == 0) {
                        pTokenIter.previous();
                        break;
                    }
                    if (--parenDepth < 0) {
                        throw new InvalidInputException("mismatched number of parentheses detected within expression");
                    }
                    pTokens.add(token);
                    continue;
                }
                if (token.mCode.equals(Token.Code.PAREN_BEGIN)) {
                    ++parenDepth;
                    pTokens.add(token);
                    continue;
                }
                if (token.mCode.equals(Token.Code.SEMICOLON)) {
                    throw new InvalidInputException("end of statement reached when parenthesis expected");
                }
                if (token.mCode.equals(Token.Code.COMMA)) {
                    if (parenDepth == 0) {
                        pTokenIter.previous();
                        break;
                    }
                    pTokens.add(token);
                    continue;
                }
                if (token.mCode.equals(Token.Code.QUOTE)) {
                    inQuote = true;
                    continue;
                }
                pTokens.add(token);
                continue;
            }
            if (token.mCode.equals(Token.Code.QUOTE)) {
                inQuote = false;
                Token newToken = new Token(Token.Code.SYMBOL);
                String symbolName = quotedString.toString();
                quotedString.delete(0, symbolName.length());
                newToken.mSymbol = symbolName = this.translateMathExpressionsInString(symbolName, pSymbolMap);
                pTokens.add(newToken);
                continue;
            }
            quotedString.append(token.toString());
        }
        if (pTokens.size() == 0) {
            throw new InvalidInputException("a symbol token was expected in list environment");
        }
    }

    private String obtainSymbol(ListIterator pTokenIter, HashMap pSymbolMap) throws InvalidInputException, DataNotFoundException {
        Token token = this.getNextToken(pTokenIter);
        String symbolName = null;
        if (token.mCode.equals(Token.Code.SYMBOL)) {
            symbolName = token.mSymbol;
        } else if (token.mCode.equals(Token.Code.QUOTE)) {
            token = this.getNextToken(pTokenIter);
            if (!token.mCode.equals(Token.Code.SYMBOL)) {
                throw new InvalidInputException("expected symbol token after quote");
            }
            symbolName = this.translateMathExpressionsInString(token.mSymbol, pSymbolMap);
            token = this.getNextToken(pTokenIter);
            if (!token.mCode.equals(Token.Code.QUOTE)) {
                throw new InvalidInputException("expected end quote token");
            }
        } else {
            throw new InvalidInputException("expected symbol or quoted string; instead found token: " + token);
        }
        this.checkSymbolValidity(symbolName);
        return symbolName;
    }

    private String obtainSymbolWithNamespace(ListIterator pTokenIter, HashMap pSymbolMap) throws InvalidInputException, DataNotFoundException {
        String symbol = this.obtainSymbol(pTokenIter, pSymbolMap);
        Object convertedSymbolObj = ModelBuilderCommandLanguage.performSymbolTokenMacroTranslationLookup(symbol, pSymbolMap, this.mNamespace);
        String retSymbol = null;
        if (!(convertedSymbolObj instanceof String)) {
            throw new InvalidInputException("where expected a symbol, macro reference translated into a value: " + symbol);
        }
        retSymbol = (String)convertedSymbolObj;
        return retSymbol;
    }

    private boolean isNumericLiteral(String pTokenString) {
        boolean retVal = false;
        try {
            Double.parseDouble(pTokenString);
            retVal = true;
        }
        catch (NumberFormatException numberFormatException) {}
        return retVal;
    }

    private Value obtainValue(ListIterator pTokenIter, HashMap pSymbolMap, boolean pAllowDeferred) throws InvalidInputException, DataNotFoundException {
        boolean allowTerminateOnParen = false;
        return this.obtainValue(pTokenIter, pSymbolMap, pAllowDeferred, allowTerminateOnParen);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Value obtainValue(ListIterator pTokenIter, HashMap pSymbolMap, boolean pAllowDeferred, boolean pAllowTerminateOnParen) throws InvalidInputException, DataNotFoundException {
        boolean firstToken = true;
        StringBuffer expressionBuffer = new StringBuffer();
        boolean deferredExpression = false;
        StringBuffer quoteBuffer = new StringBuffer();
        boolean inQuote = false;
        int parenDepth = 0;
        while (pTokenIter.hasNext()) {
            Token token = this.getNextToken(pTokenIter);
            if (inQuote) {
                assert (!firstToken) : "first token, and within a quotation";
                if (token.mCode.equals(Token.Code.QUOTE)) {
                    String quotedString = quoteBuffer.toString();
                    quoteBuffer.delete(0, quoteBuffer.length());
                    quotedString = this.translateMathExpressionsInString(quotedString, pSymbolMap);
                    expressionBuffer.append(quotedString);
                    inQuote = false;
                    continue;
                }
                quoteBuffer.append(token.toString());
                continue;
            }
            if (token.mCode.equals(Token.Code.SEMICOLON) || token.mCode.equals(Token.Code.COMMA) && parenDepth == 0) {
                if (firstToken) {
                    throw new InvalidInputException("expression was expected, but instead, a comma or semicolon was found");
                }
                if (parenDepth > 0) {
                    throw new InvalidInputException("expression ended with mismatched parentheses");
                }
                pTokenIter.previous();
                break;
            }
            if (token.mCode.equals(Token.Code.BRACKET_BEGIN)) {
                if (!pAllowDeferred) {
                    throw new InvalidInputException("deferred evaluation expression not allowed here, so this token was unexpected: \"" + token.mCode + "\"");
                }
                if (!firstToken) throw new InvalidInputException("unexpected token encountered in an expression: \"" + token.mCode + "\"");
                deferredExpression = true;
            } else if (token.mCode.equals(Token.Code.QUOTE)) {
                inQuote = true;
            } else {
                if (token.mCode.equals(Token.Code.BRACKET_END)) {
                    if (!pAllowDeferred) {
                        throw new InvalidInputException("deferred evaluation expression not allowed here, so this token was unexpected: \"" + token.mCode + "\"");
                    }
                    if (!deferredExpression) {
                        throw new InvalidInputException("encountered closing bracket without an opening bracket");
                    }
                    if (!inQuote) break;
                    throw new InvalidInputException("missing quotation mark in expression");
                }
                if (token.mCode.equals(Token.Code.PAREN_BEGIN)) {
                    expressionBuffer.append(token.toString());
                    ++parenDepth;
                } else if (token.mCode.equals(Token.Code.PAREN_END)) {
                    if (parenDepth == 0 && pAllowTerminateOnParen) {
                        pTokenIter.previous();
                        break;
                    }
                    expressionBuffer.append(token.toString());
                    if (--parenDepth < 0) {
                        throw new InvalidInputException("mismatched number of parentheses detected within an expression");
                    }
                } else if (token.mCode.equals(Token.Code.SYMBOL)) {
                    String symbolString = token.mSymbol;
                    if (!this.isNumericLiteral(symbolString)) {
                        Object translatedObject = ModelBuilderCommandLanguage.performSymbolTokenMacroTranslationLookup(symbolString, pSymbolMap, this.mNamespace);
                        if (translatedObject instanceof String) {
                            symbolString = (String)translatedObject;
                        } else if (translatedObject instanceof Value) {
                            Value symbolValueObj = (Value)translatedObject;
                            if (symbolValueObj.isExpression()) {
                                symbolString = symbolValueObj.getExpressionString();
                            } else {
                                double value = symbolValueObj.getValue();
                                symbolString = Double.toString(value);
                            }
                        }
                    }
                    expressionBuffer.append(symbolString);
                } else {
                    expressionBuffer.append(token.toString());
                }
            }
            if (!firstToken) continue;
            firstToken = false;
        }
        if (inQuote) {
            throw new InvalidInputException("expression ended without a matching quotation character");
        }
        String expressionString = expressionBuffer.toString();
        Expression expression = null;
        try {
            expression = new Expression(expressionString);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidInputException("invalid mathematical formula \"" + expressionString + "\"; cause is: " + e.getMessage() + ";", e);
        }
        Value value = null;
        if (deferredExpression) {
            return new Value(expression);
        }
        try {
            return new Value(expression.computeValue(pSymbolMap));
        }
        catch (DataNotFoundException e) {
            throw new InvalidInputException("unable to determine value for expression: " + expressionString, e);
        }
    }

    private void handleStatementAssociate(ListIterator pTokenIter, Model pModelHashMap, HashMap pSymbolMap) throws InvalidInputException, DataNotFoundException {
        String symbolName = this.obtainSymbolWithNamespace(pTokenIter, pSymbolMap);
        assert (symbolName != null) : "null symbol string for symbol token";
        Token token = this.getNextToken(pTokenIter);
        if (!token.mCode.equals(Token.Code.ATSIGN)) {
            if (token.mCode.equals(Token.Code.BRACKET_BEGIN)) {
                throw new InvalidInputException("encountered begin bracket token when expected at-sign token; perhaps you forgot to put double quotes around your symbol definition?");
            }
            throw new InvalidInputException("encountered unknown token when expected at-sign token");
        }
        String associatedSymbolName = this.obtainSymbolWithNamespace(pTokenIter, pSymbolMap);
        SymbolValue associatedSymbolValue = (SymbolValue)pSymbolMap.get(associatedSymbolName);
        Compartment compartment = null;
        if (!(associatedSymbolValue instanceof Compartment)) {
            if (!associatedSymbolValue.getClass().getSuperclass().equals(Object.class)) {
                throw new InvalidInputException("symbol \"" + associatedSymbolName + "\" is already defined as an incompatible symbol type");
            }
            compartment = new Compartment(associatedSymbolValue);
            pSymbolMap.put(associatedSymbolName, compartment);
        } else {
            compartment = (Compartment)associatedSymbolValue;
        }
        SymbolValue symbolValue = (SymbolValue)pSymbolMap.get(symbolName);
        Species species = null;
        if (!(symbolValue instanceof Species)) {
            if (!symbolValue.getClass().getSuperclass().equals(Object.class)) {
                throw new InvalidInputException("symbol \"" + symbolName + "\" is already defined as an incompatible symbol type");
            }
            species = new Species(symbolValue, compartment);
            pSymbolMap.put(symbolName, species);
        } else {
            species = (Species)symbolValue;
            if (!species.getCompartment().equals(compartment)) {
                throw new InvalidInputException("species \"" + symbolName + "\" is already assigned to a different compartment: " + compartment.getName());
            }
        }
        this.getEndOfStatement(pTokenIter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleStatementSymbolDefinition(ListIterator pTokenIter, Model pModelHashMap, HashMap pSymbolMap) throws InvalidInputException, DataNotFoundException {
        String symbolName = this.obtainSymbolWithNamespace(pTokenIter, pSymbolMap);
        assert (symbolName != null) : "null symbol string for symbol token";
        Token token = this.getNextToken(pTokenIter);
        if (!token.mCode.equals(Token.Code.EQUALS)) {
            if (!token.mCode.equals(Token.Code.BRACKET_BEGIN)) throw new InvalidInputException("encountered unknown token when expected equals token");
            throw new InvalidInputException("encountered begin bracket token when expected equals token; perhaps you forgot to put double quotes around your symbol definition?");
        }
        boolean allowDeferred = true;
        Value value = this.obtainValue(pTokenIter, pSymbolMap, allowDeferred);
        SymbolValue symbolValue = new SymbolValue(symbolName, value);
        SymbolValue foundSymbolValue = (SymbolValue)pSymbolMap.get(symbolName);
        if (foundSymbolValue != null) {
            if (foundSymbolValue.getValue() != null && !foundSymbolValue.getClass().getSuperclass().equals(Object.class)) throw new InvalidInputException("a symbol of type " + foundSymbolValue.getClass().getName() + " cannot have its value redefined; symbol name is: " + symbolName);
            foundSymbolValue.setValue(symbolValue.getValue());
        } else {
            pSymbolMap.put(symbolName, symbolValue);
        }
        this.getEndOfStatement(pTokenIter);
    }

    static Compartment getDefaultCompartment(HashMap pSymbolMap) {
        Compartment compartment = (Compartment)pSymbolMap.get(COMPARTMENT_NAME_DEFAULT);
        return compartment;
    }

    private void getReactionParticipants(ListIterator pTokenIter, HashMap pSymbolMap, HashMap pSpeciesStoicMap, HashMap pSpeciesDynamicMap, ReactionParticipant.Type pParticipantType) throws InvalidInputException, DataNotFoundException {
        while (pTokenIter.hasNext()) {
            boolean dynamic = true;
            Token token = this.getNextToken(pTokenIter);
            if (token.mCode.equals(Token.Code.DOLLAR)) {
                dynamic = false;
            } else {
                pTokenIter.previous();
            }
            String speciesName = this.obtainSymbolWithNamespace(pTokenIter, pSymbolMap);
            MutableInteger speciesStoic = (MutableInteger)pSpeciesStoicMap.get(speciesName);
            if (speciesStoic == null) {
                speciesStoic = new MutableInteger(1);
                pSpeciesStoicMap.put(speciesName, speciesStoic);
            } else {
                int stoic = speciesStoic.getValue() + 1;
                speciesStoic.setValue(stoic);
            }
            MutableBoolean speciesDynamic = (MutableBoolean)pSpeciesDynamicMap.get(speciesName);
            if (speciesDynamic != null) {
                if (speciesDynamic.booleanValue() != dynamic) {
                    throw new InvalidInputException("species " + speciesName + " is defined both as dynamic and boundary, for the same reaction");
                }
            } else {
                speciesDynamic = new MutableBoolean(dynamic);
                pSpeciesDynamicMap.put(speciesName, speciesDynamic);
            }
            token = this.getNextToken(pTokenIter);
            if (pParticipantType.equals(ReactionParticipant.Type.REACTANT) && token.mCode.equals(Token.Code.HYPHEN)) {
                token = this.getNextToken(pTokenIter);
                assert (token.mCode.equals(Token.Code.GREATER_THAN)) : "expected greater-than symbol";
                break;
            }
            if (token.mCode.equals(Token.Code.PLUS)) continue;
            if (pParticipantType.equals(ReactionParticipant.Type.PRODUCT) && token.mCode.equals(Token.Code.COMMA)) break;
            throw new InvalidInputException("invalid token type encountered in reaction definition: \"" + token.toString() + "\"");
        }
    }

    private void handleSpeciesDefinitions(Reaction pReaction, ReactionParticipant.Type pReactionParticipantType, HashMap pSymbolMap, HashMap pSpeciesStoicMap, HashMap pSpeciesDynamicMap) throws InvalidInputException {
        for (String speciesName : pSpeciesStoicMap.keySet()) {
            MutableBoolean speciesDynamic = (MutableBoolean)pSpeciesDynamicMap.get(speciesName);
            assert (speciesDynamic != null) : "expected to find non-null object for species: " + speciesName;
            boolean dynamic = speciesDynamic.booleanValue();
            MutableInteger speciesStoic = (MutableInteger)pSpeciesStoicMap.get(speciesName);
            assert (speciesStoic != null) : "expected to find non-null object for species: " + speciesName;
            int stoichiometry = speciesStoic.getValue();
            SymbolValue speciesSymbolValue = (SymbolValue)pSymbolMap.get(speciesName);
            if (speciesSymbolValue == null) {
                throw new InvalidInputException("species \"" + speciesName + "\" was referenced in a reaction defintion, but was not previously defined");
            }
            Species species = null;
            if (!(speciesSymbolValue instanceof Species)) {
                if (!speciesSymbolValue.getClass().getSuperclass().equals(Object.class)) {
                    throw new InvalidInputException("symbol: \"" + speciesName + "\" is already defined as a different (non-species) symbol of type \"" + speciesSymbolValue.getClass().getName() + "\"");
                }
                Compartment compartment = ModelBuilderCommandLanguage.getDefaultCompartment(pSymbolMap);
                species = new Species(speciesSymbolValue, compartment);
                pSymbolMap.put(speciesName, species);
            } else {
                species = (Species)speciesSymbolValue;
            }
            pReaction.addSpecies(species, stoichiometry, dynamic, pReactionParticipantType);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void handleStatementReaction(ListIterator pTokenIter, Model pModel, HashMap pSymbolMap, MutableInteger pNumReactions) throws InvalidInputException, DataNotFoundException {
        block23: {
            block22: {
                token = null;
                hasName = false;
                hasReactants = false;
                gotHyphen = false;
                while (pTokenIter.hasNext()) {
                    token = this.getNextToken(pTokenIter);
                    if (!token.mCode.equals(Token.Code.HYPHEN)) continue;
                    gotHyphen = true;
                    break;
                }
                if (ModelBuilderCommandLanguage.$assertionsDisabled || gotHyphen) ** GOTO lbl34
                throw new AssertionError((Object)"unable to locate the \"->\" reaction symbol within reaction statement");
lbl-1000:
                // 1 sources

                {
                    token = (Token)pTokenIter.previous();
                    if (token.mCode.equals(Token.Code.COMMA)) {
                        hasName = true;
                        continue;
                    }
                    if (token.mCode.equals(Token.Code.PLUS)) {
                        hasReactants = true;
                        continue;
                    }
                    if (token.mCode.equals(Token.Code.SYMBOL)) {
                        if (hasName) continue;
                        hasReactants = true;
                        continue;
                    }
                    if (token.mCode.equals(Token.Code.DOLLAR)) {
                        hasReactants = true;
                        continue;
                    }
                    if (token.mCode.equals(Token.Code.SEMICOLON)) {
                        pTokenIter.next();
                        break;
                    }
                    if (!token.mCode.equals(Token.Code.BRACE_END)) continue;
                    pTokenIter.next();
                    break;
lbl34:
                    // 7 sources

                    ** while (pTokenIter.hasPrevious())
                }
lbl35:
                // 3 sources

                reactionName = null;
                if (hasName) {
                    reactionName = this.obtainSymbolWithNamespace(pTokenIter, pSymbolMap);
                    token = this.getNextToken(pTokenIter);
                    if (!token.mCode.equals(Token.Code.COMMA)) {
                        throw new InvalidInputException("expected comma after reaction name token");
                    }
                } else {
                    numReactions = pNumReactions.getValue() + 1;
                    pNumReactions.setValue(numReactions);
                    reactionName = "___r" + numReactions;
                }
                reaction = new Reaction(reactionName);
                speciesStoicMap = new HashMap<K, V>();
                speciesDynamicMap = new HashMap<K, V>();
                if (hasReactants) {
                    this.getReactionParticipants(pTokenIter, pSymbolMap, speciesStoicMap, speciesDynamicMap, ReactionParticipant.Type.REACTANT);
                    this.handleSpeciesDefinitions(reaction, ReactionParticipant.Type.REACTANT, pSymbolMap, speciesStoicMap, speciesDynamicMap);
                } else {
                    pTokenIter.next();
                    pTokenIter.next();
                }
                token = this.getNextToken(pTokenIter);
                hasProducts = false;
                if (token.mCode.equals(Token.Code.SYMBOL) || token.mCode.equals(Token.Code.QUOTE)) {
                    hasProducts = true;
                    pTokenIter.previous();
                } else if (!token.mCode.equals(Token.Code.COMMA)) {
                    throw new InvalidInputException("expected comma separator between reaction and rate; token is: " + token);
                }
                speciesStoicMap.clear();
                if (hasProducts) {
                    this.getReactionParticipants(pTokenIter, pSymbolMap, speciesStoicMap, speciesDynamicMap, ReactionParticipant.Type.PRODUCT);
                    this.handleSpeciesDefinitions(reaction, ReactionParticipant.Type.PRODUCT, pSymbolMap, speciesStoicMap, speciesDynamicMap);
                }
                if (!pTokenIter.hasNext()) {
                    throw new InvalidInputException("incomplete reaction definition; expected to find reaction rate specifier");
                }
                allowDeferred = true;
                rateValue = this.obtainValue(pTokenIter, pSymbolMap, allowDeferred);
                reaction.setRate(rateValue);
                if (pSymbolMap.get(reactionName) != null) {
                    throw new InvalidInputException("already found a symbol defined with name: " + reactionName + "; cannot process reaction definition of same name");
                }
                pSymbolMap.put(reactionName, reaction);
                pModel.addReaction(reaction);
                nextToken = this.getNextToken(pTokenIter);
                if (!nextToken.mCode.equals(Token.Code.COMMA)) break block22;
                nextToken = this.getNextToken(pTokenIter);
                if (!nextToken.mCode.equals(Token.Code.SYMBOL)) ** GOTO lbl90
                if (nextToken.mSymbol.equals("steps:")) {
                    this.handleMultistepReaction(reaction, pSymbolMap, pTokenIter);
                } else if (nextToken.mSymbol.equals("delay:")) {
                    this.handleDelayedReaction(reaction, pSymbolMap, pTokenIter);
                } else {
                    throw new InvalidInputException("unknown reaction modifier symbol: " + nextToken.mSymbol + "; did you forget to include the reaction modifier \"" + "steps:" + "\" or \"" + "delay:" + "\"?");
lbl90:
                    // 1 sources

                    pTokenIter.previous();
                    this.handleMultistepReaction(reaction, pSymbolMap, pTokenIter);
                }
                break block23;
            }
            pTokenIter.previous();
        }
        this.getEndOfStatement(pTokenIter);
    }

    private void handleDelayedReaction(Reaction pReaction, HashMap pSymbolMap, ListIterator pTokenIter) throws InvalidInputException, DataNotFoundException {
        Value delayValue = this.obtainValue(pTokenIter, pSymbolMap, false);
        if (delayValue.isExpression()) {
            throw new InvalidInputException("reaction delay must be specified as a number, not a deferred-evaluation expression");
        }
        double delay = delayValue.getValue();
        if (delay < 0.0) {
            throw new InvalidInputException("reaction delay must be a nonnegative number");
        }
        pReaction.setDelay(delay);
    }

    private void handleMultistepReaction(Reaction pReaction, HashMap pSymbolMap, ListIterator pTokenIter) throws InvalidInputException, DataNotFoundException {
        boolean allowDeferred = false;
        Value stepsValue = this.obtainValue(pTokenIter, pSymbolMap, allowDeferred);
        if (stepsValue.isExpression()) {
            throw new InvalidInputException("number of reaction steps must be specified as a number, not a deferred-evaluation expression");
        }
        int numSteps = (int)stepsValue.getValue();
        if (numSteps <= 0) {
            throw new InvalidInputException("invalid number of steps specified");
        }
        if (numSteps > 1) {
            pReaction.setNumSteps(numSteps);
        }
    }

    private void getEndOfStatement(ListIterator pTokenIter) throws InvalidInputException {
        Token token = this.getNextToken(pTokenIter);
        if (!token.mCode.equals(Token.Code.SEMICOLON)) {
            throw new InvalidInputException("expected statement-ending semicolon; instead encountered token \"" + token + "\"");
        }
    }

    private String getQuotedString(ListIterator pTokenIter) throws InvalidInputException {
        Token token = this.getNextToken(pTokenIter);
        if (!token.mCode.equals(Token.Code.QUOTE)) {
            throw new InvalidInputException("expected quote symbol");
        }
        token = this.getNextToken(pTokenIter);
        if (!token.mCode.equals(Token.Code.SYMBOL)) {
            throw new InvalidInputException("expected quoted string");
        }
        String string = token.mSymbol;
        token = this.getNextToken(pTokenIter);
        assert (token.mCode.equals(Token.Code.QUOTE)) : "missing terminating quote";
        return string;
    }

    private void handleStatementModel(ListIterator pTokenIter, Model pModel, HashMap pSymbolMap) throws InvalidInputException, DataNotFoundException {
        Token token = this.getNextToken(pTokenIter);
        assert (token.mCode.equals(Token.Code.POUNDSIGN)) : "where expected a pound sign, got an unexpected token \"" + token + "\"";
        token = this.getNextToken(pTokenIter);
        assert (token.mCode.equals(Token.Code.SYMBOL)) : "where expected a symbol token, got an unexpected token: " + token;
        assert (token.mSymbol.equals("model")) : "where expected the model keyword, got an unexpected symbol token: " + token.mSymbol;
        if (this.mNamespace != null) {
            throw new InvalidInputException("it is illegal to define a model name inside a macro reference");
        }
        String modelName = this.obtainSymbol(pTokenIter, pSymbolMap);
        pModel.setName(modelName);
        this.getEndOfStatement(pTokenIter);
    }

    private void handleStatementMacroDefinition(ListIterator pTokenIter, Model pModel, HashMap pSymbolMap, MutableInteger pNumReactions) throws InvalidInputException, DataNotFoundException {
        Token token = this.getNextToken(pTokenIter);
        assert (token.mCode.equals(Token.Code.POUNDSIGN)) : "where expected a pound sign, got an unexpected token: " + token;
        token = this.getNextToken(pTokenIter);
        assert (token.mCode.equals(Token.Code.SYMBOL)) : "where expected a symbol token, got an unexpected token: " + token;
        assert (token.mSymbol.equals(STATEMENT_KEYWORD_DEFINE)) : "where expected the define keyword, got an unexpected symbol token: " + token.mSymbol;
        String macroName = this.obtainSymbol(pTokenIter, pSymbolMap);
        if (pSymbolMap.get(macroName) != null) {
            throw new InvalidInputException("symbol " + macroName + " was defined more than once in the same model");
        }
        if (-1 != macroName.indexOf("::")) {
            throw new InvalidInputException("macro name may not contain the namespace identifier \"::\"; macro name is: " + macroName);
        }
        ArrayList<String> externalSymbolsList = new ArrayList<String>();
        if (!pTokenIter.hasNext()) {
            throw new InvalidInputException("expected parenthesis or curly brace after macro definition statement");
        }
        token = this.getNextToken(pTokenIter);
        if (token.mCode.equals(Token.Code.PAREN_BEGIN)) {
            boolean expectSymbol = true;
            boolean gotEndParen = false;
            while (pTokenIter.hasNext()) {
                if (expectSymbol) {
                    String symbol = this.obtainSymbol(pTokenIter, pSymbolMap);
                    externalSymbolsList.add(symbol);
                    expectSymbol = false;
                    continue;
                }
                token = this.getNextToken(pTokenIter);
                if (token.mCode.equals(Token.Code.PAREN_END)) {
                    gotEndParen = true;
                    break;
                }
                if (token.mCode.equals(Token.Code.SEMICOLON)) {
                    throw new InvalidInputException("end of statement token encountered inside macro definition symbol list");
                }
                if (token.mCode.equals(Token.Code.COMMA)) {
                    if (expectSymbol) {
                        throw new InvalidInputException("comma encountered unexpectedly in macro definition symbol list");
                    }
                    expectSymbol = true;
                    continue;
                }
                throw new InvalidInputException("unexpected token encountered in macro definition symbol list \"" + token + "\"");
            }
            if (!gotEndParen) {
                throw new InvalidInputException("failed to find end parenthesis");
            }
        } else if (token.mCode.equals(Token.Code.BRACE_BEGIN)) {
            pTokenIter.previous();
        } else {
            throw new InvalidInputException("unknown token found in macro definition statement");
        }
        if (!pTokenIter.hasNext()) {
            throw new InvalidInputException("expected curly brace token, instead found nothing");
        }
        token = this.getNextToken(pTokenIter);
        if (!token.mCode.equals(Token.Code.BRACE_BEGIN)) {
            throw new InvalidInputException("expected curly brace token in macro definition statement");
        }
        Macro macro = new Macro(macroName);
        macro.mExternalSymbols = externalSymbolsList;
        LinkedList<Token> tokenList = new LinkedList<Token>();
        boolean gotEndBrace = false;
        Token prevToken = null;
        int braceCtr = 1;
        while (pTokenIter.hasNext()) {
            prevToken = token;
            token = this.getNextToken(pTokenIter);
            if (token.mCode.equals(Token.Code.BRACE_END)) {
                if (--braceCtr == 0) {
                    gotEndBrace = true;
                    break;
                }
            } else if (token.mCode.equals(Token.Code.BRACE_BEGIN)) {
                ++braceCtr;
            } else if (prevToken != null && prevToken.mCode.equals(Token.Code.POUNDSIGN) && token.mCode.equals(Token.Code.SYMBOL) && token.mSymbol.equals(STATEMENT_KEYWORD_DEFINE)) {
                throw new InvalidInputException("it is illegal to embed a macro definition inside a macro definition");
            }
            tokenList.add(token);
        }
        if (!gotEndBrace) {
            throw new InvalidInputException("failed to find end brace");
        }
        macro.mTokenList = tokenList;
        pSymbolMap.put(macroName, macro);
    }

    private void handleStatementInclude(ListIterator pTokenIter, Model pModel, HashMap pSymbolMap, MutableInteger pNumReactions, IncludeHandler pIncludeHandler) throws InvalidInputException {
        if (pIncludeHandler == null) {
            throw new InvalidInputException("encountered an include statement; include statements are not allowed in this context");
        }
        Token token = this.getNextToken(pTokenIter);
        assert (token.mCode.equals(Token.Code.POUNDSIGN)) : "where expected a pound sign, got an unexpected token: " + token;
        token = this.getNextToken(pTokenIter);
        assert (token.mCode.equals(Token.Code.SYMBOL)) : "where expected a symbol token, got an unexpected token: " + token;
        assert (token.mSymbol.equals(STATEMENT_KEYWORD_INCLUDE)) : "where expected the include keyword, got an unexpected symbol token: " + token.mSymbol;
        String fileName = this.getQuotedString(pTokenIter);
        this.getEndOfStatement(pTokenIter);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = pIncludeHandler.openReaderForIncludeFile(fileName, sCharset);
            if (bufferedReader != null) {
                boolean insideInclude = true;
                this.parseModelDefinition(bufferedReader, pModel, pIncludeHandler, pSymbolMap, pNumReactions, insideInclude);
            }
        }
        catch (IOException e) {
            throw new InvalidInputException("error reading include file \"" + fileName + "\"", e);
        }
        catch (InvalidInputException e) {
            StringBuffer sb = new StringBuffer(e.getMessage());
            sb.append(" in file \"" + fileName + "\"; included");
            throw new InvalidInputException(sb.toString(), e);
        }
    }

    private String getErrorMessage(Exception e, int pLineCtr) {
        StringBuffer message = new StringBuffer(e.getMessage());
        message.append(" at line " + pLineCtr);
        return message.toString();
    }

    private void synchIterators(ListIterator master, ListIterator slave) {
        while (slave.nextIndex() < master.nextIndex()) {
            slave.next();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void executeStatementBlock(List pTokens, Model pModel, IncludeHandler pIncludeHandler, HashMap pSymbolMap, MutableInteger pNumReactions) throws InvalidInputException {
        ListIterator tokenIter = pTokens.listIterator();
        ListIterator tokenIterExec = pTokens.listIterator();
        Token prevToken = null;
        Token token = null;
        int lineCtr = 0;
        try {
            while (tokenIter.hasNext()) {
                token = (Token)tokenIter.next();
                assert (token != null) : "unexpected null token";
                lineCtr = token.mLine;
                if (token.mCode.equals(Token.Code.EQUALS)) {
                    this.handleStatementSymbolDefinition(tokenIterExec, pModel, pSymbolMap);
                    this.synchIterators(tokenIterExec, tokenIter);
                } else if (token.mCode.equals(Token.Code.ATSIGN)) {
                    this.handleStatementAssociate(tokenIterExec, pModel, pSymbolMap);
                    this.synchIterators(tokenIterExec, tokenIter);
                } else if (token.mCode.equals(Token.Code.GREATER_THAN)) {
                    if (prevToken == null) throw new InvalidInputException("encountered \">\" with no preceding hyphen and outside of an expression context");
                    if (!prevToken.mCode.equals(Token.Code.HYPHEN)) throw new InvalidInputException("encountered \">\" unexpectedly");
                    this.handleStatementReaction(tokenIterExec, pModel, pSymbolMap, pNumReactions);
                    this.synchIterators(tokenIterExec, tokenIter);
                } else if (token.mCode.equals(Token.Code.SYMBOL) && prevToken != null && prevToken.mCode.equals(Token.Code.POUNDSIGN)) {
                    assert (token.mSymbol != null) : "null symbol string found in symbol token";
                    if (token.mSymbol.equals(STATEMENT_KEYWORD_INCLUDE)) {
                        this.handleStatementInclude(tokenIterExec, pModel, pSymbolMap, pNumReactions, pIncludeHandler);
                        this.synchIterators(tokenIterExec, tokenIter);
                    } else if (token.mSymbol.equals("model")) {
                        this.handleStatementModel(tokenIterExec, pModel, pSymbolMap);
                        this.synchIterators(tokenIterExec, tokenIter);
                    } else if (token.mSymbol.equals(STATEMENT_KEYWORD_DEFINE)) {
                        this.handleStatementMacroDefinition(tokenIterExec, pModel, pSymbolMap, pNumReactions);
                        this.synchIterators(tokenIterExec, tokenIter);
                    } else {
                        if (!token.mSymbol.equals(STATEMENT_KEYWORD_REF)) throw new InvalidInputException("unknown command keyword \"" + token.mSymbol + "\"");
                        this.handleStatementMacroReference(tokenIterExec, pModel, pIncludeHandler, pSymbolMap, pNumReactions);
                        this.synchIterators(tokenIterExec, tokenIter);
                    }
                } else if (token.mCode.equals(Token.Code.PAREN_BEGIN)) {
                    if (prevToken == null) throw new InvalidInputException("statement began with a parenthesis");
                    if (!prevToken.mCode.equals(Token.Code.SYMBOL)) throw new InvalidInputException("parenthesis following unexpected token \"" + prevToken.mCode + "\"");
                    if (!prevToken.mSymbol.equals(KEYWORD_LOOP)) throw new InvalidInputException("parenthesis following unknown keyword: " + prevToken.mSymbol);
                    this.handleStatementLoop(tokenIterExec, pModel, pIncludeHandler, pSymbolMap, pNumReactions);
                    this.synchIterators(tokenIterExec, tokenIter);
                } else if (token.mCode.equals(Token.Code.SEMICOLON)) {
                    throw new InvalidInputException("unknown statement type");
                }
                prevToken = token;
            }
            return;
        }
        catch (DataNotFoundException e) {
            throw new InvalidInputException(this.getErrorMessage(e, lineCtr), e);
        }
        catch (InvalidInputException e) {
            throw new InvalidInputException(this.getErrorMessage(e, lineCtr), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleStatementLoop(ListIterator pTokenIter, Model pModel, IncludeHandler pIncludeHandler, HashMap pSymbolMap, MutableInteger pNumReactions) throws InvalidInputException, DataNotFoundException {
        Token token = this.getNextToken(pTokenIter);
        assert (token.mCode.equals(Token.Code.SYMBOL)) : "expected a symbol token, unexpectedly got token: " + token;
        assert (token.mSymbol.equals(KEYWORD_LOOP)) : "expected loop keyword; unexpectedly got symbol: " + token.mSymbol;
        token = this.getNextToken(pTokenIter);
        if (!token.mCode.equals(Token.Code.PAREN_BEGIN)) {
            throw new InvalidInputException("unexpected token found when expected beginning parenthesis; token is \"" + token + "\"");
        }
        token = this.getNextToken(pTokenIter);
        if (!token.mCode.equals(Token.Code.SYMBOL)) {
            throw new InvalidInputException("unexpected token found when expected loop index symbol; token is \"" + token + "\"");
        }
        String loopIndexSymbolName = token.mSymbol;
        if (ReservedSymbolMapperChemCommandLanguage.isReservedSymbol(loopIndexSymbolName)) {
            throw new InvalidInputException("cannot use a reserved symbol as a loop index; you used \"" + loopIndexSymbolName + "\"");
        }
        loopIndexSymbolName = ModelBuilderCommandLanguage.addNamespaceToSymbol(loopIndexSymbolName, this.mNamespace);
        token = this.getNextToken(pTokenIter);
        if (!token.mCode.equals(Token.Code.COMMA)) {
            throw new InvalidInputException("unexpected token found when expected comma separator; token is \"" + token + "\"");
        }
        if (!pTokenIter.hasNext()) {
            throw new InvalidInputException("missing loop starting value");
        }
        boolean allowDeferred = false;
        Value startValueObj = this.obtainValue(pTokenIter, pSymbolMap, allowDeferred);
        int startValue = (int)startValueObj.getValue();
        if (!pTokenIter.hasNext()) {
            throw new InvalidInputException("missing loop ending value");
        }
        token = this.getNextToken(pTokenIter);
        if (!token.mCode.equals(Token.Code.COMMA)) {
            throw new InvalidInputException("expected a comma separating the start expression from the end expression, in a loop statement; instead found the token \"" + token.mCode + "\"");
        }
        boolean allowTerminateOnParen = true;
        Value stopValueObj = this.obtainValue(pTokenIter, pSymbolMap, allowDeferred, allowTerminateOnParen);
        int endValue = (int)stopValueObj.getValue();
        if (!pTokenIter.hasNext()) {
            throw new InvalidInputException("missing paren at end of loop statement");
        }
        token = this.getNextToken(pTokenIter);
        if (!token.mCode.equals(Token.Code.PAREN_END)) {
            throw new InvalidInputException("expected a paren at the end of the loop statement; instead found the token \"" + token.mCode + "\"");
        }
        if (!pTokenIter.hasNext()) {
            throw new InvalidInputException("missing curly brace after loop statement");
        }
        token = this.getNextToken(pTokenIter);
        if (!token.mCode.equals(Token.Code.BRACE_BEGIN)) {
            throw new InvalidInputException("expected a curly brace after the loop statement; instead found the token \"" + token.mCode + "\"");
        }
        SymbolValue loopIndexSymbolValue = (SymbolValue)pSymbolMap.get(loopIndexSymbolName);
        LoopIndex loopIndexObj = null;
        if (loopIndexSymbolValue != null) {
            if (!(loopIndexSymbolValue instanceof LoopIndex)) throw new InvalidInputException("loop index \"" + loopIndexSymbolName + "\" has already been used as a symbol elsewhere");
            loopIndexObj = (LoopIndex)loopIndexSymbolValue;
        } else {
            loopIndexSymbolValue = new LoopIndex(loopIndexSymbolName, startValue);
            pSymbolMap.put(loopIndexSymbolName, loopIndexSymbolValue);
            loopIndexObj = (LoopIndex)loopIndexSymbolValue;
        }
        LinkedList<Token> subTokenList = new LinkedList<Token>();
        int braceCtr = 1;
        while (pTokenIter.hasNext()) {
            token = this.getNextToken(pTokenIter);
            if (token.mCode.equals(Token.Code.BRACE_BEGIN)) {
                ++braceCtr;
            } else if (token.mCode.equals(Token.Code.BRACE_END)) {
                --braceCtr;
            }
            if (braceCtr > 0) {
                subTokenList.add(token);
            }
            if (braceCtr == 0) break;
        }
        if (braceCtr > 0) {
            throw new InvalidInputException("end-of-file encountered without matching end brace");
        }
        int loopIndex = startValue;
        while (loopIndex <= endValue) {
            loopIndexObj.setValue(loopIndex);
            try {
                this.executeStatementBlock(subTokenList, pModel, pIncludeHandler, pSymbolMap, pNumReactions);
            }
            catch (InvalidInputException e) {
                StringBuffer messageBuf = new StringBuffer(e.getMessage());
                messageBuf.append(" in loop block beginning");
                throw new InvalidInputException(messageBuf.toString(), e);
            }
            ++loopIndex;
        }
        pSymbolMap.remove(loopIndexSymbolName);
    }

    private void handleStatementMacroReference(ListIterator pTokenIter, Model pModel, IncludeHandler pIncludeHandler, HashMap pSymbolMap, MutableInteger pNumReactions) throws InvalidInputException, DataNotFoundException {
        Token token = this.getNextToken(pTokenIter);
        assert (token.mCode.equals(Token.Code.POUNDSIGN)) : "where expected a pound sign, got an unexpected token: " + token;
        token = this.getNextToken(pTokenIter);
        assert (token.mCode.equals(Token.Code.SYMBOL)) : "where expected a symbol token, got an unexpected token: " + token;
        assert (token.mSymbol.equals(STATEMENT_KEYWORD_REF)) : "where expected the ref keyword, got an unexpected symbol token: " + token.mSymbol;
        String macroName = this.obtainSymbol(pTokenIter, pSymbolMap);
        SymbolValue symbolValue = (SymbolValue)pSymbolMap.get(macroName);
        if (symbolValue == null) {
            throw new InvalidInputException("unknown macro referenced: " + macroName);
        }
        if (!(symbolValue instanceof Macro)) {
            throw new InvalidInputException("symbol referenced is not a macro: " + macroName);
        }
        Macro macro = (Macro)symbolValue;
        String macroInstanceName = this.obtainSymbol(pTokenIter, pSymbolMap);
        ArrayList<Object> externalSymbolsList = new ArrayList<Object>();
        if (!pTokenIter.hasNext()) {
            throw new InvalidInputException("expected parenthesis or curly brace after macro definition statement");
        }
        token = this.getNextToken(pTokenIter);
        if (token.mCode.equals(Token.Code.PAREN_BEGIN)) {
            boolean expectSymbol = true;
            boolean gotEndParen = false;
            boolean allowDeferred = true;
            LinkedList tokenList = new LinkedList();
            while (pTokenIter.hasNext()) {
                if (expectSymbol) {
                    tokenList.clear();
                    this.grabTokensToNextCommaOrParen(pTokenIter, tokenList, pSymbolMap);
                    if (tokenList.size() > 1) {
                        Value valueObj = this.obtainValue(tokenList.listIterator(), pSymbolMap, allowDeferred);
                        externalSymbolsList.add(valueObj);
                    } else {
                        Token firstToken = (Token)tokenList.get(0);
                        if (firstToken.mCode.equals(Token.Code.SYMBOL)) {
                            Object symbolObj;
                            block29: {
                                symbolObj = null;
                                String symbolName = firstToken.mSymbol;
                                double value = 0.0;
                                try {
                                    value = Double.parseDouble(symbolName);
                                    Value symbolValueObj = new Value(value);
                                    symbolObj = symbolValueObj;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    symbolObj = ModelBuilderCommandLanguage.addNamespaceToSymbol(symbolName, this.mNamespace);
                                    Object symbolTableEntry = pSymbolMap.get(symbolObj);
                                    if (symbolTableEntry == null || !(symbolTableEntry instanceof DummySymbol)) break block29;
                                    DummySymbol dummySymbol = (DummySymbol)symbolTableEntry;
                                    symbolObj = dummySymbol.mInstanceSymbolObject;
                                }
                            }
                            externalSymbolsList.add(symbolObj);
                        } else {
                            throw new InvalidInputException("unknown token in list of symbols: " + firstToken);
                        }
                    }
                    expectSymbol = false;
                    continue;
                }
                token = this.getNextToken(pTokenIter);
                if (token.mCode.equals(Token.Code.PAREN_END)) {
                    gotEndParen = true;
                    break;
                }
                if (token.mCode.equals(Token.Code.SEMICOLON)) {
                    throw new InvalidInputException("end of statement token encountered inside parentheses");
                }
                if (token.mCode.equals(Token.Code.COMMA)) {
                    if (expectSymbol) {
                        throw new InvalidInputException("comma encountered unexpectedly");
                    }
                    expectSymbol = true;
                    continue;
                }
                throw new InvalidInputException("unknown symbol encountered " + token);
            }
            if (!gotEndParen) {
                throw new InvalidInputException("failed to find end parenthesis");
            }
        } else {
            pTokenIter.previous();
        }
        this.getEndOfStatement(pTokenIter);
        if (externalSymbolsList.size() != macro.mExternalSymbols.size()) {
            throw new InvalidInputException("number of symbols is mismatched, for macro reference: " + macroName);
        }
        String oldNamespace = this.mNamespace;
        this.mNamespace = ModelBuilderCommandLanguage.addNamespaceToSymbol(macroInstanceName, this.mNamespace);
        int numExtSym = externalSymbolsList.size();
        int i = 0;
        while (i < numExtSym) {
            String dummySymbolName = (String)macro.mExternalSymbols.get(i);
            assert (dummySymbolName != null) : "unexpected null array element";
            String translatedDummySymbolName = ModelBuilderCommandLanguage.addNamespaceToSymbol(dummySymbolName, this.mNamespace);
            assert (pSymbolMap.get(dummySymbolName) == null) : "unexpectedly found dummy symbol in global symbol table: " + dummySymbolName;
            Object extSymValueObj = externalSymbolsList.get(i);
            assert (extSymValueObj != null) : "unexpected null array element";
            DummySymbol dummySymbol = new DummySymbol(translatedDummySymbolName, extSymValueObj);
            pSymbolMap.put(translatedDummySymbolName, dummySymbol);
            ++i;
        }
        LinkedList tokenList = macro.mTokenList;
        new LinkedList();
        tokenList.iterator();
        try {
            this.executeStatementBlock(macro.mTokenList, pModel, pIncludeHandler, pSymbolMap, pNumReactions);
        }
        catch (InvalidInputException e) {
            StringBuffer messageBuffer = new StringBuffer(e.getMessage());
            messageBuffer.append(" in macro referenced");
            throw new InvalidInputException(messageBuffer.toString(), e);
        }
        int i2 = 0;
        while (i2 < numExtSym) {
            String extSymDummy = (String)macro.mExternalSymbols.get(i2);
            extSymDummy = ModelBuilderCommandLanguage.addNamespaceToSymbol(extSymDummy, this.mNamespace);
            pSymbolMap.remove(extSymDummy);
            ++i2;
        }
        this.mNamespace = oldNamespace;
    }

    private void tokenizeAndExecuteStatementBuffer(StringBuffer pStatementBuffer, List pTokenList, Model pModel, IncludeHandler pIncludeHandler, HashMap pSymbolMap, MutableInteger pNumReactions, int pLineNumber) throws InvalidInputException {
        String statement = pStatementBuffer.toString();
        this.tokenizeStatement(statement, pTokenList, pLineNumber);
        pStatementBuffer.delete(0, statement.length());
        this.executeStatementBlock(pTokenList, pModel, pIncludeHandler, pSymbolMap, pNumReactions);
        pTokenList.clear();
    }

    private void parseModelDefinition(BufferedReader pInputReader, Model pModel, IncludeHandler pIncludeHandler, HashMap pSymbolMap, MutableInteger pNumReactions, boolean pInsideInclude) throws IOException, InvalidInputException {
        StreamTokenizer streamTokenizer = new StreamTokenizer(pInputReader);
        streamTokenizer.slashSlashComments(true);
        streamTokenizer.slashStarComments(true);
        streamTokenizer.lowerCaseMode(false);
        streamTokenizer.quoteChar(34);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.ordinaryChars(32, 32);
        streamTokenizer.ordinaryChars(9, 9);
        streamTokenizer.ordinaryChars(48, 57);
        streamTokenizer.ordinaryChars(46, 46);
        streamTokenizer.ordinaryChars(45, 45);
        streamTokenizer.ordinaryChars(47, 47);
        if (!pInsideInclude) {
            this.processDefaultModelElements(pSymbolMap);
        }
        int lineCtr = 1;
        StringBuffer statementBuffer = new StringBuffer();
        LinkedList tokenList = new LinkedList();
        int braceLevel = 0;
        while (true) {
            boolean executeStatement = false;
            int tokenType = streamTokenizer.nextToken();
            if (-1 == tokenType) break;
            if (tokenType == 34) {
                String quotedString = streamTokenizer.sval;
                statementBuffer.append("\"" + quotedString + "\"");
            } else if (tokenType == 10) {
                statementBuffer.append("\n");
            } else if (tokenType == 123) {
                ++braceLevel;
                statementBuffer.append("{");
            } else if (tokenType == 125) {
                if (braceLevel == 0) {
                    throw new InvalidInputException("mismatched braces, encountered \"}\" brace without matching \"{\" brace previously");
                }
                statementBuffer.append("}");
                if (--braceLevel == 0) {
                    executeStatement = true;
                }
            } else if (tokenType == 59) {
                statementBuffer.append(";");
                if (braceLevel == 0) {
                    executeStatement = true;
                }
            } else if (tokenType == -3) {
                statementBuffer.append(streamTokenizer.sval);
            } else if (tokenType == 9) {
                statementBuffer.append(" ");
            } else if (tokenType == -2) {
                double value = streamTokenizer.nval;
                statementBuffer.append(value);
            } else {
                statementBuffer.append(Character.toString((char)tokenType));
            }
            if (!executeStatement) continue;
            this.tokenizeAndExecuteStatementBuffer(statementBuffer, tokenList, pModel, pIncludeHandler, pSymbolMap, pNumReactions, lineCtr);
            lineCtr = streamTokenizer.lineno();
        }
        if (statementBuffer.toString().trim().length() != 0) {
            throw new InvalidInputException("model definition file ended without a statement-ending token (semicolon); at line " + lineCtr + " of model definition file");
        }
        if (!pInsideInclude) {
            this.defineParameters(pSymbolMap, pModel);
        }
    }

    public Model buildModel(InputStream pInputStream, IncludeHandler pIncludeHandler) throws InvalidInputException, IOException {
        Model model = new Model();
        model.setName("model");
        model.setReservedSymbolMapper(new ReservedSymbolMapperChemCommandLanguage());
        HashMap symbolMap = new HashMap();
        MutableInteger numReactions = new MutableInteger(0);
        this.mNamespace = null;
        boolean insideInclude = false;
        BufferedReader bufferedReader = this.getBufferedReader(pInputStream);
        this.parseModelDefinition(bufferedReader, model, pIncludeHandler, symbolMap, numReactions, insideInclude);
        return model;
    }

    public void writeModel(String pModelText, OutputStream pOutputStream) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(pOutputStream, sCharset);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        PrintWriter printWriter = new PrintWriter(bufferedWriter);
        printWriter.print(pModelText);
        printWriter.flush();
    }

    public BufferedReader getBufferedReader(InputStream pInputStream) {
        InputStreamReader inputStreamReader = new InputStreamReader(pInputStream, sCharset);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        return bufferedReader;
    }

    public String readModel(InputStream pInputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(pInputStream, sCharset);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuffer stringBuffer = new StringBuffer();
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            stringBuffer.append(String.valueOf(line) + "\n");
        }
        return stringBuffer.toString();
    }

    public static boolean isValidSymbol(String pSymbolName) {
        return VALID_SYMBOL_PATTERN.matcher(pSymbolName).matches();
    }

    public String getFileRegex() {
        return ".*\\.(dizzy|cmdl)$";
    }

    static class DummySymbol
    extends SymbolValue {
        public Object mInstanceSymbolObject;

        public DummySymbol(String pDummySymbolName, Object pInstanceSymbolObject) {
            super(pDummySymbolName);
            this.mInstanceSymbolObject = pInstanceSymbolObject;
        }
    }

    static class LoopIndex
    extends SymbolValue {
        public LoopIndex(String pIndexName, int pValue) {
            super(pIndexName);
            this.setValue(new Value(pValue));
        }

        public void setValue(int pValue) {
            this.getValue().setValue(pValue);
        }

        public String toString() {
            int value = (int)this.getValue().getValue();
            return Integer.toString(value);
        }
    }

    static class Macro
    extends SymbolValue {
        public String mMacroName;
        public ArrayList mExternalSymbols;
        public LinkedList mTokenList;

        public Macro(String pMacroName) {
            super(pMacroName);
            this.mMacroName = pMacroName;
        }
    }

    static class SymbolEvaluatorNamespaced
    extends SymbolEvaluatorHashMap {
        private String mNamespace;

        public SymbolEvaluatorNamespaced(HashMap pSymbolMap, String pNamespace) {
            super(pSymbolMap);
            this.mNamespace = pNamespace;
        }

        public double getUnindexedValue(Symbol pSymbol) throws DataNotFoundException {
            Object convertedSymbol = ModelBuilderCommandLanguage.performSymbolTokenMacroTranslationLookup(pSymbol.getName(), this.mSymbolMap, this.mNamespace);
            double retVal = 0.0;
            if (convertedSymbol instanceof String) {
                String symbolName = (String)convertedSymbol;
                retVal = super.getValue(symbolName);
            } else if (convertedSymbol instanceof Value) {
                Value symbolValue = (Value)convertedSymbol;
                retVal = symbolValue.getValue(this);
            } else assert (false) : "unknown converted symbol type, for symbol: " + pSymbol.getName();
            return retVal;
        }
    }

    static class Token {
        Code mCode;
        String mSymbol;
        int mLine;

        public Token(Code pCode) {
            this.mCode = pCode;
        }

        public String toString() {
            String string = null;
            string = this.mCode.equals(Code.SYMBOL) ? this.mSymbol : this.mCode.mName;
            return string;
        }

        static class Code {
            private final String mName;
            public static final Code POUNDSIGN = new Code("#");
            public static final Code ATSIGN = new Code("@");
            public static final Code EQUALS = new Code("=");
            public static final Code SYMBOL = new Code("symbol");
            public static final Code HYPHEN = new Code("-");
            public static final Code COMMA = new Code(",");
            public static final Code GREATER_THAN = new Code(">");
            public static final Code PLUS = new Code("+");
            public static final Code BRACKET_BEGIN = new Code("[");
            public static final Code BRACKET_END = new Code("]");
            public static final Code PAREN_BEGIN = new Code("(");
            public static final Code PAREN_END = new Code(")");
            public static final Code BRACE_BEGIN = new Code("{");
            public static final Code BRACE_END = new Code("}");
            public static final Code QUOTE = new Code("\"");
            public static final Code SEMICOLON = new Code(";");
            public static final Code DOLLAR = new Code("$");
            public static final Code ASTERISK = new Code("*");
            public static final Code PERCENT = new Code("%");
            public static final Code RIGHT_SLASH = new Code("/");
            public static final Code CARET = new Code("^");

            private Code(String pName) {
                this.mName = pName;
            }

            public String toString() {
                return this.mName;
            }
        }
    }
}

