/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.systemsbiology.chem.Compartment;
import org.systemsbiology.chem.IModelExporter;
import org.systemsbiology.chem.Model;
import org.systemsbiology.chem.ModelBuilderCommandLanguage;
import org.systemsbiology.chem.ModelExporterException;
import org.systemsbiology.chem.Parameter;
import org.systemsbiology.chem.Reaction;
import org.systemsbiology.chem.ReactionParticipant;
import org.systemsbiology.chem.Species;
import org.systemsbiology.math.Expression;
import org.systemsbiology.math.Symbol;
import org.systemsbiology.math.SymbolEvaluationPostProcessor;
import org.systemsbiology.math.SymbolValue;
import org.systemsbiology.math.Value;
import org.systemsbiology.util.DataNotFoundException;
import org.systemsbiology.util.IAliasableClass;

public class ModelExporterCommandLanguage
implements IModelExporter,
IAliasableClass {
    public static final String CLASS_ALIAS = "command-language";
    private CMDLSymbolPrinter mSymbolPrinter = null;

    public void export(Model pModel, PrintWriter pOutputWriter) throws IllegalArgumentException, DataNotFoundException, IllegalStateException, UnsupportedOperationException, ModelExporterException {
        CMDLSymbolPrinter symbolPrinter;
        HashMap symbolsMap = pModel.getSymbolsMap();
        Set keySet = symbolsMap.keySet();
        Iterator keyIter = keySet.iterator();
        SymbolValue obj = null;
        String symbolName = null;
        SymbolEvaluationPostProcessor symbolEvaluationPostProcessor = pModel.getSymbolEvaluationPostProcessor();
        this.mSymbolPrinter = symbolPrinter = new CMDLSymbolPrinter(symbolsMap);
        symbolPrinter.setSymbolEvaluationPostProcessor(symbolEvaluationPostProcessor);
        LinkedList<SymbolValue> compartments = new LinkedList<SymbolValue>();
        LinkedList<SymbolValue> parameters = new LinkedList<SymbolValue>();
        LinkedList<SymbolValue> species = new LinkedList<SymbolValue>();
        LinkedList<SymbolValue> reactions = new LinkedList<SymbolValue>();
        while (keyIter.hasNext()) {
            symbolName = (String)keyIter.next();
            obj = (SymbolValue)symbolsMap.get(symbolName);
            if (obj instanceof Compartment) {
                compartments.add(obj);
                continue;
            }
            if (obj instanceof Parameter) {
                parameters.add(obj);
                continue;
            }
            if (obj instanceof Species) {
                species.add(obj);
                continue;
            }
            if (obj instanceof Reaction) {
                reactions.add(obj);
                continue;
            }
            throw new IllegalStateException("unknown symbol in model: " + obj.toString());
        }
        StringBuffer sb = new StringBuffer();
        Compartment defaultCompartment = ModelBuilderCommandLanguage.getDefaultCompartment(symbolsMap);
        Object var16_16 = null;
        Collections.sort(compartments);
        for (Compartment compartment : compartments) {
            if (defaultCompartment != null && compartment.equals(defaultCompartment)) continue;
            sb.append(String.valueOf(this.translateSymbolName(compartment.getName())) + " = " + this.printValue(compartment) + ";\n");
        }
        Collections.sort(parameters);
        Iterator iter = parameters.iterator();
        Parameter parameter = null;
        while (iter.hasNext()) {
            parameter = (Parameter)iter.next();
            sb.append(String.valueOf(this.translateSymbolName(parameter.getName())) + " = " + this.printValue(parameter) + ";\n");
        }
        Object var19_23 = null;
        Collections.sort(species);
        for (Species species2 : species) {
            Compartment compartment = species2.getCompartment();
            sb.append(String.valueOf(species2.getName()) + " = " + this.printValue(species2) + ";\n");
            if (defaultCompartment != null && compartment.equals(defaultCompartment)) continue;
            sb.append(String.valueOf(this.translateSymbolName(species2.getName())) + " @ " + compartment.getName() + ";\n");
        }
        Object var20_26 = null;
        Collections.sort(reactions);
        for (Reaction reaction : reactions) {
            String reactionName = reaction.getName();
            SymbolValue[] localSymbolValues = reaction.getLocalSymbolValues();
            int numLocalSymbols = localSymbolValues.length;
            SymbolValue localSymbol = null;
            HashSet<String> symbolValuesSet = new HashSet<String>();
            int i = 0;
            while (i < numLocalSymbols) {
                localSymbol = localSymbolValues[i];
                symbolValuesSet.add(localSymbol.getSymbol().getName());
                sb.append(String.valueOf(reactionName) + "___" + localSymbol.getSymbol().getName() + " = ");
                sb.append(String.valueOf(this.printValue(localSymbol)) + ";\n");
                ++i;
            }
            this.mSymbolPrinter.setLocalSymbolsAndReactionName(symbolValuesSet, reactionName);
            HashMap products = reaction.getProductsMap();
            HashMap reactants = reaction.getReactantsMap();
            ReactionParticipant reacParticipant = null;
            if (!reactionName.startsWith("___")) {
                sb.append(String.valueOf(this.translateSymbolName(reaction.getName())) + ", ");
            }
            String speciesName = null;
            Iterator spIter = reactants.keySet().iterator();
            int stoic = 0;
            while (spIter.hasNext()) {
                speciesName = (String)spIter.next();
                reacParticipant = (ReactionParticipant)reactants.get(speciesName);
                stoic = reacParticipant.mStoichiometry;
                while (--stoic >= 0) {
                    if (!reacParticipant.mDynamic) {
                        sb.append("$");
                    }
                    sb.append(reacParticipant.mSpecies.getName());
                    if (stoic <= 0 && !spIter.hasNext()) continue;
                    sb.append(" + ");
                }
            }
            sb.append(" -> ");
            spIter = products.keySet().iterator();
            while (spIter.hasNext()) {
                speciesName = (String)spIter.next();
                reacParticipant = (ReactionParticipant)products.get(speciesName);
                stoic = reacParticipant.mStoichiometry;
                while (--stoic >= 0) {
                    sb.append(reacParticipant.mSpecies.getName());
                    if (stoic <= 0 && !spIter.hasNext()) continue;
                    sb.append(" + ");
                }
            }
            sb.append(", " + this.printValue(reaction));
            int numSteps = reaction.getNumSteps();
            if (numSteps > 1) {
                sb.append(", steps: " + numSteps);
            } else {
                double delay = reaction.getDelay();
                if (delay > 0.0) {
                    sb.append(", delay: " + delay);
                }
            }
            sb.append(";\n");
            this.mSymbolPrinter.setLocalSymbolsAndReactionName(null, null);
        }
        pOutputWriter.println(sb.toString());
        pOutputWriter.flush();
    }

    private String printValue(SymbolValue pSymbolValue) throws DataNotFoundException {
        Value value = pSymbolValue.getValue();
        String retStr = null;
        if (value.isExpression()) {
            return "[" + value.getExpressionString(this.mSymbolPrinter) + "]";
        }
        retStr = Double.toString(value.getValue());
        return retStr;
    }

    private String translateSymbolName(String pSymbolName) {
        return pSymbolName.replaceAll("::", "___");
    }

    public String getFileRegex() {
        return ".*";
    }

    class CMDLSymbolPrinter
    implements Expression.SymbolPrinter {
        private String mReactionName = null;
        private HashSet mLocalSymbols = null;
        private HashMap mSymbolsMap;
        private SymbolEvaluationPostProcessor mSymbolEvaluationPostProcessor;

        public CMDLSymbolPrinter(HashMap pSymbolsMap) {
            this.mSymbolsMap = pSymbolsMap;
            this.mSymbolEvaluationPostProcessor = null;
        }

        public void setSymbolEvaluationPostProcessor(SymbolEvaluationPostProcessor pSymbolEvaluationPostProcessor) {
            this.mSymbolEvaluationPostProcessor = pSymbolEvaluationPostProcessor;
        }

        public String printSymbol(Symbol pSymbol) throws DataNotFoundException {
            String symbolName = pSymbol.getName();
            SymbolValue cfr_ignored_0 = (SymbolValue)this.mSymbolsMap.get(symbolName);
            String translatedSymbolName = null;
            if (this.mLocalSymbols != null && this.mReactionName != null && this.mLocalSymbols.contains(symbolName)) {
                translatedSymbolName = String.valueOf(this.mReactionName) + "___" + symbolName;
            }
            if (translatedSymbolName == null) {
                translatedSymbolName = this.mSymbolEvaluationPostProcessor != null ? this.mSymbolEvaluationPostProcessor.modifySymbol(pSymbol) : symbolName;
            }
            return ModelExporterCommandLanguage.this.translateSymbolName(translatedSymbolName);
        }

        public void setLocalSymbolsAndReactionName(HashSet pLocalSymbols, String pReactionName) {
            this.mLocalSymbols = pLocalSymbols;
            this.mReactionName = pReactionName;
        }
    }
}

