/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.systemsbiology.chem.Compartment;
import org.systemsbiology.chem.IModelExporter;
import org.systemsbiology.chem.Model;
import org.systemsbiology.chem.ModelExporterException;
import org.systemsbiology.chem.Parameter;
import org.systemsbiology.chem.Reaction;
import org.systemsbiology.chem.ReactionParticipant;
import org.systemsbiology.chem.Species;
import org.systemsbiology.math.SymbolValue;
import org.systemsbiology.math.Value;
import org.systemsbiology.util.DataNotFoundException;
import org.systemsbiology.util.IAliasableClass;

public class ModelExporterOrrellColumnFormat
implements IModelExporter,
IAliasableClass {
    public static final String CLASS_ALIAS = "orrell-column-format";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void export(Model pModel, PrintWriter pOutputWriter) throws IllegalArgumentException, DataNotFoundException, IllegalStateException, UnsupportedOperationException, ModelExporterException {
        Collection symbols = pModel.getSymbols();
        Iterator symbolsIter = symbols.iterator();
        LinkedList<Compartment> compartmentsList = new LinkedList<Compartment>();
        ArrayList<Species> speciesList = new ArrayList<Species>();
        while (symbolsIter.hasNext()) {
            SymbolValue symbolValue = (SymbolValue)symbolsIter.next();
            if (symbolValue instanceof Compartment) {
                compartmentsList.add((Compartment)symbolValue);
                continue;
            }
            if (!(symbolValue instanceof Species)) continue;
            speciesList.add((Species)symbolValue);
        }
        Collections.sort(compartmentsList);
        Collections.sort(speciesList);
        for (Compartment compartment : compartmentsList) {
            compartment.getName();
            Value volumeValueObj = compartment.getValue();
            if (volumeValueObj.isExpression()) {
                throw new UnsupportedOperationException("cannot export to SBML a model that has a compartment with a custom expression for the compartment volume");
            }
            double volumeLiters = volumeValueObj.getValue();
            new Double(volumeLiters);
        }
        Collection dynamicSymbols = pModel.getDynamicSymbols();
        Iterator dynamicSymbolsIter = dynamicSymbols.iterator();
        HashSet<String> dynamicSymbolNames = new HashSet<String>();
        while (dynamicSymbolsIter.hasNext()) {
            SymbolValue dynamicSymbol = (SymbolValue)dynamicSymbolsIter.next();
            dynamicSymbolNames.add(dynamicSymbol.getSymbol().getName());
        }
        HashMap<String, Integer> speciesHash = new HashMap<String, Integer>();
        int numSpecies = speciesList.size();
        Collection reactionsColl = pModel.getReactions();
        ArrayList reactionsList = new ArrayList(reactionsColl);
        int numReactions = reactionsList.size();
        Collections.sort(reactionsList);
        pOutputWriter.println(String.valueOf(numSpecies) + " " + numReactions);
        pOutputWriter.println("1.0 1.0");
        pOutputWriter.println("1 0.0");
        int ctr = 0;
        while (ctr < numSpecies) {
            Species species = (Species)speciesList.get(ctr);
            String speciesName = species.getName();
            speciesHash.put(speciesName, new Integer(ctr));
            ++ctr;
        }
        symbolsIter = symbols.iterator();
        LinkedList<SymbolValue> parametersList = new LinkedList<SymbolValue>();
        while (symbolsIter.hasNext()) {
            SymbolValue symbolValue = (SymbolValue)symbolsIter.next();
            if (!(symbolValue instanceof Parameter)) continue;
            parametersList.add(symbolValue);
        }
        Collections.sort(parametersList);
        for (Reaction reaction : reactionsList) {
            reaction.getNumSteps();
            String reactionName = reaction.getName();
            int numReactants = reaction.getNumParticipants(ReactionParticipant.Type.REACTANT);
            if (numReactants > 2) {
                throw new ModelExporterException("reaction " + reactionName + " contains more than two reactant species types");
            }
            int numProducts = reaction.getNumParticipants(ReactionParticipant.Type.PRODUCT);
            if (numProducts > 2) {
                throw new ModelExporterException("reaction " + reactionName + " contains more than two product species types");
            }
            Species[] reactantSpecies = new Species[numReactants];
            int[] reactantStoichiometries = new int[numReactants];
            boolean[] reactantDynamic = new boolean[numReactants];
            reaction.constructSpeciesArrays(reactantSpecies, reactantStoichiometries, reactantDynamic, ReactionParticipant.Type.REACTANT);
            Species[] productSpecies = new Species[numProducts];
            int[] productStoichiometries = new int[numProducts];
            boolean[] productDynamic = new boolean[numProducts];
            reaction.constructSpeciesArrays(productSpecies, productStoichiometries, productDynamic, ReactionParticipant.Type.PRODUCT);
            int reactant1 = 0;
            int reactant2 = 0;
            int ctr2 = 0;
            while (ctr2 < numReactants) {
                Species species = reactantSpecies[ctr2];
                String speciesName = species.getName();
                int stoic = reactantStoichiometries[ctr2];
                Integer speciesIndexObj = (Integer)speciesHash.get(speciesName);
                if (speciesIndexObj == null) {
                    throw new ModelExporterException("unknown species name: " + speciesName);
                }
                int speciesIndex = speciesIndexObj + 1;
                if (stoic == 1) {
                    if (reactant1 == 0) {
                        reactant1 = speciesIndex;
                    } else {
                        if (reactant2 != 0) throw new ModelExporterException("too many reactants, for reaction: " + reactionName);
                        reactant2 = speciesIndex;
                    }
                } else {
                    if (stoic != 2) throw new ModelExporterException("reaction " + reactionName + " contains a reactant with a stoichiometry of zero; reactant is: " + speciesName);
                    if (numReactants >= 2) throw new ModelExporterException("reaction " + reactionName + " contains more than two reactant molecules");
                    reactant2 = reactant1 = speciesIndex;
                }
                ++ctr2;
            }
            int product1 = 0;
            int product2 = 0;
            int ctr3 = 0;
            while (ctr3 < numProducts) {
                Species species = productSpecies[ctr3];
                String speciesName = species.getName();
                int stoic = productStoichiometries[ctr3];
                Integer speciesIndexObj = (Integer)speciesHash.get(speciesName);
                if (speciesIndexObj == null) {
                    throw new ModelExporterException("unknown species name: " + speciesName);
                }
                int speciesIndex = speciesIndexObj + 1;
                if (stoic == 1) {
                    if (product1 == 0) {
                        product1 = speciesIndex;
                    } else {
                        if (product2 != 0) throw new ModelExporterException("too many products, for reaction: " + reactionName);
                        product2 = speciesIndex;
                    }
                } else {
                    if (stoic != 2) throw new ModelExporterException("reaction " + reactionName + " contains a product with a stoichiometry of zero; product is: " + speciesName);
                    if (numProducts >= 2) throw new ModelExporterException("reaction " + reactionName + " contains more than two product molecules");
                    product2 = product1 = speciesIndex;
                }
                ++ctr3;
            }
            Value rateValue = reaction.getValue();
            double reactionParameter = 0.0;
            if (rateValue.isExpression()) {
                throw new ModelExporterException("a reaction contains a custom reaction rate expression; reaction is: " + reactionName);
            }
            reactionParameter = rateValue.getValue();
            pOutputWriter.println(String.valueOf(reactant1) + " " + reactant2 + " " + product1 + " " + product2 + " " + reactionParameter + " 0");
        }
        pOutputWriter.println("");
        int ctr4 = 0;
        while (ctr4 < numSpecies) {
            Species species = (Species)speciesList.get(ctr4);
            String speciesName = species.getName();
            Integer speciesIndexObj = (Integer)speciesHash.get(speciesName);
            if (speciesIndexObj == null) {
                throw new ModelExporterException("unknown species: " + speciesName);
            }
            int speciesIndex = speciesIndexObj + 1;
            pOutputWriter.println(String.valueOf(speciesIndex) + " " + speciesName);
            ++ctr4;
        }
        pOutputWriter.flush();
    }

    public String getFileRegex() {
        return ".*\\.txt$";
    }
}

