/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem;

import org.systemsbiology.math.Expression;
import org.systemsbiology.math.SymbolValue;
import org.systemsbiology.math.Value;

public final class Parameter
extends SymbolValue {
    private String mName;

    public String getSymbolName() {
        return this.mName;
    }

    public String getName() {
        return this.mName;
    }

    public Parameter(String pName, Expression pValue) {
        super(pName);
        this.setValue(new Value(pValue));
        this.mName = pName;
    }

    public Parameter(String pName) {
        super(pName);
        this.mName = pName;
    }

    public Parameter(String pName, double pValue) {
        super(pName);
        this.setValue(new Value(pValue));
        this.mName = pName;
    }

    public Parameter(SymbolValue pSymbolValue) {
        super(pSymbolValue);
        this.mName = pSymbolValue.getSymbol().getName();
    }

    public void setValue(Expression pValue) {
        this.setValue(new Value(pValue));
    }

    public void setValue(double pValue) {
        this.setValue(new Value(pValue));
    }

    public Object clone() {
        Parameter newParam = new Parameter(this.mName);
        newParam.setValue((Value)this.mValue.clone());
        return newParam;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Parameter: ");
        sb.append(this.getName());
        sb.append(" [Value: ");
        sb.append(this.getValue().toString());
        sb.append("]");
        return sb.toString();
    }
}

