/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.systemsbiology.chem.Parameter;
import org.systemsbiology.chem.ReactionParticipant;
import org.systemsbiology.chem.Species;
import org.systemsbiology.math.Expression;
import org.systemsbiology.math.ReservedSymbolMapper;
import org.systemsbiology.math.Symbol;
import org.systemsbiology.math.SymbolValue;
import org.systemsbiology.math.Value;
import org.systemsbiology.util.DataNotFoundException;

public final class Reaction
extends SymbolValue {
    private final String mName;
    private HashMap mReactantsMap;
    private HashMap mProductsMap;
    private HashMap mLocalSymbolsValuesMap;
    private int mNumSteps;
    private double mDelay;
    private static final boolean DEFAULT_REACTANT_DYNAMIC = true;

    public Object clone() {
        Reaction reaction = new Reaction(this.mName);
        reaction.setRate((Value)this.getRate().clone());
        reaction.mReactantsMap = this.mReactantsMap;
        reaction.mProductsMap = this.mProductsMap;
        reaction.mLocalSymbolsValuesMap = this.mLocalSymbolsValuesMap;
        reaction.mNumSteps = this.mNumSteps;
        reaction.mDelay = this.mDelay;
        return reaction;
    }

    public Reaction(String pName) {
        super(pName);
        this.mName = pName;
        this.mReactantsMap = new HashMap();
        this.mProductsMap = new HashMap();
        this.mLocalSymbolsValuesMap = new HashMap();
        this.mNumSteps = 1;
        this.mDelay = 0.0;
    }

    boolean containsReactant(String pReactantName) {
        return this.mReactantsMap.get(pReactantName) != null;
    }

    public Collection getParameters() {
        return this.mLocalSymbolsValuesMap.values();
    }

    public void addParameter(Parameter pParameter) {
        pParameter.addSymbolToMap(this.mLocalSymbolsValuesMap, pParameter.getSymbolName());
    }

    public boolean hasLocalSymbols() {
        return this.mLocalSymbolsValuesMap.keySet().size() > 0;
    }

    public void setNumSteps(int pNumSteps) {
        if (pNumSteps < 1) {
            throw new IllegalArgumentException("the number of steps for a reaction must be greater than or equal to one");
        }
        this.mNumSteps = pNumSteps;
    }

    public double getDelay() {
        return this.mDelay;
    }

    public void setDelay(double pDelay) {
        if (pDelay < 0.0) {
            throw new IllegalArgumentException("the delay time is invalid");
        }
        this.mDelay = pDelay;
    }

    public int getNumSteps() {
        return this.mNumSteps;
    }

    public int getNumParticipants(ReactionParticipant.Type pParticipantType) {
        int numParticipants = 0;
        numParticipants = pParticipantType.equals(ReactionParticipant.Type.REACTANT) ? this.mReactantsMap.values().size() : this.mProductsMap.values().size();
        return numParticipants;
    }

    static Species getIndexedSpecies(Species pSpecies, HashMap pSymbolMap, Species[] pDynamicSymbolValues, SymbolValue[] pNonDynamicSymbolValues) throws IllegalStateException {
        String speciesName = pSpecies.getName();
        Symbol extSymbol = (Symbol)pSymbolMap.get(speciesName);
        int extSpeciesIndex = extSymbol.getArrayIndex();
        Species species = null;
        species = extSymbol.getDoubleArray() != null ? pDynamicSymbolValues[extSpeciesIndex] : (Species)pNonDynamicSymbolValues[extSpeciesIndex];
        return species;
    }

    public void constructSpeciesArrays(Species[] pSpeciesArray, int[] pStoichiometryArray, boolean[] pDynamicArray, ReactionParticipant.Type pParticipantType) {
        this.constructSpeciesArrays(pSpeciesArray, pStoichiometryArray, pDynamicArray, null, null, null, pParticipantType);
    }

    void constructSpeciesArrays(Species[] pSpeciesArray, int[] pStoichiometryArray, boolean[] pDynamicArray, Species[] pDynamicSymbolValues, SymbolValue[] pNonDynamicSymbolValues, HashMap pSymbolMap, ReactionParticipant.Type pParticipantType) {
        Collection speciesColl = null;
        speciesColl = pParticipantType.equals(ReactionParticipant.Type.REACTANT) ? this.mReactantsMap.values() : this.mProductsMap.values();
        int numSpecies = speciesColl.size();
        if (pSpeciesArray.length < numSpecies) {
            throw new IllegalArgumentException("insufficient array size");
        }
        if (pStoichiometryArray.length < numSpecies) {
            throw new IllegalArgumentException("insufficient array size");
        }
        Iterator speciesIter = speciesColl.iterator();
        int reactantCtr = 0;
        while (speciesIter.hasNext()) {
            int stoic;
            ReactionParticipant participant = (ReactionParticipant)speciesIter.next();
            Species species = participant.mSpecies;
            if (pSymbolMap != null) {
                species = Reaction.getIndexedSpecies(species, pSymbolMap, pDynamicSymbolValues, pNonDynamicSymbolValues);
            }
            pSpeciesArray[reactantCtr] = species;
            pDynamicArray[reactantCtr] = participant.mDynamic;
            pStoichiometryArray[reactantCtr] = stoic = participant.mStoichiometry;
            ++reactantCtr;
        }
    }

    public int getNumReactants() {
        return this.mReactantsMap.values().size();
    }

    public int getNumProducts() {
        return this.mProductsMap.values().size();
    }

    public int getNumLocalSymbols() {
        return this.mLocalSymbolsValuesMap.values().size();
    }

    SymbolValue[] getLocalSymbolValues() {
        int numSymbolValues = this.mLocalSymbolsValuesMap.size();
        SymbolValue[] retArray = new SymbolValue[numSymbolValues];
        SymbolValue[] dummyArray = new SymbolValue[]{};
        SymbolValue[] origArray = this.mLocalSymbolsValuesMap.values().toArray(dummyArray);
        int j = 0;
        while (j < numSymbolValues) {
            retArray[j] = (SymbolValue)origArray[j].clone();
            ++j;
        }
        return retArray;
    }

    private void addSymbolsToGlobalSymbolsMap(HashMap pReactionSpecies, HashMap pSymbols, ReservedSymbolMapper pReservedSymbolMapper) {
        Collection speciesCollection = pReactionSpecies.values();
        for (ReactionParticipant reactionParticipant : speciesCollection) {
            Species species = reactionParticipant.getSpecies();
            String speciesSymbolName = species.getSymbol().getName();
            species.addSymbolToMap(pSymbols, speciesSymbolName, pReservedSymbolMapper);
        }
    }

    HashMap getReactantsMap() {
        return this.mReactantsMap;
    }

    HashMap getProductsMap() {
        return this.mProductsMap;
    }

    public boolean equals(Reaction pReaction) {
        return this.mName.equals(pReaction.mName) && this.mReactantsMap.equals(pReaction.mReactantsMap) && this.mProductsMap.equals(pReaction.mProductsMap) && super.equals(pReaction);
    }

    public String getName() {
        return this.mName;
    }

    Value getRate() {
        return this.getValue();
    }

    public void setRate(Value pRate) {
        this.setValue(pRate);
    }

    public void setRate(double pRate) {
        this.setRate(new Value(pRate));
    }

    public void setRate(Expression pRate) {
        this.setRate(new Value(pRate));
    }

    public void addReactionParticipantToMap(ReactionParticipant pReactionParticipant, HashMap pMap) throws IllegalArgumentException {
        Species species = pReactionParticipant.getSpecies();
        if (species.getValue() == null) {
            throw new IllegalArgumentException("species has no initial value defined");
        }
        String speciesSymbolName = species.getName();
        ReactionParticipant reactionParticipant = (ReactionParticipant)pMap.get(speciesSymbolName);
        if (reactionParticipant != null) {
            throw new IllegalStateException("Species is already defined for this reaction.  Species name: " + speciesSymbolName);
        }
        pMap.put(speciesSymbolName, pReactionParticipant);
    }

    void addReactant(ReactionParticipant pReactionParticipant) throws IllegalStateException {
        this.addReactionParticipantToMap(pReactionParticipant, this.mReactantsMap);
    }

    public void addReactant(Species pSpecies, int pStoichiometry, boolean pDynamic) throws IllegalStateException {
        this.addReactant(new ReactionParticipant(pSpecies, pStoichiometry, pDynamic));
    }

    public void addReactant(Species pSpecies, int pStoichiometry) throws IllegalStateException {
        this.addReactant(new ReactionParticipant(pSpecies, pStoichiometry, true));
    }

    void addProduct(ReactionParticipant pReactionParticipant) throws IllegalStateException {
        this.addReactionParticipantToMap(pReactionParticipant, this.mProductsMap);
    }

    public void addProduct(Species pSpecies, int pStoichiometry) throws IllegalStateException {
        boolean dynamic = true;
        this.addProduct(new ReactionParticipant(pSpecies, pStoichiometry, dynamic));
    }

    public void addProduct(Species pSpecies, int pStoichiometry, boolean pDynamic) throws IllegalStateException {
        this.addProduct(new ReactionParticipant(pSpecies, pStoichiometry, pDynamic));
    }

    public void addSpecies(Species pSpecies, int pStoichiometry, boolean pDynamic, ReactionParticipant.Type pParticipantType) throws IllegalArgumentException {
        if (pParticipantType.equals(ReactionParticipant.Type.REACTANT)) {
            this.addReactant(pSpecies, pStoichiometry, pDynamic);
        } else if (pParticipantType.equals(ReactionParticipant.Type.PRODUCT)) {
            this.addProduct(pSpecies, pStoichiometry, pDynamic);
        } else {
            throw new IllegalArgumentException("unknown reaction participant type: " + pParticipantType);
        }
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("Reaction: ");
        Iterator reactantsIter = this.mReactantsMap.keySet().iterator();
        sb.append(String.valueOf(this.getName()) + ", ");
        while (reactantsIter.hasNext()) {
            String reactant = (String)reactantsIter.next();
            ReactionParticipant participant = (ReactionParticipant)this.mReactantsMap.get(reactant);
            int stoic = participant.mStoichiometry;
            boolean dynamic = participant.mDynamic;
            i = 0;
            while (i < stoic) {
                if (!dynamic) {
                    sb.append("$");
                }
                sb.append(reactant);
                if (i < stoic - 1) {
                    sb.append(" + ");
                }
                ++i;
            }
            if (!reactantsIter.hasNext()) continue;
            sb.append(" + ");
        }
        sb.append(" -> ");
        Iterator productsIter = this.getProductsMap().keySet().iterator();
        while (productsIter.hasNext()) {
            String product = (String)productsIter.next();
            ReactionParticipant participant = (ReactionParticipant)this.mProductsMap.get(product);
            int stoic = participant.mStoichiometry;
            i = 0;
            while (i < stoic) {
                sb.append(product);
                if (i < stoic - 1) {
                    sb.append(" + ");
                }
                ++i;
            }
            if (!productsIter.hasNext()) continue;
            sb.append(" + ");
        }
        sb.append(", ");
        sb.append(" [Rate: ");
        sb.append(this.getRate().toString());
        sb.append("]");
        return sb.toString();
    }

    private void addSymbolsFromReactionSpeciesMapToGlobalSymbolMap(HashMap pReactionSpeciesMap, HashMap pSymbolMap, ReservedSymbolMapper pReservedSymbolMapper) {
        Collection speciesCollection = pReactionSpeciesMap.values();
        for (ReactionParticipant reactionParticipant : speciesCollection) {
            Species species = reactionParticipant.getSpecies();
            species.addSymbolsToGlobalSymbolMap(pSymbolMap, pReservedSymbolMapper);
        }
    }

    void addSymbolsToGlobalSymbolMap(HashMap pSymbolMap, ReservedSymbolMapper pReservedSymbolMapper) {
        this.addSymbolToMap(pSymbolMap, this.mName, pReservedSymbolMapper);
        this.addSymbolsFromReactionSpeciesMapToGlobalSymbolMap(this.getReactantsMap(), pSymbolMap, pReservedSymbolMapper);
        this.addSymbolsFromReactionSpeciesMapToGlobalSymbolMap(this.getProductsMap(), pSymbolMap, pReservedSymbolMapper);
    }

    private void addDynamicSpeciesFromReactionSpeciesMapToGlobalSpeciesMap(HashMap pReactionSpecies, HashMap pDynamicSpecies, ReservedSymbolMapper pReservedSymbolMapper) {
        Collection speciesCollection = pReactionSpecies.values();
        for (ReactionParticipant reactionParticipant : speciesCollection) {
            if (!reactionParticipant.getDynamic()) continue;
            Species species = reactionParticipant.getSpecies();
            String speciesSymbolName = species.getSymbol().getName();
            species.addSymbolToMap(pDynamicSpecies, speciesSymbolName, pReservedSymbolMapper);
        }
    }

    void addDynamicSpeciesToGlobalSpeciesMap(HashMap pDynamicSpecies, ReservedSymbolMapper pReservedSymbolMapper) {
        this.addDynamicSpeciesFromReactionSpeciesMapToGlobalSpeciesMap(this.getReactantsMap(), pDynamicSpecies, pReservedSymbolMapper);
        this.addDynamicSpeciesFromReactionSpeciesMapToGlobalSpeciesMap(this.getProductsMap(), pDynamicSpecies, pReservedSymbolMapper);
    }

    Expression getRateExpression() throws DataNotFoundException {
        Expression retVal = null;
        Value rateValue = this.getRate();
        if (rateValue.isExpression()) {
            retVal = rateValue.getExpressionValue();
        } else {
            Iterator reactantsIter = this.mReactantsMap.values().iterator();
            StringBuffer expBuf = new StringBuffer();
            boolean firstReactant = true;
            while (reactantsIter.hasNext()) {
                ReactionParticipant participant = (ReactionParticipant)reactantsIter.next();
                Species species = participant.mSpecies;
                int stoic = participant.mStoichiometry;
                String speciesName = species.getName();
                if (!firstReactant) {
                    expBuf.append("*");
                } else {
                    firstReactant = false;
                }
                if (stoic > 1) {
                    expBuf.append(String.valueOf(speciesName) + "^" + stoic);
                    continue;
                }
                expBuf.append(speciesName);
            }
            double rateVal = rateValue.getValue();
            Expression rateExp = new Expression(rateVal);
            retVal = expBuf.length() > 0 ? Expression.multiply(rateExp, new Expression(expBuf.toString())) : rateExp;
        }
        return retVal;
    }
}

