/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem;

import org.systemsbiology.chem.Species;

public final class ReactionParticipant
implements Comparable {
    final Species mSpecies;
    final int mStoichiometry;
    final boolean mDynamic;

    public ReactionParticipant(Species pSpecies, int pStoichiometry, boolean pDynamic) throws IllegalArgumentException {
        if (pSpecies.getValue().isExpression() && pDynamic) {
            throw new IllegalArgumentException("attempt to use a species with a population expression, as a dynamic participant of a reaction");
        }
        if (pStoichiometry < 1) {
            throw new IllegalArgumentException("illegal stoichiometry value: " + pStoichiometry);
        }
        this.mStoichiometry = pStoichiometry;
        this.mSpecies = pSpecies;
        this.mDynamic = pDynamic;
    }

    public int getStoichiometry() {
        return this.mStoichiometry;
    }

    public boolean getDynamic() {
        return this.mDynamic;
    }

    public Species getSpecies() {
        return this.mSpecies;
    }

    public boolean equals(ReactionParticipant pReactionParticipant) {
        return this.mSpecies.equals(pReactionParticipant.mSpecies) && this.mStoichiometry == pReactionParticipant.mStoichiometry && this.mDynamic == pReactionParticipant.mDynamic;
    }

    public int compareTo(Object pReactionParticipant) {
        return this.mSpecies.getName().compareTo(((ReactionParticipant)pReactionParticipant).mSpecies.getName());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ReactionParticipant[");
        sb.append(this.mSpecies.toString());
        sb.append(", Stoichiometry: ");
        sb.append(this.mStoichiometry);
        sb.append(", Dynamic: ");
        sb.append(this.mDynamic);
        sb.append("]");
        return sb.toString();
    }

    public static final class Type {
        private final String mName;
        public static final Type REACTANT = new Type("reactant");
        public static final Type PRODUCT = new Type("product");

        private Type(String pName) {
            this.mName = pName;
        }

        public String toString() {
            return this.mName;
        }
    }
}

