/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem;

import java.util.Collection;
import java.util.HashSet;
import org.systemsbiology.chem.SymbolEvaluatorChem;
import org.systemsbiology.math.ReservedSymbolMapper;
import org.systemsbiology.math.Symbol;
import org.systemsbiology.math.SymbolEvaluator;
import org.systemsbiology.util.DataNotFoundException;

public final class ReservedSymbolMapperChemCommandLanguage
extends ReservedSymbolMapper {
    public static final String SYMBOL_TIME = "time";
    public static final String SYMBOL_AVOGADRO = "Navo";
    private static final HashSet sReservedSymbolNames = new HashSet();

    static {
        ReservedSymbolMapperChemCommandLanguage.getReservedSymbolNamesStatic(sReservedSymbolNames);
    }

    private static void getReservedSymbolNamesStatic(HashSet pReservedSymbolNames) {
        pReservedSymbolNames.add(SYMBOL_TIME);
        pReservedSymbolNames.add(SYMBOL_AVOGADRO);
    }

    public Collection getReservedSymbolNames() {
        return new HashSet(sReservedSymbolNames);
    }

    public static boolean isReservedSymbol(String pSymbolName) {
        return sReservedSymbolNames.contains(pSymbolName);
    }

    public boolean isReservedSymbol(Symbol pSymbol) {
        return sReservedSymbolNames.contains(pSymbol.getName());
    }

    public double getReservedSymbolValue(Symbol pSymbol, SymbolEvaluator pSymbolEvaluator) throws DataNotFoundException {
        String symbolName = pSymbol.getName();
        if (symbolName.equals(SYMBOL_AVOGADRO)) {
            return 6.02214199E23;
        }
        if (symbolName.equals(SYMBOL_TIME)) {
            return ((SymbolEvaluatorChem)pSymbolEvaluator).getTime();
        }
        throw new DataNotFoundException("symbol is not a reserved symbol: \"" + symbolName + "\"");
    }
}

