/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem;

import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Vector;
import org.systemsbiology.chem.SimulatorParameters;

public final class SimulationResults {
    private String mSimulatorAlias = null;
    private double mStartTime;
    private double mEndTime;
    private SimulatorParameters mSimulatorParameters = null;
    private String[] mResultsSymbolNames = null;
    private double[] mResultsTimeValues = null;
    private Object[] mResultsSymbolValues = null;
    private double[] mResultsFinalSymbolFluctuations = null;
    private Date mResultsDateTime = new Date(System.currentTimeMillis());
    private String mModelName = null;
    private Object[] mStatCollector;
    private LinkedList mDeadlockList = null;
    private double maxY = -1.0;
    private String[] reactionNames;
    private double[] reactionCounts;
    private double[] reactionTimes;
    private static final int LENGTH_ABBREV_MODEL_NAME = 10;

    public void setModelName(String pModelName) {
        this.mModelName = pModelName;
    }

    public String getModelName() {
        return this.mModelName;
    }

    public double[] getResultsFinalSymbolFluctuations() {
        return this.mResultsFinalSymbolFluctuations;
    }

    public void setResultsFinalSymbolFluctuations(double[] pResultsFinalSymbolFluctuations) {
        this.mResultsFinalSymbolFluctuations = pResultsFinalSymbolFluctuations;
    }

    public String getSimulatorAlias() {
        return this.mSimulatorAlias;
    }

    public double getStartTime() {
        return this.mStartTime;
    }

    public double getEndTime() {
        return this.mEndTime;
    }

    public SimulatorParameters getSimulatorParameters() {
        return this.mSimulatorParameters;
    }

    public String[] getResultsSymbolNames() {
        return this.mResultsSymbolNames;
    }

    public double[] getResultsTimeValues() {
        return this.mResultsTimeValues;
    }

    public Object[] getResultsSymbolValues() {
        return this.mResultsSymbolValues;
    }

    public void setSimulatorAlias(String pSimulatorAlias) {
        this.mSimulatorAlias = pSimulatorAlias;
    }

    public void setStartTime(double pStartTime) {
        this.mStartTime = pStartTime;
    }

    public void setEndTime(double pEndTime) {
        this.mEndTime = pEndTime;
    }

    public void setSimulatorParameters(SimulatorParameters pSimulatorParameters) {
        this.mSimulatorParameters = pSimulatorParameters;
    }

    public void setResultsSymbolNames(String[] pResultsSymbolNames) {
        this.mResultsSymbolNames = pResultsSymbolNames;
    }

    public void setResultsTimeValues(double[] pResultsTimeValues) {
        this.mResultsTimeValues = pResultsTimeValues;
    }

    public void setResultsSymbolValues(Object[] pResultsSymbolValues) {
        this.mResultsSymbolValues = pResultsSymbolValues;
    }

    public Date getResultsDateTime() {
        return this.mResultsDateTime;
    }

    private static String generateSimulationResultsLabel(String pModelName, String pSimulatorAlias, Date pResultsDateTime) {
        DateFormat df = DateFormat.getTimeInstance(3, Locale.FRANCE);
        String timeString = df.format(pResultsDateTime);
        df = DateFormat.getDateInstance(3);
        String dateString = df.format(pResultsDateTime);
        String abbrevModelName = pModelName;
        if (pModelName.length() > 10) {
            abbrevModelName = abbrevModelName.substring(0, 9);
        }
        StringBuffer retStr = new StringBuffer();
        retStr.append("[" + dateString + " " + timeString + "] ");
        retStr.append("[" + abbrevModelName + "] ");
        retStr.append("[" + pSimulatorAlias + "]");
        return retStr.toString();
    }

    public String createLabel() {
        return SimulationResults.generateSimulationResultsLabel(this.mModelName, this.mSimulatorAlias, this.mResultsDateTime);
    }

    public String toString() {
        return this.createLabel();
    }

    public int getTruncatePoint() {
        int truncatePoint = 0;
        int j = 0;
        while (j < this.mResultsTimeValues.length - 1) {
            double[] values = (double[])this.mResultsSymbolValues[j];
            double[] nextValues = (double[])this.mResultsSymbolValues[j + 1];
            int i = 0;
            while (i < values.length) {
                double dif = Math.abs((nextValues[i] - values[i]) / this.getMaxY());
                if (dif > 3.0E-4) {
                    truncatePoint = j + 1;
                    break;
                }
                ++i;
            }
            ++j;
        }
        return truncatePoint;
    }

    public double getMaxY() {
        if (this.maxY == -1.0) {
            int j = 0;
            while (j < this.mResultsTimeValues.length) {
                double[] values = (double[])this.mResultsSymbolValues[j];
                int i = 0;
                while (i < values.length) {
                    if (values[i] > this.maxY) {
                        this.maxY = values[i];
                    }
                    ++i;
                }
                ++j;
            }
        }
        return this.maxY;
    }

    public Vector getSymbolNameSets() {
        Vector<String[]> toReturn = new Vector<String[]>();
        toReturn.add(this.mResultsSymbolNames);
        return toReturn;
    }

    public void setStatCollector(Object[] pStatCollector) {
        this.mStatCollector = pStatCollector;
    }

    public Object[] getStatCollector() {
        return this.mStatCollector;
    }

    public String[] getReactionNames() {
        return this.reactionNames;
    }

    public double[] getReactionCounts() {
        return this.reactionCounts;
    }

    public double[] getReactionTimes() {
        return this.reactionTimes;
    }

    public void setReactionNames(String[] pReactionNames) {
        this.reactionNames = pReactionNames;
    }

    public void setReactionCounts(double[] pReactionCounts) {
        this.reactionCounts = pReactionCounts;
    }

    public void setReactionTimes(double[] pReactionTimes) {
        this.reactionTimes = pReactionTimes;
    }

    public void setDeadlockList(LinkedList pDeadlockList) {
        this.mDeadlockList = pDeadlockList;
    }

    public LinkedList getDeadlockList() {
        return this.mDeadlockList;
    }
}

