/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem;

import java.util.LinkedList;
import java.util.Vector;
import org.systemsbiology.chem.SimulationResultsSet;
import org.systemsbiology.chem.SimulatorParameters;
import org.systemsbiology.chem.tp.GraphMergeException;

public class SimulationResultsSetImp
implements SimulationResultsSet {
    private Vector mResultsSymbolNames;
    private double[] mResultsTimeValues;
    private Object[] mResultsSymbolValues;
    double maxY = -1.0;

    public SimulationResultsSetImp(SimulationResultsSet setOne, SimulationResultsSet setTwo) {
    }

    public SimulationResultsSetImp() {
        this.mResultsSymbolNames = new Vector();
        this.mResultsTimeValues = new double[0];
        this.mResultsSymbolValues = new Object[0];
    }

    public SimulationResultsSetImp(SimulationResultsSet set) {
        this.mResultsSymbolNames = set.getSymbolNameSets();
        this.mResultsTimeValues = set.getResultsTimeValues();
        this.mResultsSymbolValues = set.getResultsSymbolValues();
    }

    public String[] getResultsSymbolNames() {
        int count = 0;
        for (String[] temp : this.mResultsSymbolNames) {
            count += temp.length;
        }
        String[] toReturn = new String[count];
        count = 0;
        for (String[] temp : this.mResultsSymbolNames) {
            int j = 0;
            while (j < temp.length) {
                toReturn[count] = temp[j];
                ++count;
                ++j;
            }
        }
        return toReturn;
    }

    public double[] getResultsTimeValues() {
        return this.mResultsTimeValues;
    }

    public Object[] getResultsSymbolValues() {
        return this.mResultsSymbolValues;
    }

    private void merge(SimulationResultsSet set) throws GraphMergeException {
        if (this.mResultsSymbolNames.size() == 0) {
            this.mResultsSymbolNames = set.getSymbolNameSets();
            this.mResultsTimeValues = set.getResultsTimeValues();
            this.mResultsSymbolValues = set.getResultsSymbolValues();
            return;
        }
        if (set.getResultsTimeValues().length != this.getResultsTimeValues().length) {
            throw new GraphMergeException("Cannot merge graphs with different numbers of sample points");
        }
        if (set.getResultsTimeValues()[0] != this.getResultsTimeValues()[0] || set.getResultsTimeValues()[set.getResultsTimeValues().length - 1] != this.getResultsTimeValues()[set.getResultsTimeValues().length - 1]) {
            throw new GraphMergeException("Cannot merge graphs with data plotted over different time periods");
        }
        set.getResultsTimeValues();
        Object[] setSymbolValues = set.getResultsSymbolValues();
        this.mResultsSymbolNames.addAll(set.getSymbolNameSets());
        Object[] tempSymbolValues = new Object[setSymbolValues.length];
        int i = 0;
        while (i < tempSymbolValues.length) {
            double[] currentValues = (double[])this.mResultsSymbolValues[i];
            double[] setValues = (double[])setSymbolValues[i];
            double[] newValues = new double[currentValues.length + setValues.length];
            int j = 0;
            while (j < currentValues.length) {
                newValues[j] = currentValues[j];
                ++j;
            }
            j = 0;
            while (j < setValues.length) {
                newValues[j + currentValues.length] = setValues[j];
                ++j;
            }
            tempSymbolValues[i] = newValues;
            ++i;
        }
        this.mResultsSymbolValues = tempSymbolValues;
    }

    public void addResultsSet(SimulationResultsSet set) throws GraphMergeException {
        this.merge(set);
    }

    public int getTruncatePoint() {
        int truncatePoint = 0;
        int j = 0;
        while (j < this.mResultsTimeValues.length - 1) {
            double[] values = (double[])this.mResultsSymbolValues[j];
            double[] nextValues = (double[])this.mResultsSymbolValues[j + 1];
            int i = 0;
            while (i < values.length) {
                double dif = Math.abs((nextValues[i] - values[i]) / this.getMaxY());
                if (dif > 3.0E-4) {
                    truncatePoint = j + 1;
                    break;
                }
                ++i;
            }
            ++j;
        }
        return truncatePoint;
    }

    public double getMaxY() {
        if (this.maxY == -1.0) {
            int j = 0;
            while (j < this.mResultsTimeValues.length) {
                double[] values = (double[])this.mResultsSymbolValues[j];
                int i = 0;
                while (i < values.length) {
                    if (values[i] > this.maxY) {
                        this.maxY = values[i];
                    }
                    ++i;
                }
                ++j;
            }
        }
        return this.maxY;
    }

    public Vector getSymbolNameSets() {
        return this.mResultsSymbolNames;
    }

    public SimulatorParameters getSimulatorParameters() {
        return null;
    }

    public Object[] getStatCollector() {
        return null;
    }

    public Object[] getReactionFireCounter() {
        return null;
    }

    public LinkedList getDeadlockList() {
        return null;
    }
}

