/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem;

import java.util.ArrayList;
import java.util.HashMap;
import org.systemsbiology.chem.Compartment;
import org.systemsbiology.chem.DelayedReactionSolver;
import org.systemsbiology.chem.Model;
import org.systemsbiology.chem.Reaction;
import org.systemsbiology.chem.ReactionParticipant;
import org.systemsbiology.chem.SimulationController;
import org.systemsbiology.chem.SimulationProgressReporter;
import org.systemsbiology.chem.SimulationResults;
import org.systemsbiology.chem.SimulatorParameters;
import org.systemsbiology.chem.Species;
import org.systemsbiology.chem.SymbolEvaluatorChem;
import org.systemsbiology.math.DoubleVector;
import org.systemsbiology.math.Expression;
import org.systemsbiology.math.MutableInteger;
import org.systemsbiology.math.ReservedSymbolMapper;
import org.systemsbiology.math.Symbol;
import org.systemsbiology.math.SymbolEvaluationPostProcessor;
import org.systemsbiology.math.SymbolValue;
import org.systemsbiology.math.Value;
import org.systemsbiology.util.DataNotFoundException;
import umontreal.iro.lecuyer.stat.TallyStore;

public abstract class Simulator {
    private static final int MIN_NUM_REACTION_STEPS_FOR_USING_DELAY_FUNCTION = 15;
    protected static final long DEFAULT_MIN_NUM_MILLISECONDS_FOR_UPDATE = 1000L;
    protected static final int NULL_REACTION = -1;
    private static final long MAX_POPULATION_FOR_COMBINATORIC_EFFECTS = 100000L;
    private static final boolean DEFAULT_USE_EXPRESSION_VALUE_CACHING = true;
    protected String mModelName;
    protected Value[] mNonDynamicSymbolValues;
    protected Value[] mNonDynamicSymbolExpressionValues;
    protected boolean mUseExpressionValueCaching;
    protected SymbolEvaluatorChem mSymbolEvaluator;
    protected HashMap mSymbolMap;
    protected SimulationController mSimulationController;
    protected DelayedReactionSolver[] mDelayedReactionSolvers;
    protected boolean mInitialized;
    protected long mMinNumMillisecondsForUpdate;
    protected SimulationProgressReporter mSimulationProgressReporter;
    protected boolean mIsStochasticSimulator;
    protected Species[] mDynamicSymbols;
    protected double[] mInitialDynamicSymbolValues;
    protected String[] mDynamicSymbolNames;
    protected double[] mDynamicSymbolValues;
    protected Reaction[] mReactions;
    protected Object[] mDynamicSymbolAdjustmentVectors;
    protected double[] mReactionProbabilities;
    protected Object[] mReactionsReactantsSpecies;
    protected Object[] mReactionsReactantsStoichiometries;
    protected Object[] mReactionsReactantsDynamic;
    protected Object[] mReactionsProductsSpecies;
    protected Object[] mReactionsProductsStoichiometries;
    protected Object[] mReactionsProductsDynamic;
    protected HashMap[] mReactionsLocalParamSymbolsMaps;
    protected Value[] mReactionRates;
    protected DelayedReactionSolver[] mReactionsDelayedReactionAssociations;
    protected Symbol[] mReactionSymbols;

    protected boolean hasDelayedReactionSolvers() {
        return this.mDelayedReactionSolvers != null;
    }

    static final void indexSymbolArray(SymbolValue[] pSymbolArray, HashMap pSymbolMap, double[] pDoubleArray, Value[] pValueArray) {
        assert (pDoubleArray == null || pValueArray == null) : "either pDoubleArray or pValueArray must be null";
        int numSymbols = pSymbolArray.length;
        int symbolCtr = 0;
        while (symbolCtr < numSymbols) {
            SymbolValue symbolValue = pSymbolArray[symbolCtr];
            Symbol symbol = symbolValue.getSymbol();
            String symbolName = symbol.getName();
            Value value = symbolValue.getValue();
            assert (symbol.getDoubleArray() == null) : "array not null for new symbol " + symbolName;
            assert (symbol.getValueArray() == null) : "array not null for new symbol " + symbolName;
            assert (-1 == symbol.getArrayIndex()) : "array index not null for new symbol " + symbolName;
            assert (value != null) : "null value object for symbol: " + symbolName;
            pSymbolMap.put(symbolName, symbol);
            if (pDoubleArray != null) {
                symbol.setArray(pDoubleArray);
                pDoubleArray[symbolCtr] = value.getValue();
            } else {
                symbol.setArray(pValueArray);
                pValueArray[symbolCtr] = value;
            }
            symbol.setArrayIndex(symbolCtr);
            ++symbolCtr;
        }
    }

    public final boolean isInitialized() {
        return this.mInitialized;
    }

    public boolean canComputeFluctuations() {
        return true;
    }

    private final void clearDelayedReactionSolvers() {
        int numDelayedReactionSolvers = this.mDelayedReactionSolvers.length;
        int ctr = 0;
        while (ctr < numDelayedReactionSolvers) {
            DelayedReactionSolver solver = this.mDelayedReactionSolvers[ctr];
            solver.clear();
            ++ctr;
        }
    }

    protected final void resizeDelayedReactionSolvers(int pNumHistoryBins) {
        int numDelayedReactionSolvers = this.mDelayedReactionSolvers.length;
        int ctr = 0;
        while (ctr < numDelayedReactionSolvers) {
            DelayedReactionSolver solver = this.mDelayedReactionSolvers[ctr];
            if (pNumHistoryBins != solver.getNumHistoryBins()) {
                solver.setNumHistoryBins(pNumHistoryBins);
            }
            ++ctr;
        }
    }

    protected final void prepareForSimulation(double pStartTime) {
        System.arraycopy(this.mInitialDynamicSymbolValues, 0, this.mDynamicSymbolValues, 0, this.mDynamicSymbolValues.length);
        DoubleVector.zeroElements(this.mReactionProbabilities);
        if (this.mDelayedReactionSolvers != null) {
            this.clearDelayedReactionSolvers();
        }
        if (this.mUseExpressionValueCaching) {
            this.clearExpressionValueCaches();
        }
        this.mSymbolEvaluator.setTime(pStartTime);
        this.mSymbolEvaluator.setLocalSymbolsMap(null);
    }

    private static final void handleDelayedReaction(Reaction pReaction, ArrayList pReactions, int pReactionIndex, ArrayList pDynamicSpecies, ArrayList pDelayedReactionSolvers, MutableInteger pRecursionDepth, boolean pIsStochasticSimulator) {
        String reactionName = pReaction.getName();
        HashMap reactantsMap = pReaction.getReactantsMap();
        if (reactantsMap.size() != 1) {
            throw new IllegalStateException("a multi-step reaction must have excactly one reactant species; reaction is: " + reactionName);
        }
        HashMap productsMap = pReaction.getProductsMap();
        if (productsMap.size() != 1) {
            throw new IllegalStateException("a multi-step reaction must have exactly one product species; reaction is: " + reactionName);
        }
        int numSteps = pReaction.getNumSteps();
        Species reactant = ((ReactionParticipant)reactantsMap.values().iterator().next()).getSpecies();
        Species product = ((ReactionParticipant)productsMap.values().iterator().next()).getSpecies();
        if (!reactant.getCompartment().equals(product.getCompartment())) {
            throw new IllegalStateException("the reactant and product for a multi-step reaction must be the same compartment");
        }
        Value rateValue = pReaction.getRate();
        if (rateValue.isExpression()) {
            throw new IllegalStateException("a multi-step reaction must have a numeric reaction rate, not a custom rate expression");
        }
        double rate = rateValue.getValue();
        Reaction firstReaction = new Reaction(reactionName);
        firstReaction.setRate(rate);
        firstReaction.addReactant(reactant, 1);
        String intermedSpeciesName = new String(String.valueOf(reactionName) + "___intermed_species_0");
        Compartment reactantCompartment = reactant.getCompartment();
        Species intermedSpecies = new Species("___" + intermedSpeciesName, reactantCompartment);
        intermedSpecies.setSpeciesPopulation(0.0);
        firstReaction.addProduct(intermedSpecies, 1);
        pReactions.set(pReactionIndex, firstReaction);
        pDynamicSpecies.add(intermedSpecies);
        if (--numSteps > 0 && numSteps < 15) {
            Species lastIntermedSpecies = intermedSpecies;
            int ctr = 0;
            while (ctr < numSteps) {
                Reaction reaction = new Reaction("___" + reactionName + "___multistep_reaction_" + ctr);
                reaction.setRate(rate);
                reaction.addReactant(lastIntermedSpecies, 1);
                if (ctr < numSteps - 1) {
                    intermedSpeciesName = new String(String.valueOf(reactionName) + "___intermed_species_" + (ctr + 1));
                    intermedSpecies = new Species("___" + intermedSpeciesName, reactantCompartment);
                    intermedSpecies.setSpeciesPopulation(0.0);
                    reaction.addProduct(intermedSpecies, 1);
                    pDynamicSpecies.add(intermedSpecies);
                    lastIntermedSpecies = intermedSpecies;
                } else {
                    reaction.addProduct(product, 1);
                }
                pReactions.add(reaction);
                ++ctr;
            }
        } else {
            boolean isMultistep;
            Reaction delayedReaction = new Reaction("___" + reactionName + "___delayed_reaction");
            delayedReaction.addReactant(intermedSpecies, 1);
            delayedReaction.addProduct(product, 1);
            pReactions.add(delayedReaction);
            delayedReaction.setRate(rate);
            double delay = 0.0;
            if (numSteps > 0) {
                delay = (double)(numSteps - 1) / rate;
                isMultistep = true;
            } else {
                delay = pReaction.getDelay();
                isMultistep = false;
            }
            DelayedReactionSolver solver = new DelayedReactionSolver((Species)reactant.clone(), (Species)intermedSpecies.clone(), delay, rate, isMultistep, pReactions.size() - 1, pIsStochasticSimulator);
            pDelayedReactionSolvers.add(solver);
        }
    }

    public abstract boolean isStochasticSimulator();

    protected final void initializeSimulator(Model pModel) throws DataNotFoundException {
        HashMap symbolMap;
        boolean isStochasticSimulator;
        this.clearSimulatorState();
        this.mModelName = pModel.getName();
        ArrayList reactionsList = pModel.constructReactionsList();
        int numReactions = reactionsList.size();
        ArrayList dynamicSymbolsList = pModel.constructDynamicSymbolsList();
        SymbolValue[] nonDynamicSymbols = pModel.constructGlobalNonDynamicSymbolsArray();
        int numNonDynamicSymbols = nonDynamicSymbols.length;
        ArrayList delayedReactionSolvers = new ArrayList();
        this.mIsStochasticSimulator = isStochasticSimulator = this.isStochasticSimulator();
        int reactionCtr = 0;
        while (reactionCtr < numReactions) {
            Reaction reaction = (Reaction)reactionsList.get(reactionCtr);
            int numSteps = reaction.getNumSteps();
            double delay = reaction.getDelay();
            if (numSteps != 1 || delay != 0.0) {
                MutableInteger recursionDepth = new MutableInteger(1);
                Simulator.handleDelayedReaction(reaction, reactionsList, reactionCtr, dynamicSymbolsList, delayedReactionSolvers, recursionDepth, isStochasticSimulator);
            }
            ++reactionCtr;
        }
        DelayedReactionSolver[] delayedReactionSolversArray = delayedReactionSolvers.toArray(new DelayedReactionSolver[0]);
        int numDelayedReactions = 0;
        this.mDelayedReactionSolvers = null;
        if (delayedReactionSolversArray.length > 0) {
            this.mDelayedReactionSolvers = delayedReactionSolversArray;
            numDelayedReactions = this.mDelayedReactionSolvers.length;
        }
        SymbolValue[] dynamicSymbols = dynamicSymbolsList.toArray(new Species[0]);
        this.mDynamicSymbols = dynamicSymbols;
        int numDynamicSymbols = dynamicSymbols.length;
        Reaction[] reactions = reactionsList.toArray(new Reaction[0]);
        this.mReactions = reactions;
        numReactions = reactions.length;
        double[] dynamicSymbolValues = new double[numDynamicSymbols];
        String[] dynamicSymbolNames = new String[numDynamicSymbols];
        this.mDynamicSymbolValues = dynamicSymbolValues;
        int symbolCtr = 0;
        while (symbolCtr < numDynamicSymbols) {
            double symbolValueDouble;
            Species symbolValue = dynamicSymbols[symbolCtr];
            Symbol symbol = symbolValue.getSymbol();
            String symbolName = symbol.getName();
            Value value = symbolValue.getValue();
            assert (value != null) : "null value for symbol: " + symbolName;
            dynamicSymbolValues[symbolCtr] = symbolValueDouble = symbolValue.getValue().getValue();
            dynamicSymbolNames[symbolCtr] = symbolName;
            ++symbolCtr;
        }
        this.mDynamicSymbolNames = dynamicSymbolNames;
        double[] initialDynamicSymbolValues = new double[numDynamicSymbols];
        System.arraycopy(dynamicSymbolValues, 0, initialDynamicSymbolValues, 0, numDynamicSymbols);
        this.mInitialDynamicSymbolValues = initialDynamicSymbolValues;
        this.mSymbolMap = symbolMap = new HashMap();
        Simulator.indexSymbolArray(dynamicSymbols, symbolMap, dynamicSymbolValues, null);
        Value[] nonDynamicSymbolValues = new Value[numNonDynamicSymbols];
        this.mNonDynamicSymbolValues = nonDynamicSymbolValues;
        Simulator.indexSymbolArray(nonDynamicSymbols, symbolMap, null, nonDynamicSymbolValues);
        ArrayList<Value> nonDynamicExpressionValues = new ArrayList<Value>();
        boolean hasExpressionValues = false;
        int ctr = 0;
        while (ctr < numNonDynamicSymbols) {
            if (this.mNonDynamicSymbolValues[ctr].isExpression()) {
                nonDynamicExpressionValues.add(this.mNonDynamicSymbolValues[ctr]);
                hasExpressionValues = true;
            }
            ++ctr;
        }
        this.mNonDynamicSymbolExpressionValues = nonDynamicExpressionValues.toArray(new Value[0]);
        if (this.mDelayedReactionSolvers != null) {
            this.mReactionsDelayedReactionAssociations = new DelayedReactionSolver[numReactions];
            int j = 0;
            while (j < numReactions) {
                this.mReactionsDelayedReactionAssociations[j] = null;
                ++j;
            }
            ctr = 0;
            while (ctr < numDelayedReactions) {
                DelayedReactionSolver solver = this.mDelayedReactionSolvers[ctr];
                solver.initializeSpeciesSymbols(symbolMap, (Species[])dynamicSymbols, nonDynamicSymbols);
                int reactionIndex = solver.getReactionIndex();
                this.mReactionsDelayedReactionAssociations[reactionIndex] = solver;
                ++ctr;
            }
        } else {
            this.mReactionsDelayedReactionAssociations = null;
        }
        ReservedSymbolMapper reservedSymbolMapper = pModel.getReservedSymbolMapper();
        SymbolEvaluationPostProcessor symbolEvaluationPostProcessor = pModel.getSymbolEvaluationPostProcessor();
        if (symbolEvaluationPostProcessor != null) {
            symbolEvaluationPostProcessor = (SymbolEvaluationPostProcessor)symbolEvaluationPostProcessor.clone();
        }
        this.mUseExpressionValueCaching = hasExpressionValues;
        SymbolEvaluatorChem evaluator = new SymbolEvaluatorChem(this.mUseExpressionValueCaching, symbolEvaluationPostProcessor, reservedSymbolMapper, symbolMap);
        evaluator.setTime(0.0);
        this.mSymbolEvaluator = evaluator;
        this.checkSymbolsValues();
        this.mReactionsReactantsSpecies = new Object[numReactions];
        this.mReactionsReactantsStoichiometries = new Object[numReactions];
        this.mReactionsReactantsDynamic = new Object[numReactions];
        this.mReactionsProductsSpecies = new Object[numReactions];
        this.mReactionsProductsStoichiometries = new Object[numReactions];
        this.mReactionsProductsDynamic = new Object[numReactions];
        this.mReactionsLocalParamSymbolsMaps = new HashMap[numReactions];
        this.mReactionRates = new Value[numReactions];
        this.mReactionSymbols = new Symbol[numReactions];
        int reactionCtr2 = 0;
        while (reactionCtr2 < numReactions) {
            Reaction reaction = reactions[reactionCtr2];
            this.mReactionRates[reactionCtr2] = reaction.getValue();
            int numReactants = reaction.getNumReactants();
            Species[] reactantsSpeciesArray = new Species[numReactants];
            int[] reactantsStoichiometryArray = new int[numReactants];
            boolean[] reactantsDynamicArray = new boolean[numReactants];
            reaction.constructSpeciesArrays(reactantsSpeciesArray, reactantsStoichiometryArray, reactantsDynamicArray, (Species[])dynamicSymbols, nonDynamicSymbols, symbolMap, ReactionParticipant.Type.REACTANT);
            Symbol[] reactantsSymbolsArray = new Symbol[numReactants];
            int j = 0;
            while (j < numReactants) {
                reactantsSymbolsArray[j] = reactantsSpeciesArray[j].getSymbol();
                ++j;
            }
            this.mReactionsReactantsSpecies[reactionCtr2] = reactantsSymbolsArray;
            this.mReactionsReactantsStoichiometries[reactionCtr2] = reactantsStoichiometryArray;
            this.mReactionsReactantsDynamic[reactionCtr2] = reactantsDynamicArray;
            int numProducts = reaction.getNumProducts();
            Species[] productsSpeciesArray = new Species[numProducts];
            int[] productsStoichiometryArray = new int[numProducts];
            boolean[] productsDynamicArray = new boolean[numProducts];
            reaction.constructSpeciesArrays(productsSpeciesArray, productsStoichiometryArray, productsDynamicArray, (Species[])dynamicSymbols, nonDynamicSymbols, symbolMap, ReactionParticipant.Type.PRODUCT);
            Symbol[] productsSymbolsArray = new Symbol[numProducts];
            int j2 = 0;
            while (j2 < numProducts) {
                productsSymbolsArray[j2] = productsSpeciesArray[j2].getSymbol();
                ++j2;
            }
            this.mReactionsProductsSpecies[reactionCtr2] = productsSymbolsArray;
            this.mReactionsProductsStoichiometries[reactionCtr2] = productsStoichiometryArray;
            this.mReactionsProductsDynamic[reactionCtr2] = productsDynamicArray;
            this.mReactionsLocalParamSymbolsMaps[reactionCtr2] = Simulator.createLocalSymbolsMap(reaction);
            this.mReactionSymbols[reactionCtr2] = reaction.getSymbol();
            ++reactionCtr2;
        }
        this.mReactionProbabilities = new double[numReactions];
        this.checkReactionRates();
    }

    protected void setInitialized(boolean pInitialized) {
        this.mInitialized = true;
    }

    static HashMap createLocalSymbolsMap(Reaction pReaction) {
        SymbolValue[] localSymbolsValues = pReaction.getLocalSymbolValues();
        int numLocalSymbols = localSymbolsValues.length;
        Value[] localValues = new Value[numLocalSymbols];
        HashMap localSymbolsMap = new HashMap();
        Simulator.indexSymbolArray(localSymbolsValues, localSymbolsMap, null, localValues);
        return localSymbolsMap;
    }

    private final void checkReactionRates() throws DataNotFoundException {
        int numReactions = this.mReactions.length;
        int reactionCtr = 0;
        while (reactionCtr < numReactions) {
            int numReactants;
            this.computeReactionRate(reactionCtr);
            Symbol[] reactants = (Symbol[])this.mReactionsReactantsSpecies[reactionCtr];
            int reactantCtr = numReactants = reactants.length;
            while (--reactantCtr >= 0) {
                Symbol symbol = reactants[reactantCtr];
                this.mSymbolEvaluator.getValue(symbol);
            }
            ++reactionCtr;
        }
    }

    private final void checkSymbolsValues() {
        for (String symbolName : this.mSymbolMap.keySet()) {
            Symbol symbol = (Symbol)this.mSymbolMap.get(symbolName);
            assert (symbol != null) : "found null Symbol where a valid Symbol object was expected";
        }
    }

    protected void clearSimulatorState() {
        this.mInitialized = false;
        this.mDynamicSymbolValues = null;
        this.mInitialDynamicSymbolValues = null;
        this.mNonDynamicSymbolValues = null;
        this.mSymbolEvaluator = null;
        this.mReactions = null;
        this.mReactionProbabilities = null;
        this.mSymbolMap = null;
        this.mSimulationController = null;
        this.mDelayedReactionSolvers = null;
        this.mDynamicSymbols = null;
        this.mDynamicSymbolAdjustmentVectors = null;
        this.mReactionsDelayedReactionAssociations = null;
        this.mReactionSymbols = null;
        this.mReactionRates = null;
        this.mNonDynamicSymbolExpressionValues = null;
        this.mModelName = null;
    }

    public Simulator() {
        this.clearSimulatorState();
        this.setMinNumMillisecondsForUpdate(1000L);
    }

    protected final void initializeDynamicSymbolAdjustmentVectors() {
        Reaction[] reactions = this.mReactions;
        int numReactions = reactions.length;
        Object[] dynamicSymbolAdjustmentVectors = new Object[numReactions];
        int ctr = 0;
        while (ctr < numReactions) {
            dynamicSymbolAdjustmentVectors[ctr] = this.constructDynamicSymbolAdjustmentVector(ctr);
            ++ctr;
        }
        this.mDynamicSymbolAdjustmentVectors = dynamicSymbolAdjustmentVectors;
    }

    public abstract String getAlias();

    protected final SimulationResults createSimulationResults(double pStartTime, double pEndTime, SimulatorParameters pSimulatorParameters, String[] pResultsSymbolNames, double[] pResultsTimeValues, Object[] pResultsSymbolValues, double[] pResultsFinalSymbolFluctuations) {
        SimulationResults simulationResults = new SimulationResults();
        simulationResults.setSimulatorAlias(this.getAlias());
        simulationResults.setStartTime(pStartTime);
        simulationResults.setEndTime(pEndTime);
        simulationResults.setSimulatorParameters(pSimulatorParameters);
        simulationResults.setResultsSymbolNames(pResultsSymbolNames);
        simulationResults.setResultsTimeValues(pResultsTimeValues);
        simulationResults.setResultsSymbolValues(pResultsSymbolValues);
        simulationResults.setResultsFinalSymbolFluctuations(pResultsFinalSymbolFluctuations);
        simulationResults.setModelName(this.mModelName);
        return simulationResults;
    }

    protected final SimulationResults createSimulationResults(double pStartTime, double pEndTime, SimulatorParameters pSimulatorParameters, String[] pResultsSymbolNames, double[] pResultsTimeValues, Object[] pResultsSymbolValues, double[] pResultsFinalSymbolFluctuations, Object[] pStatCollector, String[] pReactionNames, double[] pReactionCounts, double[] pReactionTimes) {
        SimulationResults simulationResults = this.createSimulationResults(pStartTime, pEndTime, pSimulatorParameters, pResultsSymbolNames, pResultsTimeValues, pResultsSymbolValues, pResultsFinalSymbolFluctuations);
        simulationResults.setReactionNames(pReactionNames);
        simulationResults.setReactionCounts(pReactionCounts);
        simulationResults.setReactionTimes(pReactionTimes);
        simulationResults.setStatCollector(pStatCollector);
        return simulationResults;
    }

    protected final int addRequestedSymbolValues(double pCurTime, int pLastTimeIndex, Symbol[] pRequestedSymbols, double[] pTimeValues, Object[] pRetSymbolValues) throws DataNotFoundException {
        int numTimePoints = pTimeValues.length;
        int numRequestedSymbolValues = pRequestedSymbols.length;
        if (this.mUseExpressionValueCaching) {
            this.clearExpressionValueCaches();
        }
        double saveTime = this.mSymbolEvaluator.getTime();
        int timeCtr = pLastTimeIndex;
        while (timeCtr < numTimePoints) {
            double timeValue = pTimeValues[timeCtr];
            this.mSymbolEvaluator.setTime(timeValue);
            if (!(timeValue <= pCurTime)) break;
            double[] symbolValues = (double[])pRetSymbolValues[timeCtr];
            int symCtr = numRequestedSymbolValues - 1;
            while (symCtr >= 0) {
                Symbol symbol = pRequestedSymbols[symCtr];
                int n = symCtr--;
                symbolValues[n] = symbolValues[n] + this.mSymbolEvaluator.getValue(symbol);
            }
            ++timeCtr;
        }
        this.mSymbolEvaluator.setTime(saveTime);
        return timeCtr;
    }

    protected final int addRequestedSymbolValues(double pCurTime, int pLastTimeIndex, Symbol[] pRequestedSymbols, double[] pTimeValues, Object[] pRetSymbolValues, Object[] pStatCollector) throws DataNotFoundException {
        int numTimePoints = pTimeValues.length;
        int numRequestedSymbolValues = pRequestedSymbols.length;
        if (this.mUseExpressionValueCaching) {
            this.clearExpressionValueCaches();
        }
        double saveTime = this.mSymbolEvaluator.getTime();
        int timeCtr = pLastTimeIndex;
        while (timeCtr < numTimePoints) {
            double timeValue = pTimeValues[timeCtr];
            this.mSymbolEvaluator.setTime(timeValue);
            if (!(timeValue <= pCurTime)) break;
            double[] symbolValues = (double[])pRetSymbolValues[timeCtr];
            TallyStore[] stat = (TallyStore[])pStatCollector[timeCtr];
            int symCtr = numRequestedSymbolValues - 1;
            while (symCtr >= 0) {
                Symbol symbol = pRequestedSymbols[symCtr];
                int n = symCtr;
                symbolValues[n] = symbolValues[n] + this.mSymbolEvaluator.getValue(symbol);
                stat[symCtr].add(this.mSymbolEvaluator.getValue(symbol));
                --symCtr;
            }
            ++timeCtr;
        }
        this.mSymbolEvaluator.setTime(saveTime);
        return timeCtr;
    }

    protected static final double[] createodeToJavaTimesArray(double pStartTime, double pEndTime, int pNumTimePoints) {
        assert (pNumTimePoints > 1) : " invalid number of time points";
        int offset = 0;
        double[] retTimesArray = null;
        if (pStartTime == 0.0) {
            retTimesArray = new double[pNumTimePoints];
        } else {
            retTimesArray = new double[pNumTimePoints + 1];
            offset = 1;
            retTimesArray[0] = 0.0;
        }
        double deltaTime = (pEndTime - pStartTime) / (double)(pNumTimePoints - 1);
        int timeCtr = 0;
        while (timeCtr < pNumTimePoints) {
            double time = (double)timeCtr * deltaTime + pStartTime;
            if (time > pEndTime) {
                time = pEndTime;
            }
            retTimesArray[timeCtr + offset] = time;
            ++timeCtr;
        }
        return retTimesArray;
    }

    protected static final double[] createTimesArray(double pStartTime, double pEndTime, int pNumTimePoints) {
        assert (pNumTimePoints > 1) : " invalid number of time points";
        double[] retTimesArray = new double[pNumTimePoints];
        double deltaTime = (pEndTime - pStartTime) / (double)(pNumTimePoints - 1);
        int timeCtr = 0;
        while (timeCtr < pNumTimePoints) {
            double time = (double)timeCtr * deltaTime + pStartTime;
            if (time > pEndTime) {
                time = pEndTime;
            }
            retTimesArray[timeCtr] = time;
            ++timeCtr;
        }
        return retTimesArray;
    }

    protected final Symbol[] createRequestedSymbolArray(HashMap pSymbolMap, String[] pRequestedSymbols) throws DataNotFoundException {
        int numSymbols = pRequestedSymbols.length;
        Symbol[] symbols = new Symbol[numSymbols];
        int symbolCtr = numSymbols - 1;
        while (symbolCtr >= 0) {
            String symbolName = pRequestedSymbols[symbolCtr];
            Symbol symbol = (Symbol)pSymbolMap.get(symbolName);
            if (symbol == null) {
                throw new DataNotFoundException("requested symbol not found in model: " + symbolName);
            }
            symbols[symbolCtr] = symbol;
            --symbolCtr;
        }
        return symbols;
    }

    public final void checkSimulationParameters(double pStartTime, double pEndTime, SimulatorParameters pSimulatorParameters, int pNumResultsTimePoints) throws IllegalArgumentException, IllegalStateException {
        if (!this.mInitialized) {
            throw new IllegalStateException("simulator has not been initialized yet");
        }
        if (pNumResultsTimePoints <= 1) {
            throw new IllegalArgumentException("number of time points must be greater than or equal to 1");
        }
        if (pStartTime >= pEndTime) {
            throw new IllegalArgumentException("end time must be greater than the start time");
        }
        this.checkSimulationParametersImpl(pSimulatorParameters, pNumResultsTimePoints);
    }

    protected abstract void checkSimulationParametersImpl(SimulatorParameters var1, int var2);

    protected final void computeReactionProbabilities() throws DataNotFoundException {
        int numReactions = this.mReactions.length;
        if (this.mUseExpressionValueCaching) {
            this.clearExpressionValueCaches();
        }
        int reactionCtr = numReactions;
        while (--reactionCtr >= 0) {
            this.mReactionProbabilities[reactionCtr] = this.computeReactionRate(reactionCtr);
        }
    }

    protected static final double getDelayedReactionEstimatedAverageFutureRate(SymbolEvaluatorChem pSymbolEvaluator, DelayedReactionSolver[] pDelayedReactionSolvers) throws DataNotFoundException {
        int numDelayedReactions;
        double compositeRate = 0.0;
        int ctr = numDelayedReactions = pDelayedReactionSolvers.length;
        while (--ctr >= 0) {
            DelayedReactionSolver solver = pDelayedReactionSolvers[ctr];
            double estimatedFutureRate = solver.getEstimatedAverageFutureRate(pSymbolEvaluator);
            compositeRate += estimatedFutureRate;
        }
        return compositeRate;
    }

    protected final void clearExpressionValueCaches() {
        Value[] expressionValues = this.mNonDynamicSymbolExpressionValues;
        int ctr = expressionValues.length;
        while (--ctr >= 0) {
            expressionValues[ctr].clearExpressionValueCache();
        }
    }

    protected final void computeDerivative(double[] pTempDynamicSymbolValues, double[] pDynamicSymbolDerivatives) throws DataNotFoundException {
        this.computeReactionProbabilities();
        int numReactions = this.mReactions.length;
        double reactionRate = 0.0;
        DoubleVector.zeroElements(pDynamicSymbolDerivatives);
        Object[] dynamicSymbolAdjustmentVectors = this.mDynamicSymbolAdjustmentVectors;
        int reactionCtr = numReactions;
        while (--reactionCtr >= 0) {
            reactionRate = this.mReactionProbabilities[reactionCtr];
            double[] symbolAdjustmentVector = (double[])dynamicSymbolAdjustmentVectors[reactionCtr];
            DoubleVector.scalarMultiply(symbolAdjustmentVector, reactionRate, pTempDynamicSymbolValues);
            DoubleVector.add(pTempDynamicSymbolValues, pDynamicSymbolDerivatives, pDynamicSymbolDerivatives);
        }
    }

    public final void setProgressReporter(SimulationProgressReporter pSimulationProgressReporter) {
        this.mSimulationProgressReporter = pSimulationProgressReporter;
    }

    public final void setController(SimulationController pSimulationController) {
        this.mSimulationController = pSimulationController;
    }

    public final void setStatusUpdateIntervalSeconds(double pUpdateIntervalSeconds) throws IllegalArgumentException {
        if (pUpdateIntervalSeconds <= 0.0) {
            throw new IllegalArgumentException("invalid minimum number of seconds for update: " + pUpdateIntervalSeconds);
        }
        long updateIntervalMilliseconds = (long)(1000.0 * pUpdateIntervalSeconds);
        this.setMinNumMillisecondsForUpdate(updateIntervalMilliseconds);
    }

    protected final void setMinNumMillisecondsForUpdate(long pMinNumMillisecondsForUpdate) {
        this.mMinNumMillisecondsForUpdate = pMinNumMillisecondsForUpdate;
    }

    protected final double getMinDelayedReactionDelay() {
        double retDelay = Double.MAX_VALUE;
        DelayedReactionSolver[] delayedReactionSolvers = this.mDelayedReactionSolvers;
        int numDelayedReactions = delayedReactionSolvers.length;
        int ctr = 0;
        while (ctr < numDelayedReactions) {
            DelayedReactionSolver delayedReactionSolver = delayedReactionSolvers[ctr];
            double delay = delayedReactionSolver.getDelay();
            if (delay < retDelay) {
                retDelay = delay;
            }
            ++ctr;
        }
        return retDelay;
    }

    private static double computeRateFactorForSpecies(double pSpeciesValue, int pStoichiometry, boolean pIsDynamic, boolean pIsStochastic) {
        if (pIsStochastic && pIsDynamic) {
            if (pSpeciesValue >= (double)pStoichiometry) {
                if (pSpeciesValue < 100000.0) {
                    if (1 == pStoichiometry) {
                        return pSpeciesValue;
                    }
                    double retVal = 1.0;
                    int ctr = pStoichiometry;
                    while (--ctr >= 0) {
                        retVal *= pSpeciesValue - (double)ctr;
                    }
                    return retVal;
                }
                return Math.pow(pSpeciesValue, pStoichiometry);
            }
            return 0.0;
        }
        if (1 == pStoichiometry) {
            return pSpeciesValue;
        }
        return Math.pow(pSpeciesValue, pStoichiometry);
    }

    static Expression computeRatePartialDerivativeExpression(Expression pRateExpression, SymbolValue pSymbolValue, SymbolEvaluatorChem pSymbolEvaluator, HashMap pLocalSymbolsMap) throws DataNotFoundException {
        Symbol derivSymbol = pSymbolValue.getSymbol();
        pSymbolEvaluator.setLocalSymbolsMap(pLocalSymbolsMap);
        Expression retVal = pRateExpression.computePartialDerivative(derivSymbol, pSymbolEvaluator);
        pSymbolEvaluator.setLocalSymbolsMap(null);
        return retVal;
    }

    protected Expression computeRatePartialDerivativeExpression(int pReactionCtr, Expression pRateExpression, SymbolValue pSymbolValue, SymbolEvaluatorChem pSymbolEvaluator) throws DataNotFoundException {
        return Simulator.computeRatePartialDerivativeExpression(pRateExpression, pSymbolValue, pSymbolEvaluator, this.mReactionsLocalParamSymbolsMaps[pReactionCtr]);
    }

    final double computeReactionRate(int pReactionCtr) throws DataNotFoundException {
        if (this.mReactionsDelayedReactionAssociations == null || this.mReactionsDelayedReactionAssociations[pReactionCtr] == null) {
            if (!this.mReactionRates[pReactionCtr].isExpression()) {
                int numReactants;
                Symbol[] reactantsSpecies = (Symbol[])this.mReactionsReactantsSpecies[pReactionCtr];
                int[] reactantsStoichiometries = (int[])this.mReactionsReactantsStoichiometries[pReactionCtr];
                boolean[] reactantsDynamic = (boolean[])this.mReactionsReactantsDynamic[pReactionCtr];
                double rate = this.mReactionRates[pReactionCtr].getValue();
                int reactantCtr = numReactants = reactantsSpecies.length;
                while (--reactantCtr >= 0) {
                    rate *= Simulator.computeRateFactorForSpecies(this.mSymbolEvaluator.getValue(reactantsSpecies[reactantCtr]), reactantsStoichiometries[reactantCtr], reactantsDynamic[reactantCtr], this.mIsStochasticSimulator);
                }
                return rate;
            }
            this.mSymbolEvaluator.setLocalSymbolsMap(this.mReactionsLocalParamSymbolsMaps[pReactionCtr]);
            double rate = this.mSymbolEvaluator.getValue(this.mReactionSymbols[pReactionCtr]);
            this.mSymbolEvaluator.setLocalSymbolsMap(null);
            return rate;
        }
        double rate = this.mReactionsDelayedReactionAssociations[pReactionCtr].computeRate(this.mSymbolEvaluator);
        return rate;
    }

    private double[] constructDynamicSymbolAdjustmentVector(int pReactionCtr) {
        int numSymbols = this.mDynamicSymbols.length;
        double[] dynamicSymbolVector = new double[numSymbols];
        Reaction reaction = this.mReactions[pReactionCtr];
        HashMap reactantsMap = reaction.getReactantsMap();
        HashMap productsMap = reaction.getProductsMap();
        int symbolCtr = 0;
        while (symbolCtr < numSymbols) {
            ReactionParticipant productParticipant;
            Species symbolValue = this.mDynamicSymbols[symbolCtr];
            Symbol symbol = symbolValue.getSymbol();
            String symbolName = symbol.getName();
            double vecElement = 0.0;
            ReactionParticipant reactantParticipant = (ReactionParticipant)reactantsMap.get(symbolName);
            if (reactantParticipant != null && reactantParticipant.mDynamic) {
                vecElement -= (double)reactantParticipant.mStoichiometry;
            }
            if ((productParticipant = (ReactionParticipant)productsMap.get(symbolName)) != null && productParticipant.mDynamic) {
                vecElement += (double)productParticipant.mStoichiometry;
            }
            dynamicSymbolVector[symbolCtr] = vecElement;
            ++symbolCtr;
        }
        return dynamicSymbolVector;
    }

    public static Expression[] getReactionRateExpressions(Reaction[] pReactions) throws DataNotFoundException {
        int numReactions = pReactions.length;
        Expression[] a = new Expression[numReactions];
        int j = 0;
        while (j < numReactions) {
            Reaction reaction = pReactions[j];
            a[j] = reaction.getRateExpression();
            ++j;
        }
        return a;
    }

    protected void checkSimulationParametersForDeterministicSimulator(SimulatorParameters pSimulatorParameters, int pNumResultsTimePoints) {
        double maxAllowedAbsoluteError;
        double maxAllowedRelativeError;
        Boolean flagGetFinalSymbolFluctuations = pSimulatorParameters.getComputeFluctuations();
        if (flagGetFinalSymbolFluctuations == null) {
            throw new IllegalArgumentException("missing flag for whether to obtain the final symbol fluctuations");
        }
        Double maxAllowedRelativeErrorObj = pSimulatorParameters.getMaxAllowedRelativeError();
        if (maxAllowedRelativeErrorObj != null && (maxAllowedRelativeError = maxAllowedRelativeErrorObj.doubleValue()) <= 0.0) {
            throw new IllegalArgumentException("invalid max allowed relative error: " + maxAllowedRelativeError);
        }
        Double maxAllowedAbsoluteErrorObj = pSimulatorParameters.getMaxAllowedAbsoluteError();
        if (maxAllowedAbsoluteErrorObj != null && (maxAllowedAbsoluteError = maxAllowedAbsoluteErrorObj.doubleValue()) <= 0.0) {
            throw new IllegalArgumentException("invalid max allowed absolute error: " + maxAllowedAbsoluteError);
        }
        Double stepSizeObj = pSimulatorParameters.getStepSizeFraction();
        double stepSize = 0.0;
        if (stepSizeObj != null) {
            stepSize = stepSizeObj;
            if (stepSize <= 0.0) {
                throw new IllegalArgumentException("invalid step size fraction: " + stepSize);
            }
        } else {
            throw new IllegalArgumentException("no step size fraction defined, for deterministic simulator");
        }
        if (stepSize > 1.0 / (double)pNumResultsTimePoints) {
            throw new IllegalArgumentException("step size is too large, given the granularity of the results requested; please either decrease the step size fraction, or decrease the number of requested results time points");
        }
        if (this.hasDelayedReactionSolvers()) {
            Integer numHistoryBinsObj = pSimulatorParameters.getNumHistoryBins();
            if (numHistoryBinsObj == null) {
                throw new IllegalArgumentException("no number of history bins defined");
            }
            int numHistoryBins = numHistoryBinsObj;
            if (numHistoryBins <= 10) {
                throw new IllegalArgumentException("invalid number of history bins: " + numHistoryBins + "; minimum value is: " + 10);
            }
            double maxStepSizeDueToDelayedReactions = this.getMinDelayedReactionDelay() / (double)numHistoryBins;
            if (stepSize > maxStepSizeDueToDelayedReactions) {
                throw new IllegalArgumentException("step size exceeds maximum allowed for a delayed reaction; please use a smaller step size fraction");
            }
        }
    }
}

