/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem;

import org.systemsbiology.chem.DelayedReactionSolver;
import org.systemsbiology.chem.Model;
import org.systemsbiology.chem.Reaction;
import org.systemsbiology.chem.SimulationController;
import org.systemsbiology.chem.SimulationProgressReporter;
import org.systemsbiology.chem.SimulationResults;
import org.systemsbiology.chem.Simulator;
import org.systemsbiology.chem.SimulatorParameters;
import org.systemsbiology.chem.SteadyStateAnalyzer;
import org.systemsbiology.chem.SymbolEvaluatorChem;
import org.systemsbiology.math.AccuracyException;
import org.systemsbiology.math.DoubleVector;
import org.systemsbiology.math.MutableDouble;
import org.systemsbiology.math.Symbol;
import org.systemsbiology.util.DataNotFoundException;

public abstract class SimulatorDeterministicBase
extends Simulator {
    private static final double DEFAULT_STEP_SIZE_FRACTION = 0.001;
    public static final double DEFAULT_MAX_ALLOWED_RELATIVE_ERROR = 1.0E-4;
    public static final double DEFAULT_MAX_ALLOWED_ABSOLUTE_ERROR = 0.01;
    public static final boolean DEFAULT_FLAG_GET_FINAL_SYMBOL_FLUCTUATIONS = false;
    protected static final int DEFAULT_NUM_HISTORY_BINS = 400;
    protected RKScratchPad mRKScratchPad;

    protected abstract double iterate(double[] var1) throws DataNotFoundException, AccuracyException;

    protected final void rk4step(double pTimeStepSize, double[] pNewDynamicSymbolValues) throws DataNotFoundException {
        double time = this.mSymbolEvaluator.getTime();
        double[] k1 = this.mRKScratchPad.k1;
        int numVars = k1.length;
        double[] y = this.mDynamicSymbolValues;
        double[] ysav = this.mRKScratchPad.ysav;
        double[] yscratch = this.mRKScratchPad.yscratch;
        double halfStep = pTimeStepSize / 2.0;
        double timePlusHalfStep = time + halfStep;
        System.arraycopy(y, 0, ysav, 0, numVars);
        this.computeDerivative(yscratch, k1);
        DoubleVector.scalarMultiply(k1, halfStep, k1);
        DoubleVector.add(ysav, k1, y);
        this.mSymbolEvaluator.setTime(timePlusHalfStep);
        double[] k2 = this.mRKScratchPad.k2;
        this.computeDerivative(yscratch, k2);
        DoubleVector.scalarMultiply(k2, halfStep, k2);
        DoubleVector.add(ysav, k2, y);
        double[] k3 = this.mRKScratchPad.k3;
        this.computeDerivative(yscratch, k3);
        DoubleVector.scalarMultiply(k3, pTimeStepSize, k3);
        DoubleVector.add(ysav, k3, y);
        double[] k4 = this.mRKScratchPad.k4;
        double pNextTime = time + pTimeStepSize;
        this.mSymbolEvaluator.setTime(pNextTime);
        this.computeDerivative(yscratch, k4);
        DoubleVector.scalarMultiply(k4, pTimeStepSize, k4);
        int ctr = numVars;
        while (--ctr >= 0) {
            double newDynamicSymbolValue;
            pNewDynamicSymbolValues[ctr] = newDynamicSymbolValue = ysav[ctr] + k1[ctr] / 3.0 + 2.0 * k2[ctr] / 3.0 + k3[ctr] / 3.0 + k4[ctr] / 6.0;
        }
        DoubleVector.zeroNegativeElements(pNewDynamicSymbolValues);
        System.arraycopy(ysav, 0, y, 0, numVars);
        this.mSymbolEvaluator.setTime(time);
    }

    private void resetScratchpad() {
        int numDynamicSymbols = this.mDynamicSymbolValues.length;
        this.mRKScratchPad = new RKScratchPad(numDynamicSymbols);
    }

    public void initialize(Model pModel) throws DataNotFoundException {
        this.initializeSimulator(pModel);
        this.initializeDynamicSymbolAdjustmentVectors();
        this.resetScratchpad();
        this.setInitialized(true);
    }

    protected final void computeScale(double pTimeStepSize, double[] yscale) throws DataNotFoundException, AccuracyException {
        double[] yscratch = this.mRKScratchPad.yscratch;
        double[] dydt = this.mRKScratchPad.dydt;
        int numDynamicSymbols = this.mDynamicSymbolValues.length;
        double dydtn = 0.0;
        double yn = 0.0;
        this.computeDerivative(yscratch, dydt);
        boolean gotNonzero = false;
        int symCtr = numDynamicSymbols;
        while (--symCtr >= 0) {
            double scale;
            dydtn = dydt[symCtr];
            yn = this.mDynamicSymbolValues[symCtr];
            yscale[symCtr] = scale = Math.abs(yn) + Math.abs(dydtn * pTimeStepSize);
            if (!(scale > 0.0)) continue;
            gotNonzero = true;
        }
        if (!gotNonzero) {
            throw new AccuracyException("unable to determine any scale at time: " + this.mSymbolEvaluator.getTime());
        }
    }

    protected final void rkqc(double pTimeStepSize, double[] pDynamicSymbolValueScales, double[] pNewDynamicSymbolValues, MutableDouble pRetAggregateRelativeError, MutableDouble pRetAggregateAbsoluteError) throws DataNotFoundException {
        double time = this.mSymbolEvaluator.getTime();
        int numDynamicSymbols = this.mDynamicSymbolValues.length;
        this.rk4step(pTimeStepSize, pNewDynamicSymbolValues);
        double halfStepSize = pTimeStepSize / 2.0;
        double timePlusHalfStep = time + halfStepSize;
        double[] y1 = this.mRKScratchPad.y1;
        this.rk4step(halfStepSize, y1);
        double[] ysav = this.mRKScratchPad.ysav;
        System.arraycopy(this.mDynamicSymbolValues, 0, ysav, 0, numDynamicSymbols);
        System.arraycopy(y1, 0, this.mDynamicSymbolValues, 0, numDynamicSymbols);
        this.mSymbolEvaluator.setTime(timePlusHalfStep);
        double[] y2 = this.mRKScratchPad.y2;
        this.rk4step(halfStepSize, y2);
        System.arraycopy(ysav, 0, this.mDynamicSymbolValues, 0, numDynamicSymbols);
        this.mSymbolEvaluator.setTime(time);
        double aggregateRelativeError = 0.0;
        double aggregateAbsoluteError = 0.0;
        double singleError = 0.0;
        double scale = 0.0;
        double deltaY = 0.0;
        int symCtr = numDynamicSymbols;
        while (--symCtr >= 0) {
            scale = pDynamicSymbolValueScales[symCtr];
            if (!(scale > 0.0)) continue;
            deltaY = Math.abs(pNewDynamicSymbolValues[symCtr] - y2[symCtr]);
            singleError = deltaY / scale;
            aggregateRelativeError += singleError;
            aggregateAbsoluteError += deltaY;
        }
        pRetAggregateRelativeError.setValue(aggregateRelativeError);
        pRetAggregateAbsoluteError.setValue(aggregateAbsoluteError);
    }

    protected abstract void setupErrorTolerances(SimulatorParameters var1, RKScratchPad var2);

    public SimulationResults simulate(double pStartTime, double pEndTime, SimulatorParameters pSimulatorParameters, int pNumResultsTimePoints, String[] pRequestedSymbolNames) throws DataNotFoundException, IllegalStateException, AccuracyException {
        double initialStepSize;
        this.checkSimulationParameters(pStartTime, pEndTime, pSimulatorParameters, pNumResultsTimePoints);
        int numHistoryBins = pSimulatorParameters.getNumHistoryBins();
        if (this.mDelayedReactionSolvers != null) {
            this.resizeDelayedReactionSolvers(numHistoryBins);
        }
        Object[] retSymbolValues = new Object[pNumResultsTimePoints];
        SimulationProgressReporter simulationProgressReporter = this.mSimulationProgressReporter;
        SimulationController simulationController = this.mSimulationController;
        boolean doUpdates = simulationController != null || simulationProgressReporter != null;
        long minNumMillisecondsForUpdate = 0L;
        long timeOfLastUpdateMilliseconds = 0L;
        if (doUpdates) {
            minNumMillisecondsForUpdate = this.mMinNumMillisecondsForUpdate;
            timeOfLastUpdateMilliseconds = System.currentTimeMillis();
        }
        long iterationCounter = 0L;
        if (simulationProgressReporter != null) {
            simulationProgressReporter.updateProgressStatistics(false, 0.0, iterationCounter);
        }
        double[] timesArray = SimulatorDeterministicBase.createTimesArray(pStartTime, pEndTime, pNumResultsTimePoints);
        Symbol[] requestedSymbols = this.createRequestedSymbolArray(this.mSymbolMap, pRequestedSymbolNames);
        int numRequestedSymbols = requestedSymbols.length;
        int i = 0;
        while (i < pNumResultsTimePoints) {
            double[] tArray = new double[numRequestedSymbols];
            int i2 = 0;
            while (i2 < numRequestedSymbols) {
                tArray[i2] = 0.0;
                ++i2;
            }
            retSymbolValues[i] = tArray;
            ++i;
        }
        SymbolEvaluatorChem symbolEvaluator = this.mSymbolEvaluator;
        Reaction[] reactions = this.mReactions;
        double[] dynamicSymbolValues = this.mDynamicSymbolValues;
        int numDynamicSymbolValues = dynamicSymbolValues.length;
        double time = 0.0;
        double timeRangeMult = 1.0 / (pEndTime - pStartTime);
        this.prepareForSimulation(0.0);
        double[] newSimulationSymbolValues = new double[numDynamicSymbolValues];
        System.arraycopy(dynamicSymbolValues, 0, newSimulationSymbolValues, 0, numDynamicSymbolValues);
        int timeCtr = 0;
        RKScratchPad scratchPad = this.mRKScratchPad;
        scratchPad.clear();
        this.setupErrorTolerances(pSimulatorParameters, scratchPad);
        double deltaTime = pEndTime - pStartTime;
        scratchPad.stepSize = initialStepSize = pSimulatorParameters.getStepSizeFraction() * deltaTime;
        this.setupImpl(deltaTime, pNumResultsTimePoints, pSimulatorParameters, scratchPad);
        boolean isCancelled = false;
        DelayedReactionSolver[] delayedReactionSolvers = this.mDelayedReactionSolvers;
        int numDelayedReactions = 0;
        if (delayedReactionSolvers != null) {
            numDelayedReactions = delayedReactionSolvers.length;
        }
        long currentTimeMilliseconds = 0L;
        double fractionComplete = 0.0;
        while (pNumResultsTimePoints - timeCtr > 0) {
            time = this.iterate(newSimulationSymbolValues);
            ++scratchPad.numIterations;
            if (time > timesArray[timeCtr]) {
                timeCtr = this.addRequestedSymbolValues(time, timeCtr, requestedSymbols, timesArray, retSymbolValues);
            }
            System.arraycopy(newSimulationSymbolValues, 0, dynamicSymbolValues, 0, numDynamicSymbolValues);
            if (delayedReactionSolvers != null) {
                int ctr = numDelayedReactions;
                while (--ctr >= 0) {
                    DelayedReactionSolver solver = delayedReactionSolvers[ctr];
                    solver.update(symbolEvaluator, time);
                }
            }
            ++iterationCounter;
            if (!doUpdates || (currentTimeMilliseconds = System.currentTimeMillis()) - timeOfLastUpdateMilliseconds < minNumMillisecondsForUpdate) continue;
            if ((simulationController != null || simulationController.getFinished()) && (isCancelled = simulationController.handlePauseOrCancel())) break;
            if (simulationProgressReporter != null) {
                fractionComplete = time * timeRangeMult;
                simulationProgressReporter.updateProgressStatistics(false, fractionComplete, iterationCounter);
            }
            timeOfLastUpdateMilliseconds = System.currentTimeMillis();
        }
        if (simulationProgressReporter != null) {
            fractionComplete = time * timeRangeMult;
            simulationProgressReporter.updateProgressStatistics(true, fractionComplete, iterationCounter);
        }
        SimulationResults simulationResults = null;
        if (!isCancelled) {
            boolean estimateFinalSpeciesFluctuations = false;
            Boolean flagGetFinalSymbolFluctuations = pSimulatorParameters.getComputeFluctuations();
            if (flagGetFinalSymbolFluctuations != null) {
                estimateFinalSpeciesFluctuations = flagGetFinalSymbolFluctuations;
            }
            double[] finalSpeciesFluctuations = null;
            if (estimateFinalSpeciesFluctuations) {
                if (this.mUseExpressionValueCaching) {
                    this.clearExpressionValueCaches();
                }
                this.computeReactionProbabilities();
                double[] allFinalSpeciesFluctuations = SteadyStateAnalyzer.estimateSpeciesFluctuations(reactions, this.mDynamicSymbols, this.mDynamicSymbolAdjustmentVectors, this.mReactionProbabilities, symbolEvaluator);
                if (allFinalSpeciesFluctuations != null) {
                    finalSpeciesFluctuations = new double[numRequestedSymbols];
                    int i2 = 0;
                    while (i2 < numRequestedSymbols) {
                        Symbol requestedSymbol = requestedSymbols[i2];
                        int arrayIndex = requestedSymbol.getArrayIndex();
                        finalSpeciesFluctuations[i2] = 0.0;
                        if (-1 != arrayIndex && requestedSymbol.getDoubleArray() != null) {
                            finalSpeciesFluctuations[i2] = allFinalSpeciesFluctuations[arrayIndex];
                        }
                        ++i2;
                    }
                }
            }
            simulationResults = this.createSimulationResults(pStartTime, pEndTime, pSimulatorParameters, pRequestedSymbolNames, timesArray, retSymbolValues, finalSpeciesFluctuations);
        }
        return simulationResults;
    }

    public SimulatorParameters getDefaultSimulatorParameters() {
        SimulatorParameters sp = new SimulatorParameters();
        sp.setMaxAllowedRelativeError(new Double(1.0E-4));
        sp.setMaxAllowedAbsoluteError(new Double(0.01));
        sp.setComputeFluctuations(false);
        sp.setStepSizeFraction(new Double(0.001));
        sp.setNumHistoryBins(400);
        return sp;
    }

    public boolean isStochasticSimulator() {
        return false;
    }

    public boolean allowsInterrupt() {
        return true;
    }

    protected abstract void setupImpl(double var1, int var3, SimulatorParameters var4, RKScratchPad var5);

    class RKScratchPad {
        double[] k1;
        double[] k2;
        double[] k3;
        double[] k4;
        double[] ysav;
        double[] yscratch;
        double[] y1;
        double[] y2;
        double[] yscale;
        double[] dydt;
        double stepSize;
        double maxStepSize;
        double maxRelativeError;
        double maxAbsoluteError;
        int numIterations;
        MutableDouble relativeError;
        MutableDouble absoluteError;

        public RKScratchPad(int pNumVariables) {
            this.k1 = new double[pNumVariables];
            this.k2 = new double[pNumVariables];
            this.k3 = new double[pNumVariables];
            this.k4 = new double[pNumVariables];
            this.ysav = new double[pNumVariables];
            this.yscratch = new double[pNumVariables];
            this.y1 = new double[pNumVariables];
            this.y2 = new double[pNumVariables];
            this.yscale = new double[pNumVariables];
            this.dydt = new double[pNumVariables];
            this.relativeError = new MutableDouble(0.0);
            this.absoluteError = new MutableDouble(0.0);
            this.clear();
        }

        public void clear() {
            DoubleVector.zeroElements(this.k1);
            DoubleVector.zeroElements(this.k2);
            DoubleVector.zeroElements(this.k3);
            DoubleVector.zeroElements(this.k4);
            DoubleVector.zeroElements(this.ysav);
            DoubleVector.zeroElements(this.yscratch);
            DoubleVector.zeroElements(this.y1);
            DoubleVector.zeroElements(this.y2);
            DoubleVector.zeroElements(this.yscale);
            DoubleVector.zeroElements(this.dydt);
            this.stepSize = 0.0;
            this.maxStepSize = 0.0;
            this.numIterations = 0;
            this.maxRelativeError = 0.0;
            this.maxAbsoluteError = 0.0;
            this.relativeError.setValue(0.0);
            this.absoluteError.setValue(0.0);
        }
    }
}

