/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem;

import org.systemsbiology.chem.ISimulator;
import org.systemsbiology.chem.SimulatorDeterministicBase;
import org.systemsbiology.chem.SimulatorParameters;
import org.systemsbiology.math.AccuracyException;
import org.systemsbiology.math.MutableDouble;
import org.systemsbiology.util.DataNotFoundException;
import org.systemsbiology.util.IAliasableClass;

public final class SimulatorDeterministicRungeKuttaAdaptive
extends SimulatorDeterministicBase
implements IAliasableClass,
ISimulator {
    public static final String CLASS_ALIAS = "ODE-RK5-adaptive";
    private static final double SAFETY = 0.9;
    private static final double PGROW = -0.2;
    private static final double PSHRINK = -0.25;
    private static final double ERRCON = 6.0E-4;
    private static final int MAXSTEPS = 100;

    protected double iterate(double[] pNewDynamicSymbolValues) throws DataNotFoundException, AccuracyException {
        this.mRKScratchPad.stepSize = this.adaptiveStep(pNewDynamicSymbolValues);
        return this.mSymbolEvaluator.getTime();
    }

    protected void setupErrorTolerances(SimulatorParameters pSimulatorParams, SimulatorDeterministicBase.RKScratchPad pRKScratchPad) {
        double maxAbsoluteError;
        double maxRelativeError;
        Double maxRelativeErrorObj = pSimulatorParams.getMaxAllowedRelativeError();
        if (maxRelativeErrorObj == null) {
            throw new IllegalArgumentException("max fractional error must be specified");
        }
        pRKScratchPad.maxRelativeError = maxRelativeError = maxRelativeErrorObj.doubleValue();
        Double maxAbsoluteErrorObj = pSimulatorParams.getMaxAllowedAbsoluteError();
        if (maxAbsoluteErrorObj == null) {
            throw new IllegalArgumentException("max fractional error must be specified");
        }
        pRKScratchPad.maxAbsoluteError = maxAbsoluteError = maxAbsoluteErrorObj.doubleValue();
    }

    private double adaptiveStep(double[] pNewDynamicSymbolValues) throws DataNotFoundException, AccuracyException {
        double time;
        double errRatio;
        double stepSize;
        block2: {
            stepSize = this.mRKScratchPad.stepSize;
            double[] yscale = this.mRKScratchPad.yscale;
            this.computeScale(stepSize, yscale);
            errRatio = 0.0;
            time = this.mSymbolEvaluator.getTime();
            int numSteps = 0;
            double maxRelativeError = this.mRKScratchPad.maxRelativeError;
            double maxAbsoluteError = this.mRKScratchPad.maxAbsoluteError;
            MutableDouble relativeErrorObj = this.mRKScratchPad.relativeError;
            MutableDouble absoluteErrorObj = this.mRKScratchPad.absoluteError;
            do {
                this.rkqc(stepSize, yscale, pNewDynamicSymbolValues, relativeErrorObj, absoluteErrorObj);
                double relativeError = relativeErrorObj.getValue();
                double absoluteError = absoluteErrorObj.getValue();
                errRatio = Math.max(relativeError / maxRelativeError, absoluteError / maxAbsoluteError);
                if (!(errRatio > 1.0)) break block2;
                stepSize *= 0.9 * Math.exp(-0.25 * Math.log(errRatio));
            } while (++numSteps <= 100);
            throw new AccuracyException("maximum number of time step subdivisions exceeded; this model probably is too stuff for this simple Runge-Kutta adaptive integrator");
        }
        this.mSymbolEvaluator.setTime(time + stepSize);
        double nextStepSize = 0.0;
        nextStepSize = errRatio > 6.0E-4 ? 0.9 * stepSize * Math.exp(-0.2 * Math.log(errRatio)) : 4.0 * stepSize;
        double maxStepSize = this.mRKScratchPad.maxStepSize;
        if (nextStepSize > maxStepSize) {
            nextStepSize = maxStepSize;
        }
        return nextStepSize;
    }

    protected void setupImpl(double pDeltaTime, int pNumResultsTimePoints, SimulatorParameters pSimulatorParams, SimulatorDeterministicBase.RKScratchPad pRKScratchPad) {
        double maxStepSize = pDeltaTime / (double)pNumResultsTimePoints;
        if (this.hasDelayedReactionSolvers()) {
            int numHistoryBins = pSimulatorParams.getNumHistoryBins();
            double maxStepSizeDueToDelayedReactions = this.getMinDelayedReactionDelay() / (double)numHistoryBins;
            if (maxStepSize > maxStepSizeDueToDelayedReactions) {
                maxStepSize = maxStepSizeDueToDelayedReactions;
            }
        }
        pRKScratchPad.maxStepSize = maxStepSize;
    }

    public void checkSimulationParametersImpl(SimulatorParameters pSimulatorParameters, int pNumResultsTimePoints) {
        if (pSimulatorParameters.getMaxAllowedAbsoluteError() == null) {
            throw new IllegalArgumentException("missing max allowed absolute error");
        }
        if (pSimulatorParameters.getMaxAllowedRelativeError() == null) {
            throw new IllegalArgumentException("missing max allowed relative error");
        }
        this.checkSimulationParametersForDeterministicSimulator(pSimulatorParameters, pNumResultsTimePoints);
    }

    public String getAlias() {
        return CLASS_ALIAS;
    }
}

