/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem;

import org.systemsbiology.chem.ISimulator;
import org.systemsbiology.chem.SimulatorDeterministicBase;
import org.systemsbiology.chem.SimulatorParameters;
import org.systemsbiology.math.AccuracyException;
import org.systemsbiology.math.MutableDouble;
import org.systemsbiology.util.DataNotFoundException;
import org.systemsbiology.util.IAliasableClass;

public final class SimulatorDeterministicRungeKuttaFixed
extends SimulatorDeterministicBase
implements IAliasableClass,
ISimulator {
    public static final String CLASS_ALIAS = "ODE-RK5-fixed";
    private static final int NUM_ITERATIONS_BEFORE_ERROR_CHECK = 10;

    protected void setupErrorTolerances(SimulatorParameters pSimulatorParams, SimulatorDeterministicBase.RKScratchPad pRKScratchPad) {
        double maxAbsoluteError;
        double maxRelativeError;
        Double maxRelativeErrorObj = pSimulatorParams.getMaxAllowedRelativeError();
        pRKScratchPad.maxRelativeError = maxRelativeErrorObj != null ? (maxRelativeError = maxRelativeErrorObj.doubleValue()) : -1.0;
        Double maxAbsoluteErrorObj = pSimulatorParams.getMaxAllowedAbsoluteError();
        pRKScratchPad.maxAbsoluteError = maxAbsoluteErrorObj != null ? (maxAbsoluteError = maxAbsoluteErrorObj.doubleValue()) : -1.0;
    }

    protected double iterate(double[] pNewDynamicSymbolValues) throws DataNotFoundException, AccuracyException {
        double stepSize = this.mRKScratchPad.stepSize;
        int numIterations = this.mRKScratchPad.numIterations;
        if (numIterations % 10 != 0) {
            this.rk4step(stepSize, pNewDynamicSymbolValues);
        } else {
            double absoluteError;
            double relativeError;
            double[] yscale = this.mRKScratchPad.yscale;
            this.computeScale(stepSize, yscale);
            MutableDouble relativeErrorObj = this.mRKScratchPad.relativeError;
            MutableDouble absoluteErrorObj = this.mRKScratchPad.absoluteError;
            this.rkqc(stepSize, yscale, pNewDynamicSymbolValues, relativeErrorObj, absoluteErrorObj);
            double maxRelativeError = this.mRKScratchPad.maxRelativeError;
            if (maxRelativeError > 0.0 && maxRelativeError - (relativeError = relativeErrorObj.getValue()) < 0.0) {
                throw new AccuracyException("numeric approximation error exceeded threshold; try a smaller value for \"fractional step size\"");
            }
            double maxAbsoluteError = this.mRKScratchPad.maxAbsoluteError;
            if (maxAbsoluteError > 0.0 && maxAbsoluteError - (absoluteError = absoluteErrorObj.getValue()) < 0.0) {
                throw new AccuracyException("numeric approximation error exceeded threshold; try a smaller value for \"fractional step size\"");
            }
        }
        this.mSymbolEvaluator.setTime(this.mSymbolEvaluator.getTime() + stepSize);
        return this.mSymbolEvaluator.getTime();
    }

    protected double getMaxStepSize(double pDeltaTime, long pNumResultsTimePoints, SimulatorParameters pSimulatorParams) {
        double maxStepSize = pDeltaTime / (double)pNumResultsTimePoints;
        return maxStepSize;
    }

    protected void setupImpl(double pDeltaTime, int pNumResultsTimePoints, SimulatorParameters pSimulatorParams, SimulatorDeterministicBase.RKScratchPad pRKScratchPad) {
    }

    public void checkSimulationParametersImpl(SimulatorParameters pSimulatorParameters, int pNumResultsTimePoints) {
        this.checkSimulationParametersForDeterministicSimulator(pSimulatorParameters, pNumResultsTimePoints);
    }

    public String getAlias() {
        return CLASS_ALIAS;
    }
}

