/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem;

import cern.jet.random.Poisson;
import edu.cornell.lassp.houle.RngPack.RandomElement;
import edu.cornell.lassp.houle.RngPack.Ranmar;
import java.util.LinkedList;
import org.systemsbiology.chem.DelayedReactionSolver;
import org.systemsbiology.chem.Model;
import org.systemsbiology.chem.Reaction;
import org.systemsbiology.chem.SimulationController;
import org.systemsbiology.chem.SimulationProgressReporter;
import org.systemsbiology.chem.SimulationResults;
import org.systemsbiology.chem.Simulator;
import org.systemsbiology.chem.SimulatorParameters;
import org.systemsbiology.chem.Species;
import org.systemsbiology.chem.SymbolEvaluatorChem;
import org.systemsbiology.math.AccuracyException;
import org.systemsbiology.math.MutableInteger;
import org.systemsbiology.math.Symbol;
import org.systemsbiology.util.DataNotFoundException;
import org.systemsbiology.util.InvalidInputException;
import umontreal.iro.lecuyer.stat.TallyStore;

public abstract class SimulatorStochasticBase
extends Simulator {
    public static final int DEFAULT_ENSEMBLE_SIZE = 1;
    public static final boolean DEFAULT_FLAG_GET_FINAL_SYMBOL_FLUCTUATIONS = false;
    public static final int DEFAULT_NUM_HISTORY_BINS = 400;
    public static final double DEFAULT_CONFIDENCE_INTERVAL = 0.05;
    protected RandomElement mRandomNumberGenerator;
    protected Poisson mPoissonEventGenerator;
    protected DelayedReactionSolver[] mDynamicSymbolDelayedReactionAssociations;

    protected abstract void modifyDefaultSimulatorParameters(SimulatorParameters var1);

    protected void setRandomNumberGenerator(RandomElement pRandomNumberGenerator) {
        this.mRandomNumberGenerator = pRandomNumberGenerator;
    }

    protected RandomElement getRandomNumberGenerator() {
        return this.mRandomNumberGenerator;
    }

    protected static final double getRandomNumberUniformInterval(RandomElement pRandomNumberGenerator) {
        return 1.0 - pRandomNumberGenerator.raw();
    }

    protected void initializeRandomNumberGenerator() {
        this.setRandomNumberGenerator((RandomElement)new Ranmar(System.currentTimeMillis()));
    }

    protected void initializePoissonEventGenerator() {
        this.mPoissonEventGenerator = new Poisson(1.0, this.mRandomNumberGenerator);
    }

    protected void checkDynamicalSymbolsValues(boolean pSimulationIsRunning, SymbolEvaluatorChem pSymbolEvaluator) throws AccuracyException {
        int numDynamicalSymbols = this.mDynamicSymbolValues.length;
        int ctr = 0;
        while (ctr < numDynamicalSymbols) {
            double speciesValue = this.mDynamicSymbolValues[ctr];
            if (speciesValue > 1.0 && speciesValue - 1.0 == speciesValue) {
                String timeStr = null;
                timeStr = !pSimulationIsRunning ? "at the initial time" : "at time " + Double.toString(pSymbolEvaluator.getTime());
                throw new AccuracyException(String.valueOf(timeStr) + ", the species value for species \"" + this.mDynamicSymbolNames[ctr] + "\" is too large for the stochastic Simulator: " + speciesValue);
            }
            ++ctr;
        }
    }

    protected static final int getNextDelayedReactionIndex(DelayedReactionSolver[] pDelayedReactionSolvers) {
        int numDelayedReactions = pDelayedReactionSolvers.length;
        int nextReactionSolver = -1;
        double nextReactionTime = Double.POSITIVE_INFINITY;
        int ctr = numDelayedReactions;
        while (--ctr >= 0) {
            double specReactionTime;
            DelayedReactionSolver solver = pDelayedReactionSolvers[ctr];
            if (!solver.canHaveReaction() || !((specReactionTime = solver.peekNextReactionTime()) < nextReactionTime)) continue;
            nextReactionTime = specReactionTime;
            nextReactionSolver = ctr;
        }
        return nextReactionSolver;
    }

    protected final void updateSymbolValuesForReaction(int pReactionCtr, double[] pDynamicSymbolValues, DelayedReactionSolver[] pDynamicSymbolDelayedReactionAssociations, long pNumberFirings) throws DataNotFoundException {
        int numSpecies;
        Symbol[] speciesArray = (Symbol[])this.mReactionsReactantsSpecies[pReactionCtr];
        boolean[] speciesDynamicFlagArray = (boolean[])this.mReactionsReactantsDynamic[pReactionCtr];
        int[] speciesStoichiometryArray = (int[])this.mReactionsReactantsStoichiometries[pReactionCtr];
        int ctr = numSpecies = speciesArray.length;
        while (--ctr >= 0) {
            if (!speciesDynamicFlagArray[ctr]) continue;
            int n = speciesArray[ctr].getArrayIndex();
            pDynamicSymbolValues[n] = pDynamicSymbolValues[n] - (double)(pNumberFirings * (long)speciesStoichiometryArray[ctr]);
        }
        speciesArray = (Symbol[])this.mReactionsProductsSpecies[pReactionCtr];
        speciesDynamicFlagArray = (boolean[])this.mReactionsProductsDynamic[pReactionCtr];
        speciesStoichiometryArray = (int[])this.mReactionsProductsStoichiometries[pReactionCtr];
        int ctr2 = numSpecies = speciesArray.length;
        while (--ctr2 >= 0) {
            int speciesIndex;
            if (!speciesDynamicFlagArray[ctr2]) continue;
            int n = speciesIndex = speciesArray[ctr2].getArrayIndex();
            pDynamicSymbolValues[n] = pDynamicSymbolValues[n] + (double)(pNumberFirings * (long)speciesStoichiometryArray[ctr2]);
            if (pDynamicSymbolDelayedReactionAssociations == null || pDynamicSymbolDelayedReactionAssociations[speciesIndex] == null) continue;
            DelayedReactionSolver solver = pDynamicSymbolDelayedReactionAssociations[speciesIndex];
            long j = pNumberFirings;
            while (--j >= 0L) {
                solver.addReactant(this.mSymbolEvaluator);
            }
        }
    }

    protected final double chooseDeltaTimeToNextReaction(double pReactionProbability) {
        double randomNumberUniformInterval = SimulatorStochasticBase.getRandomNumberUniformInterval(this.mRandomNumberGenerator);
        double inverseRandomNumberUniformInterval = 1.0 / randomNumberUniformInterval;
        double logInverseRandomNumberUniformInterval = Math.log(inverseRandomNumberUniformInterval);
        double timeConstant = 1.0 / pReactionProbability;
        double deltaTime = timeConstant * logInverseRandomNumberUniformInterval;
        return deltaTime;
    }

    public boolean isStochasticSimulator() {
        return true;
    }

    protected abstract double iterate(MutableInteger var1) throws DataNotFoundException, IllegalStateException, AccuracyException;

    protected abstract boolean getDeadlock();

    protected abstract void prepareForStochasticSimulation(double var1, SimulatorParameters var3) throws DataNotFoundException, IllegalArgumentException;

    protected static final int getPoissonEvent(Poisson pPoissonEventGenerator, double pMean) {
        boolean gotSuccessfulEvent = false;
        int retVal = 0;
        do {
            try {
                retVal = pPoissonEventGenerator.nextInt(pMean);
                gotSuccessfulEvent = true;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.err.println("internal bug in cern.jet.random.Poisson tripped; this is being handled");
            }
        } while (!gotSuccessfulEvent);
        return retVal;
    }

    private static final void integerizeInitialData(double[] pDynamicSymbolValues, Species[] pDynamicSymbols, RandomElement pRandomNumberGenerator) {
        int numSpecies = pDynamicSymbolValues.length;
        double speciesValue = 0.0;
        int i = 0;
        while (i < numSpecies) {
            speciesValue = pDynamicSymbolValues[i];
            double floorSpeciesValue = Math.floor(speciesValue);
            if (speciesValue > floorSpeciesValue) {
                double frac = speciesValue - floorSpeciesValue;
                double randVal = pRandomNumberGenerator.raw();
                double initialVal = floorSpeciesValue;
                if (randVal < frac) {
                    initialVal += 1.0;
                }
                pDynamicSymbolValues[i] = initialVal;
            }
            ++i;
        }
    }

    protected final void initializeSimulatorStochastic(Model pModel) throws InvalidInputException {
        try {
            boolean simulationIsRunning = false;
            SymbolEvaluatorChem symbolEvaluator = null;
            this.checkDynamicalSymbolsValues(simulationIsRunning, symbolEvaluator);
        }
        catch (AccuracyException e) {
            throw new InvalidInputException(e.getMessage(), e);
        }
        this.initializeRandomNumberGenerator();
        this.initializePoissonEventGenerator();
        if (this.mDelayedReactionSolvers != null) {
            int numDynamicSymbols = this.mDynamicSymbols.length;
            this.mDynamicSymbolDelayedReactionAssociations = new DelayedReactionSolver[numDynamicSymbols];
            int ctr = 0;
            while (ctr < numDynamicSymbols) {
                this.mDynamicSymbolDelayedReactionAssociations[ctr] = null;
                ++ctr;
            }
            int numDelayedReactions = this.mDelayedReactionSolvers.length;
            int ctr2 = 0;
            while (ctr2 < numDelayedReactions) {
                DelayedReactionSolver solver = this.mDelayedReactionSolvers[ctr2];
                Species intermedSpecies = solver.getIntermedSpecies();
                String intermedSpeciesName = intermedSpecies.getName();
                Symbol intermedSpeciesSymbol = (Symbol)this.mSymbolMap.get(intermedSpeciesName);
                int intermedSpeciesIndex = intermedSpeciesSymbol.getArrayIndex();
                this.mDynamicSymbolDelayedReactionAssociations[intermedSpeciesIndex] = solver;
                ++ctr2;
            }
        } else {
            this.mDynamicSymbolDelayedReactionAssociations = null;
        }
    }

    protected final int chooseIndexOfNextReaction(double pAggregateReactionProbabilityDensity) throws IllegalArgumentException {
        double randomNumberUniformInterval = SimulatorStochasticBase.getRandomNumberUniformInterval(this.mRandomNumberGenerator);
        double cumulativeReactionProbabilityDensity = 0.0;
        double fractionOfAggregateReactionProbabilityDensity = randomNumberUniformInterval * pAggregateReactionProbabilityDensity;
        if (pAggregateReactionProbabilityDensity <= 0.0) {
            throw new IllegalArgumentException("invalid aggregate reaction probability density: " + pAggregateReactionProbabilityDensity);
        }
        int numReactions = this.mReactions.length;
        int reactionIndex = -1;
        int reactionCtr = numReactions - 1;
        while (reactionCtr >= 0) {
            double reactionProbability = this.mReactionProbabilities[reactionCtr];
            if ((cumulativeReactionProbabilityDensity += reactionProbability) >= fractionOfAggregateReactionProbabilityDensity) {
                reactionIndex = reactionCtr;
                break;
            }
            --reactionCtr;
        }
        return reactionIndex;
    }

    public final SimulationResults simulate(double pStartTime, double pEndTime, SimulatorParameters pSimulatorParameters, int pNumResultsTimePoints, String[] pRequestedSymbolNames) throws DataNotFoundException, IllegalStateException, IllegalArgumentException, AccuracyException {
        this.checkSimulationParameters(pStartTime, pEndTime, pSimulatorParameters, pNumResultsTimePoints);
        int numHistoryBins = pSimulatorParameters.getNumHistoryBins();
        if (this.mDelayedReactionSolvers != null) {
            this.resizeDelayedReactionSolvers(numHistoryBins);
        }
        double[] cfr_ignored_0 = new double[pNumResultsTimePoints];
        Object[] retSymbolValues = new Object[pNumResultsTimePoints];
        SimulationProgressReporter simulationProgressReporter = this.mSimulationProgressReporter;
        SimulationController simulationController = this.mSimulationController;
        boolean doUpdates = simulationController != null || simulationProgressReporter != null;
        long minNumMillisecondsForUpdate = 0L;
        long timeOfLastUpdateMilliseconds = 0L;
        if (doUpdates) {
            minNumMillisecondsForUpdate = this.mMinNumMillisecondsForUpdate;
            timeOfLastUpdateMilliseconds = System.currentTimeMillis();
        }
        long iterationCounter = 0L;
        if (simulationProgressReporter != null) {
            simulationProgressReporter.updateProgressStatistics(false, 0.0, iterationCounter);
        }
        double[] timesArray = SimulatorStochasticBase.createTimesArray(pStartTime, pEndTime, pNumResultsTimePoints);
        Symbol[] requestedSymbols = this.createRequestedSymbolArray(this.mSymbolMap, pRequestedSymbolNames);
        int numRequestedSymbols = requestedSymbols.length;
        int i = 0;
        while (i < pNumResultsTimePoints) {
            double[] tArray = new double[numRequestedSymbols];
            int i2 = 0;
            while (i2 < numRequestedSymbols) {
                tArray[i2] = 0.0;
                ++i2;
            }
            retSymbolValues[i] = tArray;
            ++i;
        }
        SymbolEvaluatorChem symbolEvaluator = this.mSymbolEvaluator;
        Reaction[] reactions = this.mReactions;
        double[] dynamicSymbolValues = this.mDynamicSymbolValues;
        Species[] dynamicSymbols = this.mDynamicSymbols;
        int cfr_ignored_1 = dynamicSymbolValues.length;
        RandomElement randomNumberGenerator = this.mRandomNumberGenerator;
        int ensembleSize = pSimulatorParameters.getEnsembleSize();
        boolean isCancelled = false;
        int timePointIndex = 0;
        MutableInteger lastReactionIndex = new MutableInteger(-1);
        double ensembleMult = 1.0 / (double)ensembleSize;
        double timeRangeMult = 1.0 / (pEndTime - pStartTime);
        double fractionComplete = 0.0;
        double time = 0.0;
        double previousTime = 0.0;
        long currentTimeMilliseconds = 0L;
        int simCtr = ensembleSize;
        Boolean getFinalSymbolFluctuationsObj = pSimulatorParameters.getComputeFluctuations();
        Object[] statCollector = new Object[pNumResultsTimePoints];
        int timeCtr = 0;
        while (timeCtr < pNumResultsTimePoints) {
            TallyStore[] stat = new TallyStore[numRequestedSymbols];
            int symCtr = 0;
            while (symCtr < numRequestedSymbols) {
                stat[symCtr] = new TallyStore();
                ++symCtr;
            }
            statCollector[timeCtr] = stat;
            ++timeCtr;
        }
        long[] reactionCount = new long[reactions.length];
        double[] reactionTime = new double[reactions.length];
        int i2 = 0;
        while (i2 < reactions.length) {
            reactionCount[i2] = 0L;
            reactionTime[i2] = 0.0;
            ++i2;
        }
        Object[] finalSymbolValues = null;
        double[] finalSymbolValuesElem = null;
        if (getFinalSymbolFluctuationsObj.booleanValue()) {
            if (ensembleSize < 2) {
                throw new IllegalArgumentException("an ensemble size of greater than one is required, in order to compute the final species fluctuations");
            }
            finalSymbolValues = new Object[ensembleSize];
        }
        boolean simulationIsRunning = true;
        LinkedList<Double> deadlockList = new LinkedList<Double>();
        while (--simCtr >= 0) {
            timePointIndex = 0;
            time = 0.0;
            this.prepareForSimulation(0.0);
            lastReactionIndex.setValue(-1);
            SimulatorStochasticBase.integerizeInitialData(dynamicSymbolValues, dynamicSymbols, randomNumberGenerator);
            this.prepareForStochasticSimulation(0.0, pSimulatorParameters);
            double deadlockTime = -1.0;
            while (pNumResultsTimePoints - timePointIndex > 0) {
                previousTime = time;
                time = this.iterate(lastReactionIndex);
                if (time > pEndTime) {
                    time = pEndTime;
                    symbolEvaluator.setTime(pEndTime);
                }
                ++iterationCounter;
                try {
                    if (time >= pStartTime) {
                        int n = lastReactionIndex.getValue();
                        reactionCount[n] = reactionCount[n] + 1L;
                        int n2 = lastReactionIndex.getValue();
                        reactionTime[n2] = reactionTime[n2] + (time - previousTime);
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                if (doUpdates && (currentTimeMilliseconds = System.currentTimeMillis()) - timeOfLastUpdateMilliseconds >= minNumMillisecondsForUpdate) {
                    if (simulationController != null && ((isCancelled = simulationController.handlePauseOrCancel()) || simulationController.getFinished())) break;
                    if (simulationProgressReporter != null) {
                        fractionComplete = ((double)(ensembleSize - simCtr - 1) + time * timeRangeMult) * ensembleMult;
                        simulationProgressReporter.updateProgressStatistics(false, fractionComplete, iterationCounter);
                    }
                    timeOfLastUpdateMilliseconds = System.currentTimeMillis();
                }
                if (time >= timesArray[timePointIndex]) {
                    this.checkDynamicalSymbolsValues(simulationIsRunning, symbolEvaluator);
                    timePointIndex = this.addRequestedSymbolValues(time, timePointIndex, requestedSymbols, timesArray, retSymbolValues, statCollector);
                }
                if (!this.getDeadlock() || !(deadlockTime < 0.0)) continue;
                deadlockTime = time;
            }
            if (this.getDeadlock()) {
                deadlockList.add(new Double(deadlockTime));
            }
            if (isCancelled) break;
            if (finalSymbolValues == null) continue;
            finalSymbolValuesElem = new double[numRequestedSymbols];
            finalSymbolValues[simCtr] = finalSymbolValuesElem;
            int i3 = numRequestedSymbols;
            while (--i3 >= 0) {
                finalSymbolValuesElem[i3] = symbolEvaluator.getValue(requestedSymbols[i3]);
            }
        }
        if (simulationProgressReporter != null) {
            fractionComplete = ((double)(ensembleSize - simCtr - 1) + time * timeRangeMult) * ensembleMult;
            simulationProgressReporter.updateProgressStatistics(true, fractionComplete, iterationCounter);
        }
        SimulationResults simulationResults = null;
        if (!isCancelled) {
            int timePointCtr = timePointIndex;
            while (--timePointCtr >= 0) {
                double[] symbolValues = (double[])retSymbolValues[timePointCtr];
                int symbolCtr = numRequestedSymbols;
                while (--symbolCtr >= 0) {
                    int n = symbolCtr;
                    symbolValues[n] = symbolValues[n] * ensembleMult;
                }
            }
            double[] avgReactionCount = new double[reactions.length];
            String[] reactionNames = new String[reactions.length];
            int i4 = 0;
            while (i4 < reactions.length) {
                reactionNames[i4] = reactions[i4].getName();
                avgReactionCount[i4] = (double)reactionCount[i4] * ensembleMult;
                int n = i4++;
                reactionTime[n] = reactionTime[n] * ensembleMult;
            }
            double[] retFinalSymbolFluctuations = null;
            if (finalSymbolValues != null) {
                retFinalSymbolFluctuations = new double[numRequestedSymbols];
                double[] averageFinalSymbolValues = (double[])retSymbolValues[timePointIndex - 1];
                double avg = 0.0;
                double stddev = 0.0;
                finalSymbolValuesElem = null;
                int i5 = 0;
                while (i5 < numRequestedSymbols) {
                    avg = averageFinalSymbolValues[i5];
                    stddev = 0.0;
                    int j = 0;
                    while (j < ensembleSize) {
                        finalSymbolValuesElem = (double[])finalSymbolValues[j];
                        stddev += Math.pow(avg - finalSymbolValuesElem[i5], 2.0);
                        ++j;
                    }
                    retFinalSymbolFluctuations[i5] = Math.sqrt(stddev / (double)(ensembleSize - 1));
                    ++i5;
                }
            }
            simulationResults = this.createSimulationResults(pStartTime, pEndTime, pSimulatorParameters, pRequestedSymbolNames, timesArray, retSymbolValues, retFinalSymbolFluctuations, statCollector, reactionNames, avgReactionCount, reactionTime);
            simulationResults.setDeadlockList(deadlockList);
        }
        return simulationResults;
    }

    public boolean allowsInterrupt() {
        return true;
    }

    protected void checkSimulationParametersImpl(SimulatorParameters pSimulatorParameters, int pNumResultsTimePoints) {
        Boolean flagGetFinalSymbolFluctuations = pSimulatorParameters.getComputeFluctuations();
        if (flagGetFinalSymbolFluctuations == null) {
            throw new IllegalArgumentException("missing flag for whether to obtain the final symbol fluctuations");
        }
        Integer ensembleSizeObj = pSimulatorParameters.getEnsembleSize();
        if (ensembleSizeObj == null) {
            throw new IllegalArgumentException("missing ensemble size");
        }
        int ensembleSize = ensembleSizeObj;
        if (ensembleSize <= 0) {
            throw new IllegalStateException("illegal ensemble size: " + ensembleSize);
        }
        if (this.hasDelayedReactionSolvers()) {
            Integer numHistoryBinsObj = pSimulatorParameters.getNumHistoryBins();
            if (numHistoryBinsObj == null) {
                throw new IllegalArgumentException("no number of history bins defined");
            }
            int numHistoryBins = numHistoryBinsObj;
            if (numHistoryBins <= 0) {
                throw new IllegalArgumentException("invalid number of history bins: " + numHistoryBins);
            }
        }
    }

    public SimulatorParameters getDefaultSimulatorParameters() {
        SimulatorParameters sp = new SimulatorParameters();
        sp.setEnsembleSize(new Integer(1));
        sp.setComputeFluctuations(false);
        sp.setNumHistoryBins(400);
        sp.setConfidenceInterval(0.05);
        this.modifyDefaultSimulatorParameters(sp);
        return sp;
    }
}

