/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.systemsbiology.chem.DelayedReactionSolver;
import org.systemsbiology.chem.ISimulator;
import org.systemsbiology.chem.Model;
import org.systemsbiology.chem.Reaction;
import org.systemsbiology.chem.ReservedSymbolMapperChemCommandLanguage;
import org.systemsbiology.chem.SimulatorParameters;
import org.systemsbiology.chem.SimulatorStochasticBase;
import org.systemsbiology.data.AbstractComparator;
import org.systemsbiology.data.IndexedPriorityQueue;
import org.systemsbiology.math.Expression;
import org.systemsbiology.math.MutableDouble;
import org.systemsbiology.math.MutableInteger;
import org.systemsbiology.math.ReservedSymbolMapper;
import org.systemsbiology.math.Symbol;
import org.systemsbiology.math.Value;
import org.systemsbiology.util.DataNotFoundException;
import org.systemsbiology.util.IAliasableClass;
import org.systemsbiology.util.InvalidInputException;

public final class SimulatorStochasticGibsonBruck
extends SimulatorStochasticBase
implements IAliasableClass,
ISimulator {
    public static final String CLASS_ALIAS = "gibson-bruck";
    private static final long NUMBER_FIRINGS = 1L;
    private Object[] mReactionDependencies;
    private Integer[] mReactionsRecomputeAfterEachIteration;
    private IndexedPriorityQueue mPutativeTimeToNextReactions;
    private boolean deadlock = false;

    private void initializePutativeTimeToNextReactions() {
        IndexedPriorityQueue putativeTimeToNextReactions;
        this.mPutativeTimeToNextReactions = putativeTimeToNextReactions = new IndexedPriorityQueue(new AbstractComparator(){

            public int compare(Object p1, Object p2) {
                return MutableDouble.compare((MutableDouble)p1, (MutableDouble)p2);
            }
        });
    }

    private void processExpressionDependencies(Collection pDependentSymbolNames, HashMap pSpeciesReactions, boolean pTimeSymbolAllowed, HashSet pReactionsRecomputeAfterEachIteration, Integer pReactionIndex) {
        Iterator dependentSymbolNames = pDependentSymbolNames.iterator();
        HashSet speciesReactionDependencies = null;
        while (dependentSymbolNames.hasNext()) {
            String dependentSymbolName = (String)dependentSymbolNames.next();
            speciesReactionDependencies = (HashSet)pSpeciesReactions.get(dependentSymbolName);
            if (speciesReactionDependencies != null) {
                if (pReactionsRecomputeAfterEachIteration.contains(pReactionIndex)) continue;
                speciesReactionDependencies.add(pReactionIndex);
                continue;
            }
            if (!pTimeSymbolAllowed || !dependentSymbolName.equals("time")) continue;
            pReactionsRecomputeAfterEachIteration.add(pReactionIndex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createDependencyGraph(Model pModel) throws DataNotFoundException {
        HashSet dependentReactions;
        Reaction[] reactions = this.mReactions;
        int numReactions = reactions.length;
        HashSet dependencySet = new HashSet();
        ExpressionDependencyGetter dependencyGetter = new ExpressionDependencyGetter(dependencySet);
        HashSet reactionsRecomputeAfterEachIteration = new HashSet();
        String[] speciesArray = this.mDynamicSymbolNames;
        int numSpecies = speciesArray.length;
        HashMap speciesReactions = new HashMap();
        int ctr = 0;
        while (ctr < numSpecies) {
            String speciesName = speciesArray[ctr];
            speciesReactions.put(speciesName, new HashSet());
            ++ctr;
        }
        ReservedSymbolMapper reservedSymbolMapper = this.mSymbolEvaluator.getReservedSymbolMapper();
        boolean timeSymbolAllowed = reservedSymbolMapper != null && reservedSymbolMapper instanceof ReservedSymbolMapperChemCommandLanguage;
        int j = 0;
        while (j < numReactions) {
            Reaction reaction = reactions[j];
            Value reactionRate = reaction.getRate();
            Integer reactionIndex = new Integer(j);
            if (!reactionRate.isExpression()) {
                Symbol[] reactants = (Symbol[])this.mReactionsReactantsSpecies[j];
                int numReactants = reactants.length;
                int k = 0;
                while (k < numReactants) {
                    Symbol reactant = reactants[k];
                    String reactantName = reactant.getName();
                    HashSet speciesReactionDependencies = (HashSet)speciesReactions.get(reactantName);
                    if (speciesReactionDependencies != null) {
                        if (!reactionsRecomputeAfterEachIteration.contains(reactionIndex)) {
                            speciesReactionDependencies.add(reactionIndex);
                        }
                    } else {
                        Symbol indexedReactantSymbol = (Symbol)this.mSymbolMap.get(reactantName);
                        if (indexedReactantSymbol == null) throw new IllegalStateException("unrecognized symbol: " + reactantName + " in reaction: " + reaction.getName());
                        if (indexedReactantSymbol.getValueArray() == null) throw new IllegalStateException("symbol has not been indexed: " + reactantName + " in reaction: " + reaction);
                        Value indexedReactantValue = this.mNonDynamicSymbolValues[indexedReactantSymbol.getArrayIndex()];
                        if (indexedReactantValue.isExpression()) {
                            dependencySet.clear();
                            indexedReactantValue.getExpressionValue().visit(dependencyGetter);
                            this.processExpressionDependencies(dependencySet, speciesReactions, timeSymbolAllowed, reactionsRecomputeAfterEachIteration, reactionIndex);
                        }
                    }
                    ++k;
                }
            } else {
                dependencySet.clear();
                reactionRate.getExpressionValue().visit(dependencyGetter);
                this.processExpressionDependencies(dependencySet, speciesReactions, timeSymbolAllowed, reactionsRecomputeAfterEachIteration, reactionIndex);
            }
            ++j;
        }
        Integer[] dummyArray = new Integer[]{};
        this.mReactionsRecomputeAfterEachIteration = reactionsRecomputeAfterEachIteration.toArray(dummyArray);
        HashSet[] reactionDependencies = new HashSet[numReactions];
        int j2 = 0;
        while (j2 < numReactions) {
            Reaction cfr_ignored_0 = reactions[j2];
            dependentReactions = new HashSet();
            Symbol[] productsSpecies = (Symbol[])this.mReactionsProductsSpecies[j2];
            boolean[] productsDynamic = (boolean[])this.mReactionsProductsDynamic[j2];
            int numProducts = productsSpecies.length;
            int i = 0;
            while (i < numProducts) {
                Symbol productSpecies;
                String productSpeciesName;
                HashSet speciesDependentReactions;
                if (productsDynamic[i] && (speciesDependentReactions = (HashSet)speciesReactions.get(productSpeciesName = (productSpecies = productsSpecies[i]).getName())) != null) {
                    dependentReactions.addAll(speciesDependentReactions);
                }
                ++i;
            }
            Symbol[] reactantsSpecies = (Symbol[])this.mReactionsReactantsSpecies[j2];
            boolean[] reactantsDynamic = (boolean[])this.mReactionsReactantsDynamic[j2];
            int numReactants = reactantsSpecies.length;
            int i2 = 0;
            while (i2 < numReactants) {
                Symbol reactantSpecies;
                String reactantSpeciesName;
                HashSet speciesDependentReactions;
                if (reactantsDynamic[i2] && (speciesDependentReactions = (HashSet)speciesReactions.get(reactantSpeciesName = (reactantSpecies = reactantsSpecies[i2]).getName())) != null) {
                    dependentReactions.addAll(speciesDependentReactions);
                }
                ++i2;
            }
            reactionDependencies[j2] = dependentReactions;
            ++j2;
        }
        this.mReactionDependencies = new Object[numReactions];
        int ctr2 = 0;
        while (ctr2 < numReactions) {
            dependentReactions = reactionDependencies[ctr2];
            Integer reactionCtr = new Integer(ctr2);
            if (dependentReactions.contains(reactionCtr)) {
                dependentReactions.remove(reactionCtr);
            }
            Integer[] fakeArray = new Integer[]{};
            this.mReactionDependencies[ctr2] = dependentReactions.toArray(fakeArray);
            ++ctr2;
        }
    }

    private double computeTimeToNextReaction(double[] pReactionProbabilities, int pIndex, double pTime, RandomElement pRandomNumberGenerator) {
        double probRate = pReactionProbabilities[pIndex];
        double timeOfNextReaction = 0.0;
        timeOfNextReaction = 0.0 < probRate ? pTime + this.chooseDeltaTimeToNextReaction(pReactionProbabilities[pIndex]) : Double.POSITIVE_INFINITY;
        return timeOfNextReaction;
    }

    private void computePutativeTimeToNextReactions(RandomElement pRandomNumberGenerator, double pStartTime, double[] pReactionProbabilities, Reaction[] pReactions) {
        int numReactions = pReactions.length;
        IndexedPriorityQueue putativeTimeToNextReactions = this.mPutativeTimeToNextReactions;
        putativeTimeToNextReactions.clear();
        int ctr = 0;
        while (ctr < numReactions) {
            double timeToNextReaction = this.computeTimeToNextReaction(pReactionProbabilities, ctr, pStartTime, pRandomNumberGenerator);
            MutableDouble storeTimeToNextReaction = new MutableDouble(timeToNextReaction);
            putativeTimeToNextReactions.add(storeTimeToNextReaction);
            ++ctr;
        }
    }

    private void updateReactionRateAndTime(double pCurrentTime, int pReactionIndex, int pLastReactionIndex) throws DataNotFoundException {
        MutableDouble timeOfNextReactionEventObj = (MutableDouble)this.mPutativeTimeToNextReactions.get(pReactionIndex);
        double newRate = this.computeReactionRate(pReactionIndex);
        if (pLastReactionIndex != pReactionIndex) {
            if (newRate > 0.0 && this.mReactionProbabilities[pReactionIndex] > 0.0) {
                timeOfNextReactionEventObj.setValue((timeOfNextReactionEventObj.getValue() - pCurrentTime) * this.mReactionProbabilities[pReactionIndex] / newRate + pCurrentTime);
            } else if (newRate > 0.0) {
                timeOfNextReactionEventObj.setValue(pCurrentTime + this.chooseDeltaTimeToNextReaction(newRate));
            } else {
                timeOfNextReactionEventObj.setValue(Double.POSITIVE_INFINITY);
            }
        } else {
            timeOfNextReactionEventObj.setValue(pCurrentTime + this.chooseDeltaTimeToNextReaction(newRate));
        }
        this.mPutativeTimeToNextReactions.update(pReactionIndex, timeOfNextReactionEventObj);
        this.mReactionProbabilities[pReactionIndex] = newRate;
        if (newRate == 0.0) {
            this.setDeadlock(true);
        }
    }

    protected void prepareForStochasticSimulation(double pStartTime, SimulatorParameters pSimulatorParameters) throws DataNotFoundException {
        this.computeReactionProbabilities();
        this.computePutativeTimeToNextReactions(this.mRandomNumberGenerator, pStartTime, this.mReactionProbabilities, this.mReactions);
        this.deadlock = false;
    }

    protected double iterate(MutableInteger pLastReactionIndex) throws DataNotFoundException, IllegalStateException {
        DelayedReactionSolver solver;
        double nextDelayedReactionTime;
        int nextDelayedReactionIndex;
        IndexedPriorityQueue putativeTimeToNextReactions = this.mPutativeTimeToNextReactions;
        Object[] reactionDependencies = this.mReactionDependencies;
        double time = this.mSymbolEvaluator.getTime();
        int lastReactionIndex = pLastReactionIndex.getValue();
        if (-1 != lastReactionIndex) {
            int numDependentReactions;
            int numReactionsRecomputeAfterEachIteration;
            this.updateSymbolValuesForReaction(lastReactionIndex, this.mDynamicSymbolValues, this.mDynamicSymbolDelayedReactionAssociations, 1L);
            if (this.mUseExpressionValueCaching) {
                this.clearExpressionValueCaches();
            }
            this.updateReactionRateAndTime(time, lastReactionIndex, lastReactionIndex);
            int j = numReactionsRecomputeAfterEachIteration = this.mReactionsRecomputeAfterEachIteration.length;
            while (--j >= 0) {
                int reactionCtr = this.mReactionsRecomputeAfterEachIteration[j];
                this.updateReactionRateAndTime(time, reactionCtr, lastReactionIndex);
            }
            Integer[] dependentReactions = (Integer[])reactionDependencies[lastReactionIndex];
            int ctr = numDependentReactions = dependentReactions.length;
            while (--ctr >= 0) {
                Integer dependentReactionCtrObj = dependentReactions[ctr];
                int dependentReactionCtr = dependentReactionCtrObj;
                this.updateReactionRateAndTime(time, dependentReactionCtr, lastReactionIndex);
            }
        }
        int reactionIndex = putativeTimeToNextReactions.peekIndex();
        MutableDouble timeOfNextReactionObj = (MutableDouble)putativeTimeToNextReactions.get(reactionIndex);
        double timeOfNextReaction = timeOfNextReactionObj.getValue();
        if (this.mDelayedReactionSolvers != null && (nextDelayedReactionIndex = SimulatorStochasticGibsonBruck.getNextDelayedReactionIndex(this.mDelayedReactionSolvers)) >= 0 && (nextDelayedReactionTime = (solver = this.mDelayedReactionSolvers[nextDelayedReactionIndex]).peekNextReactionTime()) < timeOfNextReaction) {
            timeOfNextReaction = nextDelayedReactionTime;
            reactionIndex = solver.getReactionIndex();
            solver.pollNextReactionTime();
        }
        pLastReactionIndex.setValue(reactionIndex);
        time = timeOfNextReaction;
        this.mSymbolEvaluator.setTime(time);
        return time;
    }

    public void initialize(Model pModel) throws DataNotFoundException, InvalidInputException {
        this.initializeSimulator(pModel);
        this.initializeSimulatorStochastic(pModel);
        this.createDependencyGraph(pModel);
        this.initializePutativeTimeToNextReactions();
        this.setInitialized(true);
    }

    protected void modifyDefaultSimulatorParameters(SimulatorParameters pSimulatorParameters) {
    }

    public String getAlias() {
        return CLASS_ALIAS;
    }

    private void setDeadlock(boolean pDeadlock) {
        this.deadlock = pDeadlock;
    }

    public boolean getDeadlock() {
        return this.deadlock;
    }

    class ExpressionDependencyGetter
    implements Expression.IVisitor {
        private Collection mDependentSymbols;

        public ExpressionDependencyGetter(Collection pDependentSymbols) {
            this.setDependentSymbols(pDependentSymbols);
        }

        public void setDependentSymbols(Collection pDependentSymbols) {
            this.mDependentSymbols = pDependentSymbols;
        }

        public Collection getDependentSymbols() {
            return this.mDependentSymbols;
        }

        public void visit(Symbol pSymbol) {
            Symbol indexedSymbol = (Symbol)SimulatorStochasticGibsonBruck.this.mSymbolMap.get(pSymbol.getName());
            if (indexedSymbol != null) {
                if (indexedSymbol.getValueArray() != null) {
                    Value symbolValue = SimulatorStochasticGibsonBruck.this.mNonDynamicSymbolValues[indexedSymbol.getArrayIndex()];
                    if (symbolValue.isExpression()) {
                        symbolValue.getExpressionValue().visit(this);
                    }
                } else {
                    this.mDependentSymbols.add(pSymbol.getName());
                }
            } else {
                this.mDependentSymbols.add(pSymbol.getName());
            }
        }
    }
}

