/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem;

import org.systemsbiology.chem.DelayedReactionSolver;
import org.systemsbiology.chem.ISimulator;
import org.systemsbiology.chem.Model;
import org.systemsbiology.chem.SimulatorParameters;
import org.systemsbiology.chem.SimulatorStochasticBase;
import org.systemsbiology.math.DoubleVector;
import org.systemsbiology.math.MutableInteger;
import org.systemsbiology.util.DataNotFoundException;
import org.systemsbiology.util.IAliasableClass;
import org.systemsbiology.util.InvalidInputException;

public final class SimulatorStochasticGillespie
extends SimulatorStochasticBase
implements IAliasableClass,
ISimulator {
    public static final String CLASS_ALIAS = "gillespie-direct";
    private static final long NUMBER_FIRINGS = 1L;
    private boolean deadlock = false;

    protected void prepareForStochasticSimulation(double pStartTime, SimulatorParameters pSimulatorParameters) {
        this.deadlock = false;
    }

    protected double iterate(MutableInteger pLastReactionIndex) throws DataNotFoundException, IllegalStateException {
        DelayedReactionSolver solver;
        double nextDelayedReactionTime;
        int nextDelayedReactionIndex;
        double time = this.mSymbolEvaluator.getTime();
        int lastReactionIndex = pLastReactionIndex.getValue();
        if (-1 != lastReactionIndex) {
            this.updateSymbolValuesForReaction(lastReactionIndex, this.mDynamicSymbolValues, this.mDynamicSymbolDelayedReactionAssociations, 1L);
        }
        this.computeReactionProbabilities();
        double aggregateReactionProbability = DoubleVector.sumElements(this.mReactionProbabilities);
        double deltaTimeToNextReaction = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.mReactionProbabilities.length) {
            if (this.mReactionProbabilities[i] == 0.0) {
                this.setDeadlock(true);
            }
            ++i;
        }
        if (aggregateReactionProbability > 0.0) {
            deltaTimeToNextReaction = this.chooseDeltaTimeToNextReaction(aggregateReactionProbability);
        }
        int reactionIndex = -1;
        if (this.mDelayedReactionSolvers != null && (nextDelayedReactionIndex = SimulatorStochasticGillespie.getNextDelayedReactionIndex(this.mDelayedReactionSolvers)) >= 0 && (nextDelayedReactionTime = (solver = this.mDelayedReactionSolvers[nextDelayedReactionIndex]).peekNextReactionTime()) < time + deltaTimeToNextReaction) {
            deltaTimeToNextReaction = nextDelayedReactionTime - time;
            reactionIndex = solver.getReactionIndex();
            solver.pollNextReactionTime();
        }
        if (-1 == reactionIndex && aggregateReactionProbability > 0.0) {
            reactionIndex = this.chooseIndexOfNextReaction(aggregateReactionProbability);
        }
        if (-1 != reactionIndex) {
            pLastReactionIndex.setValue(reactionIndex);
            time += deltaTimeToNextReaction;
        } else {
            time = Double.POSITIVE_INFINITY;
        }
        this.mSymbolEvaluator.setTime(time);
        return time;
    }

    public void initialize(Model pModel) throws DataNotFoundException, InvalidInputException {
        this.initializeSimulator(pModel);
        this.initializeSimulatorStochastic(pModel);
        this.setInitialized(true);
    }

    protected void modifyDefaultSimulatorParameters(SimulatorParameters pSimulatorParameters) {
    }

    public String getAlias() {
        return CLASS_ALIAS;
    }

    private void setDeadlock(boolean pDeadlock) {
        this.deadlock = pDeadlock;
    }

    public boolean getDeadlock() {
        return this.deadlock;
    }
}

