/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem;

import org.systemsbiology.chem.DelayedReactionSolver;
import org.systemsbiology.chem.Model;
import org.systemsbiology.chem.SimulatorParameters;
import org.systemsbiology.chem.SimulatorStochasticBase;
import org.systemsbiology.chem.SymbolEvaluatorChem;
import org.systemsbiology.math.AccuracyException;
import org.systemsbiology.math.DoubleVector;
import org.systemsbiology.math.MutableInteger;
import org.systemsbiology.util.DataNotFoundException;
import org.systemsbiology.util.InvalidInputException;

public abstract class SimulatorStochasticTauLeapBase
extends SimulatorStochasticBase {
    private static final long NUM_FIRINGS_GILLESPIE = 1L;
    private static final double DEFAULT_MAX_ALLOWED_RELATIVE_ERROR = 0.005;
    private static final double DEFAULT_STEP_SIZE_FRACTION = 0.1;
    private static final long MULTIPLIER_FOR_MIN_NUM_GILLESPIE_STEPS = 4L;
    private static final int MAX_FAILED_LEAP_ATTEMPTS_BEFORE_ABORT = 40;
    private static final int NUM_EVALUATIONS_BEFORE_RECOMPUTE_FJJP = 10;
    private static final long MIN_NUM_MILLISECONDS_FOR_PROGRESS_UPDATE = 4000L;
    private double[] mEstimatedSpeciesChange;
    protected boolean[] mReactionHasLocalSymbolsFlags;
    protected double mAllowedError;
    protected long mNumNonLeapIterationsSinceLastLeapCheck;
    protected boolean mLastIterationWasLeap;
    protected long mMinRatioOfLeapTimeToReactionTimeScale;
    public static final String CLASS_ALIAS = "gillespie-tauleap";
    protected boolean deadlock = false;

    protected void prepareForStochasticSimulation(double pStartTime, SimulatorParameters pSimulatorParameters) throws IllegalArgumentException {
        Double maxAllowedError = pSimulatorParameters.getMaxAllowedRelativeError();
        if (maxAllowedError == null) {
            throw new IllegalArgumentException("required simulator parameter maxAllowedRelativeError was not specified");
        }
        this.mAllowedError = maxAllowedError;
        Double stepSizeFraction = pSimulatorParameters.getStepSizeFraction();
        if (stepSizeFraction == null) {
            throw new IllegalArgumentException("required simulator step size fraction was not supplied");
        }
        this.mMinRatioOfLeapTimeToReactionTimeScale = (long)(1.0 / stepSizeFraction);
        this.mNumNonLeapIterationsSinceLastLeapCheck = 0L;
        this.mLastIterationWasLeap = true;
        this.deadlock = false;
    }

    protected double iterate(MutableInteger pLastReactionIndex) throws DataNotFoundException, IllegalStateException, AccuracyException {
        double time = this.mSymbolEvaluator.getTime();
        int lastReactionIndex = pLastReactionIndex.getValue();
        if (-1 != lastReactionIndex) {
            this.updateSymbolValuesForReaction(lastReactionIndex, this.mDynamicSymbolValues, this.mDynamicSymbolDelayedReactionAssociations, 1L);
        }
        int cfr_ignored_0 = this.mReactions.length;
        int cfr_ignored_1 = this.mDynamicSymbols.length;
        this.computeReactionProbabilities();
        double aggregateReactionProbability = DoubleVector.sumElements(this.mReactionProbabilities);
        double leapTime = 0.0;
        boolean doLeap = false;
        if (this.mLastIterationWasLeap || this.mNumNonLeapIterationsSinceLastLeapCheck >= 4L * this.mMinRatioOfLeapTimeToReactionTimeScale) {
            leapTime = this.getLargestJumpConsistentWithAllowedError(aggregateReactionProbability, this.mEstimatedSpeciesChange);
            if (leapTime >= (double)this.mMinRatioOfLeapTimeToReactionTimeScale / aggregateReactionProbability) {
                doLeap = true;
            }
            this.mNumNonLeapIterationsSinceLastLeapCheck = 0L;
        }
        this.mLastIterationWasLeap = doLeap;
        if (!doLeap) {
            DelayedReactionSolver solver;
            double nextDelayedReactionTime;
            int nextDelayedReactionIndex;
            double deltaTimeToNextReaction = Double.POSITIVE_INFINITY;
            ++this.mNumNonLeapIterationsSinceLastLeapCheck;
            int i = 0;
            while (i < this.mReactionProbabilities.length) {
                if (this.mReactionProbabilities[i] == 0.0) {
                    this.setDeadlock(true);
                }
                ++i;
            }
            if (aggregateReactionProbability > 0.0) {
                deltaTimeToNextReaction = this.chooseDeltaTimeToNextReaction(aggregateReactionProbability);
            }
            int reactionIndex = -1;
            if (this.mDelayedReactionSolvers != null && (nextDelayedReactionIndex = SimulatorStochasticTauLeapBase.getNextDelayedReactionIndex(this.mDelayedReactionSolvers)) >= 0 && (nextDelayedReactionTime = (solver = this.mDelayedReactionSolvers[nextDelayedReactionIndex]).peekNextReactionTime()) < time + deltaTimeToNextReaction) {
                deltaTimeToNextReaction = nextDelayedReactionTime - time;
                reactionIndex = solver.getReactionIndex();
                solver.pollNextReactionTime();
            }
            if (-1 == reactionIndex && aggregateReactionProbability > 0.0) {
                reactionIndex = this.chooseIndexOfNextReaction(aggregateReactionProbability);
            }
            if (-1 != reactionIndex) {
                pLastReactionIndex.setValue(reactionIndex);
                time += deltaTimeToNextReaction;
            } else {
                time = Double.POSITIVE_INFINITY;
            }
            this.mSymbolEvaluator.setTime(time);
        } else {
            time += leapTime;
            pLastReactionIndex.setValue(-1);
            boolean successfulLeap = false;
            int failedLeaps = 0;
            while (failedLeaps < 40) {
                successfulLeap = this.attemptLeap(leapTime);
                if (successfulLeap) break;
                ++failedLeaps;
            }
            if (!successfulLeap) {
                throw new AccuracyException("simulation became unstable; please re-run with a smaller value for the error control parameter");
            }
            DoubleVector.add(this.mEstimatedSpeciesChange, this.mDynamicSymbolValues, this.mDynamicSymbolValues);
            if (this.mDelayedReactionSolvers != null) {
                double nextDelayedReactionTime = 0.0;
                DelayedReactionSolver solver = null;
                int nextDelayedReactionIndex = -1;
                while (nextDelayedReactionTime <= time) {
                    nextDelayedReactionIndex = SimulatorStochasticTauLeapBase.getNextDelayedReactionIndex(this.mDelayedReactionSolvers);
                    if (nextDelayedReactionIndex <= -1) break;
                    solver = this.mDelayedReactionSolvers[nextDelayedReactionIndex];
                    nextDelayedReactionTime = solver.peekNextReactionTime();
                    if (!(nextDelayedReactionTime <= time)) continue;
                    this.updateSymbolValuesForReaction(solver.getReactionIndex(), this.mDynamicSymbolValues, this.mDynamicSymbolDelayedReactionAssociations, 1L);
                    solver.pollNextReactionTime();
                }
            }
            this.mSymbolEvaluator.setTime(time);
        }
        return time;
    }

    private boolean attemptLeap(double pLeapTime) throws DataNotFoundException {
        DoubleVector.zeroElements(this.mEstimatedSpeciesChange);
        int numSpecies = this.mDynamicSymbolValues.length;
        int numReactions = this.mReactions.length;
        double lambda = 0.0;
        long numFirings = 0L;
        int j = numReactions;
        while (--j >= 0) {
            lambda = pLeapTime * this.mReactionProbabilities[j];
            if (!(lambda > 0.0)) continue;
            numFirings = 1.0 / Math.sqrt(lambda) > this.mAllowedError ? (long)SimulatorStochasticTauLeapBase.getPoissonEvent(this.mPoissonEventGenerator, lambda) : Math.round(lambda);
            this.updateSymbolValuesForReaction(j, this.mEstimatedSpeciesChange, null, numFirings);
        }
        boolean succeeded = true;
        int i = numSpecies;
        while (--i >= 0) {
            if (!(this.mEstimatedSpeciesChange[i] + this.mDynamicSymbolValues[i] < 0.0)) continue;
            succeeded = false;
            break;
        }
        return succeeded;
    }

    protected abstract double computeLeapTime(double var1) throws DataNotFoundException;

    private double getLargestJumpConsistentWithAllowedError(double pSumReactionProbabilities, double[] pEstimatedSpeciesChange) throws DataNotFoundException {
        double jumpTime = this.computeLeapTime(pSumReactionProbabilities);
        int numReactions = this.mReactionProbabilities.length;
        int numSpecies = this.mDynamicSymbolValues.length;
        double rate = 0.0;
        double numFirings = 0.0;
        double[] reactionProbabilities = this.mReactionProbabilities;
        DoubleVector.zeroElements(pEstimatedSpeciesChange);
        int j = numReactions;
        while (--j >= 0) {
            rate = reactionProbabilities[j];
            numFirings = rate * jumpTime;
            if (!(numFirings > 0.0)) continue;
            this.updateSymbolValuesForReaction(j, pEstimatedSpeciesChange, null, (long)numFirings);
        }
        double frac = 0.0;
        double minFrac = 1.0;
        double oldSpeciesValue = 0.0;
        double[] dynamicSpeciesValues = this.mDynamicSymbolValues;
        int i = numSpecies;
        while (--i >= 0) {
            oldSpeciesValue = dynamicSpeciesValues[i];
            if (!(oldSpeciesValue > 0.0) || !(oldSpeciesValue + pEstimatedSpeciesChange[i] < 0.0) || !((frac = -0.5 * oldSpeciesValue / pEstimatedSpeciesChange[i]) < minFrac)) continue;
            minFrac = frac;
        }
        if (minFrac < 1.0) {
            jumpTime *= minFrac;
        }
        return jumpTime;
    }

    protected abstract void initializeTauLeap(SymbolEvaluatorChem var1) throws DataNotFoundException, InvalidInputException;

    private void initializeReactionHasLocalSymbolsFlags() {
        int numReactions = this.mReactions.length;
        this.mReactionHasLocalSymbolsFlags = new boolean[numReactions];
        int j = 0;
        while (j < numReactions) {
            this.mReactionHasLocalSymbolsFlags[j] = this.mReactions[j].hasLocalSymbols();
            ++j;
        }
    }

    public void initialize(Model pModel) throws DataNotFoundException, InvalidInputException {
        this.initializeSimulator(pModel);
        this.initializeSimulatorStochastic(pModel);
        this.initializeDynamicSymbolAdjustmentVectors();
        this.initializeReactionHasLocalSymbolsFlags();
        this.initializeTauLeap(this.mSymbolEvaluator);
        this.mEstimatedSpeciesChange = new double[this.mDynamicSymbolValues.length];
        this.mMinNumMillisecondsForUpdate = 4000L;
        this.setInitialized(true);
    }

    public String getAlias() {
        return CLASS_ALIAS;
    }

    protected void modifyDefaultSimulatorParameters(SimulatorParameters pSimulatorParameters) {
        SimulatorParameters sp = pSimulatorParameters;
        sp.setMaxAllowedRelativeError(new Double(0.005));
        sp.setStepSizeFraction(new Double(0.1));
    }

    protected void checkSimulationParametersImpl(SimulatorParameters pSimulatorParameters, int pNumResultsTimePoints) {
        super.checkSimulationParametersImpl(pSimulatorParameters, pNumResultsTimePoints);
        Double maxAllowedRelativeErrorObj = pSimulatorParameters.getMaxAllowedRelativeError();
        if (maxAllowedRelativeErrorObj == null) {
            throw new IllegalArgumentException("missing max allowed relative error");
        }
        double maxAllowedRelativeError = maxAllowedRelativeErrorObj;
        if (maxAllowedRelativeError <= 0.0 || maxAllowedRelativeError >= 1.0) {
            throw new IllegalArgumentException("invalid max allowed relative error: " + maxAllowedRelativeError);
        }
        Double stepSizeFractionObj = pSimulatorParameters.getStepSizeFraction();
        if (stepSizeFractionObj == null) {
            throw new IllegalArgumentException("missing step size fraction");
        }
        double stepSizeFraction = stepSizeFractionObj;
        if (stepSizeFraction <= 0.0) {
            throw new IllegalArgumentException("invalid step size fraction: " + stepSizeFraction);
        }
    }

    private void setDeadlock(boolean pDeadlock) {
        this.deadlock = pDeadlock;
    }

    public boolean getDeadlock() {
        return this.deadlock;
    }
}

