/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem;

import java.util.ArrayList;
import org.systemsbiology.chem.ISimulator;
import org.systemsbiology.chem.Reaction;
import org.systemsbiology.chem.Simulator;
import org.systemsbiology.chem.SimulatorStochasticTauLeapBase;
import org.systemsbiology.chem.Species;
import org.systemsbiology.chem.SymbolEvaluatorChem;
import org.systemsbiology.math.DoubleVector;
import org.systemsbiology.math.Expression;
import org.systemsbiology.util.DataNotFoundException;
import org.systemsbiology.util.IAliasableClass;

public class SimulatorStochasticTauLeapComplex
extends SimulatorStochasticTauLeapBase
implements IAliasableClass,
ISimulator {
    public static final String CLASS_ALIAS = "tauleap-complex";
    private Object[] mF;
    private Object[] mFinv;
    private int[] mJexpCols;
    private int[] mJexpRows;
    private Expression[] mJexp;
    private double[] mAdjVecVals;
    private int[] mAdjVecRows;
    private int[] mAdjVecCols;

    protected double computeLeapTime(double pSumReactionProbabilities) throws DataNotFoundException {
        double[] Fj;
        int numReactions = this.mReactionProbabilities.length;
        int cfr_ignored_0 = this.mDynamicSymbols.length;
        int numAdjVecElements = this.mAdjVecVals.length;
        int numJexpElements = this.mJexp.length;
        Object[] F = this.mF;
        Object[] Finv = this.mFinv;
        int j = numReactions;
        while (--j >= 0) {
            System.arraycopy(Finv[j], 0, F[j], 0, numReactions);
        }
        SymbolEvaluatorChem symbolEvaluator = this.mSymbolEvaluator;
        Expression derivExp = null;
        double derivVal = 0.0;
        int[] jexpRows = this.mJexpRows;
        int[] jexpCols = this.mJexpCols;
        Expression[] jexp = this.mJexp;
        int[] adjVecCols = this.mAdjVecCols;
        int[] adjVecRows = this.mAdjVecRows;
        double[] adjVecVals = this.mAdjVecVals;
        boolean[] reactionHasLocalSymbolsFlags = this.mReactionHasLocalSymbolsFlags;
        int k = numJexpElements;
        while (--k >= 0) {
            j = jexpRows[k];
            int i = jexpCols[k];
            derivExp = jexp[k];
            if (!reactionHasLocalSymbolsFlags[j]) {
                derivVal = derivExp.computeValue(symbolEvaluator);
            } else {
                symbolEvaluator.setLocalSymbolsMap(this.mReactionsLocalParamSymbolsMaps[j]);
                derivVal = derivExp.computeValue(symbolEvaluator);
                symbolEvaluator.setLocalSymbolsMap(null);
            }
            Fj = (double[])F[j];
            int kp = numAdjVecElements;
            while (--kp >= 0) {
                if (i != adjVecRows[kp]) continue;
                int n = adjVecCols[kp];
                Fj[n] = Fj[n] + adjVecVals[kp] * derivVal;
            }
        }
        double muj = 0.0;
        double sigmaj = 0.0;
        double ftimesrate = 0.0;
        double[] reactionProbabilities = this.mReactionProbabilities;
        double jumpTime = Double.MAX_VALUE;
        double muVal = 0.0;
        double sigmaVal = 0.0;
        double muFac = this.mAllowedError * pSumReactionProbabilities;
        double sigmaFac = muFac * muFac;
        j = numReactions;
        while (--j >= 0) {
            muj = 0.0;
            sigmaj = 0.0;
            Fj = (double[])F[j];
            int jp = numReactions;
            while (--jp >= 0) {
                ftimesrate = Fj[jp] * reactionProbabilities[jp];
                muj += ftimesrate;
                sigmaj += Fj[jp] * ftimesrate;
            }
            muVal = muFac / Math.abs(muj);
            if (muVal < jumpTime) {
                jumpTime = muVal;
            }
            if (!((sigmaVal = sigmaFac / sigmaj) < jumpTime)) continue;
            jumpTime = sigmaVal;
        }
        return jumpTime;
    }

    protected void initializeTauLeap(SymbolEvaluatorChem pSymbolEvaluator) throws DataNotFoundException {
        int numReactions = this.mReactions.length;
        int numSpecies = this.mDynamicSymbols.length;
        Object[] v = this.mDynamicSymbolAdjustmentVectors;
        ArrayList<Double> adjVecValues = new ArrayList<Double>();
        ArrayList<Integer> adjVecRows = new ArrayList<Integer>();
        ArrayList<Integer> adjVecCols = new ArrayList<Integer>();
        int j = 0;
        while (j < numReactions) {
            double[] vj = (double[])v[j];
            int i = 0;
            while (i < numSpecies) {
                double vji = vj[i];
                if (vji != 0.0) {
                    adjVecValues.add(new Double(vji));
                    adjVecRows.add(new Integer(i));
                    adjVecCols.add(new Integer(j));
                }
                ++i;
            }
            ++j;
        }
        int numAdjVecElements = adjVecValues.size();
        this.mAdjVecVals = new double[numAdjVecElements];
        this.mAdjVecRows = new int[numAdjVecElements];
        this.mAdjVecCols = new int[numAdjVecElements];
        int k = 0;
        while (k < numAdjVecElements) {
            this.mAdjVecVals[k] = (Double)adjVecValues.get(k);
            this.mAdjVecRows[k] = (Integer)adjVecRows.get(k);
            this.mAdjVecCols[k] = (Integer)adjVecCols.get(k);
            ++k;
        }
        ArrayList<Expression> partialDerivExpressions = new ArrayList<Expression>();
        ArrayList<Integer> partialDerivRows = new ArrayList<Integer>();
        ArrayList<Integer> partialDerivCols = new ArrayList<Integer>();
        Expression[] a = Simulator.getReactionRateExpressions(this.mReactions);
        Species species = null;
        Expression reactionRate = null;
        Expression deriv = null;
        double derivValue = 0.0;
        this.mFinv = new Object[numReactions];
        int j2 = 0;
        while (j2 < numReactions) {
            this.mFinv[j2] = new double[numReactions];
            DoubleVector.zeroElements((double[])this.mFinv[j2]);
            ++j2;
        }
        double[] v_jp = null;
        int j3 = 0;
        while (j3 < numReactions) {
            Reaction cfr_ignored_0 = this.mReactions[j3];
            reactionRate = a[j3];
            double[] Finv_j = (double[])this.mFinv[j3];
            int i = 0;
            while (i < numSpecies) {
                species = this.mDynamicSymbols[i];
                deriv = this.computeRatePartialDerivativeExpression(j3, reactionRate, species, pSymbolEvaluator);
                if (!deriv.isSimpleNumber()) {
                    partialDerivExpressions.add(deriv);
                    partialDerivRows.add(new Integer(j3));
                    partialDerivCols.add(new Integer(i));
                } else {
                    derivValue = deriv.getSimpleNumberValue();
                    if (derivValue > 0.0) {
                        int jp = 0;
                        while (jp < numReactions) {
                            v_jp = (double[])v[jp];
                            int n = jp++;
                            Finv_j[n] = Finv_j[n] + v_jp[i] * derivValue;
                        }
                    }
                }
                ++i;
            }
            ++j3;
        }
        int numPartials = partialDerivExpressions.size();
        this.mJexp = new Expression[numPartials];
        this.mJexpRows = new int[numPartials];
        this.mJexpCols = new int[numPartials];
        int k2 = 0;
        while (k2 < numPartials) {
            this.mJexp[k2] = (Expression)partialDerivExpressions.get(k2);
            this.mJexpRows[k2] = (Integer)partialDerivRows.get(k2);
            this.mJexpCols[k2] = (Integer)partialDerivCols.get(k2);
            ++k2;
        }
        this.mF = new Object[numReactions];
        int j4 = 0;
        while (j4 < numReactions) {
            this.mF[j4] = new double[numReactions];
            ++j4;
        }
    }
}

