/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem;

import org.systemsbiology.chem.ISimulator;
import org.systemsbiology.chem.Reaction;
import org.systemsbiology.chem.Simulator;
import org.systemsbiology.chem.SimulatorStochasticTauLeapBase;
import org.systemsbiology.chem.Species;
import org.systemsbiology.chem.SymbolEvaluatorChem;
import org.systemsbiology.math.Expression;
import org.systemsbiology.util.DataNotFoundException;
import org.systemsbiology.util.IAliasableClass;
import org.systemsbiology.util.InvalidInputException;

public class SimulatorStochasticTauLeapSimple
extends SimulatorStochasticTauLeapBase
implements IAliasableClass,
ISimulator {
    public static final String CLASS_ALIAS = "tauleap-simple";
    private Expression[] mMu;
    private Expression[] mSigma;

    protected double computeLeapTime(double pSumReactionProbabilities) throws DataNotFoundException {
        int numReactions = this.mReactionProbabilities.length;
        int cfr_ignored_0 = this.mDynamicSymbols.length;
        SymbolEvaluatorChem symbolEvaluator = this.mSymbolEvaluator;
        double muj = 0.0;
        double sigmaj = 0.0;
        double jumpTime = Double.MAX_VALUE;
        double muVal = 0.0;
        double sigmaVal = 0.0;
        double muFac = this.mAllowedError * pSumReactionProbabilities;
        double sigmaFac = muFac * muFac;
        int j = numReactions;
        while (--j >= 0) {
            muj = this.mMu[j].computeValue(symbolEvaluator);
            muVal = muFac / Math.abs(muj);
            if (muVal < jumpTime) {
                jumpTime = muVal;
            }
            if (!((sigmaVal = sigmaFac / (sigmaj = this.mSigma[j].computeValue(symbolEvaluator))) < jumpTime)) continue;
            jumpTime = sigmaVal;
        }
        return jumpTime;
    }

    protected void initializeTauLeap(SymbolEvaluatorChem pSymbolEvaluator) throws DataNotFoundException, InvalidInputException {
        int numReactions = this.mReactions.length;
        int numSpecies = this.mDynamicSymbols.length;
        Object[] v = this.mDynamicSymbolAdjustmentVectors;
        Expression[] a = Simulator.getReactionRateExpressions(this.mReactions);
        Species species = null;
        Expression reactionRate = null;
        Expression deriv = null;
        Object[] f = new Object[numReactions];
        Expression[] fj = null;
        int j = 0;
        while (j < numReactions) {
            if (this.mReactionHasLocalSymbolsFlags[j]) {
                throw new InvalidInputException("this model contains local parameter definitions, which are not supported by the \"tauleap-simple\" simulator; please try using a different simulator");
            }
            f[j] = fj = new Expression[numReactions];
            int jp = 0;
            while (jp < numReactions) {
                fj[jp] = null;
                ++jp;
            }
            ++j;
        }
        double vjpi = 0.0;
        int j2 = 0;
        while (j2 < numReactions) {
            Reaction cfr_ignored_0 = this.mReactions[j2];
            reactionRate = a[j2];
            fj = (Expression[])f[j2];
            int i = 0;
            while (i < numSpecies) {
                species = this.mDynamicSymbols[i];
                deriv = this.computeRatePartialDerivativeExpression(j2, reactionRate, species, pSymbolEvaluator);
                int jp = 0;
                while (jp < numReactions) {
                    if (!(deriv.isSimpleNumber() && 0.0 == deriv.getSimpleNumberValue() || (vjpi = ((double[])v[jp])[i]) == 0.0)) {
                        if (fj[jp] == null) {
                            fj[jp] = new Expression(0.0);
                        }
                        fj[jp] = Expression.add(Expression.multiply(new Expression(vjpi), deriv), fj[jp]);
                    }
                    ++jp;
                }
                ++i;
            }
            ++j2;
        }
        Expression[] mu = new Expression[numReactions];
        Expression[] sigma = new Expression[numReactions];
        Expression ajp = null;
        Expression fjjp = null;
        int j3 = 0;
        while (j3 < numReactions) {
            mu[j3] = new Expression(0.0);
            sigma[j3] = new Expression(0.0);
            fj = (Expression[])f[j3];
            int jp = 0;
            while (jp < numReactions) {
                ajp = a[jp];
                fjjp = fj[jp];
                if (!(ajp.isSimpleNumber() && 0.0 == ajp.getSimpleNumberValue() || fjjp == null)) {
                    mu[j3] = Expression.add(mu[j3], Expression.multiply(ajp, fjjp));
                    sigma[j3] = Expression.add(sigma[j3], Expression.multiply(ajp, Expression.square(fjjp)));
                }
                ++jp;
            }
            f[j3] = null;
            ++j3;
        }
        f = null;
        this.mMu = mu;
        this.mSigma = sigma;
    }
}

