/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem;

import java.util.HashMap;
import org.systemsbiology.chem.Compartment;
import org.systemsbiology.math.Expression;
import org.systemsbiology.math.ReservedSymbolMapper;
import org.systemsbiology.math.SymbolValue;
import org.systemsbiology.math.Value;

public final class Species
extends SymbolValue {
    private final String mName;
    private final Compartment mCompartment;

    public Species(String pName, Compartment pCompartment) throws IllegalArgumentException {
        super(pName);
        this.mName = pName;
        this.mCompartment = pCompartment;
    }

    public Species(SymbolValue pSymbolValue, Compartment pCompartment) throws IllegalArgumentException {
        super(pSymbolValue);
        this.mName = pSymbolValue.getSymbol().getName();
        this.mCompartment = pCompartment;
    }

    public void setSpeciesPopulation(double pSpeciesPopulation) {
        this.setValue(new Value(pSpeciesPopulation));
    }

    public void setSpeciesPopulation(Expression pSpeciesPopulation) {
        this.setValue(new Value(pSpeciesPopulation));
    }

    void addSymbolsToGlobalSymbolMap(HashMap pSymbolMap, ReservedSymbolMapper pReservedSymbolMapper) {
        this.addSymbolToMap(pSymbolMap, this.getName(), pReservedSymbolMapper);
        Compartment compartment = this.getCompartment();
        compartment.addSymbolToMap(pSymbolMap, compartment.getName(), pReservedSymbolMapper);
    }

    public String getName() {
        return this.mName;
    }

    public Compartment getCompartment() {
        return this.mCompartment;
    }

    public boolean equals(Species pSpecies) {
        return this.mName.equals(pSpecies.mName) && super.equals(pSpecies) && this.mCompartment.equals(pSpecies.mCompartment);
    }

    public Object clone() {
        Species species = new Species(this.mName, this.mCompartment);
        species.setValue((Value)this.getValue().clone());
        return species;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Species: ");
        sb.append(this.getName());
        sb.append(" [Value: ");
        sb.append(this.getValue().toString());
        sb.append(", Compartment: ");
        sb.append(this.getCompartment().getName());
        sb.append("]");
        return sb.toString();
    }
}

