/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.EigenvalueDecomposition;
import java.util.HashMap;
import org.systemsbiology.chem.Model;
import org.systemsbiology.chem.Reaction;
import org.systemsbiology.chem.Simulator;
import org.systemsbiology.chem.Species;
import org.systemsbiology.chem.SymbolEvaluatorChem;
import org.systemsbiology.math.Expression;
import org.systemsbiology.util.DataNotFoundException;

public final class SteadyStateAnalyzer {
    private Model mModel;

    public SteadyStateAnalyzer(Model pModel) {
        this.mModel = pModel;
    }

    public static Object[] computeJacobian(Expression[] pReactionRateExpressions, Reaction[] pReactions, Species[] pSpecies, Object[] pReactionSpeciesAdjustmentVectors, SymbolEvaluatorChem pSymbolEvaluator) throws DataNotFoundException {
        int numReactions = pReactions.length;
        Object[] v = pReactionSpeciesAdjustmentVectors;
        int numSpecies = pSpecies.length;
        Object[] jac = new Object[numSpecies];
        Object[] partials = new Object[numSpecies];
        HashMap[] localSymbolsMaps = new HashMap[numReactions];
        int j = 0;
        while (j < numReactions) {
            localSymbolsMaps[j] = Simulator.createLocalSymbolsMap(pReactions[j]);
            ++j;
        }
        int i = 0;
        while (i < numSpecies) {
            Species species = pSpecies[i];
            species.getSymbol();
            double[] partialsi = new double[numReactions];
            partials[i] = partialsi;
            int j2 = 0;
            while (j2 < numReactions) {
                Reaction cfr_ignored_0 = pReactions[j2];
                Expression reactionRateExpression = pReactionRateExpressions[j2];
                partialsi[j2] = Simulator.computeRatePartialDerivativeExpression(reactionRateExpression, species, pSymbolEvaluator, localSymbolsMaps[j2]).computeValue(pSymbolEvaluator);
                ++j2;
            }
            ++i;
        }
        i = 0;
        while (i < numSpecies) {
            double[] jaci = new double[numSpecies];
            jac[i] = jaci;
            int ip = 0;
            while (ip < numSpecies) {
                double[] partialsip = (double[])partials[ip];
                double sum = 0.0;
                int j3 = 0;
                while (j3 < numReactions) {
                    double[] vj = (double[])v[j3];
                    sum += vj[i] * partialsip[j3];
                    ++j3;
                }
                jaci[ip] = sum;
                ++ip;
            }
            ++i;
        }
        return jac;
    }

    public static double[] estimateSpeciesFluctuations(Reaction[] pReactions, Species[] pSpecies, Object[] pReactionSpeciesAdjustmentVectors, double[] pReactionProbabilities, SymbolEvaluatorChem pSymbolEvaluator) throws DataNotFoundException {
        int i;
        int numReactions = pReactions.length;
        int numSpecies = pSpecies.length;
        Expression[] a = Simulator.getReactionRateExpressions(pReactions);
        Object[] Jdbl = SteadyStateAnalyzer.computeJacobian(a, pReactions, pSpecies, pReactionSpeciesAdjustmentVectors, pSymbolEvaluator);
        Algebra algebra = new Algebra();
        DoubleFactory2D df = DoubleFactory2D.sparse;
        DoubleMatrix2D J = df.make(numSpecies, numSpecies);
        int i2 = 0;
        while (i2 < numSpecies) {
            double[] Jdbl_i = (double[])Jdbl[i2];
            int ip = 0;
            while (ip < numSpecies) {
                J.set(i2, ip, Jdbl_i[ip]);
                ++ip;
            }
            ++i2;
        }
        EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(J);
        DoubleMatrix2D P = eigenvalueDecomposition.getV();
        DoubleMatrix1D u = eigenvalueDecomposition.getRealEigenvalues();
        DoubleMatrix2D T = df.make(numSpecies, numSpecies);
        double eigenvalueRealPart = 0.0;
        double matElem = 0.0;
        boolean gotNegEigenvalue = false;
        int i3 = 0;
        while (i3 < numSpecies) {
            eigenvalueRealPart = u.get(i3);
            if (eigenvalueRealPart < 0.0) {
                matElem = 1.0 / Math.sqrt(Math.abs(eigenvalueRealPart));
                gotNegEigenvalue = true;
            } else {
                matElem = 0.0;
            }
            T.set(i3, i3, matElem);
            ++i3;
        }
        if (!gotNegEigenvalue) {
            return null;
        }
        DoubleMatrix2D Pinv = algebra.inverse(P);
        DoubleMatrix2D PT = algebra.mult(P, T);
        DoubleMatrix2D Q = algebra.mult(PT, Pinv);
        Object[] v = pReactionSpeciesAdjustmentVectors;
        DoubleMatrix2D r = df.make(numSpecies, numReactions);
        int j = 0;
        while (j < numReactions) {
            double[] vj = (double[])v[j];
            double sum = 0.0;
            int i4 = 0;
            while (i4 < numSpecies) {
                sum += Math.abs(vj[i4]);
                ++i4;
            }
            double norm = 1.0 / Math.sqrt(sum);
            i = 0;
            while (i < numSpecies) {
                r.set(i, j, vj[i] * norm);
                ++i;
            }
            ++j;
        }
        DoubleMatrix2D Qr = algebra.mult(Q, r);
        DoubleMatrix2D w = df.make(numSpecies, numReactions);
        int i5 = 0;
        while (i5 < numSpecies) {
            int j2 = 0;
            while (j2 < numReactions) {
                w.set(i5, j2, 0.5 * Math.pow(Qr.get(i5, j2), 2.0));
                ++j2;
            }
            ++i5;
        }
        DoubleFactory1D df1 = DoubleFactory1D.dense;
        DoubleMatrix1D s = df1.make(numReactions);
        int j3 = 0;
        while (j3 < numReactions) {
            s.set(j3, pReactionProbabilities[j3]);
            ++j3;
        }
        DoubleMatrix1D var = algebra.mult(w, s);
        double[] varArray = var.toArray();
        i = 0;
        while (i < numSpecies) {
            varArray[i] = Math.sqrt(varArray[i]);
            ++i;
        }
        return varArray;
    }
}

