/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem;

import java.util.HashMap;
import org.systemsbiology.math.Expression;
import org.systemsbiology.math.ReservedSymbolMapper;
import org.systemsbiology.math.Symbol;
import org.systemsbiology.math.SymbolEvaluationPostProcessor;
import org.systemsbiology.math.SymbolEvaluator;
import org.systemsbiology.math.Value;
import org.systemsbiology.util.DataNotFoundException;

public final class SymbolEvaluatorChem
extends SymbolEvaluator {
    private final HashMap mSymbolsMap;
    private double mTime;
    private HashMap mLocalSymbolsMap;
    private final ReservedSymbolMapper mReservedSymbolMapper;

    public SymbolEvaluatorChem(boolean pUseExpressionValueCaching, SymbolEvaluationPostProcessor pSymbolEvaluationPostProcessor, ReservedSymbolMapper pReservedSymbolMapper, HashMap pSymbolsMap) {
        super(pUseExpressionValueCaching, pSymbolEvaluationPostProcessor);
        this.mReservedSymbolMapper = pReservedSymbolMapper;
        this.mSymbolsMap = pSymbolsMap;
    }

    public ReservedSymbolMapper getReservedSymbolMapper() {
        return this.mReservedSymbolMapper;
    }

    public void setLocalSymbolsMap(HashMap pLocalSymbolsMap) {
        this.mLocalSymbolsMap = pLocalSymbolsMap;
    }

    public void setTime(double pTime) {
        this.mTime = pTime;
    }

    public double getTime() {
        return this.mTime;
    }

    HashMap getSymbolsMap() {
        return this.mSymbolsMap;
    }

    public Expression getExpressionValue(Symbol pSymbol) throws DataNotFoundException {
        Expression retVal = null;
        String symbolName = pSymbol.getName();
        Symbol symbol = (Symbol)this.mSymbolsMap.get(symbolName);
        if (symbol == null && (symbol = (Symbol)this.mLocalSymbolsMap.get(symbolName)) == null) {
            throw new DataNotFoundException("unable to find symbol in symbol map, symbol is \"" + symbolName + "\"");
        }
        Value[] valueArray = symbol.getValueArray();
        int arrayIndex = symbol.getArrayIndex();
        if (-1 == arrayIndex) {
            throw new IllegalStateException("null array index for symbol \"" + symbolName + "\"");
        }
        if (valueArray != null) {
            Value value = valueArray[arrayIndex];
            if (value == null) {
                throw new IllegalStateException("unexpected null value for symbol: " + symbolName);
            }
            if (value.isExpression()) {
                retVal = value.getExpressionValue();
            }
        }
        return retVal;
    }

    public double getUnindexedValue(Symbol pSymbol) throws DataNotFoundException, IllegalStateException {
        if (-1 != pSymbol.getArrayIndex()) {
            throw new IllegalStateException("getUnindexedValue() was called on symbol with non-null array index: " + pSymbol.getName());
        }
        if (this.mReservedSymbolMapper != null && this.mReservedSymbolMapper.isReservedSymbol(pSymbol)) {
            return this.mReservedSymbolMapper.getReservedSymbolValue(pSymbol, this);
        }
        String symbolName = pSymbol.getName();
        Symbol indexedSymbol = null;
        if (this.mLocalSymbolsMap != null) {
            indexedSymbol = (Symbol)this.mLocalSymbolsMap.get(symbolName);
        }
        if (indexedSymbol == null) {
            indexedSymbol = (Symbol)this.mSymbolsMap.get(symbolName);
        }
        if (indexedSymbol == null) {
            throw new DataNotFoundException("unable to obtain value for symbol: " + symbolName);
        }
        pSymbol.copyIndexInfo(indexedSymbol);
        return this.getValue(pSymbol);
    }

    public boolean hasValue(Symbol pSymbol) {
        boolean hasValue = false;
        if (this.mReservedSymbolMapper != null && this.mReservedSymbolMapper.isReservedSymbol(pSymbol)) {
            hasValue = true;
        }
        if (!hasValue && this.mSymbolsMap.get(pSymbol.getName()) != null) {
            hasValue = true;
        }
        return hasValue;
    }

    public Symbol getSymbol(String pSymbolName) {
        return (Symbol)this.mSymbolsMap.get(pSymbolName);
    }
}

