/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem;

import java.text.DecimalFormatSymbols;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;

public class TimeSeriesOutputFormat {
    private final String mName;
    private final char mCommentChar;
    private static final HashMap mMap = new HashMap();
    private final String mNaN;
    private final String mInfinity;
    private final boolean mLocalizeDecimal;
    public static final TimeSeriesOutputFormat CSV_EXCEL = new TimeSeriesOutputFormat("CSV-excel", '#', null, null, false);
    public static final TimeSeriesOutputFormat CSV_MATLAB = new TimeSeriesOutputFormat("CSV-matlab", '%', "nan", "inf", false);
    public static final TimeSeriesOutputFormat CSV_GNUPLOT = new TimeSeriesOutputFormat("CSV-gnuplot", '#', "nan", "inf", false);

    private TimeSeriesOutputFormat(String pName, char pCommentChar, String pNaN, String pInfinity, boolean pLocalizeDecimal) {
        this.mName = pName;
        this.mCommentChar = pCommentChar;
        this.mNaN = pNaN;
        this.mInfinity = pInfinity;
        this.mLocalizeDecimal = pLocalizeDecimal;
        mMap.put(pName, this);
    }

    public String toString() {
        return this.mName;
    }

    public static TimeSeriesOutputFormat get(String pName) {
        return (TimeSeriesOutputFormat)mMap.get(pName);
    }

    public void updateDecimalFormatSymbols(DecimalFormatSymbols pDecimalFormatSymbols) {
        if (this.mNaN != null) {
            pDecimalFormatSymbols.setNaN(this.mNaN);
        }
        if (this.mInfinity != null) {
            pDecimalFormatSymbols.setInfinity(this.mInfinity);
        }
        if (!this.mLocalizeDecimal) {
            pDecimalFormatSymbols.setDecimalSeparator('.');
        }
    }

    public String getNaN() {
        return this.mNaN;
    }

    public String getInfinity() {
        return this.mInfinity;
    }

    public static String[] getSortedFileFormatNames() {
        Set fileFormatNamesSet = mMap.keySet();
        LinkedList fileFormatNamesList = new LinkedList(fileFormatNamesSet);
        Collections.sort(fileFormatNamesList);
        return fileFormatNamesList.toArray(new String[0]);
    }

    public char getCommentChar() {
        return this.mCommentChar;
    }
}

