/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem;

import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import org.systemsbiology.chem.ReactionCount;
import org.systemsbiology.chem.SimulationResults;
import org.systemsbiology.chem.TimeSeriesOutputFormat;
import org.systemsbiology.math.Value;
import umontreal.iro.lecuyer.stat.TallyStore;

public class TimeSeriesSymbolValuesReporter {
    public static final void reportTimeSeriesSymbolValues(PrintWriter pPrintWriter, String[] pRequestedSymbolNames, double[] pTimeValues, Object[] pSymbolValues, TimeSeriesOutputFormat pTimeSeriesOutputFormat) throws IllegalArgumentException {
        DecimalFormat nf = new DecimalFormat("0.######E0");
        DecimalFormatSymbols decimalFormatSymbols = nf.getDecimalFormatSymbols();
        pTimeSeriesOutputFormat.updateDecimalFormatSymbols(decimalFormatSymbols);
        nf.setDecimalFormatSymbols(decimalFormatSymbols);
        nf.setGroupingUsed(false);
        TimeSeriesSymbolValuesReporter.reportTimeSeriesSymbolValues(pPrintWriter, pRequestedSymbolNames, pTimeValues, pSymbolValues, nf, pTimeSeriesOutputFormat);
    }

    public static final void reportTimeSeriesSymbolValues(PrintWriter pPrintWriter, String[] pRequestedSymbolNames, double[] pTimeValues, Object[] pSymbolValues, NumberFormat pNumberFormat, TimeSeriesOutputFormat pTimeSeriesOutputFormat) throws IllegalArgumentException {
        int numSymbols = pRequestedSymbolNames.length;
        if (pTimeSeriesOutputFormat == null) {
            throw new IllegalArgumentException("required argument pTimeSeriesOutputFormat was passed as null");
        }
        if (pNumberFormat == null) {
            throw new IllegalArgumentException("required argument pNumberFormat was passed as null");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(Character.toString(pTimeSeriesOutputFormat.getCommentChar()));
        sb.append(" time, ");
        int symCtr = 0;
        while (symCtr < numSymbols) {
            sb.append(pRequestedSymbolNames[symCtr]);
            if (symCtr < numSymbols - 1) {
                sb.append(", ");
            }
            ++symCtr;
        }
        sb.append("\n");
        int numTimePoints = pTimeValues.length;
        int ctr = 0;
        while (ctr < numTimePoints) {
            double[] symbolValue = (double[])pSymbolValues[ctr];
            if (symbolValue == null) break;
            sb.append(String.valueOf(pNumberFormat.format(pTimeValues[ctr])) + ", ");
            int symCtr2 = 0;
            while (symCtr2 < numSymbols) {
                sb.append(pNumberFormat.format(symbolValue[symCtr2]));
                if (symCtr2 < numSymbols - 1) {
                    sb.append(", ");
                }
                ++symCtr2;
            }
            sb.append("\n");
            ++ctr;
        }
        pPrintWriter.println(sb.toString());
    }

    public static final double reportTimeSeriesSymbolValues(PrintWriter pPrintWriter, String[] pRequestedSymbolNames, double[] pTimeValues, Object[] pSymbolValues, NumberFormat pNumberFormat, TimeSeriesOutputFormat pTimeSeriesOutputFormat, double pConfidenceInterval) throws IllegalArgumentException {
        int numSymbols = pRequestedSymbolNames.length;
        double notAlpha = 1.0 - pConfidenceInterval;
        double highestValue = 0.0;
        if (pTimeSeriesOutputFormat == null) {
            throw new IllegalArgumentException("required argument pTimeSeriesOutputFormat was passed as null");
        }
        if (pNumberFormat == null) {
            throw new IllegalArgumentException("required argument pNumberFormat was passed as null");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(Character.toString(pTimeSeriesOutputFormat.getCommentChar()));
        sb.append(" time, ");
        int symCtr = 0;
        while (symCtr < numSymbols) {
            sb.append(String.valueOf(pRequestedSymbolNames[symCtr]) + "(opn) ");
            sb.append(String.valueOf(pRequestedSymbolNames[symCtr]) + "(max) ");
            sb.append(String.valueOf(pRequestedSymbolNames[symCtr]) + "(min) ");
            sb.append(String.valueOf(pRequestedSymbolNames[symCtr]) + "(cls)");
            if (symCtr < numSymbols - 1) {
                sb.append(", ");
            }
            ++symCtr;
        }
        sb.append("\n");
        int numTimePoints = pTimeValues.length;
        TallyStore[] timeSnapshot = null;
        double[] values = new double[2];
        int i = 0;
        while (i < numTimePoints) {
            timeSnapshot = (TallyStore[])pSymbolValues[i];
            sb.append(String.valueOf(pNumberFormat.format(pTimeValues[i])) + ", ");
            int j = 0;
            while (j < numSymbols) {
                timeSnapshot[j].confidenceIntervalStudent(notAlpha, values);
                sb.append(String.valueOf(pNumberFormat.format(values[0] + values[1])) + " " + pNumberFormat.format(timeSnapshot[j].max()) + " " + pNumberFormat.format(timeSnapshot[j].min()) + " " + pNumberFormat.format(values[0] - values[1]));
                if (timeSnapshot[j].max() > highestValue) {
                    highestValue = timeSnapshot[j].max();
                }
                if (j < numSymbols - 1) {
                    sb.append(", ");
                }
                ++j;
            }
            sb.append("\n");
            ++i;
        }
        pPrintWriter.println(sb.toString());
        return highestValue;
    }

    public static final void reportProfileValues(PrintWriter pPrintWriter, Object[] pProfileValues, NumberFormat pNumberFormat, TimeSeriesOutputFormat pTimeSeriesOutputFormat) throws IllegalArgumentException {
        int profileValuesNum = pProfileValues.length;
        boolean error = false;
        if (pTimeSeriesOutputFormat == null) {
            throw new IllegalArgumentException("required argument pTimeSeriesOutputFormat was passed as null");
        }
        if (pNumberFormat == null) {
            throw new IllegalArgumentException("required argument pNumberFormat was passed as null");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(Character.toString(pTimeSeriesOutputFormat.getCommentChar()));
        sb.append(" profile\n");
        int i = 0;
        while (i < profileValuesNum) {
            sb.append(String.valueOf(i) + " " + ((ReactionCount)pProfileValues[i]).getCounter());
            if (i < profileValuesNum - 1) {
                sb.append("\n");
            }
            if (((ReactionCount)pProfileValues[i]).getCounter() == 0L) {
                error = true;
            }
            ++i;
        }
        pPrintWriter.println(sb.toString());
        if (error) {
            System.err.println("\none or more reactions have never been fired");
        }
    }

    public static final double reportTimeSeriesSymbolValues(PrintWriter pPrintWriter, String[] pRequestedSymbolNames, SimulationResults[] simulationResultsArray, Value[] midValue, String changeParameterName, NumberFormat pNumberFormat, TimeSeriesOutputFormat pTimeSeriesOutputFormat) throws IllegalArgumentException {
        double highestValue = 0.0;
        int numSymbols = pRequestedSymbolNames.length;
        if (pTimeSeriesOutputFormat == null) {
            throw new IllegalArgumentException("required argument pTimeSeriesOutputFormat was passed as null");
        }
        if (pNumberFormat == null) {
            throw new IllegalArgumentException("required argument pNumberFormat was passed as null");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(Character.toString(pTimeSeriesOutputFormat.getCommentChar()));
        sb.append(" time, (" + changeParameterName + "), ");
        int symCtr = 0;
        while (symCtr < numSymbols) {
            sb.append(pRequestedSymbolNames[symCtr]);
            if (symCtr < numSymbols - 1) {
                sb.append(", ");
            }
            ++symCtr;
        }
        sb.append("\n");
        int numTimePoints = simulationResultsArray[0].getResultsTimeValues().length;
        int numChangeParameter = simulationResultsArray.length;
        int ctr = 0;
        while (ctr < numTimePoints) {
            int cp = 0;
            while (cp < numChangeParameter) {
                double[] symbolValue = (double[])simulationResultsArray[cp].getResultsSymbolValues()[ctr];
                if (symbolValue == null) break;
                sb.append(String.valueOf(pNumberFormat.format(simulationResultsArray[cp].getResultsTimeValues()[ctr])) + ", ");
                sb.append(String.valueOf(pNumberFormat.format(midValue[cp].getValue())) + ", ");
                int symCtr2 = 0;
                while (symCtr2 < numSymbols) {
                    if (symbolValue[symCtr2] > highestValue) {
                        highestValue = symbolValue[symCtr2];
                    }
                    sb.append(pNumberFormat.format(symbolValue[symCtr2]));
                    if (symCtr2 < numSymbols - 1) {
                        sb.append(", ");
                    }
                    ++symCtr2;
                }
                sb.append("\n");
                ++cp;
            }
            sb.append("\n");
            ++ctr;
        }
        pPrintWriter.println(sb.toString());
        return highestValue;
    }
}

