/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem.odetojava;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import odeToJava.modules.ODE;
import odeToJava.modules.ODERecorder;
import odeToJava.modules.Span;
import org.systemsbiology.chem.DelayedReactionSolver;
import org.systemsbiology.chem.Model;
import org.systemsbiology.chem.SimulationFailedException;
import org.systemsbiology.chem.SimulationProgressReporter;
import org.systemsbiology.chem.SimulationResults;
import org.systemsbiology.chem.Simulator;
import org.systemsbiology.chem.SimulatorParameters;
import org.systemsbiology.chem.SteadyStateAnalyzer;
import org.systemsbiology.chem.SymbolEvaluatorChem;
import org.systemsbiology.math.AccuracyException;
import org.systemsbiology.math.Symbol;
import org.systemsbiology.util.DataNotFoundException;
import org.systemsbiology.util.InvalidInputException;

public abstract class SimulatorOdeToJavaBase
extends Simulator
implements ODE,
ODERecorder {
    public static final double DEFAULT_MAX_ALLOWED_RELATIVE_ERROR = 1.0E-4;
    public static final double DEFAULT_MAX_ALLOWED_ABSOLUTE_ERROR = 1.0E-4;
    public static final boolean DEFAULT_FLAG_GET_FINAL_SYMBOL_FLUCTUATIONS = false;
    protected static final int DEFAULT_NUM_HISTORY_BINS = 400;
    private static final double DEFAULT_STEP_SIZE_FRACTION = 0.001;
    private long mIterationCounter;
    private double[] mDerivative;
    private double[] mScratch;
    private boolean mSimulationCancelled;
    private double mTimeRangeMult;
    private long mTimeOfLastUpdateMilliseconds;
    boolean mSimulationCancelledEventNegReturnFlag;
    private boolean mDoUpdates;
    private double mFractionComplete;

    protected abstract void runExternalSimulation(Span var1, double[] var2, double var3, double var5, double var7, String var9);

    public SimulationResults simulate(double pStartTime, double pEndTime, SimulatorParameters pSimulatorParameters, int pNumResultsTimePoints, String[] pRequestedSymbolNames) throws DataNotFoundException, IllegalStateException, IllegalArgumentException, AccuracyException, SimulationFailedException {
        this.checkSimulationParameters(pStartTime, pEndTime, pSimulatorParameters, pNumResultsTimePoints);
        int numHistoryBins = pSimulatorParameters.getNumHistoryBins();
        if (this.mDelayedReactionSolvers != null) {
            this.resizeDelayedReactionSolvers(numHistoryBins);
        }
        double[] cfr_ignored_0 = new double[pNumResultsTimePoints];
        Object[] retSymbolValues = new Object[pNumResultsTimePoints];
        SimulationProgressReporter simulationProgressReporter = this.mSimulationProgressReporter;
        this.mDoUpdates = this.mSimulationController != null || simulationProgressReporter != null;
        this.mFractionComplete = 0.0;
        this.mTimeOfLastUpdateMilliseconds = 0L;
        if (this.mDoUpdates) {
            this.mTimeOfLastUpdateMilliseconds = System.currentTimeMillis();
        }
        this.mIterationCounter = 0L;
        if (simulationProgressReporter != null) {
            simulationProgressReporter.updateProgressStatistics(false, this.mFractionComplete, this.mIterationCounter);
        }
        double[] timesArray = SimulatorOdeToJavaBase.createodeToJavaTimesArray(pStartTime, pEndTime, pNumResultsTimePoints);
        Span simulationTimeSpan = new Span(timesArray);
        timesArray = SimulatorOdeToJavaBase.createTimesArray(pStartTime, pEndTime, pNumResultsTimePoints);
        int cfr_ignored_1 = timesArray.length;
        Symbol[] requestedSymbols = this.createRequestedSymbolArray(this.mSymbolMap, pRequestedSymbolNames);
        int numRequestedSymbols = pRequestedSymbolNames.length;
        int i = 0;
        while (i < pNumResultsTimePoints) {
            double[] tArray = new double[numRequestedSymbols];
            int i2 = 0;
            while (i2 < numRequestedSymbols) {
                tArray[i2] = 0.0;
                ++i2;
            }
            retSymbolValues[i] = tArray;
            ++i;
        }
        double deltaTime = pEndTime - pStartTime;
        double initialStepSize = pSimulatorParameters.getStepSizeFraction() * deltaTime;
        double maxAllowedRelativeError = pSimulatorParameters.getMaxAllowedRelativeError();
        double maxAllowedAbsoluteError = pSimulatorParameters.getMaxAllowedAbsoluteError();
        File tempOutputFile = null;
        try {
            tempOutputFile = File.createTempFile("simulationOutput", ".txt");
        }
        catch (IOException e) {
            throw new SimulationFailedException("unable to open temporary output file, error message is: " + e.toString());
        }
        String tempOutputFileName = tempOutputFile.getAbsolutePath();
        this.prepareForSimulation(0.0);
        this.mSimulationCancelled = false;
        this.mSimulationCancelledEventNegReturnFlag = false;
        this.mTimeRangeMult = 1.0 / deltaTime;
        this.runExternalSimulation(simulationTimeSpan, this.mDynamicSymbolValues, initialStepSize, maxAllowedRelativeError, maxAllowedAbsoluteError, tempOutputFileName);
        if (!this.mSimulationCancelled) {
            this.mFractionComplete = 1.0;
        }
        if (simulationProgressReporter != null) {
            simulationProgressReporter.updateProgressStatistics(true, this.mFractionComplete, this.mIterationCounter);
        }
        SimulationResults simulationResults = null;
        if (!this.mSimulationCancelled) {
            try {
                this.readSimulationOutput(tempOutputFile, this.mSymbolEvaluator, this.mDynamicSymbolValues, pStartTime, pEndTime, pNumResultsTimePoints, requestedSymbols, timesArray, retSymbolValues);
            }
            catch (InvalidInputException e) {
                tempOutputFile.delete();
                throw new SimulationFailedException("unable to parse the output from the simulator; error message is: " + e.toString());
            }
            catch (FileNotFoundException e) {
                tempOutputFile.delete();
                throw new SimulationFailedException("unable to parse the output from the simulator; error message is: " + e.toString());
            }
            catch (IOException e) {
                throw new SimulationFailedException("unable to read the temporary simulation output file; error message is: " + e.toString());
            }
            boolean estimateFinalSpeciesFluctuations = false;
            Boolean flagGetFinalSymbolFluctuations = pSimulatorParameters.getComputeFluctuations();
            double[] finalSpeciesFluctuations = null;
            if (flagGetFinalSymbolFluctuations != null) {
                estimateFinalSpeciesFluctuations = flagGetFinalSymbolFluctuations;
            }
            if (estimateFinalSpeciesFluctuations) {
                if (this.mUseExpressionValueCaching) {
                    this.clearExpressionValueCaches();
                }
                this.computeReactionProbabilities();
                double[] allFinalSpeciesFluctuations = SteadyStateAnalyzer.estimateSpeciesFluctuations(this.mReactions, this.mDynamicSymbols, this.mDynamicSymbolAdjustmentVectors, this.mReactionProbabilities, this.mSymbolEvaluator);
                if (allFinalSpeciesFluctuations != null) {
                    finalSpeciesFluctuations = new double[numRequestedSymbols];
                    int i2 = 0;
                    while (i2 < numRequestedSymbols) {
                        Symbol requestedSymbol = requestedSymbols[i2];
                        int arrayIndex = requestedSymbol.getArrayIndex();
                        finalSpeciesFluctuations[i2] = 0.0;
                        if (-1 != arrayIndex && requestedSymbol.getDoubleArray() != null) {
                            finalSpeciesFluctuations[i2] = allFinalSpeciesFluctuations[arrayIndex];
                        }
                        ++i2;
                    }
                }
            }
            simulationResults = this.createSimulationResults(pStartTime, pEndTime, pSimulatorParameters, pRequestedSymbolNames, timesArray, retSymbolValues, finalSpeciesFluctuations);
        }
        return simulationResults;
    }

    protected void readSimulationOutput(File pSimulationResultsFile, SymbolEvaluatorChem pSymbolEvaluator, double[] pDynamicSymbolValues, double pStartTime, double pEndTime, int pNumResultsTimePoints, Symbol[] pRequestedSymbols, double[] pRetResultsTimeValues, Object[] pRetResultsSymbolValues) throws InvalidInputException, DataNotFoundException, FileNotFoundException, IOException, SimulationFailedException {
        FileReader fileReader = new FileReader(pSimulationResultsFile);
        BufferedReader inputReader = new BufferedReader(fileReader);
        String line = null;
        int lineNumber = 0;
        SymbolEvaluatorChem symbolEvaluator = pSymbolEvaluator;
        int numDynamicSymbols = pDynamicSymbolValues.length;
        int numRequestedSymbols = pRequestedSymbols.length;
        int[] cfr_ignored_0 = new int[numRequestedSymbols];
        int timeIndex = 0;
        block2: while ((line = inputReader.readLine()) != null) {
            ++lineNumber;
            if (line.trim().length() == 0) continue;
            double curTime = pStartTime;
            StringTokenizer st = new StringTokenizer(line, " ");
            int index = -1;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                Double valueObj = null;
                try {
                    valueObj = new Double(token);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidInputException("failed to parse simulation output file at line: " + lineNumber);
                }
                double value = valueObj;
                if (index == -1) {
                    if (value < pStartTime) continue block2;
                    symbolEvaluator.setTime(value);
                    curTime = value;
                } else {
                    pDynamicSymbolValues[index] = value;
                }
                ++index;
            }
            if (index != numDynamicSymbols) {
                throw new InvalidInputException("failed to parse expected number of values from simulation output file at line: " + line);
            }
            timeIndex = this.addRequestedSymbolValues(curTime, timeIndex, pRequestedSymbols, pRetResultsTimeValues, pRetResultsSymbolValues);
        }
        if (timeIndex != pNumResultsTimePoints) {
            throw new SimulationFailedException("failed to obtain results from simulation; try making the \"max allowed relative error\" smaller");
        }
    }

    public final double[] f(double t, double[] x) {
        System.arraycopy(x, 0, this.mDynamicSymbolValues, 0, this.mDynamicSymbolValues.length);
        SymbolEvaluatorChem symbolEvaluator = this.mSymbolEvaluator;
        symbolEvaluator.setTime(t);
        try {
            if (this.mUseExpressionValueCaching) {
                this.clearExpressionValueCaches();
            }
            this.computeDerivative(this.mScratch, this.mDerivative);
        }
        catch (DataNotFoundException e) {
            throw new RuntimeException("data not found: " + e.getMessage(), e);
        }
        return this.mDerivative;
    }

    public final double[] g(double t, double[] x) {
        double[] event = new double[1];
        if (this.mSimulationCancelled) {
            double retVal = 1.0;
            if (this.mSimulationCancelledEventNegReturnFlag) {
                retVal = -1.0;
                this.mSimulationCancelledEventNegReturnFlag = false;
            } else {
                this.mSimulationCancelledEventNegReturnFlag = true;
            }
            event[0] = retVal;
        }
        return event;
    }

    public final void record(double t, double[] x) {
        long currentTimeMillis;
        ++this.mIterationCounter;
        if (this.mDoUpdates && (currentTimeMillis = System.currentTimeMillis()) - this.mTimeOfLastUpdateMilliseconds > this.mMinNumMillisecondsForUpdate) {
            if (this.mSimulationController != null) {
                this.mSimulationCancelled = this.mSimulationController.handlePauseOrCancel();
            }
            if (this.mSimulationProgressReporter != null) {
                this.mFractionComplete = t * this.mTimeRangeMult;
                this.mSimulationProgressReporter.updateProgressStatistics(false, this.mFractionComplete, this.mIterationCounter);
            }
            this.mTimeOfLastUpdateMilliseconds = System.currentTimeMillis();
        }
        if (this.mDelayedReactionSolvers != null) {
            System.arraycopy(x, 0, this.mDynamicSymbolValues, 0, this.mDynamicSymbolValues.length);
            SymbolEvaluatorChem symbolEvaluator = this.mSymbolEvaluator;
            symbolEvaluator.setTime(t);
            try {
                int numDelayedReactionSolvers;
                DelayedReactionSolver[] solvers = this.mDelayedReactionSolvers;
                int ctr = numDelayedReactionSolvers = solvers.length;
                while (--ctr >= 0) {
                    DelayedReactionSolver solver = solvers[ctr];
                    solver.update(symbolEvaluator, t);
                }
            }
            catch (DataNotFoundException e) {
                throw new RuntimeException("data not found: " + e.getMessage());
            }
        }
    }

    public void initialize(Model pModel) throws DataNotFoundException {
        this.initializeSimulator(pModel);
        this.initializeDynamicSymbolAdjustmentVectors();
        int numSpecies = this.mDynamicSymbolValues.length;
        this.mDerivative = new double[numSpecies];
        this.mScratch = new double[numSpecies];
        this.mSimulationCancelled = false;
        this.mSimulationCancelledEventNegReturnFlag = false;
        this.setInitialized(true);
    }

    public SimulatorParameters getDefaultSimulatorParameters() {
        SimulatorParameters sp = new SimulatorParameters();
        sp.setMaxAllowedRelativeError(new Double(1.0E-4));
        sp.setMaxAllowedAbsoluteError(new Double(1.0E-4));
        sp.setComputeFluctuations(false);
        sp.setStepSizeFraction(new Double(0.001));
        sp.setNumHistoryBins(400);
        return sp;
    }

    public boolean isStochasticSimulator() {
        return false;
    }

    public void checkSimulationParametersImpl(SimulatorParameters pSimulatorParameters, int pNumResultsTimePoints) {
        if (pSimulatorParameters.getMaxAllowedAbsoluteError() == null) {
            throw new IllegalArgumentException("missing max allowed absolute error");
        }
        if (pSimulatorParameters.getMaxAllowedRelativeError() == null) {
            throw new IllegalArgumentException("missing max allowed relative error");
        }
        this.checkSimulationParametersForDeterministicSimulator(pSimulatorParameters, pNumResultsTimePoints);
    }
}

