/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem.odetojava;

import odeToJava.ErkTriple;
import odeToJava.modules.Btableau;
import odeToJava.modules.ODE;
import odeToJava.modules.ODERecorder;
import odeToJava.modules.Span;
import org.systemsbiology.chem.ISimulator;
import org.systemsbiology.chem.odetojava.SimulatorOdeToJavaBase;
import org.systemsbiology.util.IAliasableClass;

public final class SimulatorOdeToJavaRungeKuttaAdaptive
extends SimulatorOdeToJavaBase
implements IAliasableClass,
ISimulator {
    public static final String CLASS_ALIAS = "ODEtoJava-dopr54-adaptive";

    protected void runExternalSimulation(Span pSimulationTimeSpan, double[] pInitialDynamicSymbolValues, double pInitialStepSize, double pMaxAllowedRelativeError, double pMaxAllowedAbsoluteError, String pTempOutputFileName) {
        Btableau simulationButcherTableau = new Btableau("dopr54");
        SimulatorOdeToJavaRungeKuttaAdaptive simulationModel = this;
        double highOrderArgument = 5.0;
        int numSpecies = pInitialDynamicSymbolValues.length;
        double[] relativeTolerance = new double[numSpecies];
        int i = 0;
        while (i < numSpecies) {
            relativeTolerance[i] = pMaxAllowedRelativeError;
            ++i;
        }
        double[] absoluteTolerance = new double[numSpecies];
        int i2 = 0;
        while (i2 < numSpecies) {
            absoluteTolerance[i2] = pMaxAllowedAbsoluteError;
            ++i2;
        }
        ErkTriple erkTriple = new ErkTriple((ODE)simulationModel, pSimulationTimeSpan, pInitialDynamicSymbolValues, pInitialStepSize, simulationButcherTableau, highOrderArgument, absoluteTolerance, relativeTolerance, pTempOutputFileName, "StiffDetect_Off", "EventLoc_Halt", "Stats_Off");
        erkTriple.setAppend(false);
        erkTriple.setNPoints(1000);
        erkTriple.setRecorder((ODERecorder)this);
        erkTriple.routine();
    }

    public boolean allowsInterrupt() {
        return true;
    }

    public String getAlias() {
        return CLASS_ALIAS;
    }
}

