/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.chem.tp;

import java.io.PrintWriter;
import org.systemsbiology.chem.Compartment;
import org.systemsbiology.chem.Model;
import org.systemsbiology.chem.Reaction;
import org.systemsbiology.chem.ReservedSymbolMapperChemCommandLanguage;
import org.systemsbiology.chem.SimulationResults;
import org.systemsbiology.chem.SimulatorDeterministicRungeKuttaFixed;
import org.systemsbiology.chem.SimulatorParameters;
import org.systemsbiology.chem.Species;
import org.systemsbiology.chem.TimeSeriesOutputFormat;
import org.systemsbiology.chem.TimeSeriesSymbolValuesReporter;

public class TestMultistep {
    private static final int NUM_TIME_POINTS = 100;

    public static final void main(String[] pArgs) {
        try {
            Compartment compartment = new Compartment("univ");
            Species speciesA = new Species("A", compartment);
            speciesA.setSpeciesPopulation(100.0);
            Species speciesB = new Species("B", compartment);
            speciesB.setSpeciesPopulation(0.0);
            Species speciesC = new Species("C", compartment);
            speciesC.setSpeciesPopulation(0.0);
            Reaction reactionY = new Reaction("Y");
            reactionY.addProduct(speciesC, 1);
            reactionY.setRate(1.0);
            Reaction reactionX = new Reaction("X");
            reactionX.addReactant(speciesA, 1);
            reactionX.addProduct(speciesB, 1);
            reactionX.setRate(1.0);
            reactionX.setNumSteps(12);
            Model model = new Model("model");
            model.addReaction(reactionX);
            model.addReaction(reactionY);
            model.setReservedSymbolMapper(new ReservedSymbolMapperChemCommandLanguage());
            System.out.println(model.toString());
            SimulatorDeterministicRungeKuttaFixed simulator = new SimulatorDeterministicRungeKuttaFixed();
            simulator.initialize(model);
            String[] requestedSymbolNames = new String[]{"A", "B"};
            long curTime = System.currentTimeMillis();
            SimulatorParameters simParams = simulator.getDefaultSimulatorParameters();
            SimulationResults simulationResults = simulator.simulate(0.0, 200.0, simParams, 100, requestedSymbolNames);
            long finalTime = System.currentTimeMillis();
            double elapsedTimeSec = (double)(finalTime - curTime) / 1000.0;
            System.out.println("elapsed time: " + elapsedTimeSec);
            int cfr_ignored_0 = requestedSymbolNames.length;
            double[] timeValues = simulationResults.getResultsTimeValues();
            Object[] symbolValues = simulationResults.getResultsSymbolValues();
            TimeSeriesSymbolValuesReporter.reportTimeSeriesSymbolValues(new PrintWriter(System.out), requestedSymbolNames, timeValues, symbolValues, TimeSeriesOutputFormat.CSV_EXCEL);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

