/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;

public class DataFileDelimiter
implements Comparable {
    private final String mName;
    private final String mDelimiter;
    private final boolean mSingle;
    private static final HashMap sMap = new HashMap();
    private String mFilterRegex;
    private String mDefaultExtension;
    public static final DataFileDelimiter TAB = new DataFileDelimiter("tab", "\t", true, ".*\\.tsv$", "tsv");
    public static final DataFileDelimiter COMMA = new DataFileDelimiter("comma", ",", true, ".*\\.csv$", "csv");
    public static final DataFileDelimiter SPACE = new DataFileDelimiter("space", " ", false, ".*\\.txt$", "txt");

    public boolean getSingle() {
        return this.mSingle;
    }

    public int compareTo(Object pObject) {
        return this.mName.compareTo(((DataFileDelimiter)pObject).mName);
    }

    public String toString() {
        return this.mName;
    }

    public String getDelimiter() {
        return this.mDelimiter;
    }

    public String getName() {
        return this.mName;
    }

    public static DataFileDelimiter get(String pName) {
        return (DataFileDelimiter)sMap.get(pName);
    }

    public static DataFileDelimiter[] getAll() {
        DataFileDelimiter[] retArray = null;
        LinkedList delimitersList = new LinkedList(sMap.values());
        Collections.sort(delimitersList);
        retArray = delimitersList.toArray(new DataFileDelimiter[0]);
        return retArray;
    }

    public String getFilterRegex() {
        return this.mFilterRegex;
    }

    public String getDefaultExtension() {
        return this.mDefaultExtension;
    }

    private DataFileDelimiter(String pName, String pDelimiter, boolean pSingle, String pFilterRegex, String pDefaultExtension) {
        this.mName = pName;
        this.mDelimiter = pDelimiter;
        this.mSingle = pSingle;
        this.mFilterRegex = pFilterRegex;
        this.mDefaultExtension = pDefaultExtension;
        sMap.put(pName, this);
    }

    public String scrubIdentifier(String pName) {
        String scrubbedIdentifier = pName;
        if (-1 != scrubbedIdentifier.indexOf(this.mDelimiter)) {
            scrubbedIdentifier = scrubbedIdentifier.replaceAll(this.mDelimiter, "_");
        }
        return scrubbedIdentifier;
    }
}

