/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.data;

import java.util.ArrayList;
import org.systemsbiology.data.AbstractComparator;
import org.systemsbiology.data.PriorityQueue;
import org.systemsbiology.util.DataNotFoundException;

public class IndexedPriorityQueue
extends PriorityQueue {
    private ArrayList mIndex;
    private static final int DEFAULT_CAPACITY = 11;

    public IndexedPriorityQueue(AbstractComparator pAbstractComparator) {
        this(11, pAbstractComparator);
    }

    public IndexedPriorityQueue(int pInitialCapacity, AbstractComparator pAbstractComparator) {
        super(pAbstractComparator);
        this.mIndex = new ArrayList(pInitialCapacity);
    }

    public void update(int pIndex, Object pValue) throws DataNotFoundException {
        IndexedNode node = (IndexedNode)this.mIndex.get(pIndex);
        if (node == null) {
            throw new DataNotFoundException("no queue element exists with this index: " + pIndex);
        }
        this.remove(node, this.mAbstractComparator);
        node.clearTreeLinks();
        node.mPayload = pValue;
        this.insertRoot(node);
    }

    public void clear() {
        this.mIndex.clear();
        super.clear();
    }

    public Object getNext() {
        throw new IllegalStateException("poll() operation not supported on an IndexedPriorityQueue");
    }

    public int peekIndex() {
        int retIndex = -1;
        if (this.mRoot != null) {
            retIndex = ((IndexedNode)this.mRoot).mIndex;
        }
        return retIndex;
    }

    public Object get(int pIndex) {
        return ((PriorityQueue.Node)this.mIndex.get((int)pIndex)).mPayload;
    }

    public boolean add(Object pElement) {
        IndexedNode node = new IndexedNode(pElement);
        int index = this.mIndex.size();
        this.insertRoot(node);
        this.mIndex.add(node);
        node.mIndex = index;
        return true;
    }

    class IndexedNode
    extends PriorityQueue.Node {
        private int mIndex;

        public IndexedNode(Object pPayload) {
            super(IndexedPriorityQueue.this, pPayload);
            this.mIndex = 0;
        }
    }
}

