/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.systemsbiology.data.DataFileDelimiter;
import org.systemsbiology.util.InvalidInputException;

public class MatrixString {
    private ArrayList mRows = new ArrayList();

    public void addRow(ArrayList pColumnValues) {
        this.mRows.add(pColumnValues);
    }

    public void clear() {
        this.mRows.clear();
    }

    public String[] getRow(int pRow) {
        ArrayList row = (ArrayList)this.mRows.get(pRow);
        return row.toArray(new String[0]);
    }

    public String[] getColumn(int pColumn) {
        int numRows = this.getRowCount();
        String[] retArr = new String[numRows];
        int i = 0;
        while (i < numRows) {
            ArrayList row = (ArrayList)this.mRows.get(i);
            retArr[i] = (String)row.get(pColumn);
            ++i;
        }
        return retArr;
    }

    public String getValueAt(int pRow, int pColumn) {
        return (String)((ArrayList)this.mRows.get(pRow)).get(pColumn);
    }

    public int getRowCount() {
        return this.mRows.size();
    }

    public int getColumnCount() {
        if (this.mRows.size() == 0) {
            return 0;
        }
        ArrayList firstRow = (ArrayList)this.mRows.get(0);
        return firstRow.size();
    }

    public String toString() {
        return this.toString(",");
    }

    public String toString(String pDelimiter) {
        Iterator rowIter = this.mRows.iterator();
        Iterator colIter = null;
        StringBuffer retBuf = new StringBuffer();
        while (rowIter.hasNext()) {
            ArrayList row = (ArrayList)rowIter.next();
            colIter = row.iterator();
            boolean firstCol = true;
            while (colIter.hasNext()) {
                String element = (String)colIter.next();
                if (firstCol) {
                    firstCol = false;
                } else {
                    retBuf.append(pDelimiter);
                }
                retBuf.append(element);
            }
            retBuf.append("\n");
        }
        return retBuf.toString();
    }

    public void buildFromLineBasedStringDelimitedInput(BufferedReader pInputReader, DataFileDelimiter pDelimiter) throws IOException, InvalidInputException {
        String inputLine = null;
        StringTokenizer lineTokenizer = null;
        ArrayList<String> row = null;
        this.clear();
        Integer numCols = null;
        int rowCount = 0;
        boolean returnDelims = pDelimiter.getSingle();
        String delimiter = pDelimiter.getDelimiter();
        while ((inputLine = pInputReader.readLine()) != null) {
            row = new ArrayList<String>();
            lineTokenizer = new StringTokenizer(inputLine, delimiter, returnDelims);
            if (inputLine.startsWith(delimiter)) {
                row.add("");
            }
            String element = null;
            boolean lastWasDelim = false;
            while (lineTokenizer.hasMoreTokens()) {
                element = lineTokenizer.nextToken();
                if (element.startsWith(delimiter)) {
                    if (lastWasDelim) {
                        row.add("");
                    }
                    if (!lineTokenizer.hasMoreTokens()) {
                        row.add("");
                        continue;
                    }
                    lastWasDelim = true;
                    continue;
                }
                lastWasDelim = false;
                row.add(element);
            }
            if (numCols == null) {
                numCols = new Integer(row.size());
            } else if (row.size() != numCols.intValue()) {
                String lineNum = Integer.toString(rowCount + 1);
                throw new InvalidInputException("inconsistent row size, at line number " + lineNum);
            }
            ++rowCount;
            this.mRows.add(row);
        }
    }

    public static final void main(String[] pArgs) {
        try {
            String fileName = pArgs[0];
            if (fileName == null) {
                throw new IllegalArgumentException("no filename was supplied");
            }
            File file = new File(fileName);
            FileReader fileReader = new FileReader(file);
            BufferedReader bufReader = new BufferedReader(fileReader);
            MatrixString matString = new MatrixString();
            matString.buildFromLineBasedStringDelimitedInput(bufReader, DataFileDelimiter.TAB);
            System.out.println(matString.toString());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

