/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.data;

import org.systemsbiology.data.AbstractComparator;
import org.systemsbiology.data.Queue;

public class PriorityQueue
extends Queue {
    protected final AbstractComparator mAbstractComparator;
    protected Node mRoot;

    public PriorityQueue(AbstractComparator pAbstractComparator) {
        this.mAbstractComparator = pAbstractComparator;
        this.mRoot = null;
    }

    public Object peekNext() {
        Object retObj = null;
        if (this.mRoot != null) {
            retObj = this.mRoot.mPayload;
        }
        return retObj;
    }

    public void checkIntegrity(Node pNode) {
        if (pNode != null) {
            assert (pNode.mPayload != null) : "null payload";
            if (pNode.mParent != null) {
                assert (pNode.mParent.mFirstChild != null) : "invalid parent-child link";
                assert (pNode.mParent.mFirstChild.equals(pNode) || pNode.mParent.mSecondChild.equals(pNode)) : "parent-child link broken";
                assert ((double)this.mAbstractComparator.compare(pNode.mPayload, pNode.mParent.mPayload) >= 0.0) : "parent has a value greater than child";
            }
            if (pNode.mFirstChild != null) {
                this.checkIntegrity(pNode.mFirstChild);
                if (pNode.mSecondChild != null) {
                    this.checkIntegrity(pNode.mSecondChild);
                }
            } else assert (pNode.mSecondChild == null) : "second child without first child";
        }
    }

    protected final void remove(Node pNode, AbstractComparator pAbstractComparator) {
        Node firstChild = pNode.mFirstChild;
        Node secondChild = pNode.mSecondChild;
        Node replacement = null;
        Node parent = pNode.mParent;
        if (firstChild != null) {
            if (secondChild != null) {
                int comp = pAbstractComparator.compare(firstChild.mPayload, secondChild.mPayload);
                if (comp > 0) {
                    PriorityQueue.insert(secondChild, firstChild, pAbstractComparator);
                    replacement = secondChild;
                } else {
                    PriorityQueue.insert(firstChild, secondChild, pAbstractComparator);
                    replacement = firstChild;
                }
            } else {
                replacement = firstChild;
            }
            replacement.mParent = parent;
        }
        if (parent != null) {
            assert (parent.mFirstChild != null) : "parent-child relationship broken";
            if (parent.mFirstChild.equals(pNode)) {
                if (replacement != null) {
                    parent.mFirstChild = replacement;
                } else {
                    parent.mFirstChild = parent.mSecondChild;
                    parent.mSecondChild = null;
                }
            } else {
                parent.mSecondChild = replacement;
            }
            --parent.mSubtreePopulation;
            assert (parent.mSubtreePopulation >= 0) : "invalid subtree population";
        } else {
            this.mRoot = replacement;
        }
    }

    public Object getNext() {
        Object retObj = null;
        if (this.mRoot != null) {
            retObj = this.mRoot.mPayload;
            this.remove(this.mRoot, this.mAbstractComparator);
        }
        return retObj;
    }

    protected static final void insert(Node pTree, Node pNode, AbstractComparator pAbstractComparator) {
        Node child1 = pTree.mFirstChild;
        if (child1 != null) {
            Node child2 = pTree.mSecondChild;
            if (child2 != null) {
                if (child2.mSubtreePopulation > child1.mSubtreePopulation) {
                    if (pAbstractComparator.compare(child1.mPayload, pNode.mPayload) >= 0) {
                        pTree.mFirstChild = pNode;
                        pNode.mParent = pTree;
                        PriorityQueue.insert(pNode, child1, pAbstractComparator);
                    } else {
                        PriorityQueue.insert(child1, pNode, pAbstractComparator);
                    }
                } else if (pAbstractComparator.compare(child2.mPayload, pNode.mPayload) >= 0) {
                    pTree.mSecondChild = pNode;
                    pNode.mParent = pTree;
                    PriorityQueue.insert(pNode, child2, pAbstractComparator);
                } else {
                    PriorityQueue.insert(child2, pNode, pAbstractComparator);
                }
            } else {
                pTree.mSecondChild = pNode;
                pNode.mParent = pTree;
            }
        } else {
            pTree.mFirstChild = pNode;
            pNode.mParent = pTree;
        }
        pTree.mSubtreePopulation += pNode.mSubtreePopulation + 1;
    }

    protected final void insertRoot(Node pNode) {
        if (this.mRoot != null) {
            Object rootObj = this.mRoot.mPayload;
            if (this.mAbstractComparator.compare(rootObj, pNode.mPayload) < 0) {
                PriorityQueue.insert(this.mRoot, pNode, this.mAbstractComparator);
            } else {
                pNode.mFirstChild = this.mRoot;
                pNode.mSubtreePopulation = this.mRoot.mSubtreePopulation + 1;
                this.mRoot.mParent = pNode;
                this.mRoot = pNode;
            }
        } else {
            this.mRoot = pNode;
        }
    }

    public boolean add(Object pElement) {
        this.insertRoot(new Node(pElement));
        return true;
    }

    public int size() {
        int retVal = 0;
        if (this.mRoot != null) {
            retVal = this.mRoot.mSubtreePopulation;
        }
        return retVal;
    }

    private void printRecursive(Node pNode, StringBuffer pStringBuffer) {
        if (pNode != null) {
            pStringBuffer.append(pNode.mPayload);
            pStringBuffer.append("(child1=");
            if (pNode.mFirstChild != null) {
                this.printRecursive(pNode.mFirstChild, pStringBuffer);
            } else {
                pStringBuffer.append("null");
            }
            pStringBuffer.append(",child2=");
            if (pNode.mSecondChild != null) {
                this.printRecursive(pNode.mSecondChild, pStringBuffer);
            } else {
                pStringBuffer.append("null");
            }
            pStringBuffer.append(")");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.printRecursive(this.mRoot, sb);
        return sb.toString();
    }

    public void clear() {
        this.mRoot = null;
    }

    protected class Node {
        protected int mSubtreePopulation;
        protected Node mFirstChild;
        protected Node mSecondChild;
        protected Node mParent;
        protected Object mPayload;

        public Node(Object pPayload) {
            this.mPayload = pPayload;
            this.clearTreeLinks();
        }

        public void clearTreeLinks() {
            this.mParent = null;
            this.mSubtreePopulation = 0;
            this.mFirstChild = null;
            this.mSecondChild = null;
        }
    }
}

