/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.data;

import org.systemsbiology.math.DoubleVector;

public class SlidingWindowTimeSeriesQueue {
    private int mNumTimePoints;
    private int mQueueIndex;
    private double[] mTimePoints;
    private double[] mValues;
    private int mNumStoredPoints;
    private int mMinIndex;
    private double mLastTime;
    private double mAverageValue;
    private double mTimeLastNonzeroValue;
    private boolean mHasNonzeroValue;
    private int mCounterForRecomputeAverage;

    public SlidingWindowTimeSeriesQueue(int pNumTimePoints) {
        this.initialize(pNumTimePoints);
    }

    public void initialize(int pNumTimePoints) {
        assert (pNumTimePoints > 0) : "invalid number of time points";
        this.mTimePoints = new double[pNumTimePoints];
        this.mValues = new double[pNumTimePoints];
        this.mNumTimePoints = pNumTimePoints;
        this.clear();
    }

    public double getValue(int pIndex) {
        return this.mValues[this.getInternalIndex(pIndex)];
    }

    public void clear() {
        this.mQueueIndex = 0;
        DoubleVector.zeroElements(this.mTimePoints);
        DoubleVector.zeroElements(this.mValues);
        this.mNumStoredPoints = 0;
        this.mMinIndex = 0;
        this.mLastTime = 0.0;
        this.mAverageValue = 0.0;
        this.mTimeLastNonzeroValue = 0.0;
        this.mHasNonzeroValue = false;
        this.mCounterForRecomputeAverage = 0;
    }

    public boolean hasNonzeroValue() {
        return this.mHasNonzeroValue;
    }

    public double getTimeLastNonzeroValue() throws IllegalStateException {
        if (!this.mHasNonzeroValue) {
            throw new IllegalStateException("there is no nonzero value in the history");
        }
        return this.mTimeLastNonzeroValue;
    }

    public double getLastTimePoint() {
        return this.mLastTime;
    }

    public int getNumStoredPoints() {
        return this.mNumStoredPoints;
    }

    public double getTimePoint(int pIndex) {
        return this.mTimePoints[this.getInternalIndex(pIndex)];
    }

    public double getAverageValue() {
        return this.mAverageValue;
    }

    private double getExactAverageValue() {
        int numPoints = this.mNumStoredPoints;
        double avg = 0.0;
        int ctr = 0;
        while (ctr < numPoints) {
            avg += this.getValue(ctr);
            ++ctr;
        }
        return avg /= (double)numPoints;
    }

    public void insertPoint(double pTime, double pValue) {
        assert (pValue >= 0.0) : "invalid value in history";
        this.mLastTime = pTime;
        int queueIndex = this.mQueueIndex;
        int numTimePoints = this.mNumTimePoints;
        double newAverage = this.mAverageValue * (double)this.mNumStoredPoints;
        double lastValue = 0.0;
        if (this.mNumStoredPoints < numTimePoints) {
            if (this.mNumStoredPoints == 0) {
                this.mMinIndex = this.mQueueIndex;
            }
            ++this.mNumStoredPoints;
        } else {
            int nextIndex = queueIndex + 1;
            if (nextIndex >= numTimePoints) {
                nextIndex -= numTimePoints;
            }
            lastValue = this.mValues[queueIndex];
            this.mMinIndex = nextIndex;
        }
        this.mTimePoints[queueIndex] = pTime;
        this.mValues[queueIndex] = pValue;
        this.mQueueIndex = queueIndex < this.mNumTimePoints - 1 ? ++this.mQueueIndex : 0;
        if (pValue > 0.0) {
            this.mTimeLastNonzeroValue = pTime;
            this.mHasNonzeroValue = true;
        } else if (this.mHasNonzeroValue && this.mTimeLastNonzeroValue < this.mTimePoints[this.mMinIndex]) {
            this.mHasNonzeroValue = false;
            this.mTimeLastNonzeroValue = 0.0;
        }
        ++this.mCounterForRecomputeAverage;
        if (this.mCounterForRecomputeAverage <= this.mNumTimePoints) {
            this.mAverageValue = newAverage = (Math.abs(newAverage - lastValue) + pValue) / (double)this.mNumStoredPoints;
        } else {
            this.mAverageValue = this.getExactAverageValue();
            this.mCounterForRecomputeAverage = 0;
        }
        assert (newAverage >= 0.0) : "invalid average value (negative); lastValue: " + lastValue + "; numStoredPoints: " + this.mNumStoredPoints + "; newAverage: " + newAverage + "; pValue: " + pValue;
    }

    public double getMinTime() {
        return this.mTimePoints[this.mMinIndex];
    }

    private int getInternalIndex(int pExternalIndex) {
        assert (pExternalIndex < this.mNumTimePoints) : "invalid external index";
        assert (pExternalIndex >= 0) : "invalid external index";
        int tempIndex = 0;
        if (this.mNumStoredPoints >= this.mNumTimePoints) {
            tempIndex = this.mQueueIndex + pExternalIndex;
            if (tempIndex >= this.mNumTimePoints) {
                tempIndex -= this.mNumTimePoints;
            }
        } else {
            if (pExternalIndex >= this.mNumStoredPoints) {
                throw new IllegalStateException("no data point has yet been stored for that index; num stored points is " + this.mNumStoredPoints + " and requested index is " + pExternalIndex);
            }
            tempIndex = pExternalIndex;
        }
        return tempIndex;
    }

    public double[] getTimePoints() {
        return this.mTimePoints;
    }

    public double[] getValues() {
        return this.mValues;
    }
}

