/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.math;

public class DoubleVector {
    public static void zeroNegativeElements(double[] vec) {
        int size;
        int ctr = size = vec.length;
        while (--ctr >= 0) {
            if (!(vec[ctr] < 0.0)) continue;
            vec[ctr] = 0.0;
        }
    }

    public static void zeroElements(double[] vec) {
        int size;
        int ctr = size = vec.length;
        while (--ctr >= 0) {
            vec[ctr] = 0.0;
        }
    }

    public static double max(double[] vec) {
        int size;
        assert (vec.length > 0) : "computing the maximum of a vector requires non-zero length";
        double retVal = -1.7976931348623157E308;
        int ctr = size = vec.length;
        while (--ctr >= 0) {
            if (!(vec[ctr] > retVal)) continue;
            retVal = vec[ctr];
        }
        return retVal;
    }

    public static double sumElements(double[] vec) {
        int size;
        double retVal = 0.0;
        int ctr = size = vec.length;
        while (--ctr >= 0) {
            retVal += vec[ctr];
        }
        return retVal;
    }

    public static void add(double[] addendX, double[] addendY, double[] sum) {
        int size1 = addendX.length;
        int size2 = addendY.length;
        int size3 = sum.length;
        assert (size1 == size2 && size2 == size3) : "inconsistent vector size";
        int ctr = size1;
        while (--ctr >= 0) {
            sum[ctr] = addendX[ctr] + addendY[ctr];
        }
    }

    public static void subtract(double[] addendX, double[] addendY, double[] sum) {
        int size1 = addendX.length;
        int size2 = addendY.length;
        int size3 = sum.length;
        assert (size1 == size2 && size2 == size3) : "inconsistent vector size";
        int ctr = size1;
        while (--ctr >= 0) {
            sum[ctr] = addendX[ctr] - addendY[ctr];
        }
    }

    public static void scalarMultiply(double[] vector, double scalar, double[] product) {
        int size1 = vector.length;
        int size2 = product.length;
        assert (size1 == size2) : "inconsistent vector size";
        int ctr = size1;
        while (--ctr >= 0) {
            product[ctr] = scalar * vector[ctr];
        }
    }

    public static void scalarMultiply(double[] vector, double scalar) {
        int size1;
        int ctr = size1 = vector.length;
        while (--ctr >= 0) {
            vector[ctr] = scalar * vector[ctr];
        }
    }
}

