/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.math;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.systemsbiology.math.MathFunctions;
import org.systemsbiology.math.Symbol;
import org.systemsbiology.math.SymbolEvaluator;
import org.systemsbiology.math.SymbolEvaluatorHashMap;
import org.systemsbiology.util.DataNotFoundException;

public class Expression
implements Cloneable {
    private static final String TOKEN_STRING_OPEN_PAREN = "(";
    private static final String TOKEN_STRING_CLOSE_PAREN = ")";
    private static final String TOKEN_STRING_MULT = "*";
    private static final String TOKEN_STRING_PLUS = "+";
    private static final String TOKEN_STRING_MINUS = "-";
    private static final String TOKEN_STRING_DIV = "/";
    private static final String TOKEN_STRING_POW = "^";
    private static final String TOKEN_STRING_MOD = "%";
    private static final String TOKEN_STRING_SEP = ",";
    private static final String TOKEN_DELIMITERS = " *+-/^(),";
    private static final String TOKEN_RESERVED = "!@#$[]|&><{}=";
    public static final Expression ZERO = new Expression("0.0");
    public static final Expression ONE = new Expression("1.0");
    private Element mRootElement;
    private SymbolEvaluatorHashMap mSymbolEvaluator;

    private void setRootElement(Element pRootElement) {
        this.mRootElement = pRootElement;
    }

    private Element getRootElement() {
        return this.mRootElement;
    }

    private void initializeRootElement() {
        this.setRootElement(null);
    }

    private void initialize() {
        this.initializeRootElement();
        this.mSymbolEvaluator = null;
    }

    protected Expression() {
        this.initialize();
    }

    public Expression(double pValue) {
        this.initialize();
        Element rootElement = new Element(ElementCode.NUMBER);
        rootElement.mNumericValue = pValue;
        this.setRootElement(rootElement);
    }

    public Expression(String pExpression) throws IllegalArgumentException {
        this.initialize();
        this.setRootElement(this.parseExpression(pExpression));
    }

    public Expression(Element element) {
        this.initialize();
        this.setRootElement(element);
    }

    private SymbolEvaluator getSymbolEvaluator(HashMap pSymbolsMap) {
        if (this.mSymbolEvaluator == null) {
            this.mSymbolEvaluator = new SymbolEvaluatorHashMap(pSymbolsMap);
        }
        return this.mSymbolEvaluator;
    }

    private void checkForReservedCharacters(String pFormula) throws IllegalArgumentException {
        String tokenReserved = TOKEN_RESERVED;
        int numReservedChars = tokenReserved.length();
        int charCtr = 0;
        while (charCtr < numReservedChars) {
            String reservedChar = tokenReserved.substring(charCtr, charCtr + 1);
            int index = pFormula.indexOf(reservedChar);
            if (index != -1) {
                throw new IllegalArgumentException("expression contained reserved character: " + reservedChar + " at position " + index);
            }
            ++charCtr;
        }
    }

    private Double parseDoubleSafe(String pString) {
        Double retVal = null;
        try {
            retVal = new Double(pString);
        }
        catch (NumberFormatException numberFormatException) {}
        return retVal;
    }

    private Integer parseIntegerSafe(String pString) {
        Integer retVal = null;
        try {
            retVal = new Integer(pString);
        }
        catch (NumberFormatException numberFormatException) {}
        return retVal;
    }

    private void handleScientificNotationNumericToken(String pPrefix, StringTokenizer pStringTokenizer, Token pToken, List pTokenizedFormula, double pMultiplier) {
        Double prefixValue = this.parseDoubleSafe(pPrefix);
        assert (prefixValue != null) : "invalid scientific notation prefix";
        if (!pStringTokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("scientific notation number missing exponent, \"" + pPrefix + "\"");
        }
        String nextTokenString = pStringTokenizer.nextToken();
        Integer nextTokenInt = this.parseIntegerSafe(nextTokenString);
        if (nextTokenInt == null) {
            throw new IllegalArgumentException("scientific notation number missing exponent, \"" + nextTokenString + "\"");
        }
        double value = prefixValue * Math.pow(10.0, pMultiplier * (double)nextTokenInt.intValue());
        pTokenizedFormula.remove(pTokenizedFormula.size() - 1);
        pToken.mCode = TokenCode.NUMBER;
        pToken.mNumericValue = value;
    }

    private List tokenizeExpression(String pFormula) throws IllegalArgumentException {
        Token token;
        this.checkForReservedCharacters(pFormula);
        LinkedList<Token> tokenizedFormula = new LinkedList<Token>();
        boolean returnDelims = true;
        StringTokenizer stringTokenizer = new StringTokenizer(pFormula, TOKEN_DELIMITERS, returnDelims);
        Pattern scientificNotationPattern = Pattern.compile("(\\d+(\\.\\d*)?)[eE]");
        while (stringTokenizer.hasMoreTokens()) {
            String scientificNotationPrefix;
            Matcher scientificNotationMatcher;
            String lastTokenName;
            Token lastToken;
            String tokenStr = stringTokenizer.nextToken();
            token = new Token();
            if (tokenStr.trim().length() == 0) {
                token.mCode = TokenCode.SPACE;
            } else if (tokenStr.equals(TOKEN_STRING_OPEN_PAREN)) {
                token.mCode = TokenCode.OPEN_PAREN;
            } else if (tokenStr.equals(TOKEN_STRING_CLOSE_PAREN)) {
                token.mCode = TokenCode.CLOSE_PAREN;
            } else if (tokenStr.equals(TOKEN_STRING_MULT)) {
                token.mCode = TokenCode.MULT;
            } else if (tokenStr.equals(TOKEN_STRING_PLUS)) {
                lastToken = null;
                int formulaSize = tokenizedFormula.size();
                if (formulaSize > 0) {
                    lastToken = (Token)tokenizedFormula.get(formulaSize - 1);
                    assert (lastToken != null) : "invalid null token found";
                    if (lastToken.mCode.equals(TokenCode.SYMBOL)) {
                        lastTokenName = lastToken.mSymbolName;
                        scientificNotationMatcher = scientificNotationPattern.matcher(lastTokenName);
                        if (scientificNotationMatcher.matches()) {
                            scientificNotationPrefix = scientificNotationMatcher.group(1);
                            this.handleScientificNotationNumericToken(scientificNotationPrefix, stringTokenizer, token, tokenizedFormula, 1.0);
                        } else {
                            token.mCode = TokenCode.PLUS;
                        }
                    } else {
                        token.mCode = TokenCode.PLUS;
                    }
                } else {
                    token.mCode = TokenCode.PLUS;
                }
            } else if (tokenStr.equals(TOKEN_STRING_MINUS)) {
                lastToken = null;
                int formulaSize = tokenizedFormula.size();
                if (formulaSize > 0) {
                    lastToken = (Token)tokenizedFormula.get(formulaSize - 1);
                    assert (lastToken != null) : "invalid null token found";
                    if (lastToken.mCode.equals(TokenCode.SYMBOL)) {
                        lastTokenName = lastToken.mSymbolName;
                        scientificNotationMatcher = scientificNotationPattern.matcher(lastTokenName);
                        if (scientificNotationMatcher.matches()) {
                            scientificNotationPrefix = scientificNotationMatcher.group(1);
                            this.handleScientificNotationNumericToken(scientificNotationPrefix, stringTokenizer, token, tokenizedFormula, -1.0);
                        } else {
                            token.mCode = TokenCode.MINUS;
                        }
                    } else {
                        token.mCode = TokenCode.MINUS;
                    }
                } else {
                    token.mCode = TokenCode.MINUS;
                }
            } else if (tokenStr.equals(TOKEN_STRING_DIV)) {
                token.mCode = TokenCode.DIV;
            } else if (tokenStr.equals(TOKEN_STRING_POW)) {
                token.mCode = TokenCode.POW;
            } else if (tokenStr.equals(TOKEN_STRING_MOD)) {
                token.mCode = TokenCode.MOD;
            } else if (tokenStr.equals(TOKEN_STRING_SEP)) {
                token.mCode = TokenCode.SEP;
            } else {
                Double valueObj = this.parseDoubleSafe(tokenStr);
                if (valueObj != null) {
                    double value = valueObj;
                    token.mCode = TokenCode.NUMBER;
                    token.mNumericValue = value;
                } else {
                    token.mCode = TokenCode.SYMBOL;
                    token.mSymbolName = tokenStr;
                }
            }
            tokenizedFormula.add(token);
        }
        ListIterator listIter = tokenizedFormula.listIterator();
        while (listIter.hasNext()) {
            token = (Token)listIter.next();
            if (!token.mCode.equals(TokenCode.SPACE)) continue;
            listIter.remove();
        }
        return tokenizedFormula;
    }

    private Element convertTokenToElement(Token pToken) throws IllegalArgumentException {
        Element retVal;
        TokenCode tokCode = pToken.mCode;
        if (tokCode != TokenCode.EXPRESSION && tokCode != TokenCode.SYMBOL && tokCode != TokenCode.NUMBER && tokCode != TokenCode.EXPRESSION_PAIR) {
            throw new IllegalArgumentException("expected a sub-expression, but instead found unexpected token: " + tokCode);
        }
        if (tokCode == TokenCode.EXPRESSION) {
            retVal = pToken.mParsedExpression;
        } else if (tokCode.equals(TokenCode.EXPRESSION_PAIR)) {
            retVal = new Element(ElementCode.PAIR);
            retVal.mFirstOperand = pToken.mParsedExpression;
            retVal.mSecondOperand = pToken.mSecondParsedExpression;
        } else if (tokCode == TokenCode.NUMBER) {
            retVal = new Element(ElementCode.NUMBER);
            retVal.mNumericValue = pToken.mNumericValue;
        } else {
            retVal = new Element(ElementCode.SYMBOL);
            retVal.mSymbol = new Symbol(pToken.mSymbolName);
        }
        return retVal;
    }

    private static String getBinaryOperatorSymbol(ElementCode pElementOperatorCode) {
        String retVal = null;
        if (pElementOperatorCode == ElementCode.MULT) {
            retVal = TOKEN_STRING_MULT;
        } else if (pElementOperatorCode == ElementCode.ADD) {
            retVal = TOKEN_STRING_PLUS;
        } else if (pElementOperatorCode == ElementCode.SUBT) {
            retVal = TOKEN_STRING_MINUS;
        } else if (pElementOperatorCode == ElementCode.DIV) {
            retVal = TOKEN_STRING_DIV;
        } else if (pElementOperatorCode == ElementCode.POW) {
            retVal = TOKEN_STRING_POW;
        } else if (pElementOperatorCode == ElementCode.MOD) {
            retVal = TOKEN_STRING_MOD;
        }
        return retVal;
    }

    private static ElementCode parseFunctionName(String pFunctionName) {
        return ElementCode.getFunction(pFunctionName);
    }

    private void parseParentheses(List pTokenizedExpression) throws IllegalArgumentException {
        int parenDepth = 0;
        int tokenCtr = 0;
        ListIterator iter = pTokenizedExpression.listIterator();
        LinkedList<Token> subFormula = null;
        Token tok = null;
        Token prevTok = null;
        while (iter.hasNext()) {
            prevTok = tok;
            tok = (Token)iter.next();
            TokenCode tokenCode = tok.mCode;
            if (parenDepth > 1 || parenDepth == 1 && tokenCode != TokenCode.CLOSE_PAREN) {
                iter.remove();
                subFormula.add(tok);
            }
            if (tokenCode == TokenCode.OPEN_PAREN) {
                if (parenDepth == 0) {
                    subFormula = new LinkedList<Token>();
                    iter.remove();
                }
                ++parenDepth;
            } else if (tokenCode == TokenCode.CLOSE_PAREN) {
                if (--parenDepth < 0) {
                    throw new IllegalArgumentException("invalid parenthesis encountered for token number: " + tokenCtr);
                }
                if (parenDepth == 0) {
                    tok.mCode = TokenCode.EXPRESSION;
                    Element parsedSubFormula = null;
                    if (prevTok == null || !prevTok.mCode.equals(TokenCode.OPEN_PAREN)) {
                        parsedSubFormula = this.parseTokenizedExpression(subFormula, true);
                    }
                    tok.mParsedExpression = parsedSubFormula;
                }
            }
            ++tokenCtr;
        }
        if (parenDepth > 0) {
            throw new IllegalArgumentException("mismatched parentheses found in formula");
        }
    }

    private void parseSeparators(List pTokenizedExpression, boolean pAllowArgumentLists) throws IllegalArgumentException {
        ListIterator<Token> iter = pTokenizedExpression.listIterator();
        Token tok = null;
        int parenDepth = 0;
        boolean hasSep = false;
        while (iter.hasNext() && !hasSep) {
            tok = (Token)iter.next();
            TokenCode tokenCode = tok.mCode;
            if (tokenCode.equals(TokenCode.OPEN_PAREN)) {
                ++parenDepth;
                continue;
            }
            if (tokenCode.equals(TokenCode.CLOSE_PAREN)) {
                if (--parenDepth >= 0) continue;
                throw new IllegalArgumentException("mismatched parentheses");
            }
            if (parenDepth != 0 || !tokenCode.equals(TokenCode.SEP)) continue;
            if (!pAllowArgumentLists) {
                throw new IllegalArgumentException("argument list not allowed in this context");
            }
            hasSep = true;
        }
        if (hasSep) {
            iter = pTokenizedExpression.listIterator();
            LinkedList<Token> subExpression = new LinkedList<Token>();
            Token newToken = new Token();
            newToken.mCode = TokenCode.EXPRESSION_PAIR;
            Element exp1 = null;
            Element exp2 = null;
            parenDepth = 0;
            while (iter.hasNext()) {
                Element parsedSubExpression;
                tok = (Token)iter.next();
                TokenCode tokenCode = tok.mCode;
                if (tokenCode.equals(TokenCode.OPEN_PAREN)) {
                    ++parenDepth;
                } else if (tokenCode.equals(TokenCode.CLOSE_PAREN) && --parenDepth < 0) {
                    throw new IllegalArgumentException("mismatched parentheses");
                }
                if (!tokenCode.equals(TokenCode.SEP)) {
                    subExpression.add(tok);
                } else {
                    if (!iter.hasNext()) {
                        throw new IllegalArgumentException("invalid argument list; missing last argument");
                    }
                    if (parenDepth == 0) {
                        if (subExpression.size() == 0) {
                            throw new IllegalArgumentException("invalid argument list; empty argument");
                        }
                        parsedSubExpression = this.parseTokenizedExpression(subExpression, false);
                        subExpression.clear();
                        if (exp1 != null) {
                            throw new IllegalArgumentException("more than two arguments are not allowed");
                        }
                        exp1 = parsedSubExpression;
                    }
                }
                if (!iter.hasNext()) {
                    if (subExpression.size() == 0) {
                        throw new IllegalArgumentException("invalid argument list; empty argument");
                    }
                    parsedSubExpression = this.parseTokenizedExpression(subExpression, false);
                    subExpression.clear();
                    exp2 = parsedSubExpression;
                }
                iter.remove();
            }
            newToken.mParsedExpression = exp1;
            newToken.mSecondParsedExpression = exp2;
            if (parenDepth != 0) {
                throw new IllegalArgumentException("mismatched number of parentheses");
            }
            iter.add(newToken);
        }
    }

    private void parseFunctionCalls(List pTokenizedExpression) throws IllegalArgumentException {
        ListIterator iter = pTokenizedExpression.listIterator();
        Token tok = null;
        while (iter.hasNext()) {
            tok = (Token)iter.next();
            TokenCode cfr_ignored_0 = tok.mCode;
            if (tok.mCode == TokenCode.SYMBOL) {
                String symbolName = tok.mSymbolName;
                ElementCode elementCodeFunction = Expression.parseFunctionName(symbolName);
                if (iter.hasNext()) {
                    Token nextTok = (Token)iter.next();
                    if (nextTok.mCode.equals(TokenCode.EXPRESSION) || nextTok.mCode.equals(TokenCode.EXPRESSION_PAIR)) {
                        if (elementCodeFunction == null) {
                            throw new IllegalArgumentException("unknown symbol used as function name: " + symbolName);
                        }
                        Element functionCallElement = new Element(elementCodeFunction);
                        int numArgs = elementCodeFunction.mNumFunctionArgs;
                        if (numArgs == 0) {
                            if (!nextTok.mCode.equals(TokenCode.EXPRESSION)) {
                                throw new IllegalArgumentException("expected an expression token, instead found token: " + nextTok.mCode);
                            }
                            functionCallElement.mFirstOperand = nextTok.mParsedExpression;
                            if (functionCallElement.mFirstOperand != null) {
                                throw new IllegalArgumentException("function does not allow any arguments: " + elementCodeFunction);
                            }
                        } else if (numArgs == 1) {
                            if (!nextTok.mCode.equals(TokenCode.EXPRESSION)) {
                                throw new IllegalArgumentException("expected an expression token, instead found token: " + nextTok.mCode);
                            }
                            functionCallElement.mFirstOperand = nextTok.mParsedExpression;
                            if (functionCallElement.mFirstOperand.mCode.equals(ElementCode.PAIR)) {
                                throw new IllegalArgumentException("two arguments for single-argument function call: " + symbolName);
                            }
                        } else if (numArgs == 2) {
                            if (!nextTok.mCode.equals(TokenCode.EXPRESSION)) {
                                throw new IllegalArgumentException("expected an expression token, instead found token: " + nextTok.mCode);
                            }
                            Element pairElement = nextTok.mParsedExpression;
                            if (!pairElement.mCode.equals(ElementCode.PAIR)) {
                                throw new IllegalArgumentException("expected an argument pair; instead found token type:  " + pairElement.mCode);
                            }
                            functionCallElement.mFirstOperand = pairElement.mFirstOperand;
                            functionCallElement.mSecondOperand = pairElement.mSecondOperand;
                            nextTok.mCode = TokenCode.EXPRESSION;
                            nextTok.mSecondParsedExpression = null;
                        } else {
                            throw new IllegalStateException("illegal number of function arguments");
                        }
                        nextTok.mParsedExpression = functionCallElement;
                        iter.previous();
                        iter.previous();
                        iter.remove();
                        iter.next();
                        continue;
                    }
                    if (elementCodeFunction == null) continue;
                    throw new IllegalArgumentException("reserved function name used as symbol: " + symbolName);
                }
                if (elementCodeFunction == null) continue;
                throw new IllegalArgumentException("reserved function name used as symbol: " + symbolName);
            }
            if (!tok.mCode.equals(TokenCode.EXPRESSION) || !tok.mParsedExpression.mCode.equals(ElementCode.PAIR)) continue;
            throw new IllegalArgumentException("argument pair not allowed in this context");
        }
    }

    private void parseUnaryOperator(HashMap pTokenCodeMap, List pTokenizedExpression) throws IllegalArgumentException {
        ListIterator iter = pTokenizedExpression.listIterator();
        Token lastTok = null;
        Token token = null;
        while (iter.hasNext()) {
            Set tokenCodeSet;
            lastTok = token;
            token = (Token)iter.next();
            TokenCode tokenCode = token.mCode;
            if (tokenCode.equals(TokenCode.EXPRESSION) || !(tokenCodeSet = pTokenCodeMap.keySet()).contains(tokenCode) || lastTok != null && (lastTok.mCode == TokenCode.SYMBOL || lastTok.mCode == TokenCode.EXPRESSION || lastTok.mCode == TokenCode.NUMBER)) continue;
            if (!iter.hasNext()) {
                throw new IllegalArgumentException("last token in the list is a minus, this is not allowed");
            }
            Token nextTok = (Token)iter.next();
            Element operand = this.convertTokenToElement(nextTok);
            Element opElement = null;
            ElementCode elementCode = (ElementCode)pTokenCodeMap.get(tokenCode);
            if (!elementCode.equals(ElementCode.NEG) || !operand.mCode.equals(ElementCode.NUMBER)) {
                opElement = new Element(elementCode);
                opElement.mFirstOperand = operand;
            } else {
                opElement = new Element(ElementCode.NUMBER);
                opElement.mNumericValue = -1.0 * operand.mNumericValue;
            }
            iter.previous();
            iter.remove();
            token.mCode = TokenCode.EXPRESSION;
            token.mParsedExpression = opElement;
        }
    }

    private void parseBinaryOperator(HashMap pTokenCodeMap, List pTokenizedExpression) throws IllegalArgumentException {
        ListIterator iter = pTokenizedExpression.listIterator();
        Token lastTok = null;
        Token token = null;
        while (iter.hasNext()) {
            Set tokenCodeSet;
            lastTok = token;
            token = (Token)iter.next();
            TokenCode tokenCode = token.mCode;
            if (tokenCode.equals(TokenCode.EXPRESSION) || !(tokenCodeSet = pTokenCodeMap.keySet()).contains(tokenCode)) continue;
            if (lastTok == null) {
                throw new IllegalArgumentException("encountered binary operator with no first operand found");
            }
            if (!iter.hasNext()) {
                throw new IllegalArgumentException("encountered binary operator with no second operand found");
            }
            Token nextTok = (Token)iter.next();
            Element op1 = this.convertTokenToElement(lastTok);
            Element op2 = this.convertTokenToElement(nextTok);
            ElementCode elementCode = (ElementCode)pTokenCodeMap.get(tokenCode);
            Element product = new Element(elementCode);
            product.mFirstOperand = op1;
            product.mSecondOperand = op2;
            iter.remove();
            iter.previous();
            iter.previous();
            iter.remove();
            iter.next();
            token.mCode = TokenCode.EXPRESSION;
            token.mParsedExpression = product;
        }
    }

    private static final double valueOfSubtreeNonSimple(Element pElement, SymbolEvaluator pSymbolEvaluator) throws DataNotFoundException {
        double valueOfFirstOperand;
        switch (pElement.mFirstOperand.mCode.mIntCode) {
            case 1: {
                valueOfFirstOperand = pSymbolEvaluator.getValue(pElement.mFirstOperand.mSymbol);
                break;
            }
            case 2: {
                valueOfFirstOperand = pElement.mFirstOperand.mNumericValue;
                break;
            }
            default: {
                valueOfFirstOperand = Expression.valueOfSubtreeNonSimple(pElement.mFirstOperand, pSymbolEvaluator);
            }
        }
        if (pElement.mSecondOperand != null) {
            double valueOfSecondOperand;
            switch (pElement.mSecondOperand.mCode.mIntCode) {
                case 1: {
                    valueOfSecondOperand = pSymbolEvaluator.getValue(pElement.mSecondOperand.mSymbol);
                    break;
                }
                case 2: {
                    valueOfSecondOperand = pElement.mSecondOperand.mNumericValue;
                    break;
                }
                default: {
                    valueOfSecondOperand = Expression.valueOfSubtreeNonSimple(pElement.mSecondOperand, pSymbolEvaluator);
                }
            }
            switch (pElement.mCode.mIntCode) {
                case 3: {
                    return valueOfFirstOperand * valueOfSecondOperand;
                }
                case 4: {
                    return valueOfFirstOperand + valueOfSecondOperand;
                }
                case 6: {
                    return valueOfFirstOperand / valueOfSecondOperand;
                }
                case 5: {
                    return valueOfFirstOperand - valueOfSecondOperand;
                }
                case 7: {
                    return Math.pow(valueOfFirstOperand, valueOfSecondOperand);
                }
                case 8: {
                    return valueOfFirstOperand % valueOfSecondOperand;
                }
                case 24: {
                    return Math.min(valueOfFirstOperand, valueOfSecondOperand);
                }
                case 25: {
                    return Math.max(valueOfFirstOperand, valueOfSecondOperand);
                }
            }
            throw new IllegalStateException("unknown function code: " + pElement.mCode);
        }
        switch (pElement.mCode.mIntCode) {
            case 9: {
                return -valueOfFirstOperand;
            }
            case 10: {
                return Math.exp(valueOfFirstOperand);
            }
            case 11: {
                return Math.log(valueOfFirstOperand);
            }
            case 12: {
                return Math.sin(valueOfFirstOperand);
            }
            case 13: {
                return Math.cos(valueOfFirstOperand);
            }
            case 14: {
                return Math.tan(valueOfFirstOperand);
            }
            case 15: {
                return Math.asin(valueOfFirstOperand);
            }
            case 16: {
                return Math.acos(valueOfFirstOperand);
            }
            case 17: {
                return Math.atan(valueOfFirstOperand);
            }
            case 18: {
                return Math.abs(valueOfFirstOperand);
            }
            case 19: {
                return Math.floor(valueOfFirstOperand);
            }
            case 20: {
                return Math.ceil(valueOfFirstOperand);
            }
            case 21: {
                return Math.sqrt(valueOfFirstOperand);
            }
            case 22: {
                return MathFunctions.thetaFunction(valueOfFirstOperand);
            }
        }
        throw new IllegalStateException("unknown function code: " + pElement.mCode);
    }

    private static final double valueOfSubtree(Element pElement, SymbolEvaluator pSymbolEvaluator) throws DataNotFoundException {
        int elementCodeInt = pElement.mCode.mIntCode;
        switch (elementCodeInt) {
            case 1: {
                Symbol symbol = pElement.mSymbol;
                return pSymbolEvaluator.getValue(symbol);
            }
            case 2: {
                return pElement.mNumericValue;
            }
        }
        return Expression.valueOfSubtreeNonSimple(pElement, pSymbolEvaluator);
    }

    private Element parseTokenizedExpression(List pFormula, boolean pAllowArgumentLists) throws IllegalArgumentException {
        this.parseParentheses(pFormula);
        this.parseSeparators(pFormula, pAllowArgumentLists);
        this.parseFunctionCalls(pFormula);
        HashMap<TokenCode, ElementCode> unaryMap = new HashMap<TokenCode, ElementCode>();
        unaryMap.put(TokenCode.MINUS, ElementCode.NEG);
        this.parseUnaryOperator(unaryMap, pFormula);
        HashMap<TokenCode, ElementCode> binaryMap = new HashMap<TokenCode, ElementCode>();
        binaryMap.put(TokenCode.POW, ElementCode.POW);
        this.parseBinaryOperator(binaryMap, pFormula);
        binaryMap.clear();
        binaryMap.put(TokenCode.MULT, ElementCode.MULT);
        binaryMap.put(TokenCode.DIV, ElementCode.DIV);
        binaryMap.put(TokenCode.MOD, ElementCode.MOD);
        this.parseBinaryOperator(binaryMap, pFormula);
        binaryMap.clear();
        binaryMap.put(TokenCode.PLUS, ElementCode.ADD);
        binaryMap.put(TokenCode.MINUS, ElementCode.SUBT);
        this.parseBinaryOperator(binaryMap, pFormula);
        ListIterator iter = pFormula.listIterator();
        if (!iter.hasNext()) {
            throw new IllegalArgumentException("no elements found in the parse tree for this expression");
        }
        Token finalToken = (Token)iter.next();
        if (iter.hasNext()) {
            throw new IllegalArgumentException("found more than one element at the root of the parsed formula tree");
        }
        return this.convertTokenToElement(finalToken);
    }

    Element parseExpression(String pExpressionString) throws IllegalArgumentException {
        List tokenizedExpression = this.tokenizeExpression(pExpressionString);
        return this.parseTokenizedExpression(tokenizedExpression, false);
    }

    public static boolean isValidSymbol(String pToken) {
        boolean isValidSymbol = false;
        try {
            boolean returnDelims;
            StringTokenizer tok;
            int numTokens;
            Expression testExp = new Expression(pToken);
            Element elem = testExp.getRootElement();
            if (ElementCode.SYMBOL == elem.mCode && (numTokens = (tok = new StringTokenizer(pToken, " ()", returnDelims = true)).countTokens()) == 1) {
                isValidSymbol = true;
            }
        }
        catch (Exception exception) {
            isValidSymbol = false;
        }
        return isValidSymbol;
    }

    public String toString() throws IllegalStateException {
        try {
            return this.toString(null);
        }
        catch (DataNotFoundException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public String toString(SymbolPrinter pSymbolPrinter) throws IllegalStateException, DataNotFoundException {
        Element rootElement = this.getRootElement();
        String retStr = rootElement != null ? rootElement.toString(pSymbolPrinter) : "null";
        return retStr;
    }

    public static boolean isFunctionName(String pName) {
        ElementCode function = ElementCode.getFunction(pName);
        return function != null && function.isFunction();
    }

    public void setExpression(String pExpressionString) throws IllegalArgumentException {
        this.setRootElement(this.parseExpression(pExpressionString));
    }

    public double computeValue(HashMap pSymbolsMap) throws DataNotFoundException, IllegalStateException {
        SymbolEvaluator symbolEvaluator = this.getSymbolEvaluator(pSymbolsMap);
        return this.computeValue(symbolEvaluator);
    }

    private static void visit(IVisitor pVisitor, Element pElement) {
        if (pElement.mSymbol != null) {
            pVisitor.visit(pElement.mSymbol);
        }
        if (pElement.mFirstOperand != null) {
            Expression.visit(pVisitor, pElement.mFirstOperand);
        }
        if (pElement.mSecondOperand != null) {
            Expression.visit(pVisitor, pElement.mSecondOperand);
        }
    }

    public void visit(IVisitor pVisitor) {
        Element rootElement = this.getRootElement();
        if (rootElement == null) {
            throw new IllegalStateException("attempted to compute value of a math expression object that has no expression defined");
        }
        Expression.visit(pVisitor, rootElement);
    }

    public double computeValue(SymbolEvaluator pSymbolEvaluator) throws DataNotFoundException, IllegalStateException, IllegalArgumentException {
        Element rootElement = this.getRootElement();
        if (rootElement == null) {
            throw new IllegalStateException("attempted to compute value of a math expression object that has no expression defined");
        }
        try {
            Expression.valueOfSubtree(rootElement, pSymbolEvaluator);
        }
        catch (StackOverflowError stackOverflowError) {
            throw new IllegalArgumentException("circular expression encountered while attempting to parse expression: " + this.toString());
        }
        return Expression.valueOfSubtree(rootElement, pSymbolEvaluator);
    }

    public Object clone() {
        Expression newExpression = new Expression();
        newExpression.mRootElement = this.mRootElement != null ? (Element)this.mRootElement.clone() : null;
        return newExpression;
    }

    private Element computePartialDerivative(Element pElement, Symbol pSymbol, SymbolEvaluator pSymbolEvaluator) throws DataNotFoundException {
        Element retElement = null;
        ElementCode code = pElement.mCode;
        int intCode = code.mIntCode;
        Element firstOperand = pElement.mFirstOperand;
        Element firstOperandDerivExpression = null;
        boolean firstOperandDerivZero = false;
        boolean firstOperandDerivUnity = false;
        if (firstOperand != null) {
            firstOperandDerivExpression = this.computePartialDerivative(firstOperand, pSymbol, pSymbolEvaluator);
            ElementCode cfr_ignored_0 = firstOperand.mCode;
            if (firstOperandDerivExpression.mCode.equals(ElementCode.NUMBER)) {
                double derivValue = firstOperandDerivExpression.mNumericValue;
                if (derivValue == 0.0) {
                    firstOperandDerivZero = true;
                } else if (derivValue == 1.0) {
                    firstOperandDerivUnity = true;
                }
            }
        }
        Element secondOperand = pElement.mSecondOperand;
        Element secondOperandDerivExpression = null;
        boolean secondOperandDerivZero = false;
        boolean secondOperandDerivUnity = false;
        if (secondOperand != null) {
            secondOperandDerivExpression = this.computePartialDerivative(secondOperand, pSymbol, pSymbolEvaluator);
            ElementCode cfr_ignored_1 = secondOperand.mCode;
            if (secondOperandDerivExpression.mCode.equals(ElementCode.NUMBER)) {
                double derivValue = secondOperandDerivExpression.mNumericValue;
                if (derivValue == 0.0) {
                    secondOperandDerivZero = true;
                } else if (derivValue == 1.0) {
                    secondOperandDerivUnity = true;
                }
            }
        }
        switch (intCode) {
            case 2: {
                retElement = new Element(ElementCode.NUMBER);
                retElement.mNumericValue = 0.0;
                break;
            }
            case 1: {
                Symbol symbol = pElement.mSymbol;
                if (symbol.getName().equals(pSymbol.getName())) {
                    retElement = new Element(ElementCode.NUMBER);
                    retElement.mNumericValue = 1.0;
                    break;
                }
                Expression symbolExpression = pSymbolEvaluator.getExpressionValue(symbol);
                if (symbolExpression != null) {
                    Expression derivExpression = symbolExpression.computePartialDerivative(pSymbol, pSymbolEvaluator);
                    retElement = derivExpression.mRootElement;
                    break;
                }
                retElement = new Element(ElementCode.NUMBER);
                retElement.mNumericValue = 0.0;
                break;
            }
            case 0: {
                throw new IllegalArgumentException("element code NONE should never occur in a valid expression tree");
            }
            case 8: {
                throw new IllegalArgumentException("unable to compute the derivative of the modulo division operator");
            }
            case 18: {
                throw new IllegalArgumentException("unable to compute the derivative of the abs() function");
            }
            case 19: {
                throw new IllegalArgumentException("unable to compute the derivative of the floor() function");
            }
            case 20: {
                throw new IllegalArgumentException("unable to compute the derivative of the ceil() function");
            }
            case 22: {
                throw new IllegalArgumentException("unable to compute the derivative of the theta() function");
            }
            case 24: {
                throw new IllegalArgumentException("unable to compute the derivative of the min() function");
            }
            case 25: {
                throw new IllegalArgumentException("unable to compute the derivative of the max() function");
            }
            case 16: {
                if (!firstOperandDerivZero) {
                    Element xSquared;
                    Element oneMinusXSquared;
                    Element sqrtOneMinusXSquared;
                    Element ratio;
                    retElement = new Element(ElementCode.NEG);
                    retElement.mFirstOperand = ratio = new Element(ElementCode.DIV);
                    ratio.mFirstOperand = firstOperandDerivExpression;
                    ratio.mSecondOperand = sqrtOneMinusXSquared = new Element(ElementCode.SQRT);
                    sqrtOneMinusXSquared.mFirstOperand = oneMinusXSquared = new Element(ElementCode.SUBT);
                    oneMinusXSquared.mFirstOperand = Element.ONE;
                    oneMinusXSquared.mSecondOperand = xSquared = new Element(ElementCode.POW);
                    xSquared.mFirstOperand = firstOperand;
                    xSquared.mSecondOperand = Element.TWO;
                    break;
                }
                retElement = firstOperandDerivExpression;
                break;
            }
            case 15: {
                if (!firstOperandDerivZero) {
                    Element xSquared;
                    Element oneMinusXSquared;
                    Element sqrtOneMinusXSquared;
                    retElement = new Element(ElementCode.DIV);
                    retElement.mFirstOperand = firstOperandDerivExpression;
                    retElement.mSecondOperand = sqrtOneMinusXSquared = new Element(ElementCode.SQRT);
                    sqrtOneMinusXSquared.mFirstOperand = oneMinusXSquared = new Element(ElementCode.SUBT);
                    oneMinusXSquared.mFirstOperand = Element.ONE;
                    oneMinusXSquared.mSecondOperand = xSquared = new Element(ElementCode.POW);
                    xSquared.mFirstOperand = firstOperand;
                    xSquared.mSecondOperand = Element.TWO;
                    break;
                }
                retElement = firstOperandDerivExpression;
                break;
            }
            case 17: {
                if (!firstOperandDerivZero) {
                    Element onePlusXSquared;
                    retElement = new Element(ElementCode.DIV);
                    retElement.mFirstOperand = firstOperandDerivExpression;
                    retElement.mSecondOperand = onePlusXSquared = new Element(ElementCode.ADD);
                    onePlusXSquared.mFirstOperand = Element.ONE;
                    Element xSquared = new Element(ElementCode.POW);
                    xSquared.mFirstOperand = firstOperand;
                    xSquared.mSecondOperand = Element.TWO;
                    onePlusXSquared.mSecondOperand = xSquared;
                    retElement.mSecondOperand = onePlusXSquared;
                    break;
                }
                retElement = firstOperandDerivExpression;
                break;
            }
            case 21: {
                if (!firstOperandDerivZero) {
                    retElement = new Element(ElementCode.DIV);
                    retElement.mFirstOperand = firstOperandDerivExpression;
                    Element twoSqrt = new Element(ElementCode.MULT);
                    twoSqrt.mFirstOperand = Element.TWO;
                    twoSqrt.mSecondOperand = pElement;
                    retElement.mSecondOperand = twoSqrt;
                    break;
                }
                retElement = firstOperandDerivExpression;
                break;
            }
            case 11: {
                if (!firstOperandDerivZero) {
                    retElement = new Element(ElementCode.DIV);
                    retElement.mFirstOperand = firstOperandDerivExpression;
                    retElement.mSecondOperand = firstOperand;
                    break;
                }
                retElement = firstOperandDerivExpression;
                break;
            }
            case 7: {
                if (!firstOperandDerivZero) {
                    if (!secondOperandDerivZero) {
                        Element sum;
                        retElement = new Element(ElementCode.MULT);
                        retElement.mFirstOperand = sum = new Element(ElementCode.ADD);
                        Element xlogx = new Element(ElementCode.MULT);
                        xlogx.mFirstOperand = firstOperand;
                        Element logx = new Element(ElementCode.LN);
                        logx.mFirstOperand = firstOperand;
                        xlogx.mSecondOperand = logx;
                        if (!secondOperandDerivUnity) {
                            Element sumFirstTerm = new Element(ElementCode.MULT);
                            sumFirstTerm.mFirstOperand = secondOperandDerivExpression;
                            sumFirstTerm.mSecondOperand = xlogx;
                            sum.mFirstOperand = sumFirstTerm;
                        } else {
                            sum.mFirstOperand = xlogx;
                        }
                        if (!firstOperandDerivUnity) {
                            Element sumSecondTerm;
                            sum.mSecondOperand = sumSecondTerm = new Element(ElementCode.MULT);
                            sumSecondTerm.mFirstOperand = firstOperandDerivExpression;
                            sumSecondTerm.mSecondOperand = secondOperand;
                        } else {
                            sum.mSecondOperand = secondOperand;
                        }
                        Element yminus1 = null;
                        if (!secondOperand.mCode.equals(ElementCode.NUMBER)) {
                            yminus1 = new Element(ElementCode.SUBT);
                            yminus1.mFirstOperand = secondOperand;
                            yminus1.mSecondOperand = Element.ONE;
                        } else {
                            double newVal = secondOperand.mNumericValue - 1.0;
                            if (newVal != 1.0) {
                                yminus1 = new Element(ElementCode.NUMBER);
                                yminus1.mNumericValue = newVal;
                            }
                        }
                        Element xtoyminus1 = null;
                        if (yminus1 != null) {
                            xtoyminus1 = new Element(ElementCode.POW);
                            xtoyminus1.mFirstOperand = firstOperand;
                            xtoyminus1.mSecondOperand = yminus1;
                        } else {
                            xtoyminus1 = firstOperand;
                        }
                        retElement.mSecondOperand = xtoyminus1;
                        break;
                    }
                    retElement = new Element(ElementCode.MULT);
                    if (!firstOperandDerivUnity) {
                        Element xprimey = new Element(ElementCode.MULT);
                        xprimey.mFirstOperand = firstOperandDerivExpression;
                        xprimey.mSecondOperand = secondOperand;
                        retElement.mFirstOperand = xprimey;
                    } else {
                        retElement.mFirstOperand = secondOperand;
                    }
                    Element yminus1 = null;
                    if (!secondOperand.mCode.equals(ElementCode.NUMBER)) {
                        yminus1 = new Element(ElementCode.SUBT);
                        yminus1.mFirstOperand = secondOperand;
                        yminus1.mSecondOperand = Element.ONE;
                    } else {
                        double newExp = secondOperand.mNumericValue - 1.0;
                        if (newExp != 1.0) {
                            yminus1 = new Element(ElementCode.NUMBER);
                            yminus1.mNumericValue = newExp;
                        }
                    }
                    Element xtoyminus1 = null;
                    if (yminus1 != null) {
                        xtoyminus1 = new Element(ElementCode.POW);
                        xtoyminus1.mFirstOperand = firstOperand;
                        xtoyminus1.mSecondOperand = yminus1;
                    } else {
                        xtoyminus1 = firstOperand;
                    }
                    retElement.mSecondOperand = xtoyminus1;
                    break;
                }
                if (!secondOperandDerivZero) {
                    retElement = new Element(ElementCode.MULT);
                    Element logx = new Element(ElementCode.LN);
                    logx.mFirstOperand = firstOperand;
                    if (!secondOperandDerivUnity) {
                        Element yprimelogx = new Element(ElementCode.MULT);
                        yprimelogx.mFirstOperand = secondOperandDerivExpression;
                        yprimelogx.mSecondOperand = logx;
                        retElement.mFirstOperand = yprimelogx;
                    } else {
                        retElement.mFirstOperand = logx;
                    }
                    retElement.mSecondOperand = pElement;
                    break;
                }
                retElement = firstOperandDerivExpression;
                break;
            }
            case 10: {
                if (!firstOperandDerivZero) {
                    if (!firstOperandDerivUnity) {
                        retElement = new Element(ElementCode.MULT);
                        retElement.mFirstOperand = firstOperandDerivExpression;
                        retElement.mSecondOperand = pElement;
                        break;
                    }
                    retElement = pElement;
                    break;
                }
                retElement = firstOperandDerivExpression;
                break;
            }
            case 9: {
                if (!firstOperandDerivZero) {
                    if (!firstOperandDerivUnity) {
                        retElement = new Element(ElementCode.NEG);
                        retElement.mFirstOperand = firstOperandDerivExpression;
                        break;
                    }
                    retElement = new Element(ElementCode.NUMBER);
                    retElement.mNumericValue = -1.0;
                    break;
                }
                retElement = firstOperandDerivExpression;
                break;
            }
            case 14: {
                if (!firstOperandDerivZero) {
                    retElement = new Element(ElementCode.DIV);
                    retElement.mFirstOperand = firstOperandDerivExpression;
                    Element cosSq = new Element(ElementCode.POW);
                    Element cos = new Element(ElementCode.COS);
                    cos.mFirstOperand = firstOperand;
                    cosSq.mFirstOperand = cos;
                    cosSq.mSecondOperand = Element.TWO;
                    retElement.mSecondOperand = cosSq;
                    break;
                }
                retElement = firstOperandDerivExpression;
                break;
            }
            case 13: {
                if (!firstOperandDerivZero) {
                    retElement = new Element(ElementCode.NEG);
                    if (!firstOperandDerivUnity) {
                        Element prod;
                        retElement.mFirstOperand = prod = new Element(ElementCode.MULT);
                        Element sinFunc = new Element(ElementCode.SIN);
                        sinFunc.mFirstOperand = firstOperand;
                        prod.mFirstOperand = sinFunc;
                        prod.mSecondOperand = firstOperandDerivExpression;
                        break;
                    }
                    Element sinFunc = new Element(ElementCode.SIN);
                    sinFunc.mFirstOperand = firstOperand;
                    retElement.mFirstOperand = sinFunc;
                    break;
                }
                retElement = firstOperandDerivExpression;
                break;
            }
            case 12: {
                if (!firstOperandDerivZero) {
                    if (!firstOperandDerivUnity) {
                        retElement = new Element(ElementCode.MULT);
                        Element cosFunc = new Element(ElementCode.COS);
                        cosFunc.mFirstOperand = firstOperand;
                        retElement.mFirstOperand = cosFunc;
                        retElement.mSecondOperand = firstOperandDerivExpression;
                        break;
                    }
                    retElement = new Element(ElementCode.COS);
                    retElement.mFirstOperand = firstOperand;
                    break;
                }
                retElement = firstOperandDerivExpression;
                break;
            }
            case 4: {
                if (!firstOperandDerivZero) {
                    if (!secondOperandDerivZero) {
                        retElement = new Element(ElementCode.ADD);
                        retElement.mFirstOperand = firstOperandDerivExpression;
                        retElement.mSecondOperand = secondOperandDerivExpression;
                        break;
                    }
                    retElement = firstOperandDerivExpression;
                    break;
                }
                if (!secondOperandDerivZero) {
                    retElement = secondOperandDerivExpression;
                    break;
                }
                retElement = firstOperandDerivExpression;
                break;
            }
            case 5: {
                if (!firstOperandDerivZero) {
                    if (!secondOperandDerivZero) {
                        retElement = new Element(ElementCode.SUBT);
                        retElement.mFirstOperand = firstOperandDerivExpression;
                        retElement.mSecondOperand = secondOperandDerivExpression;
                        break;
                    }
                    retElement = firstOperandDerivExpression;
                    break;
                }
                if (!secondOperandDerivZero) {
                    retElement = new Element(ElementCode.NEG);
                    retElement.mFirstOperand = secondOperandDerivExpression;
                    break;
                }
                retElement = firstOperandDerivExpression;
                break;
            }
            case 6: {
                if (!firstOperandDerivZero) {
                    if (!secondOperandDerivZero) {
                        retElement = new Element(ElementCode.SUBT);
                        Element firstTerm = new Element(ElementCode.DIV);
                        firstTerm.mFirstOperand = firstOperandDerivExpression;
                        firstTerm.mSecondOperand = secondOperand;
                        retElement.mFirstOperand = firstTerm;
                        Element secondTerm = new Element(ElementCode.DIV);
                        Element secondTermNum = null;
                        if (!secondOperandDerivUnity) {
                            secondTermNum = new Element(ElementCode.MULT);
                            secondTermNum.mFirstOperand = firstOperand;
                            secondTermNum.mSecondOperand = secondOperandDerivExpression;
                        } else {
                            secondTermNum = firstOperand;
                        }
                        secondTerm.mFirstOperand = secondTermNum;
                        Element secondTermDenom = new Element(ElementCode.POW);
                        secondTermDenom.mFirstOperand = secondOperand;
                        secondTermDenom.mSecondOperand = Element.TWO;
                        secondTerm.mSecondOperand = secondTermDenom;
                        retElement.mSecondOperand = secondTerm;
                        break;
                    }
                    retElement = new Element(ElementCode.DIV);
                    retElement.mFirstOperand = firstOperandDerivExpression;
                    retElement.mSecondOperand = secondOperand;
                    break;
                }
                if (!secondOperandDerivZero) {
                    Element secondTermNum;
                    Element secondTermArg;
                    if (!secondOperandDerivUnity) {
                        Element secondTermArg2;
                        retElement = new Element(ElementCode.NEG);
                        retElement.mFirstOperand = secondTermArg2 = new Element(ElementCode.DIV);
                        Element secondTermNum2 = new Element(ElementCode.MULT);
                        secondTermNum2.mFirstOperand = firstOperand;
                        secondTermNum2.mSecondOperand = secondOperandDerivExpression;
                        secondTermArg2.mFirstOperand = secondTermNum2;
                        Element secondTermDenom = new Element(ElementCode.POW);
                        secondTermDenom.mFirstOperand = secondOperand;
                        secondTermDenom.mSecondOperand = Element.TWO;
                        secondTermArg2.mSecondOperand = secondTermDenom;
                        break;
                    }
                    retElement = new Element(ElementCode.NEG);
                    retElement.mFirstOperand = secondTermArg = new Element(ElementCode.DIV);
                    secondTermArg.mFirstOperand = secondTermNum = firstOperand;
                    Element secondTermDenom = new Element(ElementCode.POW);
                    secondTermDenom.mFirstOperand = secondOperand;
                    secondTermDenom.mSecondOperand = Element.TWO;
                    secondTermArg.mSecondOperand = secondTermDenom;
                    break;
                }
                retElement = secondOperandDerivExpression;
                break;
            }
            case 3: {
                if (!firstOperandDerivZero) {
                    if (!secondOperandDerivZero) {
                        retElement = new Element(ElementCode.ADD);
                        if (!firstOperandDerivUnity) {
                            if (!secondOperandDerivUnity) {
                                Element firstTerm = new Element(ElementCode.MULT);
                                firstTerm.mFirstOperand = firstOperandDerivExpression;
                                firstTerm.mSecondOperand = secondOperand;
                                Element secondTerm = new Element(ElementCode.MULT);
                                secondTerm.mFirstOperand = firstOperand;
                                secondTerm.mSecondOperand = secondOperandDerivExpression;
                                retElement.mFirstOperand = firstTerm;
                                retElement.mSecondOperand = secondTerm;
                                break;
                            }
                            Element firstTerm = new Element(ElementCode.MULT);
                            firstTerm.mFirstOperand = firstOperandDerivExpression;
                            firstTerm.mSecondOperand = secondOperand;
                            Element secondTerm = firstOperand;
                            retElement.mFirstOperand = firstTerm;
                            retElement.mSecondOperand = secondTerm;
                            break;
                        }
                        if (!secondOperandDerivUnity) {
                            Element firstTerm = secondOperand;
                            Element secondTerm = new Element(ElementCode.MULT);
                            secondTerm.mFirstOperand = firstOperand;
                            secondTerm.mSecondOperand = secondOperandDerivExpression;
                            retElement.mFirstOperand = firstTerm;
                            retElement.mSecondOperand = secondTerm;
                            break;
                        }
                        retElement.mFirstOperand = firstOperand;
                        retElement.mSecondOperand = secondOperand;
                        break;
                    }
                    if (!firstOperandDerivUnity) {
                        retElement = new Element(ElementCode.MULT);
                        retElement.mFirstOperand = firstOperandDerivExpression;
                        retElement.mSecondOperand = secondOperand;
                        break;
                    }
                    retElement = secondOperand;
                    break;
                }
                if (!secondOperandDerivZero) {
                    if (!secondOperandDerivUnity) {
                        retElement = new Element(ElementCode.MULT);
                        retElement.mFirstOperand = firstOperand;
                        retElement.mSecondOperand = secondOperandDerivExpression;
                        break;
                    }
                    retElement = firstOperand;
                    break;
                }
                retElement = secondOperandDerivExpression;
                break;
            }
            default: {
                throw new IllegalStateException("unable to differentiate element code: " + pElement.mCode);
            }
        }
        return retElement;
    }

    public Expression computePartialDerivative(Symbol pSymbol, SymbolEvaluator pSymbolEvaluator) throws DataNotFoundException {
        Expression expression = new Expression();
        expression.mRootElement = this.computePartialDerivative(this.mRootElement, pSymbol, pSymbolEvaluator);
        return expression;
    }

    public Expression computePartialDerivative(Symbol pSymbol, HashMap pSymbolsMap) throws DataNotFoundException {
        SymbolEvaluator symbolEvaluator = this.getSymbolEvaluator(pSymbolsMap);
        Expression expression = new Expression();
        expression.mRootElement = this.computePartialDerivative(this.mRootElement, pSymbol, symbolEvaluator);
        return expression;
    }

    public boolean isSimpleNumber() {
        return this.mRootElement.mCode == ElementCode.NUMBER;
    }

    public double getSimpleNumberValue() throws IllegalStateException {
        if (!this.isSimpleNumber()) {
            throw new IllegalStateException("not allowed to call getSimpleNumberValue() on non-simple expression");
        }
        return this.mRootElement.mNumericValue;
    }

    public static Expression square(Expression A) {
        Expression retVal = null;
        if (A.isSimpleNumber()) {
            double value = A.mRootElement.mNumericValue;
            retVal = new Expression(value * value);
        } else {
            retVal = new Expression();
            Element rootElement = new Element(ElementCode.POW);
            rootElement.mFirstOperand = A.mRootElement;
            rootElement.mSecondOperand = Element.TWO;
            retVal.mRootElement = rootElement;
        }
        return retVal;
    }

    public static Expression multiply(Expression A, Expression B) {
        Expression retVal = null;
        if (A.isSimpleNumber()) {
            if (B.isSimpleNumber()) {
                double value = A.mRootElement.mNumericValue * B.mRootElement.mNumericValue;
                retVal = new Expression(value);
            } else if (A.mRootElement.mNumericValue == 0.0) {
                retVal = A;
            } else if (A.mRootElement.mNumericValue == 1.0) {
                retVal = B;
            } else if (A.mRootElement.mNumericValue == -1.0) {
                if (!B.mRootElement.mCode.equals(ElementCode.NEG)) {
                    Element rootElement = new Element(ElementCode.NEG);
                    rootElement.mFirstOperand = B.mRootElement;
                    retVal = new Expression();
                    retVal.mRootElement = rootElement;
                } else {
                    retVal = new Expression();
                    retVal.mRootElement = B.mRootElement.mFirstOperand;
                }
            }
        }
        if (retVal == null && B.isSimpleNumber()) {
            if (B.mRootElement.mNumericValue == 0.0) {
                retVal = B;
            } else if (B.mRootElement.mNumericValue == 1.0) {
                retVal = A;
            } else if (B.mRootElement.mNumericValue == -1.0) {
                if (!A.mRootElement.mCode.equals(ElementCode.NEG)) {
                    Element rootElement = new Element(ElementCode.NEG);
                    rootElement.mFirstOperand = A.mRootElement;
                    retVal = new Expression();
                    retVal.mRootElement = rootElement;
                } else {
                    retVal = new Expression();
                    retVal.mRootElement = A.mRootElement.mFirstOperand;
                }
            }
        }
        if (retVal == null) {
            retVal = new Expression();
            Element prod = new Element(ElementCode.MULT);
            prod.mFirstOperand = A.mRootElement;
            prod.mSecondOperand = B.mRootElement;
            retVal.mRootElement = prod;
        }
        return retVal;
    }

    public static Expression divide(Expression A, Expression B) {
        Expression retVal = null;
        if (A.isSimpleNumber() && A.mRootElement.mNumericValue == 0.0) {
            retVal = A;
        } else {
            retVal = new Expression();
            Element quotient = new Element(ElementCode.DIV);
            quotient.mFirstOperand = A.mRootElement;
            quotient.mSecondOperand = B.mRootElement;
            retVal.mRootElement = quotient;
        }
        return retVal;
    }

    public static Expression negate(Expression A) {
        Expression retVal = null;
        if (A.isSimpleNumber()) {
            double value = -1.0 * A.mRootElement.mNumericValue;
            retVal = new Expression(value);
        } else if (A.mRootElement.mCode.equals(ElementCode.NEG)) {
            retVal = new Expression();
            retVal.mRootElement = A.mRootElement.mFirstOperand;
        } else {
            retVal = new Expression();
            Element rootElement = new Element(ElementCode.NEG);
            rootElement.mFirstOperand = A.mRootElement;
            retVal.mRootElement = rootElement;
        }
        return retVal;
    }

    public static Expression subtract(Expression A, Expression B) {
        Expression retVal = null;
        if (A.isSimpleNumber() && A.mRootElement.mNumericValue == 0.0) {
            if (B.isSimpleNumber()) {
                retVal = new Expression(-1.0 * B.mRootElement.mNumericValue);
            } else if (!B.mRootElement.mCode.equals(ElementCode.NEG)) {
                retVal = new Expression();
                retVal.mRootElement = new Element(ElementCode.NEG);
                retVal.mRootElement.mFirstOperand = B.mRootElement;
            } else {
                retVal = new Expression();
                retVal.mRootElement = B.mRootElement.mFirstOperand;
            }
        } else if (B.isSimpleNumber() && B.mRootElement.mNumericValue == 0.0) {
            retVal = A;
        } else if (A.isSimpleNumber() && B.isSimpleNumber()) {
            double value = A.mRootElement.mNumericValue - B.mRootElement.mNumericValue;
            retVal = new Expression(value);
        } else {
            retVal = new Expression();
            Element diff = new Element(ElementCode.SUBT);
            diff.mFirstOperand = A.mRootElement;
            diff.mSecondOperand = B.mRootElement;
            retVal.mRootElement = diff;
        }
        return retVal;
    }

    public static Expression add(Expression A, Expression B) {
        Expression retVal = null;
        if (A.isSimpleNumber() && A.mRootElement.mNumericValue == 0.0) {
            retVal = B;
        } else if (B.isSimpleNumber() && B.mRootElement.mNumericValue == 0.0) {
            retVal = A;
        } else if (A.isSimpleNumber() && B.isSimpleNumber()) {
            double value = A.mRootElement.mNumericValue + B.mRootElement.mNumericValue;
            retVal = new Expression(value);
        } else {
            retVal = new Expression();
            Element sum = new Element(ElementCode.ADD);
            sum.mFirstOperand = A.mRootElement;
            sum.mSecondOperand = B.mRootElement;
            retVal.mRootElement = sum;
        }
        return retVal;
    }

    public static final void main(String[] pArgs) {
        try {
            InputStream in = System.in;
            InputStreamReader reader = new InputStreamReader(in);
            BufferedReader bufReader = new BufferedReader(reader);
            String line = null;
            while ((line = bufReader.readLine()) != null) {
                Expression expression = new Expression(line);
                System.out.println(expression.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static final class Element
    implements Cloneable {
        protected static final Element ONE = new Element(1.0);
        protected static final Element TWO = new Element(2.0);
        public final ElementCode mCode;
        public Element mFirstOperand;
        public Element mSecondOperand;
        public Symbol mSymbol;
        public double mNumericValue;

        public boolean isAtomic() {
            return this.mCode.equals(ElementCode.SYMBOL) || this.mCode.equals(ElementCode.NUMBER);
        }

        public Element(ElementCode pCode) {
            this.mCode = pCode;
        }

        public Element(double pNumericValue) {
            this.mCode = ElementCode.NUMBER;
            this.mNumericValue = pNumericValue;
        }

        public String toString(SymbolPrinter pSymbolPrinter) throws IllegalStateException, DataNotFoundException {
            ElementCode code = this.mCode;
            StringBuffer sb = new StringBuffer();
            if (code == ElementCode.NEG) {
                sb.append(Expression.TOKEN_STRING_MINUS);
                if (this.mFirstOperand.mCode != ElementCode.SYMBOL) {
                    sb.append(Expression.TOKEN_STRING_OPEN_PAREN);
                }
                sb.append(this.mFirstOperand.toString(pSymbolPrinter));
                if (this.mFirstOperand.mCode != ElementCode.SYMBOL) {
                    sb.append(Expression.TOKEN_STRING_CLOSE_PAREN);
                }
            } else if (this.mCode.isFunction()) {
                sb.append(this.mCode + Expression.TOKEN_STRING_OPEN_PAREN);
                int numArgs = this.mCode.mNumFunctionArgs;
                if (numArgs > 0) {
                    sb.append(this.mFirstOperand.toString(pSymbolPrinter));
                    if (numArgs > 1) {
                        sb.append(", " + this.mSecondOperand.toString(pSymbolPrinter));
                    }
                }
                sb.append(Expression.TOKEN_STRING_CLOSE_PAREN);
            } else {
                String operatorSymbol = Expression.getBinaryOperatorSymbol(code);
                if (operatorSymbol != null) {
                    if (!this.mFirstOperand.isAtomic()) {
                        sb.append(Expression.TOKEN_STRING_OPEN_PAREN);
                    }
                    sb.append(this.mFirstOperand.toString(pSymbolPrinter));
                    if (!this.mFirstOperand.isAtomic()) {
                        sb.append(Expression.TOKEN_STRING_CLOSE_PAREN);
                    }
                    sb.append(operatorSymbol);
                    if (!this.mSecondOperand.isAtomic()) {
                        sb.append(Expression.TOKEN_STRING_OPEN_PAREN);
                    }
                    sb.append(this.mSecondOperand.toString(pSymbolPrinter));
                    if (!this.mSecondOperand.isAtomic()) {
                        sb.append(Expression.TOKEN_STRING_CLOSE_PAREN);
                    }
                } else {
                    if (code == ElementCode.PAIR) {
                        throw new IllegalStateException("invalid element code: pair");
                    }
                    if (code == ElementCode.SYMBOL) {
                        if (pSymbolPrinter != null) {
                            sb.append(pSymbolPrinter.printSymbol(this.mSymbol));
                        } else {
                            sb.append(this.mSymbol.getName());
                        }
                    } else if (code == ElementCode.NUMBER) {
                        sb.append(this.mNumericValue);
                    } else {
                        throw new IllegalStateException("invalid element code encountered; code is: " + code);
                    }
                }
            }
            return sb.toString();
        }

        public Object clone() {
            Element newElement = new Element(this.mCode);
            newElement.mFirstOperand = this.mFirstOperand != null ? (Element)this.mFirstOperand.clone() : null;
            newElement.mSecondOperand = this.mSecondOperand != null ? (Element)this.mSecondOperand.clone() : null;
            newElement.mNumericValue = this.mNumericValue;
            newElement.mSymbol = this.mSymbol != null ? (Symbol)this.mSymbol.clone() : null;
            return newElement;
        }
    }

    public static final class ElementCode {
        private final String mName;
        private static final HashMap mFunctionsMap = new HashMap();
        public final int mIntCode;
        public final int mNumFunctionArgs;
        public static final int NULL_FUNCTION_CODE = 0;
        public static final int ELEMENT_CODE_NONE = 0;
        public static final int ELEMENT_CODE_SYMBOL = 1;
        public static final int ELEMENT_CODE_NUMBER = 2;
        public static final int ELEMENT_CODE_MULT = 3;
        public static final int ELEMENT_CODE_ADD = 4;
        public static final int ELEMENT_CODE_SUBT = 5;
        public static final int ELEMENT_CODE_DIV = 6;
        public static final int ELEMENT_CODE_POW = 7;
        public static final int ELEMENT_CODE_MOD = 8;
        public static final int ELEMENT_CODE_NEG = 9;
        public static final int ELEMENT_CODE_EXP = 10;
        public static final int ELEMENT_CODE_LN = 11;
        public static final int ELEMENT_CODE_SIN = 12;
        public static final int ELEMENT_CODE_COS = 13;
        public static final int ELEMENT_CODE_TAN = 14;
        public static final int ELEMENT_CODE_ASIN = 15;
        public static final int ELEMENT_CODE_ACOS = 16;
        public static final int ELEMENT_CODE_ATAN = 17;
        public static final int ELEMENT_CODE_ABS = 18;
        public static final int ELEMENT_CODE_FLOOR = 19;
        public static final int ELEMENT_CODE_CEIL = 20;
        public static final int ELEMENT_CODE_SQRT = 21;
        public static final int ELEMENT_CODE_THETA = 22;
        public static final int ELEMENT_CODE_PAIR = 23;
        public static final int ELEMENT_CODE_MIN = 24;
        public static final int ELEMENT_CODE_MAX = 25;
        public static final ElementCode NONE = new ElementCode("none", 0);
        public static final ElementCode SYMBOL = new ElementCode("symbol", 1);
        public static final ElementCode NUMBER = new ElementCode("number", 2);
        public static final ElementCode PAIR = new ElementCode("pair", 23);
        public static final ElementCode MULT = new ElementCode("mult", 3);
        public static final ElementCode ADD = new ElementCode("add", 4);
        public static final ElementCode SUBT = new ElementCode("subt", 5);
        public static final ElementCode DIV = new ElementCode("div", 6);
        public static final ElementCode POW = new ElementCode("pow", 7);
        public static final ElementCode MOD = new ElementCode("mod", 8);
        public static final ElementCode NEG = new ElementCode("neg", 9);
        public static final ElementCode EXP = new ElementCode("exp", 10, true, 1);
        public static final ElementCode LN = new ElementCode("ln", 11, true, 1);
        public static final ElementCode SIN = new ElementCode("sin", 12, true, 1);
        public static final ElementCode COS = new ElementCode("cos", 13, true, 1);
        public static final ElementCode TAN = new ElementCode("tan", 14, true, 1);
        public static final ElementCode ASIN = new ElementCode("asin", 15, true, 1);
        public static final ElementCode ACOS = new ElementCode("acos", 16, true, 1);
        public static final ElementCode ATAN = new ElementCode("atan", 17, true, 1);
        public static final ElementCode ABS = new ElementCode("abs", 18, true, 1);
        public static final ElementCode FLOOR = new ElementCode("floor", 19, true, 1);
        public static final ElementCode CEIL = new ElementCode("ceil", 20, true, 1);
        public static final ElementCode SQRT = new ElementCode("sqrt", 21, true, 1);
        public static final ElementCode THETA = new ElementCode("theta", 22, true, 1);
        public static final ElementCode MIN = new ElementCode("min", 24, true, 2);
        public static final ElementCode MAX = new ElementCode("max", 25, true, 2);

        private ElementCode(String pName, int pIntCode) {
            this(pName, pIntCode, false, 0);
        }

        private ElementCode(String pName, int pIntCode, boolean pIsFunction, int pNumFunctionArgs) {
            this.mName = pName;
            this.mIntCode = pIntCode;
            this.mNumFunctionArgs = pNumFunctionArgs;
            if (pIsFunction) {
                this.putFunction(this);
            }
        }

        private void putFunction(ElementCode pElementCode) {
            mFunctionsMap.put(pElementCode.mName, pElementCode);
        }

        public static ElementCode getFunction(String pName) {
            return (ElementCode)mFunctionsMap.get(pName);
        }

        public boolean isFunction() {
            return ElementCode.getFunction(this.mName) != null;
        }

        public String toString() {
            return this.mName;
        }
    }

    public static interface IVisitor {
        public void visit(Symbol var1);
    }

    public static interface SymbolPrinter {
        public String printSymbol(Symbol var1) throws DataNotFoundException;
    }

    private class Token {
        TokenCode mCode = TokenCode.NONE;
        String mSymbolName = null;
        Element mParsedExpression = null;
        double mNumericValue;
        Element mSecondParsedExpression = null;

        public String toString() {
            String retVal = null;
            retVal = this.mCode.equals(TokenCode.SYMBOL) ? this.mSymbolName : (this.mCode.equals(TokenCode.NUMBER) ? Double.toString(this.mNumericValue) : (this.mCode.equals(TokenCode.EXPRESSION) ? this.mParsedExpression.mCode.toString() : this.mCode.toString()));
            return retVal;
        }
    }

    static final class TokenCode {
        private final String mName;
        public static final TokenCode NONE = new TokenCode("none");
        public static final TokenCode OPEN_PAREN = new TokenCode("open paren");
        public static final TokenCode CLOSE_PAREN = new TokenCode("close paren");
        public static final TokenCode NUMBER = new TokenCode("number");
        public static final TokenCode MULT = new TokenCode("mult");
        public static final TokenCode PLUS = new TokenCode("plus");
        public static final TokenCode MINUS = new TokenCode("minus");
        public static final TokenCode DIV = new TokenCode("div");
        public static final TokenCode POW = new TokenCode("pow");
        public static final TokenCode MOD = new TokenCode("mod");
        public static final TokenCode SYMBOL = new TokenCode("symbol");
        public static final TokenCode EXPRESSION = new TokenCode("expression");
        public static final TokenCode SPACE = new TokenCode("space");
        public static final TokenCode SEP = new TokenCode("sep");
        public static final TokenCode EXPRESSION_PAIR = new TokenCode("expression pair");

        private TokenCode(String pName) {
            this.mName = pName;
        }

        public String toString() {
            return this.mName;
        }
    }
}

