/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.math;

import org.systemsbiology.math.MutableDouble;

public final class MathFunctions {
    private static final double SQTPI = 2.5066282746310007;
    private static final double LOGPI = 1.1447298858494002;
    public static final double LN10 = Math.log(10.0);

    public static long factorial(int pArg) {
        assert (pArg > 0);
        long retVal = 1L;
        int ctr = 1;
        while (ctr <= pArg) {
            retVal *= (long)ctr;
            ++ctr;
        }
        return retVal;
    }

    public static double thetaFunction(double pArg) {
        double retVal = 0.0;
        if (pArg > 0.0) {
            retVal = 1.0;
        }
        return retVal;
    }

    public static double chooseFunction(long N, int M) throws IllegalArgumentException {
        if (N < 0L) {
            throw new IllegalArgumentException("invalid parameter for choose function; N=" + N);
        }
        if (M < 0) {
            throw new IllegalArgumentException("invalid parameter for choose function; M=" + M);
        }
        if ((long)M > N) {
            throw new IllegalArgumentException("invalid parameters for choose function; M=" + M + "; N=" + N);
        }
        double retVal = 1.0;
        long ctr = 0L;
        while (ctr < (long)M) {
            retVal *= (double)(N - ctr);
            ++ctr;
        }
        return retVal /= (double)MathFunctions.factorial(M);
    }

    public static double log10(double pArg) {
        return Math.log(pArg) / LN10;
    }

    public static void stats(double[] pVec, MutableDouble pMean, MutableDouble pStdDev) {
        int num = pVec.length;
        if (num <= 1) {
            throw new IllegalArgumentException("minimum vector length for computing statistics is 2");
        }
        double mean = 0.0;
        int i = 0;
        while (i < num) {
            mean += pVec[i];
            ++i;
        }
        pMean.setValue(mean /= (double)num);
        double stdev = 0.0;
        int i2 = 0;
        while (i2 < num) {
            stdev += Math.pow(pVec[i2] - mean, 2.0);
            ++i2;
        }
        stdev = Math.sqrt(stdev / (double)num);
        pStdDev.setValue(stdev);
    }

    public static double sign(double x) {
        double retVal = 0.0;
        if (x > 0.0) {
            retVal = 1.0;
        } else if (x < 0.0) {
            retVal = -1.0;
        }
        return retVal;
    }

    public static double extendedSimpsonsRule(double[] pVals, double pXmin, double pXmax, int pNmin, int pNmax) {
        if (pXmax <= pXmin) {
            throw new IllegalArgumentException("max value must exceed the min value");
        }
        if (pNmax <= pNmin) {
            throw new IllegalArgumentException("max bin number must exceed the min bin number");
        }
        if (pNmin < 0) {
            throw new IllegalArgumentException("min bin number must be nonnegative");
        }
        if (pNmax >= pVals.length || pNmin >= pVals.length) {
            throw new IllegalArgumentException("bin range is out of range, for the data array supplied");
        }
        int numBins = pNmax - pNmin + 1;
        if (numBins < 3) {
            throw new IllegalArgumentException("at least three bins required for using Extended Simpsons Rule");
        }
        double cumSum = 0.0;
        double fac = 0.0;
        double h = (pXmax - pXmin) / (double)numBins;
        int k = numBins;
        while (--k >= 0) {
            fac = k == numBins - 1 ? 0.3333333333333333 : (k == 0 ? 0.3333333333333333 : (k % 2 == 1 ? 1.3333333333333333 : 0.6666666666666666));
            cumSum += h * fac * pVals[k + pNmin];
        }
        return cumSum;
    }
}

