/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.math;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import org.systemsbiology.math.MathFunctions;
import org.systemsbiology.math.SignificantDigitsCalculator;

public class ScientificNumberFormat
extends DecimalFormat {
    private SignificantDigitsCalculator mSignificantDigitsCalculator;
    private int mMinimumDigitsForScientificNotation;
    private NumberFormat mDefaultNumberFormat;
    private static final int DEFAULT_MINIMUM_DIGITS_FOR_SCIENTIFIC_NOTATION = 4;

    public ScientificNumberFormat(SignificantDigitsCalculator pSignificantDigitsCalculator) {
        this.mSignificantDigitsCalculator = pSignificantDigitsCalculator;
        this.setMinimumDigitsForScientificNotation(4);
        this.mDefaultNumberFormat = ScientificNumberFormat.getInstance();
        this.setNaNString(null);
        this.setInfinityString(null);
    }

    public void setNaNString(String pNaNString) {
        DecimalFormatSymbols decimalFormatSymbols = this.getDecimalFormatSymbols();
        decimalFormatSymbols.setNaN(pNaNString);
        this.setDecimalFormatSymbols(decimalFormatSymbols);
    }

    public String getNaNString() {
        DecimalFormatSymbols decimalFormatSymbols = this.getDecimalFormatSymbols();
        return decimalFormatSymbols.getNaN();
    }

    public void setInfinityString(String pInfinityString) {
        DecimalFormatSymbols decimalFormatSymbols = this.getDecimalFormatSymbols();
        decimalFormatSymbols.setInfinity(pInfinityString);
        this.setDecimalFormatSymbols(decimalFormatSymbols);
    }

    public String getInfinityString() {
        DecimalFormatSymbols decimalFormatSymbols = this.getDecimalFormatSymbols();
        return decimalFormatSymbols.getInfinity();
    }

    public int getMinimumDigitsForScientificNotation() {
        return this.mMinimumDigitsForScientificNotation;
    }

    public void setMinimumDigitsForScientificNotation(int pMinimumDigitsForScientificNotation) {
        if (pMinimumDigitsForScientificNotation <= 0) {
            throw new IllegalArgumentException("invalid minimum number of digits for scientific notation: " + pMinimumDigitsForScientificNotation);
        }
        this.mMinimumDigitsForScientificNotation = pMinimumDigitsForScientificNotation;
    }

    public StringBuffer format(double pValue, StringBuffer pResults, FieldPosition pFieldPosition) {
        if (Double.isNaN(pValue) || Double.isInfinite(pValue)) {
            return super.format(pValue, pResults, pFieldPosition);
        }
        int numSignificantDigits = this.mSignificantDigitsCalculator.calculate(pValue);
        if (numSignificantDigits == -1) {
            return super.format(pValue, pResults, pFieldPosition);
        }
        String pattern = this.toPattern();
        int minFractionDigits = this.getMinimumFractionDigits();
        int maxFractionDigits = this.getMaximumFractionDigits();
        StringBuffer retBuf = null;
        double log10val = 0.0;
        if (pValue != 0.0) {
            log10val = MathFunctions.log10(Math.abs(pValue));
        }
        if (Math.abs(log10val) < (double)this.mMinimumDigitsForScientificNotation) {
            this.applyPattern("0.0");
            int numDigitsToLeftOfDecimalPoint = 1 + (int)Math.floor(log10val);
            int numDigitsToRightOfDecimalPoint = numSignificantDigits - numDigitsToLeftOfDecimalPoint;
            assert (numDigitsToRightOfDecimalPoint >= 0) : "negative number of digits to the right of the decimal point";
            this.setMaximumFractionDigits(numDigitsToRightOfDecimalPoint);
            this.setMinimumFractionDigits(numDigitsToRightOfDecimalPoint);
            retBuf = super.format(pValue, pResults, pFieldPosition);
        } else {
            this.applyPattern("0.######E0");
            this.setMaximumFractionDigits(numSignificantDigits - 1);
            this.setMinimumFractionDigits(numSignificantDigits - 1);
            retBuf = super.format(pValue, pResults, pFieldPosition);
        }
        this.applyPattern(pattern);
        this.setMinimumFractionDigits(minFractionDigits);
        this.setMaximumFractionDigits(maxFractionDigits);
        return retBuf;
    }

    public static final void main(String[] pArgs) {
        SignificantDigitsCalculator sigCalc = new SignificantDigitsCalculator(new Double(1.0E-4), new Double(0.01));
        ScientificNumberFormat sciForm = new ScientificNumberFormat(sigCalc);
        InputStream in = System.in;
        InputStreamReader reader = new InputStreamReader(in);
        BufferedReader bufReader = new BufferedReader(reader);
        String line = null;
        try {
            while ((line = bufReader.readLine()) != null) {
                Double value = null;
                try {
                    value = new Double(line);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("not a double: " + line);
                    System.exit(1);
                }
                System.out.println("truncated to: " + sciForm.format(value));
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

